/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.ClipboardManager;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.Display;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.Editor;
import com.ghostsq.commander.FileCommander;
import com.ghostsq.commander.ListHelper;
import com.ghostsq.commander.LockableScrollView;
import com.ghostsq.commander.PanelsView;
import com.ghostsq.commander.PictureViewer;
import com.ghostsq.commander.TextViewer;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FavsAdapter;
import com.ghostsq.commander.adapters.ZipAdapter;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.favorites.Favorites;
import com.ghostsq.commander.favorites.LocationBar;
import com.ghostsq.commander.toolbuttons.ToolButton;
import com.ghostsq.commander.toolbuttons.ToolButtons;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panels
implements AdapterView.OnItemSelectedListener,
AdapterView.OnItemClickListener,
AbsListView.OnScrollListener,
View.OnClickListener,
View.OnLongClickListener,
View.OnTouchListener,
View.OnFocusChangeListener,
View.OnKeyListener {
    private static final String TAG = "Panels";
    public static final String DEFAULT_LOC = Environment.getExternalStorageDirectory().getAbsolutePath();
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private int current = 0;
    private final int[] titlesIds = new int[]{2131230767, 2131230768};
    private ListHelper[] list = new ListHelper[]{null, null};
    public FileCommander c;
    public View mainView;
    public View toolbar = null;
    private LockableScrollView hsv;
    public PanelsView panelsView = null;
    public boolean sxs;
    public boolean fingerFriendly = false;
    private boolean panels_sliding = true;
    private boolean arrowsLegacy = false;
    private boolean warnOnRoot = true;
    private boolean rootOnRoot = false;
    private boolean toolbarShown = false;
    public boolean volumeLegacy = true;
    private boolean selAtRight = true;
    private boolean disableOpenSelectOnly = false;
    private float selWidth = 0.5f;
    private float downX = 0.0f;
    private float downY = 0.0f;
    private float x_start = -1.0f;
    public int scroll_back = 50;
    public int fnt_sz = 12;
    private StringBuffer quickSearchBuf = null;
    private Toast quickSearchTip = null;
    private Favorites favorites;
    private LocationBar locationBar;
    private CommanderAdapter destAdapter = null;
    public ColorsKeeper ck;
    private float density = 1.0f;

    public Panels(FileCommander c_, boolean sxs_) {
        TextView right_title;
        this.c = c_;
        this.density = this.c.getResources().getDisplayMetrics().density;
        this.ck = new ColorsKeeper((Context)this.c);
        this.current = 0;
        this.c.setContentView(2130903040);
        this.mainView = this.c.findViewById(2131230765);
        this.hsv = (LockableScrollView)this.c.findViewById(2131230773);
        this.hsv.setHorizontalScrollBarEnabled(false);
        this.hsv.setSmoothScrollingEnabled(true);
        this.hsv.setOnTouchListener(this);
        if (Build.VERSION.SDK_INT >= 9) {
            ForwardCompat.disableOverScroll((View)this.hsv);
        }
        this.panelsView = (PanelsView)this.c.findViewById(2131230774);
        this.panelsView.init(this.c.getWindowManager());
        this.initList(0);
        this.initList(1);
        this.favorites = new Favorites((Context)this.c);
        this.locationBar = new LocationBar(this.c, this, this.favorites);
        this.setLayoutMode(sxs_);
        TextView left_title = (TextView)this.c.findViewById(this.titlesIds[0]);
        if (left_title != null) {
            left_title.setOnClickListener((View.OnClickListener)this);
            left_title.setOnLongClickListener((View.OnLongClickListener)this);
        }
        if ((right_title = (TextView)this.c.findViewById(this.titlesIds[1])) != null) {
            right_title.setOnClickListener((View.OnClickListener)this);
            right_title.setOnLongClickListener((View.OnLongClickListener)this);
        }
        try {
            this.quickSearchBuf = new StringBuffer();
            this.quickSearchTip = Toast.makeText((Context)this.c, (CharSequence)"", (int)0);
        }
        catch (Exception e) {
            this.c.showMessage("Exception on creating quickSearchTip: " + e);
        }
        this.focus();
    }

    public final boolean getLayoutMode() {
        return this.sxs;
    }

    public final void setLayoutMode(boolean sxs_) {
        this.sxs = sxs_;
        SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this.c);
        this.applySettings(shared_pref, false);
        this.scroll_back = (int)((double)this.c.getWindowManager().getDefaultDisplay().getWidth() * 2.0 / 10.0);
        if (this.panelsView != null) {
            this.panelsView.setMode(sxs_);
        }
    }

    public final int getCurrent() {
        return this.current;
    }

    public final int getOpposite() {
        return this.opposite();
    }

    public final void showToolbar(boolean show) {
        this.toolbarShown = show;
    }

    private final Drawable createButtonStates() {
        try {
            float bbb = Utils.getBrightness(this.ck.btnColor);
            int sc = Utils.shiftBrightness(this.ck.btnColor, 0.2f);
            StateListDrawable states = new StateListDrawable();
            GradientDrawable bpd = Utils.getShadingEx(this.ck.btnColor, 1.0f);
            bpd.setStroke(1, sc);
            bpd.setCornerRadius(2.0f);
            GradientDrawable bnd = Utils.getShadingEx(this.ck.btnColor, bbb < 0.4f ? 0.0f : 0.6f);
            bnd.setStroke(1, sc);
            bnd.setCornerRadius(2.0f);
            states.addState(new int[]{16842919}, (Drawable)bpd);
            states.addState(new int[0], (Drawable)bnd);
            return states;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void setToolbarButtons(CommanderAdapter ca) {
        try {
            if (ca == null) {
                return;
            }
            if (this.toolbarShown) {
                if (this.toolbar == null) {
                    LayoutInflater inflater = (LayoutInflater)this.c.getSystemService("layout_inflater");
                    this.toolbar = inflater.inflate(2130903059, (ViewGroup)this.mainView, true).findViewById(2131230884);
                }
                if (this.toolbar == null) {
                    Log.e((String)TAG, (String)"Toolbar inflation has failed!");
                    return;
                }
                this.toolbar.setVisibility(4);
                ViewGroup tb_holder = (ViewGroup)this.toolbar;
                tb_holder.removeAllViews();
                SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.c);
                boolean keyboard = sharedPref.getBoolean("show_hotkeys", true) || this.c.getResources().getConfiguration().keyboard != 1;
                Utils.changeLanguage((Context)this.c);
                ToolButtons tba = new ToolButtons();
                tba.restore(sharedPref, (Context)this.c);
                int bfs = this.fnt_sz + (this.fingerFriendly ? 2 : 1);
                for (int i = 0; i < tba.size(); ++i) {
                    char ch;
                    ToolButton tb = (ToolButton)tba.get(i);
                    int bid = tb.getId();
                    if (!tb.isVisible() || !ca.hasFeature(ToolButton.getFeature(bid))) continue;
                    String caption = "";
                    if (keyboard && (ch = tb.getBoundKey()) != '\u0000') {
                        caption = ch + " ";
                    }
                    caption = caption + tb.getCaption();
                    LinearLayout.LayoutParams lllp = new LinearLayout.LayoutParams(-2, -2);
                    Button b = null;
                    if (!this.ck.isButtonsDefault()) {
                        b = Build.VERSION.SDK_INT >= 11 ? new Button((Context)this.c, null, this.fingerFriendly ? 16973963 : 16973846) : new Button((Context)this.c, null);
                        int c_length = caption.length();
                        int hp = c_length < 6 ? (int)((float)(12 - c_length) * this.density) : 6;
                        int vp = this.fingerFriendly ? (int)(10.0f * this.density) : 6;
                        b.setPadding(hp, vp, hp, vp);
                        float bbb = Utils.getBrightness(this.ck.btnColor);
                        b.setTextColor(bbb > 0.8f ? -16777216 : -1);
                        b.setTextSize((float)bfs);
                        Drawable bd = this.createButtonStates();
                        if (bd != null) {
                            b.setBackgroundDrawable(bd);
                        } else {
                            b.setBackgroundResource(2130837540);
                        }
                        lllp.rightMargin = 2;
                    } else {
                        int style_id = this.fingerFriendly ? 16842824 : 16842825;
                        b = new Button((Context)this.c, null, style_id);
                        lllp.rightMargin = -2;
                    }
                    b.setLayoutParams((ViewGroup.LayoutParams)lllp);
                    b.setId(bid);
                    b.setFocusable(false);
                    b.setText((CharSequence)caption);
                    b.setOnClickListener((View.OnClickListener)this.c);
                    tb_holder.addView((View)b);
                }
                this.toolbar.setVisibility(0);
            } else if (this.toolbar != null) {
                this.toolbar.setVisibility(8);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setToolbarButtons() exception", (Throwable)e);
        }
    }

    public final void focus() {
        this.list[this.current].focus();
    }

    public void onFocusChange(View v, boolean f) {
        boolean opp;
        ListView flv = this.list[this.opposite()].flv;
        boolean bl = opp = flv == v;
        if (f && opp) {
            this.setPanelCurrent(this.opposite(), true);
        }
    }

    public ArrayList<Favorite> getFavorites() {
        return this.favorites;
    }

    public final boolean isCurrent(int q) {
        return this.current == 0 && q == 0 || this.current == 1 && q == 1;
    }

    private final void initList(int which) {
        this.list[which] = new ListHelper(which, this);
        this.setPanelTitle("", which);
    }

    public final void setPanelTitle(String s, int which) {
        try {
            TextView title = (TextView)this.c.findViewById(this.titlesIds[which]);
            if (title != null) {
                int p_width = this.mainView.getWidth();
                if (p_width > 0) {
                    title.setMaxWidth(p_width / 2);
                }
                if (s == null) {
                    title.setText((CharSequence)this.c.getString(2131361904));
                } else {
                    title.setText((CharSequence)Utils.unEscape(Favorite.screenPwd(s)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final GradientDrawable getShading(int color2) {
        float drop = Build.VERSION.SDK_INT < 9 ? 0.6f : (Build.VERSION.SDK_INT < 11 ? (this.ck.isButtonsDefault() ? 0.8f : 0.6f) : (this.ck.isButtonsDefault() ? 1.0f : 0.8f));
        return Utils.getShadingEx(color2, drop);
    }

    private final void refreshPanelTitles() {
        try {
            CommanderAdapter cur_ca = this.getListAdapter(true);
            CommanderAdapter opp_ca = this.getListAdapter(false);
            if (cur_ca != null) {
                this.setPanelTitle(cur_ca.toString(), this.current);
            }
            if (opp_ca != null) {
                this.setPanelTitle(opp_ca.toString(), this.opposite());
            }
            this.highlightCurrentTitle();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"refreshPanelTitle()", (Throwable)e);
        }
    }

    private final void highlightCurrentTitle() {
        if (this.mainView == null) {
            return;
        }
        View title_bar = this.mainView.findViewById(2131230766);
        if (title_bar != null) {
            int bg_color;
            GradientDrawable d;
            int h = title_bar.getHeight();
            if (h == 0) {
                h = 30;
            }
            if ((d = this.getShading(bg_color = this.ck.ttlColor)) != null) {
                title_bar.setBackgroundDrawable((Drawable)d);
            } else {
                title_bar.setBackgroundColor(bg_color);
            }
        }
        this.highlightTitle(this.opposite(), false);
        this.highlightTitle(this.current, true);
    }

    private final void highlightTitle(int which, boolean on) {
        TextView title = (TextView)this.mainView.findViewById(this.titlesIds[which]);
        if (title != null) {
            if (on) {
                GradientDrawable d;
                int bg_color = this.ck.selColor;
                String tt = title.getText().toString();
                if (tt.startsWith("root:")) {
                    bg_color = -65536;
                }
                if ((d = this.getShading(bg_color)) != null) {
                    title.setBackgroundDrawable((Drawable)d);
                } else {
                    title.setBackgroundColor(bg_color);
                }
                title.setTextColor(this.ck.sfgColor);
            } else {
                title.setBackgroundColor(this.ck.selColor & 0xFFFFFFF);
                float[] fgr_hsv = new float[3];
                Color.colorToHSV((int)this.ck.fgrColor, (float[])fgr_hsv);
                float[] ttl_hsv = new float[3];
                Color.colorToHSV((int)this.ck.ttlColor, (float[])ttl_hsv);
                fgr_hsv[1] = (float)((double)fgr_hsv[1] * 0.5);
                fgr_hsv[2] = (fgr_hsv[2] + ttl_hsv[2]) / 2.0f;
                title.setTextColor(Color.HSVToColor((float[])fgr_hsv));
            }
        } else {
            Log.e((String)TAG, (String)"title view was not found!");
        }
    }

    public final int getSingle(boolean touched) {
        return this.list[this.current].getSingle(touched);
    }

    public final void setSelection(int i) {
        this.setSelection(this.current, i, 0);
    }

    public final void setSelection(int which, int i, int y_) {
        this.list[which].setSelection(i, y_);
    }

    public final void setSelection(int which, String name) {
        this.list[which].setSelection(name);
    }

    public final File getCurrentFile() {
        try {
            CommanderAdapter ca = this.getListAdapter(true);
            if (ca.hasFeature(CommanderAdapter.Feature.SEND)) {
                int pos = this.getSingle(true);
                if (pos < 0) {
                    return null;
                }
                String full_name = ca.getItemName(pos, true);
                if (full_name != null) {
                    return new File(full_name);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getCurrentFile()", (Throwable)e);
        }
        return null;
    }

    private final int opposite() {
        return 1 - this.current;
    }

    public final CommanderAdapter getListAdapter(boolean forCurrent) {
        return this.list[forCurrent ? this.current : this.opposite()].getListAdapter();
    }

    public final int getWidth() {
        return this.mainView.getWidth();
    }

    public final void applyColors() {
        View div;
        this.ck.restore();
        if (this.sxs && (div = this.mainView.findViewById(2131230777)) != null) {
            div.setBackgroundColor(this.ck.ttlColor);
        }
        this.list[0].applyColors(this.ck);
        this.list[1].applyColors(this.ck);
        this.ck.restoreTypeColors();
        CommanderAdapterBase.setTypeMaskColors(this.ck);
        this.highlightCurrentTitle();
    }

    public final void applySettings(SharedPreferences sharedPref, boolean init) {
        try {
            this.applyColors();
            String fnt_sz_s = sharedPref.getString("font_size", "12");
            try {
                this.fnt_sz = Integer.parseInt(fnt_sz_s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String ffs = sharedPref.getString("finger_friendly_a", "y");
            boolean ff = false;
            if ("a".equals(ffs)) {
                Display disp = this.c.getWindowManager().getDefaultDisplay();
                Configuration config = this.c.getResources().getConfiguration();
                ff = config.hardKeyboardHidden == 2 || disp.getWidth() < disp.getHeight();
            } else {
                ff = "y".equals(ffs);
            }
            this.setFingerFriendly(ff, this.fnt_sz);
            this.warnOnRoot = sharedPref.getBoolean("prevent_root", true);
            this.rootOnRoot = sharedPref.getBoolean("root_root", false);
            this.panels_sliding = sharedPref.getBoolean("panels_sliding", true);
            this.hsv.setScrollable(this.panels_sliding);
            this.arrowsLegacy = sharedPref.getBoolean("arrow_legc", false);
            this.volumeLegacy = sharedPref.getBoolean("volume_legc", true);
            this.toolbarShown = sharedPref.getBoolean("show_toolbar", true);
            this.selAtRight = sharedPref.getBoolean("selection_zone_right", true);
            this.selWidth = (float)sharedPref.getInt("selection_zone_width", 50) / 100.0f;
            if (!init) {
                this.list[0].applySettings(sharedPref);
                this.list[1].applySettings(sharedPref);
            }
            this.setToolbarButtons(this.getListAdapter(true));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"applySettings()", (Throwable)e);
        }
    }

    public void changeSorting(int sort_mode) {
        CommanderAdapter ca = this.getListAdapter(true);
        int cur_mode = ca.setMode(0, 0);
        boolean asc = (cur_mode & 0x40) == 0;
        int sorted = cur_mode & 0x30;
        this.storeChoosedItems();
        if (sorted == sort_mode) {
            ca.setMode(64, asc ? 64 : 0);
        } else {
            ca.setMode(112, sort_mode | 0);
        }
        this.reStoreChoosedItems();
    }

    public void toggleHidden() {
        CommanderAdapter ca = this.getListAdapter(true);
        int cur_mode = ca.setMode(0, 0);
        int new_mode = (cur_mode & 8) == 0 ? 8 : 0;
        ca.setMode(8, new_mode);
        this.refreshList(this.current, true, null);
    }

    public final void refreshLists(String posto) {
        int was_current = this.current;
        int was_opp = 1 - was_current;
        this.refreshList(this.current, true, posto);
        if (this.sxs) {
            this.refreshList(was_opp, false, null);
        } else {
            this.list[was_opp].setNeedRefresh();
        }
    }

    public final void refreshList(int which, boolean was_current, String posto) {
        this.list[which].refreshList(was_current, posto);
    }

    public final void swapPanels() {
        ListAdapter left_a = this.list[0].flv.getAdapter();
        ListAdapter right_a = this.list[1].flv.getAdapter();
        this.list[0].flv.setAdapter(right_a);
        this.list[1].flv.setAdapter(left_a);
        boolean left_cur = this.current == 0;
        this.list[0].refreshList(left_cur, null);
        this.list[1].refreshList(!left_cur, null);
    }

    public final void redrawLists() {
        this.list[this.current].askRedrawList();
        if (this.sxs) {
            this.list[this.opposite()].askRedrawList();
        }
        this.list[this.current].focus();
    }

    public void setFingerFriendly(boolean finger_friendly, int font_size) {
        this.fingerFriendly = finger_friendly;
        try {
            for (int p = 0; p <= 1; ++p) {
                TextView title = (TextView)this.c.findViewById(this.titlesIds[p]);
                if (title != null) {
                    title.setTextSize((float)font_size);
                    int vm = 0;
                    int hm = (int)(8.0f * this.density);
                    vm = finger_friendly ? (int)(10.0f * this.density) : (int)(4.0f * this.density);
                    title.setPadding(hm, vm, hm, vm);
                }
                if (this.list[p] == null) continue;
                this.list[p].setFingerFriendly(finger_friendly);
            }
            this.locationBar.setFingerFriendly(finger_friendly, font_size, this.density);
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public final void makeOtherAsCurrent() {
        CommanderAdapter ca = this.getListAdapter(true);
        this.NavigateInternal(this.opposite(), ca.getUri(), ca.getCredentials(), null);
    }

    public final void togglePanelsMode() {
        this.setLayoutMode(!this.sxs);
    }

    public final void togglePanels(boolean refresh) {
        this.setPanelCurrent(this.opposite());
    }

    public final void setPanelCurrent(int which) {
        this.setPanelCurrent(which, false);
    }

    public final void setPanelCurrent(int which, boolean dont_focus) {
        if (!dont_focus && this.panelsView != null) {
            this.panelsView.setMode(this.sxs);
        }
        this.current = which;
        if (!this.sxs) {
            int dir;
            int n = dir = this.current == 0 ? 17 : 66;
            if (dont_focus) {
                this.hsv.fullScroll(dir);
            } else {
                this.hsv.post(new Runnable(){

                    public void run() {
                        Panels.this.hsv.fullScroll(dir);
                    }
                });
            }
        } else if (!dont_focus) {
            this.list[this.current].focus();
        }
        this.highlightCurrentTitle();
        this.setToolbarButtons(this.getListAdapter(true));
        if (this.list[this.current].needRefresh()) {
            this.refreshList(this.current, false, null);
        }
    }

    public final void showSizes(boolean touched) {
        this.storeChoosedItems();
        this.getListAdapter(true).reqItemsSize(this.getMultiple(touched));
    }

    public final void checkItems(boolean set, String mask, boolean dir, boolean file) {
        this.list[this.current].checkItems(set, mask, dir, file);
    }

    protected final boolean isSafeLocation(String path) {
        return path.startsWith(DEFAULT_LOC) || path.startsWith("/sdcard") || path.startsWith("/mnt/");
    }

    public final void Navigate(int which, Uri uri, Credentials crd, String posTo) {
        if (uri == null) {
            return;
        }
        String scheme = uri.getScheme();
        String path = uri.getPath();
        if (!(scheme != null && !scheme.equals("file") || path != null && this.isSafeLocation(path))) {
            if (this.warnOnRoot) {
                String cur_path;
                CommanderAdapter ca = this.list[which].getListAdapter();
                if (ca != null && ca.hasFeature(CommanderAdapter.Feature.FS) && (cur_path = ca.toString()) != null && this.isSafeLocation(cur_path)) {
                    try {
                        new NavDialog((Context)this.c, which, uri, posTo);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Navigate()", (Throwable)e);
                    }
                    return;
                }
            } else if (this.rootOnRoot) {
                uri = uri.buildUpon().scheme("root").build();
            }
        }
        this.NavigateInternal(which, uri, crd, posTo);
    }

    private final void NavigateInternal(int which, Uri uri, Credentials crd, String posTo) {
        ListHelper list_h = this.list[which];
        list_h.Navigate(uri, crd, posTo, which == this.current);
    }

    public final void recoverAfterRefresh(String item_name, int which) {
        try {
            if (which >= 0) {
                this.list[which].recoverAfterRefresh(item_name);
            } else {
                this.list[this.current].recoverAfterRefresh(which == this.current);
            }
            this.refreshPanelTitles();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"refreshList()", (Throwable)e);
        }
    }

    public void login(Credentials crd, int which_panel) {
        CommanderAdapter ca;
        if (which_panel < 0) {
            which_panel = this.current;
        }
        if ((ca = this.list[which_panel].getListAdapter()) != null) {
            ca.setCredentials(crd);
            this.list[which_panel].refreshList(true, null);
        }
    }

    public final void terminateOperation() {
        CommanderAdapter a = this.getListAdapter(true);
        a.terminateOperation();
        if (a == this.destAdapter) {
            this.destAdapter = null;
        }
        CommanderAdapter p = this.getListAdapter(false);
        p.terminateOperation();
        if (p == this.destAdapter) {
            this.destAdapter = null;
        }
        if (null != this.destAdapter) {
            this.destAdapter.terminateOperation();
            this.destAdapter = null;
        }
    }

    public final void Destroy() {
        Log.i((String)TAG, (String)"Destroing adapters");
        try {
            this.getListAdapter(false).prepareToDestroy();
            this.getListAdapter(true).prepareToDestroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void tryToSend() {
        SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this.c);
        boolean use_content = shared_pref.getBoolean("send_content", true);
        SparseBooleanArray cis = this.getMultiple(true);
        int num = cis.size();
        if (num > 1) {
            CommanderAdapter ca = this.getListAdapter(true);
            if (ca == null) {
                return;
            }
            if (!ca.hasFeature(CommanderAdapter.Feature.SEND)) {
                this.c.showError(this.c.getString(2131361962));
                return;
            }
            ArrayList<Uri> uris = new ArrayList<Uri>();
            Intent in = new Intent();
            in.setAction("android.intent.action.SEND_MULTIPLE");
            in.setType("*/*");
            for (int i = 0; i < num; ++i) {
                if (!cis.valueAt(i)) continue;
                String esc_fn = Utils.escapePath(ca.getItemName(cis.keyAt(i), true));
                Uri uri = Uri.parse((String)(use_content ? "content://com.ghostsq.commander.FileProvider" + esc_fn : "file://" + esc_fn));
                uris.add(uri);
            }
            in.putParcelableArrayListExtra("android.intent.extra.STREAM", uris);
            this.c.startActivity(Intent.createChooser((Intent)in, (CharSequence)this.c.getString(2131361950)));
        } else {
            File f = this.getCurrentFile();
            if (f != null) {
                Intent in = new Intent("android.intent.action.SEND");
                in.setType("*/*");
                in.putExtra("android.intent.extra.SUBJECT", f.getName());
                String esc_fn = Utils.escapePath(f.getAbsolutePath());
                Uri uri = Uri.parse((String)(use_content ? "content://com.ghostsq.commander.FileProvider" + esc_fn : "file://" + esc_fn));
                in.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                this.c.startActivity(Intent.createChooser((Intent)in, (CharSequence)this.c.getString(2131361950)));
            }
        }
    }

    public final void tryToOpen() {
        File f = this.getCurrentFile();
        if (f != null) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.fromFile((File)f), "*/*");
            if (Build.VERSION.SDK_INT == 19) {
                this.c.startActivity(intent);
            } else {
                this.c.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.c.getString(2131361951)));
            }
        }
    }

    public final void copyName() {
        try {
            String in;
            CommanderAdapter ca = this.getListAdapter(true);
            if (ca == null) {
                return;
            }
            ClipboardManager clipboard = (ClipboardManager)this.c.getSystemService("clipboard");
            int pos = this.getSingle(true);
            if (pos >= 0 && (in = ca.getItemName(pos, true)) != null) {
                if (in.startsWith("root:")) {
                    in = Uri.parse((String)in).getPath();
                }
                clipboard.setText((CharSequence)in);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void createDesktopShortcut() {
        int dr_id;
        String mime;
        File f = this.getCurrentFile();
        if (f == null) {
            return;
        }
        String esc_fn = Utils.escapePath(f.getAbsolutePath());
        Uri uri = Uri.parse((String)("file://" + esc_fn));
        Intent shortcutIntent = new Intent("android.intent.action.VIEW");
        shortcutIntent.setFlags(0x24000000);
        String name = f.getName();
        if (f.isDirectory()) {
            mime = "inode/directory";
            dr_id = 2130837514;
        } else {
            String ext = Utils.getFileExt(name);
            mime = Utils.getMimeByExt(ext);
            dr_id = CommanderAdapterBase.getIconId(name);
        }
        shortcutIntent.setDataAndType(uri, mime);
        Intent intent = new Intent();
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        intent.putExtra("android.intent.extra.shortcut.NAME", name);
        Intent.ShortcutIconResource iconResource = Intent.ShortcutIconResource.fromContext((Context)this.c, (int)dr_id);
        intent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconResource);
        intent.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        this.c.sendBroadcast(intent);
    }

    public final void addToFavorites(Uri u, Credentials crd, String comment) {
        this.favorites.addToFavorites(u, crd, comment);
    }

    public final void addCurrentToFavorites() {
        CommanderAdapter ca = this.getListAdapter(true);
        if (ca == null) {
            return;
        }
        Uri u = ca.getUri();
        this.favorites.addToFavorites(u, ca.getCredentials(), null);
        this.c.showMessage(this.c.getString(2131362184, new Object[]{Favorite.screenPwd(u)}));
    }

    public final void faveSelectedFolder() {
        CommanderAdapter ca = this.getListAdapter(true);
        if (ca == null) {
            return;
        }
        Uri u = ca.getUri();
        if (u != null) {
            int pos = this.getSingle(true);
            if (pos < 0) {
                return;
            }
            Uri to_add = u.buildUpon().appendEncodedPath(ca.getItemName(pos, false)).build();
            if (to_add != null) {
                this.favorites.addToFavorites(to_add, ca.getCredentials(), null);
                this.c.showMessage(this.c.getString(2131362184, new Object[]{Favorite.screenPwd(to_add)}));
            }
        }
    }

    public final void openForEdit(String file_name, boolean touched) {
        CommanderAdapter ca = this.getListAdapter(true);
        if (ca == null || !ca.hasFeature(CommanderAdapter.Feature.F4)) {
            this.c.showMessage(this.c.getString(2131361957));
            return;
        }
        if (ca instanceof FavsAdapter) {
            FavsAdapter fa = (FavsAdapter)ca;
            int pos = this.getSingle(true);
            if (pos > 0) {
                fa.editItem(pos);
            }
            return;
        }
        try {
            int last_dot_pos;
            SharedPreferences sharedPref;
            String GC_EDITOR;
            Uri u;
            if (file_name == null || file_name.length() == 0) {
                int pos = this.getSingle(touched);
                CommanderAdapter.Item item = (CommanderAdapter.Item)((ListAdapter)ca).getItem(pos);
                if (item == null) {
                    this.c.showError(this.c.getString(2131362179));
                    return;
                }
                if (item.dir) {
                    this.c.showError(this.c.getString(2131362177, new Object[]{item.name}));
                    return;
                }
                u = ca.getItemUri(pos);
            } else {
                u = Uri.parse((String)file_name);
            }
            if (u == null) {
                return;
            }
            String full_class_name = GC_EDITOR = Editor.class.getName();
            if (ca instanceof FSAdapter && !GC_EDITOR.equals(full_class_name = (sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.c)).getString("editor_activity", GC_EDITOR))) {
                u = u.buildUpon().scheme("file").authority("").build();
            }
            Intent i = new Intent("android.intent.action.EDIT");
            if (!Utils.str(full_class_name)) {
                full_class_name = GC_EDITOR;
            }
            if ((last_dot_pos = full_class_name.lastIndexOf(46)) < 0) {
                this.c.showMessage("Invalid class name: " + full_class_name);
                full_class_name = GC_EDITOR;
                last_dot_pos = full_class_name.lastIndexOf(46);
            }
            i.setClassName(full_class_name.substring(0, last_dot_pos), full_class_name);
            i.setDataAndType(u, "text/plain");
            Credentials crd = ca.getCredentials();
            if (crd != null) {
                i.putExtra(Credentials.KEY, (Parcelable)crd);
            }
            this.c.startActivity(i);
        }
        catch (ActivityNotFoundException e) {
            this.c.showMessage("Activity Not Found: " + (Object)((Object)e));
        }
        catch (IndexOutOfBoundsException e) {
            this.c.showMessage("Bad activity class name: " + e);
        }
    }

    public final void openForView(boolean touched) {
        int pos = this.getSingle(touched);
        if (pos < 0) {
            return;
        }
        String name = null;
        try {
            CommanderAdapter ca = this.getListAdapter(true);
            Uri uri = ca.getItemUri(pos);
            if (uri == null) {
                return;
            }
            CommanderAdapter.Item item = (CommanderAdapter.Item)((ListAdapter)ca).getItem(pos);
            if (item.dir) {
                this.showSizes(touched);
                return;
            }
            String mime = Utils.getMimeByExt(Utils.getFileExt(item.name));
            if (mime == null) {
                mime = "application/octet-stream";
            }
            Intent i = new Intent((Context)this.c, mime.startsWith("image/") ? PictureViewer.class : TextViewer.class);
            i.setDataAndType(uri, mime);
            Credentials crd = ca.getCredentials();
            if (crd != null) {
                i.putExtra(Credentials.KEY, (Parcelable)crd);
            }
            i.putExtra("position", pos);
            this.c.startActivity(i);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't view the file " + name), (Throwable)e);
        }
    }

    public final String getActiveItemsSummary(boolean touched) {
        return this.list[this.current].getActiveItemsSummary(touched);
    }

    public final SparseBooleanArray getMultiple(boolean touch) {
        return this.list[this.current].getMultiple(touch);
    }

    public final Uri getFolderUriWithAuth(boolean active) {
        Credentials crd;
        CommanderAdapter ca = this.getListAdapter(active);
        if (ca == null) {
            return null;
        }
        Uri u = ca.getUri();
        if (u != null && (crd = ca.getCredentials()) != null) {
            return Utils.getUriWithAuth(u, crd);
        }
        return u;
    }

    public final String getSelectedItemName(boolean touched) {
        return this.getSelectedItemName(false, touched);
    }

    public final String getSelectedItemName(boolean full, boolean touched) {
        int pos = this.getSingle(touched);
        return pos < 0 ? null : this.getListAdapter(true).getItemName(pos, full);
    }

    public final void quickSearch(char ch) {
        CommanderAdapter a = this.getListAdapter(true);
        if (a != null) {
            this.quickSearchBuf.append(ch);
            String s = this.quickSearchBuf.toString();
            this.showTip(s);
            int n = ((ListAdapter)a).getCount();
            for (int i = 1; i < n; ++i) {
                String name = a.getItemName(i, false);
                if (name == null || !s.regionMatches(true, 0, name, 0, s.length())) continue;
                this.setSelection(i);
                return;
            }
        }
    }

    private final void showTip(String s) {
        try {
            if (!this.sxs || this.current == 0) {
                this.quickSearchTip.setGravity(83, 5, 10);
            } else {
                this.quickSearchTip.setGravity(80, 10, 10);
            }
            this.quickSearchTip.setText((CharSequence)s);
            this.quickSearchTip.show();
        }
        catch (RuntimeException e) {
            this.c.showMessage("RuntimeException: " + e);
        }
    }

    public final void resetQuickSearch() {
        this.quickSearchBuf.delete(0, this.quickSearchBuf.length());
    }

    public final void openGoPanel() {
        this.locationBar.openGoPanel(this.current, this.getFolderUriWithAuth(true));
    }

    public final void operationFinished() {
        if (null != this.destAdapter) {
            this.destAdapter = null;
        }
    }

    public final void copyFiles(String dest, boolean move, boolean touch) {
        try {
            String SLS = File.separator;
            char SLC = SLS.charAt(0);
            if (dest == null) {
                return;
            }
            SparseBooleanArray items = this.getMultiple(touch);
            CommanderAdapter cur_adapter = this.getListAdapter(true);
            Uri dest_uri = Uri.parse((String)dest);
            if (Favorite.isPwdScreened(dest_uri) && (dest_uri = Favorite.borrowPassword(dest_uri, this.getFolderUriWithAuth(false))) == null) {
                this.c.showError(this.c.getString(2131361959));
                return;
            }
            if (Utils.getCount(items) == 1 && !"..".equals(dest)) {
                File dest_file;
                int pos = Utils.getPosition(items, 0);
                if (pos <= 0) {
                    return;
                }
                boolean COPY = true;
                boolean make_copy = false;
                if (dest.indexOf(SLC) < 0) {
                    make_copy = true;
                } else if (!(!cur_adapter.hasFeature(CommanderAdapter.Feature.FS) || dest.charAt(dest.length() - 1) == SLC || dest.charAt(0) != SLC || (dest_file = new File(dest)).exists() && dest_file.isDirectory())) {
                    make_copy = true;
                }
                if (make_copy) {
                    cur_adapter.renameItem(pos, dest, true);
                    return;
                }
            }
            CommanderAdapter oth_adapter = this.getListAdapter(false);
            Uri oth_uri = null;
            boolean create_new_adapter = false;
            if (oth_adapter == null) {
                create_new_adapter = true;
            } else {
                oth_uri = oth_adapter.getUri();
                boolean bl = create_new_adapter = oth_uri == null || !Utils.equals(oth_uri.getScheme(), dest_uri.getScheme()) || !Utils.equals(oth_uri.getHost(), dest_uri.getHost()) || !Utils.equals(Utils.mbAddSl(oth_uri.getPath()), Utils.mbAddSl(dest_uri.getPath()));
            }
            if (create_new_adapter) {
                if ("..".equals(dest)) {
                    oth_adapter = CA.CreateAdapter(cur_adapter.getScheme(), this.c);
                    Uri cur_uri = cur_adapter.getUri();
                    String p = cur_uri.getEncodedPath();
                    if (!Utils.str(p) || "/".equals(p)) {
                        this.c.showError(this.c.getString(2131361959));
                        return;
                    }
                    int len_ = p.length() - 1;
                    if (p.charAt(len_) == SLC) {
                        p = p.substring(0, len_);
                    }
                    if ((p = p.substring(0, p.lastIndexOf(SLC))).length() == 0) {
                        p = "/";
                    }
                    oth_adapter.setUri(cur_uri.buildUpon().encodedPath(p).build());
                    oth_adapter.setCredentials(cur_adapter.getCredentials());
                } else {
                    if (dest_uri == null) {
                        this.c.showError(this.c.getString(2131361959));
                        return;
                    }
                    String scheme = dest_uri.getScheme();
                    oth_adapter = CA.CreateAdapter(scheme, this.c);
                    if (oth_adapter == null) {
                        this.c.showError(this.c.getString(2131361959));
                        return;
                    }
                    if (oth_uri != null) {
                        oth_adapter.setUri(oth_uri);
                        oth_adapter.setMode(131072, 131072);
                    }
                    oth_adapter.setUri(dest_uri);
                }
            }
            this.destAdapter = oth_adapter;
            cur_adapter.copyItems(items, this.destAdapter, move);
            this.list[this.current].flv.clearChoices();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"copyFiles()", (Throwable)e);
            this.c.showError(e.getLocalizedMessage());
        }
    }

    public final void renameItem(String new_name, boolean touched) {
        CommanderAdapter adapter = this.getListAdapter(true);
        int pos = this.getSingle(touched);
        if (pos >= 0) {
            adapter.renameItem(pos, new_name, false);
            this.list[this.current].setSelection(new_name);
        }
    }

    public void createNewFile(String fileName) {
        String local_name = fileName;
        CommanderAdapter ca = this.getListAdapter(true);
        if (fileName.charAt(0) != '/') {
            String dirName = ca.toString();
            fileName = dirName + (dirName.charAt(dirName.length() - 1) == '/' ? "" : "/") + fileName;
        }
        if (ca.createFile(fileName)) {
            this.refreshLists(fileName);
            this.setSelection(this.current, local_name);
            this.openForEdit(fileName, false);
        }
    }

    public final void createFolder(String new_name) {
        this.getListAdapter(true).createFolder(new_name);
        this.list[this.current].setSelection(new_name);
    }

    public final void createZip(String new_zip_name, boolean touch) {
        if (new_zip_name == null || new_zip_name.length() == 0) {
            return;
        }
        CommanderAdapter ca = this.getListAdapter(true);
        if (ca instanceof FSAdapter) {
            SparseBooleanArray cis = this.getMultiple(touch);
            if (cis == null || cis.size() == 0) {
                this.c.showError(this.c.getString(2131361963));
                return;
            }
            FSAdapter fsa = (FSAdapter)ca;
            ZipAdapter z = new ZipAdapter((Context)this.c);
            z.Init(this.c);
            this.destAdapter = z;
            File[] files = fsa.bitsToFiles(cis);
            String full_name = new_zip_name.charAt(0) == '/' ? new_zip_name : Utils.mbAddSl(ca.toString()) + new_zip_name;
            z.createZip(files, full_name);
        } else {
            this.c.showError(this.c.getString(2131362037));
        }
    }

    public final void unpackZip() {
        CommanderAdapter ca = this.getListAdapter(true);
        if (ca instanceof FSAdapter) {
            FSAdapter fsa = (FSAdapter)ca;
            SparseBooleanArray cis = this.getMultiple(true);
            if (cis == null || cis.size() == 0) {
                return;
            }
            File[] files = fsa.bitsToFiles(cis);
            if (files == null || files.length == 0) {
                return;
            }
            if (!".zip".equalsIgnoreCase(Utils.getFileExt(files[0].getName()))) {
                return;
            }
            ZipAdapter z = new ZipAdapter((Context)this.c);
            z.Init(this.c);
            z.unpackZip(files[0]);
        }
    }

    public final void deleteItems(boolean touch) {
        if (this.getListAdapter(true).deleteItems(this.getMultiple(touch))) {
            this.list[this.current].flv.clearChoices();
        }
    }

    public void onItemSelected(AdapterView<?> listView, View itemView, int pos, long id2) {
        this.locationBar.closeGoPanel();
        int which = this.list[this.current].id == listView.getId() ? this.current : this.opposite();
        this.list[which].setCurPos(pos);
        this.list[which].updateStatus();
    }

    public void onNothingSelected(AdapterView<?> listView) {
        this.resetQuickSearch();
        int which = this.list[this.current].id == listView.getId() ? this.current : this.opposite();
        this.list[which].updateStatus();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.locationBar.closeGoPanel();
        this.resetQuickSearch();
        ListView flv = this.list[this.current].flv;
        if (flv != parent) {
            this.togglePanels(false);
            Log.e((String)TAG, (String)("onItemClick. current=" + this.current + ", parent=" + parent.getId()));
        }
        if (position == 0) {
            flv.setItemChecked(0, false);
        }
        this.list[this.current].setCurPos(position);
        CommanderAdapter ca = (CommanderAdapter)flv.getAdapter();
        if (this.disableOpenSelectOnly && ca.hasFeature(CommanderAdapter.Feature.CHKBL)) {
            this.disableOpenSelectOnly = false;
            BaseAdapter ba = (BaseAdapter)ca;
            ba.notifyDataSetChanged();
        } else {
            this.openItem(position);
            flv.setItemChecked(position, false);
        }
        this.list[this.current].updateStatus();
    }

    public void openItem(int position) {
        ListHelper l = this.list[this.current];
        l.setCurPos(position);
        ((CommanderAdapter)l.flv.getAdapter()).openItem(position);
    }

    public void goUp() {
        this.getListAdapter(true).openItem(0);
    }

    public void goTop() {
        if (Build.VERSION.SDK_INT >= 8) {
            ForwardCompat.smoothScrollToPosition(this.list[this.current].flv, 0);
        } else {
            this.list[this.current].flv.setSelectionAfterHeaderView();
        }
    }

    public void goBot() {
        ListView flv = this.list[this.current].flv;
        int pos = flv.getCount() - 1;
        if (Build.VERSION.SDK_INT >= 8) {
            ForwardCompat.smoothScrollToPosition(flv, pos);
        } else {
            flv.setSelection(pos);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.resetQuickSearch();
        if (this.panels_sliding && v == this.hsv) {
            if ((double)this.x_start < 0.0 && event.getAction() == 2) {
                this.x_start = event.getX();
            } else if ((double)this.x_start >= 0.0 && event.getAction() == 1) {
                float d = event.getX() - this.x_start;
                this.x_start = -1.0f;
                int to_which = Math.abs(d) > (float)this.scroll_back ? (d > 0.0f ? 0 : 1) : (this.current == 0 ? 0 : 1);
                this.setPanelCurrent(to_which);
                return true;
            }
        } else if (v instanceof ListView) {
            if (v == this.list[this.opposite()].flv) {
                this.togglePanels(false);
            }
            this.locationBar.closeGoPanel();
            switch (event.getAction()) {
                case 0: {
                    this.downX = event.getX();
                    this.downY = event.getY();
                    boolean bl = this.disableOpenSelectOnly = event.getX() > (float)v.getWidth() * this.selWidth;
                    if (this.selAtRight) break;
                    this.disableOpenSelectOnly = !this.disableOpenSelectOnly;
                    break;
                }
                case 1: {
                    int deltaX = (int)(event.getX() - this.downX);
                    int deltaY = (int)(event.getY() - this.downY);
                    int absDeltaX = Math.abs(deltaX);
                    int absDeltaY = Math.abs(deltaY);
                    if (absDeltaY > 10 || absDeltaX > 10) {
                        this.disableOpenSelectOnly = false;
                    }
                    this.list[this.current].focus();
                    break;
                }
            }
        }
        return false;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (v instanceof ListView) {
            this.locationBar.closeGoPanel();
            if (event.getAction() == 0) {
                char ch = (char)event.getUnicodeChar();
                if (ch >= 'A' && ch <= 'z' || ch == '.') {
                    this.quickSearch(ch);
                    return true;
                }
                this.resetQuickSearch();
                switch (ch) {
                    case '(': 
                    case ')': {
                        int which = ch == '(' ? 0 : 1;
                        this.locationBar.openGoPanel(which, this.getFolderUriWithAuth(this.isCurrent(which)));
                        return true;
                    }
                    case '*': {
                        this.addCurrentToFavorites();
                        return true;
                    }
                    case '{': 
                    case '}': {
                        this.setPanelCurrent(ch == '{' ? 0 : 1);
                        return true;
                    }
                    case '#': {
                        this.setLayoutMode(!this.sxs);
                        return true;
                    }
                    case '~': {
                        this.swapPanels();
                        return true;
                    }
                    case '+': 
                    case '-': {
                        this.c.showDialog(ch == '+' ? 239 : 762);
                        return true;
                    }
                    case '\"': {
                        this.c.dispatchCommand(2131230739);
                        return true;
                    }
                    case '2': {
                        this.c.dispatchCommand(2131230721);
                        return true;
                    }
                    case '3': {
                        this.c.dispatchCommand(2131230723);
                        return true;
                    }
                    case '4': {
                        this.c.dispatchCommand(2131230725);
                        return true;
                    }
                    case '5': {
                        this.c.dispatchCommand(2131230728);
                        return true;
                    }
                    case '6': {
                        this.c.dispatchCommand(2131230730);
                        return true;
                    }
                    case '7': {
                        this.c.dispatchCommand(2131230732);
                        return true;
                    }
                    case '8': {
                        this.c.dispatchCommand(2131230733);
                        return true;
                    }
                    case ' ': {
                        this.list[this.current].checkItem(true);
                        return true;
                    }
                }
                switch (keyCode) {
                    case 67: {
                        if (!this.c.backExit()) {
                            this.goUp();
                        }
                        return true;
                    }
                    case 19: 
                    case 20: {
                        this.resetQuickSearch();
                        if (event.isShiftPressed()) {
                            this.list[this.current].checkItem(false);
                            KeyEvent shiftStrippedEvent = new KeyEvent(event.getDownTime(), event.getEventTime(), 0, keyCode, event.getRepeatCount(), event.getMetaState() & 0xFFFFFF3E);
                            return v.onKeyDown(keyCode, shiftStrippedEvent);
                        }
                        return false;
                    }
                    case 22: {
                        if (!this.arrowsLegacy) break;
                        this.list[this.current].checkItem(true);
                        return true;
                    }
                    case 24: {
                        if (!this.volumeLegacy) break;
                        this.list[this.current].checkItem(true);
                        return true;
                    }
                    case 21: {
                        if (this.arrowsLegacy) {
                            this.togglePanels(false);
                            return true;
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (event.getAction() == 1 && keyCode == 4) {
                if (!this.c.backExit()) {
                    this.goUp();
                }
                return true;
            }
        }
        return false;
    }

    public void onClick(View v) {
        this.resetQuickSearch();
        int view_id = v.getId();
        switch (view_id) {
            case 2131230767: 
            case 2131230768: {
                int which;
                this.locationBar.closeGoPanel();
                int n = which = view_id == this.titlesIds[0] ? 0 : 1;
                if (which == this.current) {
                    this.focus();
                    this.refreshList(this.current, true, null);
                    break;
                }
                this.togglePanels(true);
            }
        }
    }

    public boolean onLongClick(View v) {
        int which = v.getId() == this.titlesIds[0] ? 0 : 1;
        this.locationBar.openGoPanel(which, this.getFolderUriWithAuth(this.isCurrent(which)));
        return true;
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        CommanderAdapter ca;
        try {
            ca = (CommanderAdapter)view.getAdapter();
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)"onScrollStateChanged()", (Throwable)e);
            return;
        }
        if (ca != null) {
            switch (scrollState) {
                case 0: {
                    ca.setMode(65536, 0);
                    view.invalidateViews();
                    break;
                }
                case 1: 
                case 2: {
                    ca.setMode(65536, 65536);
                }
            }
        }
    }

    public void storeChoosedItems() {
        this.list[this.current].storeChoosedItems();
    }

    public void reStoreChoosedItems() {
        this.list[this.current].reStoreChoosedItems();
    }

    public final State getState() {
        State s = new State();
        s.current = this.current;
        try {
            CommanderAdapter left_adapter = this.list[0].getListAdapter();
            s.leftUri = left_adapter.getUri();
            s.leftCrd = left_adapter.getCredentials();
            int pos = this.list[0].getCurPos();
            s.leftItem = pos >= 0 ? left_adapter.getItemName(pos, false) : "";
            CommanderAdapter right_adapter = this.list[1].getListAdapter();
            s.rightUri = right_adapter.getUri();
            s.rightCrd = right_adapter.getCredentials();
            pos = this.list[1].getCurPos();
            s.rightItem = pos >= 0 ? right_adapter.getItemName(pos, false) : "";
            s.favs = this.favorites.getAsString();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getState()", (Throwable)e);
        }
        return s;
    }

    public final void setState(State s, int dont_restore) {
        CommanderAdapter ca;
        ListHelper list_h;
        if (s == null) {
            return;
        }
        this.resetQuickSearch();
        if (s.favs != null && s.favs.length() > 0) {
            this.favorites.setFromString(s.favs);
        } else if (s.fav_uris != null) {
            this.favorites.setFromOldString(s.fav_uris);
        }
        this.current = s.current;
        if (dont_restore != 0) {
            list_h = this.list[0];
            ca = list_h.getListAdapter();
            if (ca == null) {
                Uri lu = s.leftUri != null ? s.leftUri : Uri.parse((String)"home:");
                list_h.mbNavigate(lu, s.leftCrd, s.leftItem, s.current == 0);
            } else if (!"find".equals(ca.getScheme())) {
                list_h.refreshList(s.current == 0, s.leftItem);
            }
        }
        if (dont_restore != 1) {
            list_h = this.list[1];
            ca = list_h.getListAdapter();
            if (ca == null) {
                Uri ru = s.rightUri != null ? s.rightUri : Uri.parse((String)"home:");
                list_h.mbNavigate(ru, s.rightCrd, s.rightItem, s.current == 1);
            } else if (!"find".equals(ca.getScheme())) {
                list_h.refreshList(s.current == 1, s.rightItem);
            }
        }
        this.applyColors();
    }

    final class State {
        private static final String LU = "LEFT_URI";
        private static final String RU = "RIGHT_URI";
        private static final String LC = "LEFT_CRD";
        private static final String RC = "RIGHT_CRD";
        private static final String LI = "LEFT_ITEM";
        private static final String RI = "RIGHT_ITEM";
        private static final String CP = "LAST_PANEL";
        private static final String FU = "FAV_URIS";
        private static final String FV = "FAVS";
        private int current = -1;
        private Credentials leftCrd;
        private Credentials rightCrd;
        private Uri leftUri;
        private Uri rightUri;
        private String leftItem;
        private String rightItem;
        private String favs;
        private String fav_uris;

        State() {
        }

        public final int getCurrent() {
            return this.current;
        }

        public final void store(Bundle b) {
            b.putInt(CP, this.current);
            b.putParcelable(LC, (Parcelable)this.leftCrd);
            b.putParcelable(RC, (Parcelable)this.rightCrd);
            b.putParcelable(LU, (Parcelable)this.leftUri);
            b.putParcelable(RU, (Parcelable)this.rightUri);
            b.putString(LI, this.leftItem);
            b.putString(RI, this.rightItem);
            b.putString(FV, this.favs);
        }

        public final void restore(Bundle b) {
            this.current = b.getInt(CP);
            this.leftCrd = (Credentials)b.getParcelable(LC);
            this.rightCrd = (Credentials)b.getParcelable(RC);
            this.leftUri = (Uri)b.getParcelable(LU);
            this.rightUri = (Uri)b.getParcelable(RU);
            this.leftItem = b.getString(LI);
            this.rightItem = b.getString(RI);
            this.favs = b.getString(FV);
            if (this.favs == null || this.favs.length() == 0) {
                this.fav_uris = b.getString(FU);
            }
        }

        public final void store(SharedPreferences.Editor e) {
            e.putInt(CP, this.current);
            e.putString(LU, this.leftUri != null ? this.leftUri.toString() : "");
            e.putString(RU, this.rightUri != null ? this.rightUri.toString() : "");
            e.putString(LC, this.leftCrd != null ? this.leftCrd.exportToEncriptedString() : "");
            e.putString(RC, this.rightCrd != null ? this.rightCrd.exportToEncriptedString() : "");
            e.putString(LI, this.leftItem);
            e.putString(RI, this.rightItem);
            e.putString(FV, this.favs);
        }

        public final void restore(SharedPreferences p) {
            String right_crd_s;
            String left_crd_s;
            String right_uri_s;
            String left_uri_s = p.getString(LU, null);
            if (Utils.str(left_uri_s)) {
                this.leftUri = Uri.parse((String)left_uri_s);
            }
            if (Utils.str(right_uri_s = p.getString(RU, null))) {
                this.rightUri = Uri.parse((String)right_uri_s);
            }
            if (Utils.str(left_crd_s = p.getString(LC, null))) {
                this.leftCrd = Credentials.createFromEncriptedString(left_crd_s);
            }
            if (Utils.str(right_crd_s = p.getString(RC, null))) {
                this.rightCrd = Credentials.createFromEncriptedString(right_crd_s);
            }
            this.leftItem = p.getString(LI, null);
            this.rightItem = p.getString(RI, null);
            this.current = p.getInt(CP, 0);
            this.favs = p.getString(FV, "");
            if (this.favs == null || this.favs.length() == 0) {
                this.fav_uris = p.getString(FU, "");
            }
        }
    }

    class NavDialog
    implements DialogInterface.OnClickListener {
        private final Uri sdcard = Uri.parse((String)DEFAULT_LOC);
        protected int which;
        protected String posTo;
        protected Uri uri;

        NavDialog(Context c, int which_, Uri uri_, String posTo_) {
            this.which = which_;
            this.uri = uri_;
            this.posTo = posTo_;
            LayoutInflater factory = LayoutInflater.from((Context)c);
            new AlertDialog.Builder(c).setIcon(17301543).setTitle(2131362042).setView(factory.inflate(2130903052, null)).setPositiveButton(2131361916, (DialogInterface.OnClickListener)this).setNeutralButton(2131361917, (DialogInterface.OnClickListener)this).setNegativeButton(2131361828, (DialogInterface.OnClickListener)this).show();
        }

        public void onClick(DialogInterface idialog, int whichButton) {
            if (whichButton == -1) {
                Panels.this.warnOnRoot = false;
                if (Panels.this.rootOnRoot) {
                    this.uri = this.uri.buildUpon().scheme("root").build();
                }
                Panels.this.NavigateInternal(this.which, this.uri, null, this.posTo);
            } else if (whichButton == -3) {
                Panels.this.NavigateInternal(this.which, this.sdcard, null, null);
            } else {
                Panels.this.NavigateInternal(this.which, Uri.parse((String)"home:"), null, null);
            }
            idialog.dismiss();
        }
    }
}

