/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;

public class FileProvider
extends ContentProvider {
    private static final String TAG = "FileProvider";
    public static final String URI_PREFIX = "content://com.ghostsq.commander.FileProvider";
    public static final String AUTHORITY = "com.ghostsq.commander.FileProvider";

    public boolean onCreate() {
        return true;
    }

    public String getType(Uri uri) {
        String ext = Utils.getFileExt(uri.getPath());
        String mime = Utils.getMimeByExt(ext);
        return mime;
    }

    public Cursor query(Uri uri, String[] as, String s, String[] as1, String s1) {
        Log.v((String)TAG, (String)("query( " + uri + " )"));
        if (uri.toString().startsWith(URI_PREFIX)) {
            if (as == null || as.length == 0) {
                as = new String[]{"_data", "mime_type", "_display_name", "_size"};
            }
            MatrixCursor c = new MatrixCursor(as);
            MatrixCursor.RowBuilder row = c.newRow();
            File f = new File(uri.getPath());
            if (!f.exists() || !f.isFile()) {
                throw new RuntimeException("No file name specified: " + uri);
            }
            for (String col : as) {
                if ("_data".equals(col)) {
                    row.add((Object)f.getAbsolutePath());
                    continue;
                }
                if ("mime_type".equals(col)) {
                    row.add((Object)this.getType(uri));
                    continue;
                }
                if ("_display_name".equals(col)) {
                    row.add((Object)f.getName());
                    continue;
                }
                if ("_size".equals(col)) {
                    row.add((Object)f.length());
                    continue;
                }
                row.add(null);
            }
            return c;
        }
        throw new RuntimeException("Unsupported URI");
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        File file = new File(uri.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        ParcelFileDescriptor parcel = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        return parcel;
    }

    public int update(Uri uri, ContentValues contentvalues, String s, String[] as) {
        return 0;
    }

    public int delete(Uri uri, String s, String[] as) {
        return 0;
    }

    public Uri insert(Uri uri, ContentValues contentvalues) {
        return null;
    }
}

