/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Editor
extends Activity
implements TextWatcher {
    private static final String TAG = "EditorActivity";
    private static final String SP_ENC = "encoding";
    static final int MENU_SAVE = 214;
    static final int MENU_SVAS = 212;
    static final int MENU_RELD = 439;
    static final int MENU_WRAP = 241;
    static final int MENU_ENC = 363;
    static final int MENU_EXIT = 323;
    private EditText te;
    private boolean horScroll = true;
    public Uri uri;
    public CommanderAdapter ca;
    public boolean dirty = false;
    public String encoding;
    private DataLoadTask loader = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            SharedPreferences prefs = this.getPreferences(0);
            if (prefs != null) {
                this.encoding = prefs.getString(SP_ENC, "");
            }
            boolean ct_enabled = this.requestWindowFeature(7);
            this.setContentView(2130903045);
            this.te = (EditText)this.findViewById(2131230791);
            this.te.addTextChangedListener((TextWatcher)this);
            this.te.setFilters(new InputFilter[]{new InputFilter.LengthFilter(Integer.MAX_VALUE)});
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            int fs = Integer.parseInt(shared_pref != null ? shared_pref.getString("font_size", "12") : "12");
            this.te.setTextSize((float)fs);
            ColorsKeeper ck = new ColorsKeeper((Context)this);
            ck.restore();
            this.te.setBackgroundColor(ck.bgrColor);
            this.te.setTextColor(ck.fgrColor);
            if (ct_enabled) {
                this.getWindow().setFeatureInt(7, 2130903041);
                TextView act_name_tv = (TextView)this.findViewById(2131230781);
                if (act_name_tv != null) {
                    act_name_tv.setText(2131362073);
                }
            }
            this.uri = this.getIntent().getData();
            this.loader = new DataLoadTask();
            this.loader.execute(new Void[0]);
            TextView file_name_tv = (TextView)this.findViewById(2131230782);
            if (file_name_tv != null) {
                String label_text = " - " + this.uri.getPath();
                String frgm = this.uri.getFragment();
                if (frgm != null) {
                    label_text = label_text + " (" + frgm + ")";
                }
                file_name_tv.setText((CharSequence)label_text);
            }
            this.te.setHorizontallyScrolling(this.horScroll);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            this.finish();
        }
    }

    protected void onPause() {
        super.onPause();
        SharedPreferences.Editor editor = this.getPreferences(0).edit();
        editor.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        editor.commit();
    }

    protected void onStop() {
        Log.d((String)TAG, (String)"onStop");
        super.onStop();
        if (this.ca != null) {
            this.ca.prepareToDestroy();
        }
        this.ca = null;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.loader != null) {
            this.loader.cancel(true);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (!this.dirty) break;
                DialogInterface.OnClickListener ocl = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which_button) {
                        if (which_button == -1) {
                            new DataSaveTask(true).execute(new Uri[]{Editor.this.uri});
                        } else if (which_button == -2) {
                            Editor.this.finish();
                        }
                    }
                };
                new AlertDialog.Builder((Context)this).setIcon(17301543).setTitle(2131362165).setMessage(2131362164).setPositiveButton(2131362165, ocl).setNegativeButton(2131361917, ocl).show();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.clear();
        menu2.add(0, 214, 0, (CharSequence)this.getString(2131362165)).setIcon(17301582);
        menu2.add(0, 212, 0, (CharSequence)this.getString(2131362166)).setIcon(17301582);
        menu2.add(0, 439, 0, (CharSequence)this.getString(2131362167)).setIcon(17301580);
        menu2.add(0, 241, 0, (CharSequence)this.getString(2131362168)).setIcon(2130837545);
        menu2.add(0, 363, 0, (CharSequence)Utils.getEncodingDescr((Context)this, this.encoding, 1)).setIcon(17301660);
        menu2.add(0, 323, 0, (CharSequence)this.getString(2131361850)).setIcon(17301594);
        return true;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        switch (item.getItemId()) {
            case 214: {
                new DataSaveTask(false).execute(new Uri[]{this.uri});
                return true;
            }
            case 212: {
                try {
                    LayoutInflater factory = LayoutInflater.from((Context)this);
                    View iv = factory.inflate(2130903046, null);
                    if (iv != null) {
                        TextView prompt = (TextView)iv.findViewById(2131230792);
                        final EditText edit = (EditText)iv.findViewById(2131230793);
                        prompt.setText(2131361942);
                        edit.setText((CharSequence)this.uri.toString());
                        new AlertDialog.Builder((Context)this).setTitle(2131362166).setView(iv).setPositiveButton(2131362165, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int i) {
                                new DataSaveTask(false).execute(new Uri[]{Uri.parse((String)edit.getText().toString())});
                            }
                        }).setNegativeButton(2131361917, null).show();
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
                return true;
            }
            case 439: {
                this.loader = new DataLoadTask();
                this.loader.execute(new Void[0]);
                return true;
            }
            case 363: {
                int cen = Integer.parseInt(Utils.getEncodingDescr((Context)this, this.encoding, 0));
                new AlertDialog.Builder((Context)this).setTitle(2131362172).setSingleChoiceItems(2131296263, cen, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        dialog.dismiss();
                        Editor.this.encoding = Editor.this.getResources().getStringArray(2131296264)[i];
                        Log.i((String)Editor.TAG, (String)("Chosen encoding: " + Editor.this.encoding));
                        Editor.this.showMessage(Editor.this.getString(2131362173, new Object[]{Editor.this.encoding}));
                    }
                }).show();
                return true;
            }
            case 241: {
                try {
                    EditText te = (EditText)this.findViewById(2131230791);
                    this.horScroll = !this.horScroll;
                    te.setHorizontallyScrolling(this.horScroll);
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                }
                return true;
            }
            case 323: {
                this.finish();
            }
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public final void showMessage(String s) {
        Toast.makeText((Context)this, (CharSequence)s, (int)1).show();
    }

    public void afterTextChanged(Editable s) {
        this.dirty = true;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataSaveTask
    extends AsyncTask<Uri, String, Boolean> {
        private ProgressDialog pd;
        private boolean close_on_finish;

        DataSaveTask(boolean close_on_finish_) {
            this.close_on_finish = close_on_finish_;
        }

        protected void onPreExecute() {
            this.pd = ProgressDialog.show((Context)Editor.this, (CharSequence)"", (CharSequence)Editor.this.getString(2131361903), (boolean)true, (boolean)true);
        }

        protected Boolean doInBackground(Uri ... save_uri_) {
            Uri save_uri;
            Uri uri = save_uri = save_uri_.length > 0 ? save_uri_[0] : null;
            if (save_uri == null || Editor.this.ca == null) {
                return false;
            }
            Credentials crd = null;
            try {
                crd = (Credentials)Editor.this.getIntent().getParcelableExtra(Credentials.KEY);
            }
            catch (Exception e) {
                Log.e((String)Editor.TAG, (String)"on taking credentials from parcel", (Throwable)e);
            }
            Editor.this.ca.setCredentials(crd);
            OutputStream os = Editor.this.ca.saveContent(save_uri);
            if (os == null) {
                return false;
            }
            try {
                int BUF_SIZE = 16384;
                OutputStreamWriter osw = Editor.this.encoding != null && Editor.this.encoding.length() != 0 ? new OutputStreamWriter(os, Editor.this.encoding) : new OutputStreamWriter(os);
                Editable e = Editor.this.te.getText();
                int len = e.length();
                if (len < 16384) {
                    osw.write(e.toString());
                    osw.flush();
                } else {
                    char[] chars = new char[16384];
                    int start = 0;
                    int end = 16384;
                    while (start < len - 1) {
                        e.getChars(start, end, chars, 0);
                        osw.write(chars, 0, end - start);
                        start = end;
                        if ((end += 16384) <= len) continue;
                        end = len - 1;
                    }
                    osw.flush();
                }
                Editor.this.ca.closeStream(os);
                File f = new File(save_uri.getPath());
                this.publishProgress(new String[]{Editor.this.getString(2131362163, new Object[]{f.getName()})});
                return true;
            }
            catch (Throwable e) {
                Log.e((String)Editor.TAG, (String)Favorite.screenPwd(save_uri), (Throwable)e);
                return false;
            }
        }

        protected void onProgressUpdate(String ... err) {
            if (err.length > 0) {
                Editor.this.showMessage(err[0]);
            }
        }

        protected void onPostExecute(Boolean succeeded) {
            this.pd.cancel();
            if (succeeded.booleanValue()) {
                Editor.this.dirty = false;
            } else {
                Editor.this.showMessage(Editor.this.getString(2131362180));
            }
            if (this.close_on_finish) {
                Editor.this.finish();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataLoadTask
    extends AsyncTask<Void, String, CharSequence> {
        private ProgressDialog pd;

        private DataLoadTask() {
        }

        protected void onPreExecute() {
            this.pd = ProgressDialog.show((Context)Editor.this, (CharSequence)"", (CharSequence)Editor.this.getString(2131361988), (boolean)true, (boolean)true);
        }

        protected CharSequence doInBackground(Void ... v) {
            Uri uri = Editor.this.uri;
            try {
                String scheme = uri.getScheme();
                InputStream is = null;
                if (Editor.this.ca == null) {
                    Editor.this.ca = CA.CreateAdapterInstance(scheme, (Context)Editor.this);
                }
                if (Editor.this.ca != null) {
                    Credentials crd = null;
                    try {
                        crd = (Credentials)Editor.this.getIntent().getParcelableExtra(Credentials.KEY);
                    }
                    catch (Exception e) {
                        Log.e((String)Editor.TAG, (String)"on taking credentials from parcel", (Throwable)e);
                    }
                    Editor.this.ca.setCredentials(crd);
                    is = Editor.this.ca.getContent(uri);
                }
                if (is != null) {
                    CharSequence cs = Utils.readStreamToBuffer(is, Editor.this.encoding);
                    if (Editor.this.ca != null) {
                        Editor.this.ca.closeStream(is);
                    } else {
                        is.close();
                    }
                    return cs;
                }
                this.publishProgress(new String[]{Editor.this.getString(2131361999, new Object[]{uri.toString()})});
            }
            catch (OutOfMemoryError e) {
                Log.e((String)Editor.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{Editor.this.getString(2131362175, new Object[]{uri.getPath()})});
            }
            catch (Throwable e) {
                Log.e((String)Editor.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{Editor.this.getString(2131361905) + e.getLocalizedMessage()});
            }
            return null;
        }

        protected void onProgressUpdate(String ... err) {
            if (err.length > 0) {
                Editor.this.showMessage(err[0]);
            }
        }

        protected void onPostExecute(CharSequence cs) {
            this.pd.cancel();
            Editor.this.te.setText(cs);
            Editor.this.dirty = false;
            Editor.this.loader = null;
        }
    }
}

