/*
 * Decompiled with CFR 0.152.
 */
package com.example.touch;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.ImageView;

@TargetApi(value=8)
public class TouchImageView
extends ImageView {
    Matrix matrix;
    static final int NONE = 0;
    static final int DRAG = 1;
    static final int ZOOM = 2;
    int mode = 0;
    PointF last = new PointF();
    PointF start = new PointF();
    float minScale = 1.0f;
    float maxScale = 3.0f;
    float[] m;
    float redundantXSpace;
    float redundantYSpace;
    float width;
    float height;
    static final int CLICK = 10;
    float saveScale = 1.0f;
    float right;
    float bottom;
    float origWidth;
    float origHeight;
    float bmWidth;
    float bmHeight;
    ScaleGestureDetector mScaleDetector;
    Context context;

    public TouchImageView(Context context) {
        super(context);
        super.setClickable(true);
        this.context = context;
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.init();
    }

    public final void init() {
        this.matrix = new Matrix();
        this.matrix.setTranslate(1.0f, 1.0f);
        this.m = new float[9];
        this.setImageMatrix(this.matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.mScaleDetector.onTouchEvent(event);
        this.matrix.getValues(this.m);
        float x = this.m[2];
        float y = this.m[5];
        PointF curr = new PointF(event.getX(), event.getY());
        switch (event.getAction()) {
            case 0: {
                this.last.set(event.getX(), event.getY());
                this.start.set(this.last);
                this.mode = 1;
                break;
            }
            case 2: {
                if (this.mode != 1) break;
                float deltaX = curr.x - this.last.x;
                float deltaY = curr.y - this.last.y;
                float scaleWidth = Math.round(this.origWidth * this.saveScale);
                float scaleHeight = Math.round(this.origHeight * this.saveScale);
                if (scaleWidth < this.width) {
                    deltaX = 0.0f;
                    if (y + deltaY > 0.0f) {
                        deltaY = -y;
                    } else if (y + deltaY < -this.bottom) {
                        deltaY = -(y + this.bottom);
                    }
                } else if (scaleHeight < this.height) {
                    deltaY = 0.0f;
                    if (x + deltaX > 0.0f) {
                        deltaX = -x;
                    } else if (x + deltaX < -this.right) {
                        deltaX = -(x + this.right);
                    }
                } else {
                    if (x + deltaX > 0.0f) {
                        deltaX = -x;
                    } else if (x + deltaX < -this.right) {
                        deltaX = -(x + this.right);
                    }
                    if (y + deltaY > 0.0f) {
                        deltaY = -y;
                    } else if (y + deltaY < -this.bottom) {
                        deltaY = -(y + this.bottom);
                    }
                }
                this.matrix.postTranslate(deltaX, deltaY);
                this.last.set(curr.x, curr.y);
                break;
            }
            case 1: {
                this.mode = 0;
                int xDiff = (int)Math.abs(curr.x - this.start.x);
                int yDiff = (int)Math.abs(curr.y - this.start.y);
                if (xDiff < 10 && yDiff < 10) {
                    return false;
                }
            }
            case 6: {
                this.mode = 0;
            }
        }
        this.setImageMatrix(this.matrix);
        this.invalidate();
        return true;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.bmWidth = bm.getWidth();
        this.bmHeight = bm.getHeight();
    }

    public final void setMaxZoom(float x) {
        this.maxScale = x;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float scaleX = this.width / this.bmWidth;
        float scaleY = this.height / this.bmHeight;
        float scale = Math.min(scaleX, scaleY);
        this.matrix.setScale(scale, scale);
        this.setImageMatrix(this.matrix);
        this.saveScale = 1.0f;
        this.redundantYSpace = this.height - scale * this.bmHeight;
        this.redundantXSpace = this.width - scale * this.bmWidth;
        this.redundantYSpace /= 2.0f;
        this.redundantXSpace /= 2.0f;
        this.matrix.postTranslate(this.redundantXSpace, this.redundantYSpace);
        this.origWidth = this.width - 2.0f * this.redundantXSpace;
        this.origHeight = this.height - 2.0f * this.redundantYSpace;
        this.right = this.width * this.saveScale - this.width - 2.0f * this.redundantXSpace * this.saveScale;
        this.bottom = this.height * this.saveScale - this.height - 2.0f * this.redundantYSpace * this.saveScale;
        this.setImageMatrix(this.matrix);
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            TouchImageView.this.mode = 2;
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mScaleFactor = (float)Math.min((double)Math.max(0.95f, detector.getScaleFactor()), 1.05);
            float origScale = TouchImageView.this.saveScale;
            TouchImageView.this.saveScale *= mScaleFactor;
            if (TouchImageView.this.saveScale > TouchImageView.this.maxScale) {
                TouchImageView.this.saveScale = TouchImageView.this.maxScale;
                mScaleFactor = TouchImageView.this.maxScale / origScale;
            } else if (TouchImageView.this.saveScale < TouchImageView.this.minScale) {
                TouchImageView.this.saveScale = TouchImageView.this.minScale;
                mScaleFactor = TouchImageView.this.minScale / origScale;
            }
            TouchImageView.this.right = TouchImageView.this.width * TouchImageView.this.saveScale - TouchImageView.this.width - 2.0f * TouchImageView.this.redundantXSpace * TouchImageView.this.saveScale;
            TouchImageView.this.bottom = TouchImageView.this.height * TouchImageView.this.saveScale - TouchImageView.this.height - 2.0f * TouchImageView.this.redundantYSpace * TouchImageView.this.saveScale;
            if (TouchImageView.this.origWidth * TouchImageView.this.saveScale <= TouchImageView.this.width || TouchImageView.this.origHeight * TouchImageView.this.saveScale <= TouchImageView.this.height) {
                TouchImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, TouchImageView.this.width / 2.0f, TouchImageView.this.height / 2.0f);
                if (mScaleFactor < 1.0f) {
                    TouchImageView.this.matrix.getValues(TouchImageView.this.m);
                    float x = TouchImageView.this.m[2];
                    float y = TouchImageView.this.m[5];
                    if (mScaleFactor < 1.0f) {
                        if ((float)Math.round(TouchImageView.this.origWidth * TouchImageView.this.saveScale) < TouchImageView.this.width) {
                            if (y < -TouchImageView.this.bottom) {
                                TouchImageView.this.matrix.postTranslate(0.0f, -(y + TouchImageView.this.bottom));
                            } else if (y > 0.0f) {
                                TouchImageView.this.matrix.postTranslate(0.0f, -y);
                            }
                        } else if (x < -TouchImageView.this.right) {
                            TouchImageView.this.matrix.postTranslate(-(x + TouchImageView.this.right), 0.0f);
                        } else if (x > 0.0f) {
                            TouchImageView.this.matrix.postTranslate(-x, 0.0f);
                        }
                    }
                }
            } else {
                TouchImageView.this.matrix.postScale(mScaleFactor, mScaleFactor, detector.getFocusX(), detector.getFocusY());
                TouchImageView.this.matrix.getValues(TouchImageView.this.m);
                float x = TouchImageView.this.m[2];
                float y = TouchImageView.this.m[5];
                if (mScaleFactor < 1.0f) {
                    if (x < -TouchImageView.this.right) {
                        TouchImageView.this.matrix.postTranslate(-(x + TouchImageView.this.right), 0.0f);
                    } else if (x > 0.0f) {
                        TouchImageView.this.matrix.postTranslate(-x, 0.0f);
                    }
                    if (y < -TouchImageView.this.bottom) {
                        TouchImageView.this.matrix.postTranslate(0.0f, -(y + TouchImageView.this.bottom));
                    } else if (y > 0.0f) {
                        TouchImageView.this.matrix.postTranslate(0.0f, -y);
                    }
                }
            }
            return true;
        }
    }
}

