/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ɵɵdefineInjector } from '../di/interface/defs';
import { convertInjectableProviderToFactory } from '../di/util';
import { compileNgModule as render3CompileNgModule } from '../render3/jit/module';
import { makeDecorator } from '../util/decorators';
const ɵ0 = (ngModule) => ngModule, ɵ1 = 
/**
 * Decorator that marks the following class as an NgModule, and supplies
 * configuration metadata for it.
 *
 * * The `declarations` and `entryComponents` options configure the compiler
 * with information about what belongs to the NgModule.
 * * The `providers` options configures the NgModule's injector to provide
 * dependencies the NgModule members.
 * * The `imports` and `exports` options bring in members from other modules, and make
 * this module's members available to others.
 */
(type, meta) => SWITCH_COMPILE_NGMODULE(type, meta);
/**
 * @Annotation
 * @publicApi
 */
export const NgModule = makeDecorator('NgModule', ɵ0, undefined, undefined, ɵ1);
function preR3NgModuleCompile(moduleType, metadata) {
    let imports = (metadata && metadata.imports) || [];
    if (metadata && metadata.exports) {
        imports = [...imports, metadata.exports];
    }
    const moduleInjectorType = moduleType;
    moduleInjectorType.ɵfac = convertInjectableProviderToFactory(moduleType, { useClass: moduleType });
    moduleInjectorType.ɵinj =
        ɵɵdefineInjector({ providers: metadata && metadata.providers, imports: imports });
}
export const SWITCH_COMPILE_NGMODULE__POST_R3__ = render3CompileNgModule;
const SWITCH_COMPILE_NGMODULE__PRE_R3__ = preR3NgModuleCompile;
const SWITCH_COMPILE_NGMODULE = SWITCH_COMPILE_NGMODULE__PRE_R3__;
export { ɵ0, ɵ1 };
//# sourceMappingURL=data:application/json;base64,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