/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point from which you should import all public core APIs.
 */
export * from './metadata';
export * from './version';
export * from './di';
export { createPlatform, assertPlatform, destroyPlatform, getPlatform, PlatformRef, ApplicationRef, createPlatformFactory, NgProbeToken } from './application_ref';
export { enableProdMode, isDevMode } from './util/is_dev_mode';
export { APP_ID, PACKAGE_ROOT_URL, PLATFORM_INITIALIZER, PLATFORM_ID, APP_BOOTSTRAP_LISTENER } from './application_tokens';
export { APP_INITIALIZER, ApplicationInitStatus } from './application_init';
export * from './zone';
export * from './render';
export * from './linker';
export { DebugElement, DebugEventListener, DebugNode, asNativeElements, getDebugNode } from './debug/debug_node';
export { Testability, TestabilityRegistry, setTestabilityGetter } from './testability/testability';
export * from './change_detection';
export * from './platform_core_providers';
export { TRANSLATIONS, TRANSLATIONS_FORMAT, LOCALE_ID, DEFAULT_CURRENCY_CODE, MissingTranslationStrategy } from './i18n/tokens';
export { ApplicationModule } from './application_module';
export { Type } from './interface/type';
export { EventEmitter } from './event_emitter';
export { ErrorHandler } from './error_handler';
export * from './core_private_export';
export * from './core_render3_private_export';
export { SecurityContext } from './sanitization/security';
export { Sanitizer } from './sanitization/sanitizer';
export * from './codegen_private_exports';
import { global } from './util/global';
if (typeof ngDevMode !== 'undefined' && ngDevMode) {
    // This helper is to give a reasonable error message to people upgrading to v9 that have not yet
    // installed `@angular/localize` in their app.
    // tslint:disable-next-line: no-toplevel-property-access
    global.$localize = global.$localize || function () {
        throw new Error('It looks like your application or one of its dependencies is using i18n.\n' +
            'Angular 9 introduced a global `$localize()` function that needs to be loaded.\n' +
            'Please run `ng add @angular/localize` from the Angular CLI.\n' +
            '(For non-CLI projects, add `import \'@angular/localize/init\';` to your `polyfills.ts` file.\n' +
            'For server-side rendering applications add the import to your `main.server.ts` file.)');
    };
}
//# sourceMappingURL=data:application/json;base64,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