(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/transform/src/utils", ["require", "exports", "tslib", "typescript"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.addImports = void 0;
    var tslib_1 = require("tslib");
    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ts = require("typescript");
    /**
     * Adds extra imports in the import manage for this source file, after the existing imports
     * and before the module body.
     * Can optionally add extra statements (e.g. new constants) before the body as well.
     */
    function addImports(importManager, sf, extraStatements) {
        if (extraStatements === void 0) { extraStatements = []; }
        // Generate the import statements to prepend.
        var addedImports = importManager.getAllImports(sf.fileName).map(function (i) {
            var qualifier = ts.createIdentifier(i.qualifier.text);
            var importClause = ts.createImportClause(
            /* name */ undefined, 
            /* namedBindings */ ts.createNamespaceImport(qualifier));
            var decl = ts.createImportDeclaration(
            /* decorators */ undefined, 
            /* modifiers */ undefined, 
            /* importClause */ importClause, 
            /* moduleSpecifier */ ts.createLiteral(i.specifier));
            // Set the qualifier's original TS node to the `ts.ImportDeclaration`. This allows downstream
            // transforms such as tsickle to properly process references to this import.
            //
            // This operation is load-bearing in g3 as some imported modules contain special metadata
            // generated by clutz, which tsickle uses to transform imports and references to those imports.
            //
            // TODO(alxhub): add a test for this when tsickle is updated externally to depend on this
            // behavior.
            ts.setOriginalNode(i.qualifier, decl);
            return decl;
        });
        // Filter out the existing imports and the source file body. All new statements
        // will be inserted between them.
        var existingImports = sf.statements.filter(function (stmt) { return isImportStatement(stmt); });
        var body = sf.statements.filter(function (stmt) { return !isImportStatement(stmt); });
        // Prepend imports if needed.
        if (addedImports.length > 0) {
            // If we prepend imports, we also prepend NotEmittedStatement to use it as an anchor
            // for @fileoverview Closure annotation. If there is no @fileoverview annotations, this
            // statement would be a noop.
            var fileoverviewAnchorStmt = ts.createNotEmittedStatement(sf);
            return ts.updateSourceFileNode(sf, ts.createNodeArray(tslib_1.__spread([
                fileoverviewAnchorStmt
            ], existingImports, addedImports, extraStatements, body)));
        }
        return sf;
    }
    exports.addImports = addImports;
    function isImportStatement(stmt) {
        return ts.isImportDeclaration(stmt) || ts.isImportEqualsDeclaration(stmt) ||
            ts.isNamespaceImport(stmt);
    }
});
//# sourceMappingURL=data:application/json;base64,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