/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/transform/src/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.HandlerFlags = exports.HandlerPrecedence = exports.CompilationMode = void 0;
    /**
     * Specifies the compilation mode that is used for the compilation.
     */
    var CompilationMode;
    (function (CompilationMode) {
        /**
         * Generates fully AOT compiled code using Ivy instructions.
         */
        CompilationMode[CompilationMode["FULL"] = 0] = "FULL";
        /**
         * Generates code using a stable, but intermediate format suitable to be published to NPM.
         */
        CompilationMode[CompilationMode["PARTIAL"] = 1] = "PARTIAL";
    })(CompilationMode = exports.CompilationMode || (exports.CompilationMode = {}));
    var HandlerPrecedence;
    (function (HandlerPrecedence) {
        /**
         * Handler with PRIMARY precedence cannot overlap - there can only be one on a given class.
         *
         * If more than one PRIMARY handler matches a class, an error is produced.
         */
        HandlerPrecedence[HandlerPrecedence["PRIMARY"] = 0] = "PRIMARY";
        /**
         * Handlers with SHARED precedence can match any class, possibly in addition to a single PRIMARY
         * handler.
         *
         * It is not an error for a class to have any number of SHARED handlers.
         */
        HandlerPrecedence[HandlerPrecedence["SHARED"] = 1] = "SHARED";
        /**
         * Handlers with WEAK precedence that match a class are ignored if any handlers with stronger
         * precedence match a class.
         */
        HandlerPrecedence[HandlerPrecedence["WEAK"] = 2] = "WEAK";
    })(HandlerPrecedence = exports.HandlerPrecedence || (exports.HandlerPrecedence = {}));
    /**
     * A set of options which can be passed to a `DecoratorHandler` by a consumer, to tailor the output
     * of compilation beyond the decorators themselves.
     */
    var HandlerFlags;
    (function (HandlerFlags) {
        /**
         * No flags set.
         */
        HandlerFlags[HandlerFlags["NONE"] = 0] = "NONE";
        /**
         * Indicates that this decorator is fully inherited from its parent at runtime. In addition to
         * normally inherited aspects such as inputs and queries, full inheritance applies to every aspect
         * of the component or directive, such as the template function itself.
         *
         * Its primary effect is to cause the `CopyDefinitionFeature` to be applied to the definition
         * being compiled. See that class for more information.
         */
        HandlerFlags[HandlerFlags["FULL_INHERITANCE"] = 1] = "FULL_INHERITANCE";
    })(HandlerFlags = exports.HandlerFlags || (exports.HandlerFlags = {}));
});
//# sourceMappingURL=data:application/json;base64,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