/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/main", ["require", "exports", "tslib", "@angular/compiler-cli/ngcc/src/dependencies/commonjs_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/dependency_resolver", "@angular/compiler-cli/ngcc/src/dependencies/dts_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/esm_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/module_resolver", "@angular/compiler-cli/ngcc/src/dependencies/umd_dependency_host", "@angular/compiler-cli/ngcc/src/entry_point_finder/directory_walker_entry_point_finder", "@angular/compiler-cli/ngcc/src/entry_point_finder/entry_point_collector", "@angular/compiler-cli/ngcc/src/entry_point_finder/program_based_entry_point_finder", "@angular/compiler-cli/ngcc/src/entry_point_finder/targeted_entry_point_finder", "@angular/compiler-cli/ngcc/src/execution/analyze_entry_points", "@angular/compiler-cli/ngcc/src/execution/cluster/executor", "@angular/compiler-cli/ngcc/src/execution/create_compile_function", "@angular/compiler-cli/ngcc/src/execution/single_process_executor", "@angular/compiler-cli/ngcc/src/execution/tasks/completion", "@angular/compiler-cli/ngcc/src/locking/async_locker", "@angular/compiler-cli/ngcc/src/locking/lock_file_with_child_process/index", "@angular/compiler-cli/ngcc/src/locking/sync_locker", "@angular/compiler-cli/ngcc/src/ngcc_options", "@angular/compiler-cli/ngcc/src/packages/configuration", "@angular/compiler-cli/ngcc/src/packages/entry_point", "@angular/compiler-cli/ngcc/src/packages/entry_point_manifest", "@angular/compiler-cli/ngcc/src/writing/package_json_updater"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.mainNgcc = void 0;
    var tslib_1 = require("tslib");
    var commonjs_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/commonjs_dependency_host");
    var dependency_resolver_1 = require("@angular/compiler-cli/ngcc/src/dependencies/dependency_resolver");
    var dts_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/dts_dependency_host");
    var esm_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/esm_dependency_host");
    var module_resolver_1 = require("@angular/compiler-cli/ngcc/src/dependencies/module_resolver");
    var umd_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/umd_dependency_host");
    var directory_walker_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/directory_walker_entry_point_finder");
    var entry_point_collector_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/entry_point_collector");
    var program_based_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/program_based_entry_point_finder");
    var targeted_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/targeted_entry_point_finder");
    var analyze_entry_points_1 = require("@angular/compiler-cli/ngcc/src/execution/analyze_entry_points");
    var executor_1 = require("@angular/compiler-cli/ngcc/src/execution/cluster/executor");
    var create_compile_function_1 = require("@angular/compiler-cli/ngcc/src/execution/create_compile_function");
    var single_process_executor_1 = require("@angular/compiler-cli/ngcc/src/execution/single_process_executor");
    var completion_1 = require("@angular/compiler-cli/ngcc/src/execution/tasks/completion");
    var async_locker_1 = require("@angular/compiler-cli/ngcc/src/locking/async_locker");
    var lock_file_with_child_process_1 = require("@angular/compiler-cli/ngcc/src/locking/lock_file_with_child_process/index");
    var sync_locker_1 = require("@angular/compiler-cli/ngcc/src/locking/sync_locker");
    var ngcc_options_1 = require("@angular/compiler-cli/ngcc/src/ngcc_options");
    var configuration_1 = require("@angular/compiler-cli/ngcc/src/packages/configuration");
    var entry_point_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point");
    var entry_point_manifest_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point_manifest");
    var package_json_updater_1 = require("@angular/compiler-cli/ngcc/src/writing/package_json_updater");
    function mainNgcc(options) {
        var _a = ngcc_options_1.getSharedSetup(options), basePath = _a.basePath, targetEntryPointPath = _a.targetEntryPointPath, propertiesToConsider = _a.propertiesToConsider, typingsOnly = _a.typingsOnly, compileAllFormats = _a.compileAllFormats, logger = _a.logger, pathMappings = _a.pathMappings, async = _a.async, errorOnFailedEntryPoint = _a.errorOnFailedEntryPoint, enableI18nLegacyMessageIdFormat = _a.enableI18nLegacyMessageIdFormat, invalidateEntryPointManifest = _a.invalidateEntryPointManifest, fileSystem = _a.fileSystem, absBasePath = _a.absBasePath, projectPath = _a.projectPath, tsConfig = _a.tsConfig, getFileWriter = _a.getFileWriter;
        var config = new configuration_1.NgccConfiguration(fileSystem, projectPath);
        var dependencyResolver = getDependencyResolver(fileSystem, logger, config, pathMappings);
        var entryPointManifest = invalidateEntryPointManifest ?
            new entry_point_manifest_1.InvalidatingEntryPointManifest(fileSystem, config, logger) :
            new entry_point_manifest_1.EntryPointManifest(fileSystem, config, logger);
        // Bail out early if the work is already done.
        var supportedPropertiesToConsider = ensureSupportedProperties(propertiesToConsider);
        var absoluteTargetEntryPointPath = targetEntryPointPath !== undefined ?
            fileSystem.resolve(basePath, targetEntryPointPath) :
            null;
        var finder = getEntryPointFinder(fileSystem, logger, dependencyResolver, config, entryPointManifest, absBasePath, absoluteTargetEntryPointPath, pathMappings, options.findEntryPointsFromTsConfigProgram ? tsConfig : null, projectPath);
        if (finder instanceof targeted_entry_point_finder_1.TargetedEntryPointFinder &&
            !finder.targetNeedsProcessingOrCleaning(supportedPropertiesToConsider, compileAllFormats)) {
            logger.debug('The target entry-point has already been processed');
            return;
        }
        // Determine the number of workers to use and whether ngcc should run in parallel.
        var workerCount = async ? ngcc_options_1.getMaxNumberOfWorkers() : 1;
        var inParallel = workerCount > 1;
        var analyzeEntryPoints = analyze_entry_points_1.getAnalyzeEntryPointsFn(logger, finder, fileSystem, supportedPropertiesToConsider, typingsOnly, compileAllFormats, propertiesToConsider, inParallel);
        // Create an updater that will actually write to disk.
        var pkgJsonUpdater = new package_json_updater_1.DirectPackageJsonUpdater(fileSystem);
        var fileWriter = getFileWriter(pkgJsonUpdater);
        // The function for creating the `compile()` function.
        var createCompileFn = create_compile_function_1.getCreateCompileFn(fileSystem, logger, fileWriter, enableI18nLegacyMessageIdFormat, tsConfig, pathMappings);
        // The executor for actually planning and getting the work done.
        var createTaskCompletedCallback = getCreateTaskCompletedCallback(pkgJsonUpdater, errorOnFailedEntryPoint, logger, fileSystem);
        var executor = getExecutor(async, workerCount, logger, fileWriter, pkgJsonUpdater, fileSystem, config, createTaskCompletedCallback);
        return executor.execute(analyzeEntryPoints, createCompileFn);
    }
    exports.mainNgcc = mainNgcc;
    function ensureSupportedProperties(properties) {
        var e_1, _a;
        // Short-circuit the case where `properties` has fallen back to the default value:
        // `SUPPORTED_FORMAT_PROPERTIES`
        if (properties === entry_point_1.SUPPORTED_FORMAT_PROPERTIES)
            return entry_point_1.SUPPORTED_FORMAT_PROPERTIES;
        var supportedProperties = [];
        try {
            for (var _b = tslib_1.__values(properties), _c = _b.next(); !_c.done; _c = _b.next()) {
                var prop = _c.value;
                if (entry_point_1.SUPPORTED_FORMAT_PROPERTIES.indexOf(prop) !== -1) {
                    supportedProperties.push(prop);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (supportedProperties.length === 0) {
            throw new Error("No supported format property to consider among [" + properties.join(', ') + "]. " +
                ("Supported properties: " + entry_point_1.SUPPORTED_FORMAT_PROPERTIES.join(', ')));
        }
        return supportedProperties;
    }
    function getCreateTaskCompletedCallback(pkgJsonUpdater, errorOnFailedEntryPoint, logger, fileSystem) {
        return function (taskQueue) {
            var _a;
            return completion_1.composeTaskCompletedCallbacks((_a = {},
                _a[0 /* Processed */] = completion_1.createMarkAsProcessedHandler(fileSystem, pkgJsonUpdater),
                _a[1 /* Failed */] = errorOnFailedEntryPoint ? completion_1.createThrowErrorHandler(fileSystem) :
                    completion_1.createLogErrorHandler(logger, fileSystem, taskQueue),
                _a));
        };
    }
    function getExecutor(async, workerCount, logger, fileWriter, pkgJsonUpdater, fileSystem, config, createTaskCompletedCallback) {
        var lockFile = new lock_file_with_child_process_1.LockFileWithChildProcess(fileSystem, logger);
        if (async) {
            // Execute asynchronously (either serially or in parallel)
            var _a = config.getLockingConfig(), retryAttempts = _a.retryAttempts, retryDelay = _a.retryDelay;
            var locker = new async_locker_1.AsyncLocker(lockFile, logger, retryDelay, retryAttempts);
            if (workerCount > 1) {
                // Execute in parallel.
                return new executor_1.ClusterExecutor(workerCount, fileSystem, logger, fileWriter, pkgJsonUpdater, locker, createTaskCompletedCallback);
            }
            else {
                // Execute serially, on a single thread (async).
                return new single_process_executor_1.SingleProcessExecutorAsync(logger, locker, createTaskCompletedCallback);
            }
        }
        else {
            // Execute serially, on a single thread (sync).
            return new single_process_executor_1.SingleProcessExecutorSync(logger, new sync_locker_1.SyncLocker(lockFile), createTaskCompletedCallback);
        }
    }
    function getDependencyResolver(fileSystem, logger, config, pathMappings) {
        var moduleResolver = new module_resolver_1.ModuleResolver(fileSystem, pathMappings);
        var esmDependencyHost = new esm_dependency_host_1.EsmDependencyHost(fileSystem, moduleResolver);
        var umdDependencyHost = new umd_dependency_host_1.UmdDependencyHost(fileSystem, moduleResolver);
        var commonJsDependencyHost = new commonjs_dependency_host_1.CommonJsDependencyHost(fileSystem, moduleResolver);
        var dtsDependencyHost = new dts_dependency_host_1.DtsDependencyHost(fileSystem, pathMappings);
        return new dependency_resolver_1.DependencyResolver(fileSystem, logger, config, {
            esm5: esmDependencyHost,
            esm2015: esmDependencyHost,
            umd: umdDependencyHost,
            commonjs: commonJsDependencyHost
        }, dtsDependencyHost);
    }
    function getEntryPointFinder(fs, logger, resolver, config, entryPointManifest, basePath, absoluteTargetEntryPointPath, pathMappings, tsConfig, projectPath) {
        if (absoluteTargetEntryPointPath !== null) {
            return new targeted_entry_point_finder_1.TargetedEntryPointFinder(fs, config, logger, resolver, basePath, pathMappings, absoluteTargetEntryPointPath);
        }
        else {
            var entryPointCollector = new entry_point_collector_1.EntryPointCollector(fs, config, logger, resolver);
            if (tsConfig !== null) {
                return new program_based_entry_point_finder_1.ProgramBasedEntryPointFinder(fs, config, logger, resolver, entryPointCollector, entryPointManifest, basePath, tsConfig, projectPath);
            }
            else {
                return new directory_walker_entry_point_finder_1.DirectoryWalkerEntryPointFinder(logger, resolver, entryPointCollector, entryPointManifest, basePath, pathMappings);
            }
        }
    }
});
//# sourceMappingURL=data:application/json;base64,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