/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** @internal */
export const CURRENCIES_EN = {
    'ADP': [undefined, undefined, 0],
    'AFN': [undefined, undefined, 0],
    'ALL': [undefined, undefined, 0],
    'AMD': [undefined, undefined, 2],
    'AOA': [undefined, 'Kz'],
    'ARS': [undefined, '$'],
    'AUD': ['A$', '$'],
    'BAM': [undefined, 'KM'],
    'BBD': [undefined, '$'],
    'BDT': [undefined, '৳'],
    'BHD': [undefined, undefined, 3],
    'BIF': [undefined, undefined, 0],
    'BMD': [undefined, '$'],
    'BND': [undefined, '$'],
    'BOB': [undefined, 'Bs'],
    'BRL': ['R$'],
    'BSD': [undefined, '$'],
    'BWP': [undefined, 'P'],
    'BYN': [undefined, 'р.', 2],
    'BYR': [undefined, undefined, 0],
    'BZD': [undefined, '$'],
    'CAD': ['CA$', '$', 2],
    'CHF': [undefined, undefined, 2],
    'CLF': [undefined, undefined, 4],
    'CLP': [undefined, '$', 0],
    'CNY': ['CN¥', '¥'],
    'COP': [undefined, '$', 2],
    'CRC': [undefined, '₡', 2],
    'CUC': [undefined, '$'],
    'CUP': [undefined, '$'],
    'CZK': [undefined, 'Kč', 2],
    'DJF': [undefined, undefined, 0],
    'DKK': [undefined, 'kr', 2],
    'DOP': [undefined, '$'],
    'EGP': [undefined, 'E£'],
    'ESP': [undefined, '₧', 0],
    'EUR': ['€'],
    'FJD': [undefined, '$'],
    'FKP': [undefined, '£'],
    'GBP': ['£'],
    'GEL': [undefined, '₾'],
    'GIP': [undefined, '£'],
    'GNF': [undefined, 'FG', 0],
    'GTQ': [undefined, 'Q'],
    'GYD': [undefined, '$', 2],
    'HKD': ['HK$', '$'],
    'HNL': [undefined, 'L'],
    'HRK': [undefined, 'kn'],
    'HUF': [undefined, 'Ft', 2],
    'IDR': [undefined, 'Rp', 2],
    'ILS': ['₪'],
    'INR': ['₹'],
    'IQD': [undefined, undefined, 0],
    'IRR': [undefined, undefined, 0],
    'ISK': [undefined, 'kr', 0],
    'ITL': [undefined, undefined, 0],
    'JMD': [undefined, '$'],
    'JOD': [undefined, undefined, 3],
    'JPY': ['¥', undefined, 0],
    'KHR': [undefined, '៛'],
    'KMF': [undefined, 'CF', 0],
    'KPW': [undefined, '₩', 0],
    'KRW': ['₩', undefined, 0],
    'KWD': [undefined, undefined, 3],
    'KYD': [undefined, '$'],
    'KZT': [undefined, '₸'],
    'LAK': [undefined, '₭', 0],
    'LBP': [undefined, 'L£', 0],
    'LKR': [undefined, 'Rs'],
    'LRD': [undefined, '$'],
    'LTL': [undefined, 'Lt'],
    'LUF': [undefined, undefined, 0],
    'LVL': [undefined, 'Ls'],
    'LYD': [undefined, undefined, 3],
    'MGA': [undefined, 'Ar', 0],
    'MGF': [undefined, undefined, 0],
    'MMK': [undefined, 'K', 0],
    'MNT': [undefined, '₮', 2],
    'MRO': [undefined, undefined, 0],
    'MUR': [undefined, 'Rs', 2],
    'MXN': ['MX$', '$'],
    'MYR': [undefined, 'RM'],
    'NAD': [undefined, '$'],
    'NGN': [undefined, '₦'],
    'NIO': [undefined, 'C$'],
    'NOK': [undefined, 'kr', 2],
    'NPR': [undefined, 'Rs'],
    'NZD': ['NZ$', '$'],
    'OMR': [undefined, undefined, 3],
    'PHP': [undefined, '₱'],
    'PKR': [undefined, 'Rs', 2],
    'PLN': [undefined, 'zł'],
    'PYG': [undefined, '₲', 0],
    'RON': [undefined, 'lei'],
    'RSD': [undefined, undefined, 0],
    'RUB': [undefined, '₽'],
    'RUR': [undefined, 'р.'],
    'RWF': [undefined, 'RF', 0],
    'SBD': [undefined, '$'],
    'SEK': [undefined, 'kr', 2],
    'SGD': [undefined, '$'],
    'SHP': [undefined, '£'],
    'SLL': [undefined, undefined, 0],
    'SOS': [undefined, undefined, 0],
    'SRD': [undefined, '$'],
    'SSP': [undefined, '£'],
    'STD': [undefined, undefined, 0],
    'STN': [undefined, 'Db'],
    'SYP': [undefined, '£', 0],
    'THB': [undefined, '฿'],
    'TMM': [undefined, undefined, 0],
    'TND': [undefined, undefined, 3],
    'TOP': [undefined, 'T$'],
    'TRL': [undefined, undefined, 0],
    'TRY': [undefined, '₺'],
    'TTD': [undefined, '$'],
    'TWD': ['NT$', '$', 2],
    'TZS': [undefined, undefined, 2],
    'UAH': [undefined, '₴'],
    'UGX': [undefined, undefined, 0],
    'USD': ['$'],
    'UYI': [undefined, undefined, 0],
    'UYU': [undefined, '$'],
    'UYW': [undefined, undefined, 4],
    'UZS': [undefined, undefined, 2],
    'VEF': [undefined, 'Bs', 2],
    'VND': ['₫', undefined, 0],
    'VUV': [undefined, undefined, 0],
    'XAF': ['FCFA', undefined, 0],
    'XCD': ['EC$', '$'],
    'XOF': ['CFA', undefined, 0],
    'XPF': ['CFPF', undefined, 0],
    'XXX': ['¤'],
    'YER': [undefined, undefined, 0],
    'ZAR': [undefined, 'R'],
    'ZMK': [undefined, undefined, 0],
    'ZMW': [undefined, 'ZK'],
    'ZWD': [undefined, undefined, 0]
};
//# sourceMappingURL=data:application/json;base64,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