/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule, HttpInterceptingHandler as ɵHttpInterceptingHandler } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { HttpXhrBackend, XhrFactory } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
//# sourceMappingURL=data:application/json;base64,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