"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function default_1() {
    return (options, context) => {
        if (!(options === null || options === void 0 ? void 0 : options.name)) {
            throw new Error('RunSchematicTask requires an options object with a non-empty name property.');
        }
        const maybeWorkflow = context.engine.workflow;
        const collection = options.collection || context.schematic.collection.description.name;
        if (!maybeWorkflow) {
            throw new Error('Need Workflow to support executing schematics as post tasks.');
        }
        return maybeWorkflow.execute({
            collection: collection,
            schematic: options.name,
            options: options.options,
            // Allow private when calling from the same collection.
            allowPrivate: collection == context.schematic.collection.description.name,
        });
    };
}
exports.default = default_1;
