/* This file is part of BmiCalc.
 * BmiCalc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * BmiCalc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BmiCalc.  If not, see <https://www.gnu.org/licenses/>.
 *********************************************************************/
package com.ei.bmicalc;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class TestWeightCategories {

    private WeightCategories m_wCat;
    @Before
    public void setUp(){
        m_wCat = new WeightCategories();
    }

    @Test
    public void testWeightCategoryNameID(){
        assertEquals(R.string.very_sev_underweight, m_wCat.getCategoryNameID(10.));
        assertEquals(R.string.sev_underweight,  m_wCat.getCategoryNameID(15.7));
        assertEquals(R.string.underweight,  m_wCat.getCategoryNameID(17.1));
        assertEquals(R.string.healthy,  m_wCat.getCategoryNameID(21.));
        assertEquals(R.string.overweight,  m_wCat.getCategoryNameID(26));
        assertEquals(R.string.obese,  m_wCat.getCategoryNameID(31.));
        assertEquals(R.string.sev_obese,  m_wCat.getCategoryNameID(36.));
        assertEquals(R.string.very_sev_obese,  m_wCat.getCategoryNameID(42.));
    }

    @Test
    public void testGetWeightCategory(){
        assertEquals(WeightCategories.WeightCategory.VERY_SEVERELY_UNDERWEIGHT, WeightCategories.getCategory(10.));
        assertEquals(WeightCategories.WeightCategory.SEVERELY_UNDERWEIGHT,  WeightCategories.getCategory(15.7));
        assertEquals(WeightCategories.WeightCategory.UNDERWEIGHT,  WeightCategories.getCategory(17.1));
        assertEquals(WeightCategories.WeightCategory.HEALTHY,  WeightCategories.getCategory(21.));
        assertEquals(WeightCategories.WeightCategory.OVERWEIGHT,  WeightCategories.getCategory(26));
        assertEquals(WeightCategories.WeightCategory.OBESE,  WeightCategories.getCategory(31.));
        assertEquals(WeightCategories.WeightCategory.SEVERELY_OBESE,  WeightCategories.getCategory(36.));
        assertEquals(WeightCategories.WeightCategory.VERY_SEVERELY_OBESE,  WeightCategories.getCategory(42.));
    }

    @Test
    public void testGetCategoryStyleID(){
        assertEquals(R.drawable.body_cell_vs_under, m_wCat.getCategoryStyleID(10.));
        assertEquals(R.drawable.body_cell_s_under,  m_wCat.getCategoryStyleID(15.7));
        assertEquals(R.drawable.body_cell_under,  m_wCat.getCategoryStyleID(17.1));
        assertEquals(R.drawable.body_cell_healthy,  m_wCat.getCategoryStyleID(21.));
        assertEquals(R.drawable.body_cell_over,  m_wCat.getCategoryStyleID(26));
        assertEquals(R.drawable.body_cell_obese,  m_wCat.getCategoryStyleID(31.));
        assertEquals(R.drawable.body_cell_s_obese,  m_wCat.getCategoryStyleID(36.));
        assertEquals(R.drawable.body_cell_vs_obese,  m_wCat.getCategoryStyleID(42.));
    }
}
