/* This file is part of BmiCalc.
 * BmiCalc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * BmiCalc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BmiCalc.  If not, see <https://www.gnu.org/licenses/>.
 *********************************************************************/
package com.ei.bmicalc;

import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Example local unit test, which will execute on the development machine (host).
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */
public class TestBmiUtils {

    @Test
    public void testLbToKg() {
        assertEquals(0.45359, BmiUtils.lbToKg(1), 0.00001);
        assertEquals(0, BmiUtils.lbToKg(0), 0);
    }

    @Test
    public void testIncesToMeters(){
        assertEquals(0.0254, BmiUtils.inchesToMeters(1), 0.0001);
        assertEquals(0, BmiUtils.inchesToMeters(0), 0);
    }

    @Test
    public void testGetBmi(){
        assertEquals(-1., BmiUtils.getBmi(16, 0), 0);
        assertEquals(8.85770975056689342403, BmiUtils.getBmi(25, 168), 0.1E-20);
    }

    @Test
    public void testGetBmiMetrics(){
        assertEquals(8.85770975056689342403, BmiUtils.getBmi(25,true, 168, true), 0.1E-20);
        assertEquals(8.83922772895181, BmiUtils.getBmi(55,false, 168, true), 0.1E-12);
        assertEquals(8.89579373281795, BmiUtils.getBmi(25,true, 66, false), 0.1E-12);
        assertEquals(8.87723224721015, BmiUtils.getBmi(55,false, 66, false), 0.1E-12);
    }

    @Test
    public void testkgToLb(){
        assertEquals(2.2046, BmiUtils.kgToLb(1), 0.00001);
        assertEquals(0, BmiUtils.lbToKg(0), 0);
    }

    @Test
    public void testInchToFeet(){
        assertEquals(2., BmiUtils.inchToFeet(24), 0.00001);
    }

    @Test
    public void testFeetToInches(){
        assertEquals(24., BmiUtils.feetToInches(2), 0.00001);
    }
}