/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************/

package org.xiph.libvorbis;

import static org.xiph.libvorbis.vorbis_constants.integer_constants.*;

class vorbis_look_psy {

	int n;
	vorbis_info_psy vi;

	float[][][] tonecurves;		// float ***tonecurves
	float[][] noiseoffset;		// float **noiseoffset

	float[] ath;
	int[] octave;			// in n.ocshift format
	int[] bark;

	int firstoc;
	int shiftoc;
	int eighth_octave_lines;	// power of two, please
	int total_octave_lines;
	int rate;			// cache it
	
	float m_val;	// Masking compensation value
	
//	 static float ATH[]={
	public static final float[] ATH = new float[] {
	  /*15*/  -51, -52, -53, -54, -55, -56, -57, -58,  
	  /*31*/  -59, -60, -61, -62, -63, -64, -65, -66,
	  /*63*/  -67, -68, -69, -70, -71, -72, -73, -74, 
	  /*125*/ -75, -76, -77, -78, -80, -81, -82, -83,
	  /*250*/ -84, -85, -86, -87, -88, -88, -89, -89, 
	  /*500*/ -90, -91, -91, -92, -93, -94, -95, -96,
	  /*1k*/  -96, -97, -98, -98, -99, -99,-100,-100,
	  /*2k*/ -101,-102,-103,-104,-106,-107,-107,-107,
	  /*4k*/ -107,-105,-103,-102,-101, -99, -98, -96,
	  /*8k*/  -95, -95, -96, -97, -96, -95, -93, -90,
	  /*16k*/ -80, -70, -50, -40, -30, -30, -30, -30
	};
	
//	 static float tonemasks[P_BANDS][6][EHMER_MAX]={
	public static final float[][][] tonemasks = new float[][][] {
	  /* 62.5 Hz */
	  {{ -60,  -60,  -60,  -60,  -60,  -60,  -60,  -60, 
	     -60,  -60,  -60,  -60,  -62,  -62,  -65,  -73, 
	     -69,  -68,  -68,  -67,  -70,  -70,  -72,  -74, 
	     -75,  -79,  -79,  -80,  -83,  -88,  -93, -100, 
	     -110, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -48,  -48,  -48,  -48,  -48,  -48,  -48,  -48, 
	     -48,  -48,  -48,  -48,  -48,  -53,  -61,  -66, 
	     -66,  -68,  -67,  -70,  -76,  -76,  -72,  -73, 
	     -75,  -76,  -78,  -79,  -83,  -88,  -93, -100, 
	     -110, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -37,  -37,  -37,  -37,  -37,  -37,  -37,  -37, 
	     -38,  -40,  -42,  -46,  -48,  -53,  -55,  -62, 
	     -65,  -58,  -56,  -56,  -61,  -60,  -65,  -67, 
	     -69,  -71,  -77,  -77,  -78,  -80,  -82,  -84, 
	     -88,  -93,  -98, -106, -112, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -25,  -25,  -25,  -25,  -25,  -25,  -25,  -25, 
	     -25,  -26,  -27,  -29,  -32,  -38,  -48,  -52, 
	     -52,  -50,  -48,  -48,  -51,  -52,  -54,  -60, 
	     -67,  -67,  -66,  -68,  -69,  -73,  -73,  -76, 
	     -80,  -81,  -81,  -85,  -85,  -86,  -88,  -93, 
	     -100, -110, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -16,  -16,  -16,  -16,  -16,  -16,  -16,  -16, 
	     -17,  -19,  -20,  -22,  -26,  -28,  -31,  -40, 
	     -47,  -39,  -39,  -40,  -42,  -43,  -47,  -51, 
	     -57,  -52,  -55,  -55,  -60,  -58,  -62,  -63, 
	     -70,  -67,  -69,  -72,  -73,  -77,  -80,  -82, 
	     -83,  -87,  -90,  -94,  -98, -104, -115, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   {  -8,   -8,   -8,   -8,   -8,   -8,   -8,   -8, 
	      -8,   -8,  -10,  -11,  -15,  -19,  -25,  -30, 
	      -34,  -31,  -30,  -31,  -29,  -32,  -35,  -42, 
	      -48,  -42,  -44,  -46,  -50,  -50,  -51,  -52, 
	      -59,  -54,  -55,  -55,  -58,  -62,  -63,  -66, 
	      -72,  -73,  -76,  -75,  -78,  -80,  -80,  -81, 
	      -84,  -88,  -90,  -94,  -98, -101, -106, -110}}, 
	  /* 88Hz */
	  {{ -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66, 
	     -66,  -66,  -66,  -66,  -66,  -67,  -67,  -67, 
	     -76,  -72,  -71,  -74,  -76,  -76,  -75,  -78, 
	     -79,  -79,  -81,  -83,  -86,  -89,  -93,  -97, 
	     -100, -105, -110, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -47,  -47,  -47,  -47,  -47,  -47,  -47,  -47, 
	     -47,  -47,  -47,  -48,  -51,  -55,  -59,  -66, 
	     -66,  -66,  -67,  -66,  -68,  -69,  -70,  -74, 
	     -79,  -77,  -77,  -78,  -80,  -81,  -82,  -84, 
	     -86,  -88,  -91,  -95, -100, -108, -116, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36, 
	     -36,  -37,  -37,  -41,  -44,  -48,  -51,  -58, 
	     -62,  -60,  -57,  -59,  -59,  -60,  -63,  -65, 
	     -72,  -71,  -70,  -72,  -74,  -77,  -76,  -78, 
	     -81,  -81,  -80,  -83,  -86,  -91,  -96, -100, 
	     -105, -110, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -28,  -28,  -28,  -28,  -28,  -28,  -28,  -28, 
	     -28,  -30,  -32,  -32,  -33,  -35,  -41,  -49, 
	     -50,  -49,  -47,  -48,  -48,  -52,  -51,  -57, 
	     -65,  -61,  -59,  -61,  -64,  -69,  -70,  -74, 
	     -77,  -77,  -78,  -81,  -84,  -85,  -87,  -90, 
	     -92,  -96, -100, -107, -112, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   { -19,  -19,  -19,  -19,  -19,  -19,  -19,  -19, 
	     -20,  -21,  -23,  -27,  -30,  -35,  -36,  -41, 
	     -46,  -44,  -42,  -40,  -41,  -41,  -43,  -48, 
	     -55,  -53,  -52,  -53,  -56,  -59,  -58,  -60, 
	     -67,  -66,  -69,  -71,  -72,  -75,  -79,  -81, 
	     -84,  -87,  -90,  -93,  -97, -101, -107, -114, 
	     -999, -999, -999, -999, -999, -999, -999, -999},
	   {  -9,   -9,   -9,   -9,   -9,   -9,   -9,   -9, 
	      -11,  -12,  -12,  -15,  -16,  -20,  -23,  -30, 
	      -37,  -34,  -33,  -34,  -31,  -32,  -32,  -38, 
	      -47,  -44,  -41,  -40,  -47,  -49,  -46,  -46, 
	      -58,  -50,  -50,  -54,  -58,  -62,  -64,  -67, 
	      -67,  -70,  -72,  -76,  -79,  -83,  -87,  -91, 
	      -96, -100, -104, -110, -999, -999, -999, -999}}, 
	  /* 125 Hz */
	  {{ -62,  -62,  -62,  -62,  -62,  -62,  -62,  -62, 
	     -62,  -62,  -63,  -64,  -66,  -67,  -66,  -68, 
	     -75,  -72,  -76,  -75,  -76,  -78,  -79,  -82, 
	     -84,  -85,  -90,  -94, -101, -110, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -59,  -59,  -59,  -59,  -59,  -59,  -59,  -59, 
	     -59,  -59,  -59,  -60,  -60,  -61,  -63,  -66, 
	     -71,  -68,  -70,  -70,  -71,  -72,  -72,  -75, 
	     -81,  -78,  -79,  -82,  -83,  -86,  -90,  -97, 
	     -103, -113, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -53,  -53,  -53,  -53,  -53,  -53,  -53,  -53, 
	     -53,  -54,  -55,  -57,  -56,  -57,  -55,  -61, 
	     -65,  -60,  -60,  -62,  -63,  -63,  -66,  -68, 
	     -74,  -73,  -75,  -75,  -78,  -80,  -80,  -82, 
	     -85,  -90,  -96, -101, -108, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -46,  -46,  -46,  -46,  -46,  -46,  -46,  -46, 
	     -46,  -46,  -47,  -47,  -47,  -47,  -48,  -51, 
	     -57,  -51,  -49,  -50,  -51,  -53,  -54,  -59, 
	     -66,  -60,  -62,  -67,  -67,  -70,  -72,  -75, 
	     -76,  -78,  -81,  -85,  -88,  -94,  -97, -104, 
	     -112, -999, -999, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36, 
	     -39,  -41,  -42,  -42,  -39,  -38,  -41,  -43, 
	     -52,  -44,  -40,  -39,  -37,  -37,  -40,  -47, 
	     -54,  -50,  -48,  -50,  -55,  -61,  -59,  -62, 
	     -66,  -66,  -66,  -69,  -69,  -73,  -74,  -74, 
	     -75,  -77,  -79,  -82,  -87,  -91,  -95, -100, 
	     -108, -115, -999, -999, -999, -999, -999, -999}, 
	   { -28,  -26,  -24,  -22,  -20,  -20,  -23,  -29, 
	     -30,  -31,  -28,  -27,  -28,  -28,  -28,  -35, 
	     -40,  -33,  -32,  -29,  -30,  -30,  -30,  -37, 
	     -45,  -41,  -37,  -38,  -45,  -47,  -47,  -48, 
	     -53,  -49,  -48,  -50,  -49,  -49,  -51,  -52, 
	     -58,  -56,  -57,  -56,  -60,  -61,  -62,  -70, 
	     -72,  -74,  -78,  -83,  -88,  -93, -100, -106}}, 
	  /* 177 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -110, -105, -100,  -95,  -91,  -87,  -83, 
	    -80,  -78,  -76,  -78,  -78,  -81,  -83,  -85, 
	    -86,  -85,  -86,  -87,  -90,  -97, -107, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -110, -105, -100,  -95,  -90, 
	    -85,  -81,  -77,  -73,  -70,  -67,  -67,  -68, 
	    -75,  -73,  -70,  -69,  -70,  -72,  -75,  -79, 
	    -84,  -83,  -84,  -86,  -88,  -89,  -89,  -93, 
	    -98, -105, -112, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-105, -100,  -95,  -90,  -85,  -80,  -76,  -71, 
	    -68,  -68,  -65,  -63,  -63,  -62,  -62,  -64, 
	    -65,  -64,  -61,  -62,  -63,  -64,  -66,  -68, 
	    -73,  -73,  -74,  -75,  -76,  -81,  -83,  -85, 
	    -88,  -89,  -92,  -95, -100, -108, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -80,  -75,  -71,  -68,  -65,  -63,  -62,  -61, 
	     -61,  -61,  -61,  -59,  -56,  -57,  -53,  -50, 
	     -58,  -52,  -50,  -50,  -52,  -53,  -54,  -58, 
	     -67,  -63,  -67,  -68,  -72,  -75,  -78,  -80, 
	     -81,  -81,  -82,  -85,  -89,  -90,  -93,  -97, 
	     -101, -107, -114, -999, -999, -999, -999, -999, 
	     -999, -999, -999, -999, -999, -999, -999, -999}, 
	   { -65,  -61,  -59,  -57,  -56,  -55,  -55,  -56, 
	     -56,  -57,  -55,  -53,  -52,  -47,  -44,  -44, 
	     -50,  -44,  -41,  -39,  -39,  -42,  -40,  -46, 
	     -51,  -49,  -50,  -53,  -54,  -63,  -60,  -61, 
	     -62,  -66,  -66,  -66,  -70,  -73,  -74,  -75, 
	     -76,  -75,  -79,  -85,  -89,  -91,  -96, -102, 
	     -110, -999, -999, -999, -999, -999, -999, -999}, 
	   { -52,  -50,  -49,  -49,  -48,  -48,  -48,  -49, 
	     -50,  -50,  -49,  -46,  -43,  -39,  -35,  -33, 
	     -38,  -36,  -32,  -29,  -32,  -32,  -32,  -35, 
	     -44,  -39,  -38,  -38,  -46,  -50,  -45,  -46, 
	     -53,  -50,  -50,  -50,  -54,  -54,  -53,  -53, 
	     -56,  -57,  -59,  -66,  -70,  -72,  -74,  -79, 
	     -83,  -85,  -90, -97, -114, -999, -999, -999}}, 
	  /* 250 Hz */
	  {{-999, -999, -999, -999, -999, -999, -110, -105, 
	    -100,  -95,  -90,  -86,  -80,  -75,  -75,  -79, 
	    -80,  -79,  -80,  -81,  -82,  -88,  -95, -103, 
	    -110, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -108, -103,  -98,  -93, 
	    -88,  -83,  -79,  -78,  -75,  -71,  -67,  -68, 
	    -73,  -73,  -72,  -73,  -75,  -77,  -80,  -82, 
	    -88,  -93, -100, -107, -114, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -110, -105, -101,  -96,  -90, 
	    -86,  -81,  -77,  -73,  -69,  -66,  -61,  -62, 
	    -66,  -64,  -62,  -65,  -66,  -70,  -72,  -76, 
	    -81,  -80,  -84,  -90,  -95, -102, -110, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -107, -103,  -97,  -92,  -88, 
	    -83,  -79,  -74,  -70,  -66,  -59,  -53,  -58, 
	    -62,  -55,  -54,  -54,  -54,  -58,  -61,  -62, 
	    -72,  -70,  -72,  -75,  -78,  -80,  -81,  -80, 
	    -83,  -83,  -88,  -93, -100, -107, -115, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -105, -100,  -95,  -90,  -85, 
	    -80,  -75,  -70,  -66,  -62,  -56,  -48,  -44, 
	    -48,  -46,  -46,  -43,  -46,  -48,  -48,  -51, 
	    -58,  -58,  -59,  -60,  -62,  -62,  -61,  -61, 
	    -65,  -64,  -65,  -68,  -70,  -74,  -75,  -78, 
	    -81,  -86,  -95, -110, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999,  -999, -105, -100,  -95,  -90,  -85,  -80, 
	    -75,  -70,  -65,  -61,  -55,  -49,  -39,  -33, 
	    -40,  -35,  -32,  -38,  -40,  -33,  -35,  -37, 
	    -46,  -41,  -45,  -44,  -46,  -42,  -45,  -46, 
	    -52,  -50,  -50,  -50,  -54,  -54,  -55,  -57, 
	    -62,  -64,  -66,  -68,  -70,  -76,  -81,  -90, 
	    -100, -110, -999, -999, -999, -999, -999, -999}}, 
	  /* 354 hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -105,  -98,  -90,  -85,  -82,  -83,  -80,  -78, 
	    -84,  -79,  -80,  -83,  -87,  -89,  -91,  -93, 
	    -99, -106, -117, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -105,  -98,  -90,  -85,  -80,  -75,  -70,  -68, 
	    -74,  -72,  -74,  -77,  -80,  -82,  -85,  -87, 
	    -92,  -89,  -91,  -95, -100, -106, -112, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -105,  -98,  -90,  -83,  -75,  -71,  -63,  -64, 
	    -67,  -62,  -64,  -67,  -70,  -73,  -77,  -81, 
	    -84,  -83,  -85,  -89,  -90,  -93,  -98, -104, 
	    -109, -114, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -103,  -96,  -88,  -81,  -75,  -68,  -58,  -54, 
	    -56,  -54,  -56,  -56,  -58,  -60,  -63,  -66, 
	    -74,  -69,  -72,  -72,  -75,  -74,  -77,  -81, 
	    -81,  -82,  -84,  -87,  -93,  -96,  -99, -104, 
	    -110, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -108, -102,  -96, 
	    -91,  -85,  -80,  -74,  -68,  -60,  -51,  -46, 
	    -48,  -46,  -43,  -45,  -47,  -47,  -49,  -48, 
	    -56,  -53,  -55,  -58,  -57,  -63,  -58,  -60, 
	    -66,  -64,  -67,  -70,  -70,  -74,  -77,  -84, 
	    -86,  -89,  -91,  -93,  -94, -101, -109, -118, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -108, -103,  -98,  -93,  -88, 
	    -83,  -78,  -73,  -68,  -60,  -53,  -44,  -35, 
	    -38,  -38,  -34,  -34,  -36,  -40,  -41,  -44, 
	    -51,  -45,  -46,  -47,  -46,  -54,  -50,  -49, 
	    -50,  -50,  -50,  -51,  -54,  -57,  -58,  -60, 
	    -66,  -66,  -66,  -64,  -65,  -68,  -77,  -82, 
	    -87,  -95, -110, -999, -999, -999, -999, -999}}, 
	  /* 500 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -107, -102,  -97,  -92,  -87,  -83,  -78,  -75, 
	    -82,  -79,  -83,  -85,  -89,  -92,  -95,  -98, 
	    -101, -105, -109, -113, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -106, 
	    -100,  -95,  -90,  -86,  -81,  -78,  -74,  -69, 
	    -74,  -74,  -76,  -79,  -83,  -84,  -86,  -89, 
	    -92,  -97,  -93, -100, -103, -107, -110, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -106, -100, 
	    -95, -90, -87, -83, -80, -75, -69, -60, 
	    -66, -66, -68, -70, -74, -78, -79, -81, 
	    -81, -83, -84, -87, -93, -96, -99, -103, 
	    -107, -110, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -108, -103, -98, 
	    -93, -89, -85, -82, -78, -71, -62, -55, 
	    -58, -58, -54, -54, -55, -59, -61, -62, 
	    -70, -66, -66, -67, -70, -72, -75, -78, 
	    -84, -84, -84, -88, -91, -90, -95, -98, 
	    -102, -103, -106, -110, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -108, -103,  -98,  -94, 
	    -90,  -87,  -82,  -79,  -73,  -67,  -58,  -47, 
	    -50,  -45,  -41,  -45,  -48,  -44,  -44,  -49, 
	    -54,  -51,  -48,  -47,  -49,  -50,  -51,  -57, 
	    -58,  -60,  -63,  -69,  -70,  -69,  -71,  -74, 
	    -78,  -82,  -90,  -95, -101, -105, -110, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -105, -101, -97, -93, -90, 
	    -85, -80, -77, -72, -65, -56, -48, -37, 
	    -40, -36, -34, -40, -50, -47, -38, -41, 
	    -47, -38, -35, -39, -38, -43, -40, -45, 
	    -50, -45, -44, -47, -50, -55, -48, -48, 
	    -52, -66, -70, -76, -82, -90, -97, -105, 
	    -110, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 707 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -108, -103,  -98,  -93,  -86,  -79,  -76, 
	    -83,  -81,  -85,  -87,  -89,  -93,  -98, -102, 
	    -107, -112, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -108, -103,  -98,  -93,  -86,  -79,  -71, 
	    -77,  -74,  -77,  -79,  -81,  -84,  -85,  -90, 
	    -92,  -93,  -92,  -98, -101, -108, -112, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -108, -103,  -98,  -93,  -87,  -78,  -68,  -65, 
	    -66,  -62,  -65,  -67,  -70,  -73,  -75,  -78, 
	    -82,  -82,  -83,  -84,  -91,  -93,  -98, -102, 
	    -106, -110, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -105, -100, -95, -90, -82, -74, -62, -57, 
	    -58, -56, -51, -52, -52, -54, -54, -58, 
	    -66, -59, -60, -63, -66, -69, -73, -79, 
	    -83, -84, -80, -81, -81, -82, -88, -92, 
	    -98, -105, -113, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -107, 
	    -102,  -97,  -92,  -84,  -79,  -69,  -57,  -47, 
	    -52,  -47,  -44,  -45,  -50,  -52,  -42,  -42, 
	    -53,  -43,  -43,  -48,  -51,  -56,  -55,  -52, 
	    -57,  -59,  -61,  -62,  -67,  -71,  -78,  -83, 
	    -86,  -94,  -98, -103, -110, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -105, -100, 
	    -95,  -90,  -84,  -78,  -70,  -61,  -51,  -41, 
	    -40,  -38,  -40,  -46,  -52,  -51,  -41,  -40, 
	    -46,  -40,  -38,  -38,  -41,  -46,  -41,  -46, 
	    -47,  -43,  -43,  -45,  -41,  -45,  -56,  -67, 
	    -68,  -83,  -87,  -90,  -95, -102, -107, -113, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 1000 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -109, -105, -101,  -96,  -91,  -84,  -77, 
	    -82,  -82,  -85,  -89,  -94, -100, -106, -110, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -106, -103,  -98,  -92,  -85,  -80,  -71, 
	    -75,  -72,  -76,  -80,  -84,  -86,  -89,  -93, 
	    -100, -107, -113, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -107, 
	    -104, -101,  -97,  -92,  -88,  -84,  -80,  -64, 
	    -66,  -63,  -64,  -66,  -69,  -73,  -77,  -83, 
	    -83,  -86,  -91,  -98, -104, -111, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -107, 
	    -104, -101,  -97,  -92,  -90,  -84,  -74,  -57, 
	    -58,  -52,  -55,  -54,  -50,  -52,  -50,  -52, 
	    -63,  -62,  -69,  -76,  -77,  -78,  -78,  -79, 
	    -82,  -88,  -94, -100, -106, -111, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -106, -102, 
	    -98,  -95,  -90,  -85,  -83,  -78,  -70,  -50, 
	    -50,  -41,  -44,  -49,  -47,  -50,  -50,  -44, 
	    -55,  -46,  -47,  -48,  -48,  -54,  -49,  -49, 
	    -58,  -62,  -71,  -81,  -87,  -92,  -97, -102, 
	    -108, -114, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -106, -102, 
	    -98,  -95,  -90,  -85,  -83,  -78,  -70,  -45, 
	    -43,  -41,  -47,  -50,  -51,  -50,  -49,  -45, 
	    -47,  -41,  -44,  -41,  -39,  -43,  -38,  -37, 
	    -40,  -41,  -44,  -50,  -58,  -65,  -73,  -79, 
	    -85,  -92,  -97, -101, -105, -109, -113, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 1414 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -107, -100,  -95,  -87,  -81, 
	    -85,  -83,  -88,  -93, -100, -107, -114, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -107, -101,  -95,  -88,  -83,  -76, 
	    -73,  -72,  -79,  -84,  -90,  -95, -100, -105, 
	    -110, -115, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -104,  -98,  -92,  -87,  -81,  -70, 
	    -65,  -62,  -67,  -71,  -74,  -80,  -85,  -91, 
	    -95,  -99, -103, -108, -111, -114, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -103,  -97,  -90,  -85,  -76,  -60, 
	    -56,  -54,  -60,  -62,  -61,  -56,  -63,  -65, 
	    -73,  -74,  -77,  -75,  -78,  -81,  -86,  -87, 
	    -88,  -91,  -94,  -98, -103, -110, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -105, 
	    -100,  -97,  -92,  -86,  -81,  -79,  -70,  -57, 
	    -51,  -47,  -51,  -58,  -60,  -56,  -53,  -50, 
	    -58,  -52,  -50,  -50,  -53,  -55,  -64,  -69, 
	    -71,  -85,  -82,  -78,  -81,  -85,  -95, -102, 
	    -112, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -105, 
	    -100,  -97,  -92,  -85,  -83,  -79,  -72,  -49, 
	    -40,  -43,  -43,  -54,  -56,  -51,  -50,  -40, 
	    -43,  -38,  -36,  -35,  -37,  -38,  -37,  -44, 
	    -54,  -60,  -57,  -60,  -70,  -75,  -84,  -92, 
	    -103, -112, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 2000 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -102,  -95,  -89,  -82, 
	    -83,  -84,  -90,  -92,  -99, -107, -113, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -107, -101,  -95,  -89,  -83,  -72, 
	    -74,  -78,  -85,  -88,  -88,  -90,  -92,  -98, 
	    -105, -111, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -109, -103, -97, -93, -87, -81, -70, 
	    -70, -67, -75, -73, -76, -79, -81, -83, 
	    -88, -89, -97, -103, -110, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -107, -100,  -94,  -88,  -83,  -75,  -63, 
	    -59,  -59,  -63,  -66,  -60,  -62,  -67,  -67, 
	    -77,  -76,  -81,  -88,  -86,  -92,  -96, -102, 
	    -109, -116, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -105,  -98,  -92,  -86,  -81,  -73,  -56, 
	    -52,  -47,  -55,  -60,  -58,  -52,  -51,  -45, 
	    -49,  -50,  -53,  -54,  -61,  -71,  -70,  -69, 
	    -78,  -79,  -87,  -90,  -96, -104, -112, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -103,  -96,  -90,  -86,  -78,  -70,  -51, 
	    -42,  -47,  -48,  -55,  -54,  -54,  -53,  -42, 
	    -35,  -28,  -33,  -38,  -37,  -44,  -47,  -49, 
	    -54,  -63,  -68,  -78,  -82,  -89,  -94,  -99, 
	    -104, -109, -114, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 2828 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -110, -100,  -90,  -79, 
	    -85,  -81,  -82,  -82,  -89,  -94,  -99, -103, 
	    -109, -115, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -105,  -97,  -85,  -72, 
	    -74,  -70,  -70,  -70,  -76,  -85,  -91,  -93, 
	    -97, -103, -109, -115, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -112,  -93,  -81,  -68, 
	    -62,  -60,  -60,  -57,  -63,  -70,  -77,  -82, 
	    -90,  -93,  -98, -104, -109, -113, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -113, -100,  -93,  -84,  -63, 
	    -58,  -48,  -53,  -54,  -52,  -52,  -57,  -64, 
	    -66,  -76,  -83,  -81,  -85,  -85,  -90,  -95, 
	    -98, -101, -103, -106, -108, -111, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -105,  -95,  -86,  -74,  -53, 
	    -50,  -38,  -43,  -49,  -43,  -42,  -39,  -39, 
	    -46,  -52,  -57,  -56,  -72,  -69,  -74,  -81, 
	    -87,  -92,  -94,  -97,  -99, -102, -105, -108, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -108,  -99,  -90,  -76,  -66,  -45, 
	    -43,  -41,  -44,  -47,  -43,  -47,  -40,  -30, 
	    -31,  -31,  -39,  -33,  -40,  -41,  -43,  -53, 
	    -59,  -70,  -73,  -77,  -79,  -82,  -84,  -87, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 4000 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110,  -91,  -76, 
	    -75,  -85,  -93,  -98, -104, -110, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999},
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110,  -91,  -70, 
	    -70,  -75,  -86,  -89,  -94,  -98, -101, -106, 
	    -110, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -110,  -95,  -80,  -60, 
	    -65,  -64,  -74,  -83,  -88,  -91,  -95,  -99, 
	    -103, -107, -110, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -110,  -95,  -80,  -58, 
	    -55,  -49,  -66,  -68,  -71,  -78,  -78,  -80, 
	    -88,  -85,  -89,  -97, -100, -105, -110, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -110,  -95,  -80,  -53, 
	    -52,  -41,  -59,  -59,  -49,  -58,  -56,  -63, 
	    -86,  -79,  -90,  -93,  -98, -103, -107, -112, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110,  -97,  -91,  -73,  -45, 
	    -40,  -33,  -53,  -61,  -49,  -54,  -50,  -50, 
	    -60,  -52,  -67,  -74,  -81,  -92,  -96, -100, 
	    -105, -110, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 5657 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -113, -106,  -99,  -92,  -77, 
	    -80,  -88,  -97, -106, -115, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -116, -109, -102,  -95,  -89,  -74, 
	    -72,  -88,  -87,  -95, -102, -109, -116, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -116, -109, -102,  -95,  -89,  -75, 
	    -66,  -74,  -77,  -78,  -86,  -87,  -90,  -96, 
	    -105, -115, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -115, -108, -101,  -94,  -88,  -66, 
	    -56,  -61,  -70,  -65,  -78,  -72,  -83,  -84, 
	    -93,  -98, -105, -110, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -110, -105,  -95,  -89,  -82,  -57, 
	    -52,  -52,  -59,  -56,  -59,  -58,  -69,  -67, 
	    -88,  -82,  -82,  -89,  -94, -100, -108, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -110, -101,  -96,  -90,  -83,  -77,  -54, 
	    -43,  -38,  -50,  -48,  -52,  -48,  -42,  -42, 
	    -51,  -52,  -53,  -59,  -65,  -71,  -78,  -85, 
	    -95, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 8000 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -120, -105,  -86,  -68, 
	    -78,  -79,  -90, -100, -110, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -120, -105,  -86,  -66, 
	    -73,  -77,  -88,  -96, -105, -115, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -120, -105,  -92,  -80,  -61, 
	    -64,  -68,  -80,  -87,  -92, -100, -110, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -120, -104,  -91,  -79,  -52, 
	    -60,  -54,  -64,  -69,  -77,  -80,  -82,  -84, 
	    -85,  -87,  -88,  -90, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -118, -100,  -87,  -77,  -49, 
	    -50,  -44,  -58,  -61,  -61,  -67,  -65,  -62, 
	    -62,  -62,  -65,  -68, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -115,  -98,  -84,  -62,  -49, 
	    -44,  -38,  -46,  -49,  -49,  -46,  -39,  -37, 
	    -39,  -40,  -42,  -43, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 11314 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110,  -88,  -74, 
	    -77,  -82,  -82,  -85,  -90,  -94,  -99, -104, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110,  -88,  -66, 
	    -70,  -81,  -80,  -81,  -84,  -88,  -91,  -93, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110,  -88,  -61, 
	    -63,  -70,  -71,  -74,  -77,  -80,  -83,  -85, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -110, -86, -62, 
	    -63,  -62,  -62,  -58,  -52,  -50,  -50,  -52, 
	    -54, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -118, -108,  -84,  -53, 
	    -50,  -50,  -50,  -55,  -47,  -45,  -40,  -40, 
	    -40, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -118, -100,  -73,  -43, 
	    -37,  -42,  -43,  -53,  -38,  -37,  -35,  -35, 
	    -38, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}, 
	  /* 16000 Hz */
	  {{-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -91,  -84,  -74, 
	    -80,  -80,  -80,  -80,  -80, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -91,  -84,  -74, 
	    -68,  -68,  -68,  -68,  -68, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -86,  -78,  -70, 
	    -60,  -45,  -30,  -21, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -87,  -78,  -67, 
	    -48,  -38,  -29,  -21, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -86,  -69,  -56, 
	    -45,  -35,  -33,  -29, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}, 
	   {-999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -110, -100,  -83,  -71,  -48, 
	    -27,  -38,  -37,  -34, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999, 
	    -999, -999, -999, -999, -999, -999, -999, -999}}
	};


	public vorbis_look_psy() {}

	public vorbis_look_psy( int _n, vorbis_info_psy _vi, float[][][] _tonecurves, float[][] _noiseoffset, float[] _ath, int[] _octave, int[] _bark, int _firstoc, int _shiftoc, int _eighth_octave_lines, int _total_octave_lines, int _rate ) {

		n = _n;
		vi = _vi;

		tonecurves = (float[][][])_tonecurves.clone();
		noiseoffset = (float[][])_noiseoffset.clone();

		ath = (float[])_ath.clone();
		octave = (int[])_octave.clone();
		bark = (int[])_bark.clone();

		firstoc = _firstoc;
		shiftoc = _shiftoc;
		eighth_octave_lines = _eighth_octave_lines;
		total_octave_lines = _total_octave_lines;  
		rate = _rate;
	}

	public vorbis_look_psy( vorbis_look_psy src ) {

		this( src.n, src.vi, src.tonecurves, src.noiseoffset, src.ath, src.octave, src.bark, src.firstoc, src.shiftoc, src.eighth_octave_lines, src.total_octave_lines, src.rate );
	}

	private float toBARK( double z ) {
		return new Double( 13.1f*Math.atan(.00074f*(z))+2.24f*Math.atan((z)*(z)*1.85e-8f)+1e-4f*(z) ).floatValue();
	}

//	private float fromBARK( double z ) {
//		return new Double( 102.f*(z)-2.f*Math.pow(z,2.f)+.4f*Math.pow(z,3.f)+Math.pow(1.46f,z)-1.f ).floatValue();
//	}

	// Frequency to octave.  We arbitrarily declare 63.5 Hz to be octave 0.0

	private float toOC( double z ) {
		return new Double( Math.log(z)*1.442695f-5.965784f ).floatValue();
	}

	private float fromOC( double o) {
		return new Double( Math.exp(((o)+5.965784f)*.693147f) ).floatValue();
	}

	private void min_curve( float[] c, float[] c2 ) {

		for ( int i=0; i<EHMER_MAX; i++ )
			if ( c2[i] < c[i] )
				c[i] = c2[i];
	}

	private void max_curve( float[] c, float[] c2 ) {
 
		for( int i=0; i<EHMER_MAX; i++ )
			if ( c2[i] > c[i] )
				c[i] = c2[i];
	}

	private void attenuate_curve( float[] c, float att ) {

		for ( int i=0; i<EHMER_MAX; i++)
			c[i] += att;
	}

	private void setup_tone_curves( float[] curveatt_dB, float binHz, int n, float center_boost, float center_decay_rate ) {

		int i,j,k,m;
		float[] ath = new float[ EHMER_MAX ];
		float[][][] workc = new float[ P_BANDS ][ P_LEVELS ][ EHMER_MAX ];
		float[][] athc = new float[ P_LEVELS ][ EHMER_MAX ];

		// float *brute_buffer=alloca(n*sizeof(*brute_buffer));
		float[] brute_buffer = new float[ n ];

		// float ***ret=_ogg_malloc(sizeof(*ret)*P_BANDS);
		tonecurves = new float[ P_BANDS ][ P_LEVELS ][ EHMER_MAX+2 ];

		// Java defaults inits 0.0f
		// memset(workc,0,sizeof(workc));

		for ( i=0; i<P_BANDS; i++ ) {

			// we add back in the ATH to avoid low level curves falling off to -infinity and
			// unnecessarily cutting off high level curves in the curve limiting (last step).

			// A half-band's settings must be valid over the whole band, and it's better 
			// to mask too little than too much

			int ath_offset=i*4;
			for ( j=0; j<EHMER_MAX; j++ ) {
				float min=999.0f;
				for ( k=0; k<4; k++ ) {
					if ( j+k+ath_offset < MAX_ATH ) {
						if ( min > ATH[j+k+ath_offset] )
							min = ATH[j+k+ath_offset];
						} else {
							if ( min > ATH[MAX_ATH-1] )
								min = ATH[MAX_ATH-1];
						}
				}
				ath[j] = min;
			}

			// copy curves into working space, replicate the 50dB curve to 30
			// and 40, replicate the 100dB curve to 110

			// for ( j=0; j<6; j++ )
			// 	memcpy( workc[i][j+2], va.tonemasks[i][j], EHMER_MAX*sizeof(*tonemasks[i][j]) );
			// memcpy( workc[i][0], va.tonemasks[i][0], EHMER_MAX*sizeof(*tonemasks[i][0]) );
			// memcpy( workc[i][1], va.tonemasks[i][0], EHMER_MAX*sizeof(*tonemasks[i][0]) );

			for ( j=0; j<6; j++ )
				System.arraycopy( tonemasks[i][j], 0, workc[i][j+2], 0, tonemasks[i][j].length );
			System.arraycopy( tonemasks[i][0], 0, workc[i][0], 0, tonemasks[i][0].length );
			System.arraycopy( tonemasks[i][0], 0, workc[i][1], 0, tonemasks[i][0].length );
    
			// apply centered curve boost/decay
			for ( j=0; j<P_LEVELS; j++ ) {
				for ( k=0; k<EHMER_MAX; k++ ) {
					float adj = center_boost+Math.abs(EHMER_OFFSET-k)*center_decay_rate;
					if ( adj < 0.0f && center_boost > 0 )
						adj=0.0f;
					if ( adj > 0.0f && center_boost < 0)
						adj=0.0f;
					workc[i][j][k] += adj;
				}
			}

			// normalize curves so the driving amplitude is 0dB
			// make temp curves with the ATH overlayed

			for ( j=0; j<P_LEVELS; j++ ) {

				// attenuate_curve( workc[i][j], curveatt_dB[i]+100.-(j<2?2:j)*10.-P_LEVEL_0 );
				int tmp = j;
				if ( j < 2 )
					tmp = 2;
				attenuate_curve( workc[i][j], new Double( curveatt_dB[i]+100.0f-(tmp)*10.-P_LEVEL_0 ).floatValue() );

				// memcpy( athc[j], ath, EHMER_MAX*sizeof(**athc) );
				System.arraycopy( ath, 0, athc[j], 0, athc[j].length );

				attenuate_curve( athc[j], 100.0f-j*10.f-P_LEVEL_0 );
				max_curve( athc[j], workc[i][j] );
			}

			// Now limit the louder curves.
			// the idea is this: We don't know what the playback attenuation
			// will be; 0dB SL moves every time the user twiddles the volume
			// knob. So that means we have to use a single 'most pessimal' curve
			// for all masking amplitudes, right?  Wrong.  The *loudest* sound
			// can be in (we assume) a range of ...+100dB] SL.  However, sounds
			// 20dB down will be in a range ...+80], 40dB down is from ...+60], etc...

			for ( j=1; j<P_LEVELS; j++ ) {
				min_curve( athc[j], athc[j-1] );
				min_curve( workc[i][j], athc[j] );
			}
		}

		for ( i=0; i<P_BANDS; i++ ) {

			int hi_curve,lo_curve,bin;
			// ret[i]=_ogg_malloc(sizeof(**ret)*P_LEVELS);

			// low frequency curves are measured with greater resolution than
			// the MDCT/FFT will actually give us; we want the curve applied
			// to the tone data to be pessimistic and thus apply the minimum
			// masking possible for a given bin.  That means that a single bin
			// could span more than one octave and that the curve will be a
			// composite of multiple octaves.  It also may mean that a single
			// bin may span > an eighth of an octave and that the eighth
			// octave values may also be composited.
    
			// which octave curves will we be compositing?

			bin = new Double( Math.floor(fromOC(i*.5)/binHz) ).intValue();
			lo_curve = new Double( Math.ceil(toOC(bin*binHz+1)*2) ).intValue();
			hi_curve = new Double( Math.floor(toOC((bin+1)*binHz)*2) ).intValue();
			if (lo_curve>i)
				lo_curve=i;
			if (lo_curve<0)
				lo_curve=0;
			if (hi_curve>=P_BANDS)
				hi_curve=P_BANDS-1;

			for ( m=0; m<P_LEVELS; m++ ) {

				// ret[i][m]=_ogg_malloc(sizeof(***ret)*(EHMER_MAX+2));
      
				for (j=0; j<n; j++)
					brute_buffer[j] = 999.0f;
      
				// render the curve into bins, then pull values back into curve.
				// The point is that any inherent subsampling aliasing results in a safe minimum

				for ( k=lo_curve; k<=hi_curve; k++ ) {

					int l=0;

					for ( j=0; j<EHMER_MAX; j++ ) {

						int lo_bin = new Float( fromOC(j*.125+k*.5-2.0625)/binHz ).intValue();
						int hi_bin = new Float( fromOC(j*.125+k*.5-1.9375)/binHz+1 ).intValue();
	  
						if(lo_bin<0)lo_bin=0;
						if(lo_bin>n)lo_bin=n;
						if(lo_bin<l)l=lo_bin;
						if(hi_bin<0)hi_bin=0;
						if(hi_bin>n)hi_bin=n;

						for ( ; l<hi_bin && l<n; l++) {
							if ( brute_buffer[l] > workc[k][m][j] )
								brute_buffer[l]=workc[k][m][j];
						}
					}

					for ( ; l<n; l++ ) {
						if (brute_buffer[l] > workc[k][m][EHMER_MAX-1] )
							brute_buffer[l]=workc[k][m][EHMER_MAX-1];
					}
				}

				// be equally paranoid about being valid up to next half ocatve

				if ( i+1 < P_BANDS ) {

					int l=0;
					k=i+1;

					for ( j=0; j<EHMER_MAX; j++ ) {

						int lo_bin = new Float( fromOC(j*.125+i*.5-2.0625)/binHz ).intValue();
						int hi_bin = new Float( fromOC(j*.125+i*.5-1.9375)/binHz+1 ).intValue();
	  
						if(lo_bin<0)lo_bin=0;
						if(lo_bin>n)lo_bin=n;
						if(lo_bin<l)l=lo_bin;
						if(hi_bin<0)hi_bin=0;
						if(hi_bin>n)hi_bin=n;

						for ( ;l<hi_bin && l<n; l++) {
							if ( brute_buffer[l] > workc[k][m][j] )
								brute_buffer[l]=workc[k][m][j];
						}
					}

					for ( ; l<n; l++ ) {
						if ( brute_buffer[l] > workc[k][m][EHMER_MAX-1] )
							brute_buffer[l]=workc[k][m][EHMER_MAX-1];
					}
				}

				for (j=0; j<EHMER_MAX; j++ ) {

					bin = new Float( fromOC(j*.125+i*.5-2.)/binHz ).intValue();
					if ( bin<0 ) {
						tonecurves[i][m][j+2]=-999.0f;
					} else {
						if ( bin>=n ) {
							tonecurves[i][m][j+2]=-999.0f;
						} else {
							tonecurves[i][m][j+2]=brute_buffer[bin];
						}
					}
				}

				// add fenceposts
				for ( j=0; j<EHMER_OFFSET; j++ )
					if ( tonecurves[i][m][j+2] > -200.f )
						break;  
				tonecurves[i][m][0]=j;

				for ( j=EHMER_MAX-1; j>EHMER_OFFSET+1; j-- )
					if ( tonecurves[i][m][j+2] > -200.f )
						break;
				tonecurves[i][m][1]=j;
			}
		}
	}

	public void _vp_psy_init( vorbis_info_psy _vi, vorbis_info_psy_global gi, int _n, int _rate ) {

		int i,j,lo=-99,hi=1;
		int maxoc;

		vi=_vi;
		n=_n;
		rate=_rate;
		
		// AoTuV HF weighting
		m_val = 1.f;
		if ( rate < 26000 )
			m_val = 0;
		else if( rate < 38000 )
			m_val = .94f;	// 32kHz
		else if( rate > 46000 )
			m_val = 1.275f;	// 48kHz

		eighth_octave_lines = gi.eighth_octave_lines;
		shiftoc = new Double( Math.rint( Math.log(gi.eighth_octave_lines*8.0f)/ Math.log(2.0f))-1 ).intValue();

		firstoc = new Float( toOC(0.25f*rate*0.5/n)*(1<<(shiftoc+1))-gi.eighth_octave_lines ).intValue();
		maxoc = new Float( toOC((n+.25f)*rate*0.5/n)*(1<<(shiftoc+1))+0.5f ).intValue();
		total_octave_lines = maxoc-firstoc+1;

		// ath=_ogg_malloc(n*sizeof(*ath));
		// octave=_ogg_malloc(n*sizeof(*octave));
		// bark=_ogg_malloc(n*sizeof(*bark));

		ath = new float[ n ];
		octave = new int[ n ];
		bark = new int[ n ];

		// set up the lookups for a given blocksize and sample rate

		for (i=0,j=0; i<MAX_ATH-1; i++ ) {
			int endpos = new Double( Math.rint(fromOC((i+1)*0.125f-2.0f)*2*n/rate) ).intValue();
			float base = ATH[i];
			if (j<endpos) {
				float delta=(ATH[i+1]-base)/(endpos-j);
				for (; j<endpos && j<n; j++ ) {
					ath[j]=base+100.0f;
					base+=delta;
				}
			}
		}

		for ( i=0; i<n; i++ ) {
			float _bark=toBARK(rate/(2*n)*i); 

			for (; lo+vi.noisewindowlomin<i && toBARK(rate/(2*n)*lo)<(_bark-vi.noisewindowlo); lo++);

			for (; hi<=n && (hi<i+vi.noisewindowhimin || toBARK(rate/(2*n)*hi)<(_bark+vi.noisewindowhi)); hi++);

			bark[i] = ((lo-1)<<16)+(hi-1);
		}

		for ( i=0; i<n; i++ )
			octave[i] = new Float( toOC((i+0.25f)*0.5f*rate/n)*(1<<(shiftoc+1))+0.5f ).intValue();

		setup_tone_curves( vi.toneatt, rate*0.5f/n, n, vi.tone_centerboost, vi.tone_decay );

		// try {

		// PrintStream p = new PrintStream( new FileOutputStream( "jvorbis_psy" + _psy_num + ".txt" ) );

		// p.println( "n: " + n );

		// set up rolling noise median
		// noiseoffset=_ogg_malloc(P_NOISECURVES*sizeof(*noiseoffset));
		// for(i=0;i<P_NOISECURVES;i++)
		//	noiseoffset[i]=_ogg_malloc(n*sizeof(**noiseoffset));

		noiseoffset = new float[ P_NOISECURVES ][ n ];

		for ( i=0; i<n; i++ ) {
			float halfoc=toOC((i+0.5f)*rate/(2.0f*n))*2.0f;
			int inthalfoc;
			float del;

			// p.println( "halfoc: " + halfoc );

			if(halfoc<0)halfoc=0;
			if(halfoc>=P_BANDS-1)halfoc=P_BANDS-1;
			inthalfoc=(int)halfoc;
			del=halfoc-inthalfoc;

			for( j=0; j<P_NOISECURVES; j++) {

				// p.println( "i: " + i + " j: " + j + " inthalfoc: " + inthalfoc );
// TODO - CRITICAL - pointer leak
// This has a pointer leak
// Wraps over in C
// Error in Java
// customized if else

				if ( inthalfoc == P_BANDS-1 ) {

					if ( j == P_NOISECURVES-1 ) {
						noiseoffset[j][i] = vi.noiseoff[j][inthalfoc]*(1.0f-del) + vi.noisecompand[0]*del;
						// p.println( "vi.noiseoff["+j+"][inthalfoc] = " + vi.noiseoff[j][inthalfoc] );
						// p.println( "vi.noiseoff["+j+"][inthalfoc+1] = " + vi.noisecompand[0] );
					} else {
						noiseoffset[j][i] = vi.noiseoff[j][inthalfoc]*(1.0f-del) + vi.noiseoff[j+1][0]*del;
						// p.println( "vi.noiseoff["+j+"][inthalfoc] = " + vi.noiseoff[j][inthalfoc] );
						// p.println( "vi.noiseoff["+j+"][inthalfoc+1] = " + vi.noiseoff[j+1][0] );
					}
				} else {
					noiseoffset[j][i] = vi.noiseoff[j][inthalfoc]*(1.0f-del) + vi.noiseoff[j][inthalfoc+1]*del;
					// p.println( "vi.noiseoff["+j+"][inthalfoc] = " + vi.noiseoff[j][inthalfoc] );
					// p.println( "vi.noiseoff["+j+"][inthalfoc+1] = " + vi.noiseoff[j][inthalfoc+1] );
				}
				// p.println( "noiseoffset["+j+"]["+i+"] = " + noiseoffset[j][i] );
			}
		}

		// p.close();

		// } catch (Exception e) { e.printStackTrace(System.out); }
	}
	
	// octave/(8*eighth_octave_lines) x scale and dB y scale
	static void seed_curve( float[] seed, float[][] curves, float amp, int oc, int n, int linesper, float dBoffset ) {
		
		int i;
		int post1;
		int seedptr;
		float[] posts;
		int curve;
		
		int choice = (int)((amp+dBoffset-P_LEVEL_0)*.1f);
		choice = Math.max(choice,0);
		choice = Math.min(choice,P_LEVELS-1);
		posts = curves[choice];
		// curve=posts+2;
		curve = 2;
		post1=(int)posts[1];
		
		seedptr= new Float( oc + (posts[0]-EHMER_OFFSET)*linesper-(linesper>>>1) ).intValue();
		
		for ( i=(int)posts[0]; i<post1; i++ ) {
			
			if ( seedptr > 0 ) {
				float lin = amp + posts[curve+i];
				if ( seed[seedptr] < lin )
					seed[seedptr] = lin;
			}
			seedptr += linesper;
			if ( seedptr >= n )
				break;
		}
	}

	private void seed_loop( float[][][] curves, float[] f, float[] flr, float[] seed, float specmax ) {
		
		int i;
		float dBoffset = vi.max_curve_dB-specmax;
		
		// prime the working vector with peak values
		for ( i=0; i < n; i++ ) {
			float max = f[i];
			int oc = octave[i];
			while ( i+1 < n && octave[i+1] == oc ) {
				i++;
				if ( f[i] > max)
					max = f[i];
			}
			
			if ( max+6.f > flr[i] ) {
				
				oc = oc>>shiftoc;
		
				if ( oc >= P_BANDS )
					oc = P_BANDS-1;
				
				if ( oc<0 )
					oc=0;
				
				seed_curve( seed, curves[oc], max, octave[i]-firstoc, total_octave_lines, eighth_octave_lines, dBoffset );
			}
		}
	}
	
	static void seed_chase( float[] seeds, int linesper, int n ) {
		
		// long  *posstack=alloca(n*sizeof(*posstack));
		// float *ampstack=alloca(n*sizeof(*ampstack));
		int[] posstack = new int[ n ];
		float[] ampstack = new float[ n ];
		
		int stack = 0;
		int pos = 0;
		int i;
		
		for ( i=0; i < n; i++ ) {
			
			if( stack < 2 ) {
				posstack[stack] = i;
				ampstack[stack++] = seeds[i];
			} else {
				while ( true ) {
					if ( seeds[i] < ampstack[stack-1] ) {
						posstack[stack] = i;
						ampstack[stack++] = seeds[i];
						break;
					} else {
						if ( i < posstack[stack-1]+linesper ) {
							if( stack > 1 && ampstack[stack-1] <= ampstack[stack-2] && i < posstack[stack-2]+linesper ) {
								// we completely overlap, making stack-1 irrelevant.  pop it
								stack--;
								continue;
							}
						}
						posstack[stack] = i;
						ampstack[stack++] = seeds[i];
						break;
					}
				}
			}
		}
		
		// the stack now contains only the positions that are relevant. Scan 'em straight through
		
		for ( i=0; i < stack; i++ ) {
			
			int endpos;
			if ( i < stack-1 && ampstack[i+1] > ampstack[i] ) {
				endpos = posstack[i+1];
			} else {
				endpos=posstack[i]+linesper+1; // +1 is important, else bin 0 is discarded in short frames
			}
			
			if ( endpos > n )
				endpos = n;
			for ( ; pos < endpos; pos++ )
				seeds[pos] = ampstack[i];
		}
	}

	// bleaugh, this is more complicated than it needs to be
	private void max_seeds( float[] seed, float[] flr ) {
		
		int n_local = total_octave_lines;
		int linesper = eighth_octave_lines;
		int linpos=0;
		int pos;
		
		seed_chase( seed, linesper, n_local ); // for masking
		
		pos = octave[0]-firstoc-(linesper>>1);
		
		while ( linpos+1 < n ) {
			
			float minV = seed[pos];
			int end = ((octave[linpos]+octave[linpos+1])>>1)-firstoc;
			if (minV > vi.tone_abs_limit)
				minV = vi.tone_abs_limit;
			
			while ( pos+1 <= end ) {
				pos++;
				if ( (seed[pos] > NEGINF && seed[pos] < minV) || minV == NEGINF )
					minV = seed[pos];
			}
			
			end = pos+firstoc;
			for ( ; linpos < n && octave[linpos] <= end; linpos++ )
				if ( flr[linpos] < minV)
					flr[linpos] = minV;
		}
		
		float minV = seed[total_octave_lines-1];
		for ( ; linpos < n;linpos++ )
			if ( flr[linpos] < minV )
				flr[linpos] = minV;
	}
	
	static void bark_noise_hybridmp( int n, int[] b, float[] f, int foff, float[] noise, float offset, int fixed ) {
		
		// float *N=alloca(n*sizeof(*N));
		// float *X=alloca(n*sizeof(*N));
		// float *XX=alloca(n*sizeof(*N));
		// float *Y=alloca(n*sizeof(*N));
		// float *XY=alloca(n*sizeof(*N));
		float[] N = new float[ n ];
		float[] X = new float[ n ];
		float[] XX = new float[ n ];
		float[] Y = new float[ n ];
		float[] XY = new float[ n ];
		
		float tN, tX, tXX, tY, tXY;
		int i;
		
		int lo, hi;
		float R = 0.f;
		float A = 0.f;
		float B = 0.f;
		float D = 0.f;
		float w, x, y;
		
		tN = tX = tXX = tY = tXY = 0.f;
		
		y = f[foff+0] + offset;
		if ( y < 1.f )
			y = 1.f;
		
		w = y * y * .5f;
		
		tN += w;
		tX += w;
		tY += w * y;
		
		N[0] = tN;
		X[0] = tX;
		XX[0] = tXX;
		Y[0] = tY;
		XY[0] = tXY;
		
		for ( i = 1, x = 1.f; i < n; i++, x += 1.f ) {
			
			y = f[foff+i] + offset;
			if ( y < 1.f )
				y = 1.f;
			
			w = y * y;
			
			tN += w;
			tX += w * x;
			tXX += w * x * x;
			tY += w * y;
			tXY += w * x * y;
			
			N[i] = tN;
			X[i] = tX;
			XX[i] = tXX;
			Y[i] = tY;
			XY[i] = tXY;
		}
		
		for ( i = 0, x = 0.f;; i++, x += 1.f ) {
			
			lo = b[i] >> 16;
			if ( lo >= 0 )
				break;
			hi = b[i] & 0xffff;
			
			tN = N[hi] + N[-lo];
			tX = X[hi] - X[-lo];
			tXX = XX[hi] + XX[-lo];
			tY = Y[hi] + Y[-lo];    
			tXY = XY[hi] - XY[-lo];
			
			A = tY * tXX - tX * tXY;
			B = tN * tXY - tX * tY;
			D = tN * tXX - tX * tX;
			R = (A + x * B) / D;
			if (R < 0.f)
				R = 0.f;
			
			noise[i] = R - offset;
		}
		
		for ( ;; i++, x += 1.f ) {
			
			lo = b[i] >> 16;
			hi = b[i] & 0xffff;
			if ( hi >= n )
				break;
			
			tN = N[hi] - N[lo];
			tX = X[hi] - X[lo];
			tXX = XX[hi] - XX[lo];
			tY = Y[hi] - Y[lo];
			tXY = XY[hi] - XY[lo];
			
			A = tY * tXX - tX * tXY;
			B = tN * tXY - tX * tY;
			D = tN * tXX - tX * tX;
			R = (A + x * B) / D;
			if ( R < 0.f )
				R = 0.f;
			
			noise[i] = R - offset;
		}
		
		for ( ; i < n; i++, x += 1.f ) {
			
			R = (A + x * B) / D;
			if ( R < 0.f )
				R = 0.f;
			
			noise[i] = R - offset;
		}
		
		if ( fixed <= 0 )
			return;
		
		for ( i = 0, x = 0.f;; i++, x += 1.f ) {
			
			hi = i + fixed / 2;
			lo = hi - fixed;
			if ( lo >= 0 )
				break;
			
			tN = N[hi] + N[-lo];
			tX = X[hi] - X[-lo];
			tXX = XX[hi] + XX[-lo];
			tY = Y[hi] + Y[-lo];
			tXY = XY[hi] - XY[-lo];
			
			A = tY * tXX - tX * tXY;
			B = tN * tXY - tX * tY;
			D = tN * tXX - tX * tX;
			R = (A + x * B) / D;
			
			if ( R - offset < noise[i] )
				noise[i] = R - offset;
		}
		
		for ( ;; i++, x += 1.f ) {
			
			hi = i + fixed / 2;
			lo = hi - fixed;
			if ( hi >= n )
				break;
			
			tN = N[hi] - N[lo];
			tX = X[hi] - X[lo];
			tXX = XX[hi] - XX[lo];
			tY = Y[hi] - Y[lo];
			tXY = XY[hi] - XY[lo];
			
			A = tY * tXX - tX * tXY;
			B = tN * tXY - tX * tY;
			D = tN * tXX - tX * tX;
			R = (A + x * B) / D;
			
			if ( R - offset < noise[i] )
				noise[i] = R - offset;
		}
		
		for ( ; i < n; i++, x += 1.f ) {
			R = (A + x * B) / D;
			if (R - offset < noise[i])
				noise[i] = R - offset;
		}
	}
	
	public void _vp_noisemask( float[] logmdct,  int offset, float[] logmask ) {
		
		int i;
		
		// float *work=alloca(n*sizeof(*work));
		float[] work = new float[ n ];
		
		bark_noise_hybridmp( n, bark, logmdct, offset, logmask, 140.f, -1 );
		
		for ( i=0; i < n; i++ )
			work[i] = logmdct[offset+i]-logmask[i];
		
		bark_noise_hybridmp( n, bark, work, 0, logmask, 0.f, vi.noisewindowfixed );
		
		for ( i=0 ; i < n; i++ )
			work[i] = logmdct[offset+i]-work[i];
		
		for ( i=0; i < n; i++ ) {
			int dB = new Float( logmask[i] + .5f ).intValue();
			if ( dB >= NOISE_COMPAND_LEVELS )
				dB = NOISE_COMPAND_LEVELS-1;
			if ( dB < 0 )
				dB = 0;
			logmask[i] = work[i] + vi.noisecompand[dB];
		}
	}

	public void _vp_tonemask( float[] logfft, float[] logmask, float global_specmax, float local_specmax ) {
		
		int i;
		
		// float *seed=alloca(sizeof(*seed)*p->total_octave_lines);
		float[] seed = new float[ total_octave_lines ];
		
		float att = local_specmax + vi.ath_adjatt;
		for ( i=0; i < total_octave_lines; i++ )
			seed[i] = NEGINF;
		
		// set the ATH (floating below localmax, not global max by a specified att)
		if ( att < vi.ath_maxatt)
			att = vi.ath_maxatt;
		
		for ( i=0; i < n; i++ )
			logmask[i] = ath[i] + att;
		
		// tone masking

		seed_loop( tonecurves, logfft, logmask, seed, global_specmax );
		max_seeds( seed, logmask );
	}

	public void _vp_offset_and_mix( float[] noise, float[] tone, int offset_select, float[] logmask, float[] mdct, int logmdct ) {
		
		int i;
		float de, coeffi, cx;	// AoTuV
		float toneatt = vi.tone_masteratt[offset_select];
		
		cx = m_val;
		
		for ( i=0; i < n;  i++ ) {
			float val = noise[i]+noiseoffset[offset_select][i];
			if ( val > vi.noisemaxsupp )
				val = vi.noisemaxsupp;
			logmask[i] = Math.max( val, tone[i]+toneatt );
			
			// AoTuV
			// @ M1
			// The following codes improve a noise problem.  
			// A fundamental idea uses the value of masking and carries out
			// the relative compensation of the MDCT. 
			// However, this code is not perfect and all noise problems cannot be solved. 
			// by Aoyumi @ 2004/04/18
			
			if ( offset_select == 1 ) {
				
				coeffi = -17.2f;			// coeffi is a -17.2dB threshold
				val = val - logmask[logmdct+i];  	// val == mdct line value relative to floor in dB
				
				if ( val > coeffi ) {
					
					// mdct value is > -17.2 dB below floor
					
					de = 1.0f-((val-coeffi)*0.005f*cx);
					
					// pro-rated attenuation:
					// -0.00 dB boost if mdct value is -17.2dB (relative to floor) 
					// -0.77 dB boost if mdct value is 0dB (relative to floor) 
					// -1.64 dB boost if mdct value is +17.2dB (relative to floor) 
					// etc...
					
					if ( de < 0 )
						de = 0.0001f;
				} else
					de = 1.0f-((val-coeffi)*0.0003f*cx); // mdct value is <= -17.2 dB below floor
				
				// pro-rated attenuation:
				// +0.00 dB atten if mdct value is -17.2dB (relative to floor) 
				// +0.45 dB atten if mdct value is -34.4dB (relative to floor) 
				// etc...
				
				mdct[i] *= de;
			}
		}
	}
}