/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @generated by an internal genrule from Flow types.
 *
 * We create an umbrella header (and corresponding implementation) here since
 * Cxx compilation in BUCK has a limitation: source-code producing genrule()s
 * must have a single output. More files => more genrule()s => slower builds.
 */

#ifndef __cplusplus
#error This file must be compiled as Obj-C++. If you are importing it, you must change your file extension to .mm.
#endif
#import <Foundation/Foundation.h>
#import <RCTRequired/RCTRequired.h>
#import <RCTTypeSafety/RCTConvertHelpers.h>
#import <RCTTypeSafety/RCTTypedModuleConstants.h>
#import <React/RCTBridgeModule.h>
#import <React/RCTCxxConvert.h>
#import <React/RCTManagedPointer.h>
#import <ReactCommon/RCTTurboModule.h>
#import <folly/Optional.h>
#import <vector>


@protocol NativeAccessibilityInfoSpec <RCTBridgeModule, RCTTurboModule>

- (void)isReduceMotionEnabled:(RCTResponseSenderBlock)onSuccess;
- (void)isTouchExplorationEnabled:(RCTResponseSenderBlock)onSuccess;
- (void)setAccessibilityFocus:(double)reactTag;
- (void)announceForAccessibility:(NSString *)announcement;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AccessibilityInfo'
     */

    class JSI_EXPORT NativeAccessibilityInfoSpecJSI : public ObjCTurboModule {
    public:
      NativeAccessibilityInfoSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeAccessibilityManager {
    struct SpecSetAccessibilityContentSizeMultipliersJSMultiipliers {
      folly::Optional<double> extraSmall() const;
      folly::Optional<double> small() const;
      folly::Optional<double> medium() const;
      folly::Optional<double> large() const;
      folly::Optional<double> extraLarge() const;
      folly::Optional<double> extraExtraLarge() const;
      folly::Optional<double> extraExtraExtraLarge() const;
      folly::Optional<double> accessibilityMedium() const;
      folly::Optional<double> accessibilityLarge() const;
      folly::Optional<double> accessibilityExtraLarge() const;
      folly::Optional<double> accessibilityExtraExtraLarge() const;
      folly::Optional<double> accessibilityExtraExtraExtraLarge() const;

      SpecSetAccessibilityContentSizeMultipliersJSMultiipliers(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAccessibilityManager_SpecSetAccessibilityContentSizeMultipliersJSMultiipliers)
+ (RCTManagedPointer *)JS_NativeAccessibilityManager_SpecSetAccessibilityContentSizeMultipliersJSMultiipliers:(id)json;
@end
@protocol NativeAccessibilityManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)getCurrentBoldTextState:(RCTResponseSenderBlock)onSuccess
                        onError:(RCTResponseSenderBlock)onError;
- (void)getCurrentGrayscaleState:(RCTResponseSenderBlock)onSuccess
                         onError:(RCTResponseSenderBlock)onError;
- (void)getCurrentInvertColorsState:(RCTResponseSenderBlock)onSuccess
                            onError:(RCTResponseSenderBlock)onError;
- (void)getCurrentReduceMotionState:(RCTResponseSenderBlock)onSuccess
                            onError:(RCTResponseSenderBlock)onError;
- (void)getCurrentReduceTransparencyState:(RCTResponseSenderBlock)onSuccess
                                  onError:(RCTResponseSenderBlock)onError;
- (void)getCurrentVoiceOverState:(RCTResponseSenderBlock)onSuccess
                         onError:(RCTResponseSenderBlock)onError;
- (void)setAccessibilityContentSizeMultipliers:(JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers &)JSMultiipliers;
- (void)setAccessibilityFocus:(double)reactTag;
- (void)announceForAccessibility:(NSString *)announcement;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AccessibilityManager'
     */

    class JSI_EXPORT NativeAccessibilityManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeAccessibilityManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeActionSheetManager {
    struct SpecShowActionSheetWithOptionsOptions {
      NSString *title() const;
      NSString *message() const;
      folly::Optional<facebook::react::LazyVector<NSString *>> options() const;
      folly::Optional<double> destructiveButtonIndex() const;
      folly::Optional<double> cancelButtonIndex() const;
      folly::Optional<double> anchor() const;
      folly::Optional<double> tintColor() const;

      SpecShowActionSheetWithOptionsOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeActionSheetManager_SpecShowActionSheetWithOptionsOptions)
+ (RCTManagedPointer *)JS_NativeActionSheetManager_SpecShowActionSheetWithOptionsOptions:(id)json;
@end

namespace JS {
  namespace NativeActionSheetManager {
    struct SpecShowShareActionSheetWithOptionsOptions {
      NSString *message() const;
      NSString *url() const;
      NSString *subject() const;
      folly::Optional<double> anchor() const;
      folly::Optional<double> tintColor() const;
      folly::Optional<facebook::react::LazyVector<NSString *>> excludedActivityTypes() const;

      SpecShowShareActionSheetWithOptionsOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeActionSheetManager_SpecShowShareActionSheetWithOptionsOptions)
+ (RCTManagedPointer *)JS_NativeActionSheetManager_SpecShowShareActionSheetWithOptionsOptions:(id)json;
@end

namespace JS {
  namespace NativeActionSheetManager {
    struct SpecShowShareActionSheetWithOptionsFailureCallbackError {
      NSString *domain() const;
      NSString *code() const;
      id<NSObject> _Nullable userInfo() const;
      NSString *message() const;

      SpecShowShareActionSheetWithOptionsFailureCallbackError(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeActionSheetManager_SpecShowShareActionSheetWithOptionsFailureCallbackError)
+ (RCTManagedPointer *)JS_NativeActionSheetManager_SpecShowShareActionSheetWithOptionsFailureCallbackError:(id)json;
@end
@protocol NativeActionSheetManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)showActionSheetWithOptions:(JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions &)options
                          callback:(RCTResponseSenderBlock)callback;
- (void)showShareActionSheetWithOptions:(JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions &)options
                        failureCallback:(RCTResponseSenderBlock)failureCallback
                        successCallback:(RCTResponseSenderBlock)successCallback;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ActionSheetManager'
     */

    class JSI_EXPORT NativeActionSheetManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeActionSheetManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeAlertManager {
    struct Args {
      NSString *title() const;
      NSString *message() const;
      id<NSObject> _Nullable buttons() const;
      NSString *type() const;
      NSString *defaultValue() const;
      NSString *cancelButtonKey() const;
      NSString *destructiveButtonKey() const;
      NSString *keyboardType() const;

      Args(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAlertManager_Args)
+ (RCTManagedPointer *)JS_NativeAlertManager_Args:(id)json;
@end
@protocol NativeAlertManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)alertWithArgs:(JS::NativeAlertManager::Args &)args
             callback:(RCTResponseSenderBlock)callback;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AlertManager'
     */

    class JSI_EXPORT NativeAlertManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeAlertManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeAnimatedModule {
    struct AnimatedNodeConfig {
      NSString *type() const;

      AnimatedNodeConfig(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAnimatedModule_AnimatedNodeConfig)
+ (RCTManagedPointer *)JS_NativeAnimatedModule_AnimatedNodeConfig:(id)json;
@end

namespace JS {
  namespace NativeAnimatedModule {
    struct AnimatingNodeConfig {
      NSString *type() const;

      AnimatingNodeConfig(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAnimatedModule_AnimatingNodeConfig)
+ (RCTManagedPointer *)JS_NativeAnimatedModule_AnimatingNodeConfig:(id)json;
@end

namespace JS {
  namespace NativeAnimatedModule {
    struct EndResult {
      bool finished() const;

      EndResult(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAnimatedModule_EndResult)
+ (RCTManagedPointer *)JS_NativeAnimatedModule_EndResult:(id)json;
@end

namespace JS {
  namespace NativeAnimatedModule {
    struct EventMapping {
      facebook::react::LazyVector<NSString *> nativeEventPath() const;
      folly::Optional<double> animatedValueTag() const;

      EventMapping(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAnimatedModule_EventMapping)
+ (RCTManagedPointer *)JS_NativeAnimatedModule_EventMapping:(id)json;
@end
@protocol NativeAnimatedModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)createAnimatedNode:(NSNumber *)tag
                    config:(JS::NativeAnimatedModule::AnimatedNodeConfig &)config;
- (void)startListeningToAnimatedNodeValue:(NSNumber *)tag;
- (void)stopListeningToAnimatedNodeValue:(NSNumber *)tag;
- (void)connectAnimatedNodes:(NSNumber *)parentTag
                    childTag:(NSNumber *)childTag;
- (void)disconnectAnimatedNodes:(NSNumber *)parentTag
                       childTag:(NSNumber *)childTag;
- (void)startAnimatingNode:(NSNumber *)animationId
                   nodeTag:(NSNumber *)nodeTag
                    config:(JS::NativeAnimatedModule::AnimatingNodeConfig &)config
               endCallback:(RCTResponseSenderBlock)endCallback;
- (void)stopAnimation:(NSNumber *)animationId;
- (void)setAnimatedNodeValue:(NSNumber *)nodeTag
                       value:(NSNumber *)value;
- (void)setAnimatedNodeOffset:(NSNumber *)nodeTag
                       offset:(NSNumber *)offset;
- (void)flattenAnimatedNodeOffset:(NSNumber *)nodeTag;
- (void)extractAnimatedNodeOffset:(NSNumber *)nodeTag;
- (void)connectAnimatedNodeToView:(NSNumber *)nodeTag
                          viewTag:(NSNumber *)viewTag;
- (void)disconnectAnimatedNodeFromView:(NSNumber *)nodeTag
                               viewTag:(NSNumber *)viewTag;
- (void)dropAnimatedNode:(NSNumber *)tag;
- (void)addAnimatedEventToView:(NSNumber *)viewTag
                     eventName:(NSString *)eventName
                  eventMapping:(JS::NativeAnimatedModule::EventMapping &)eventMapping;
- (void)removeAnimatedEventFromView:(NSNumber *)viewTag
                          eventName:(NSString *)eventName
                    animatedNodeTag:(NSNumber *)animatedNodeTag;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AnimatedModule'
     */

    class JSI_EXPORT NativeAnimatedModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeAnimatedModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeAnimationsDebugModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)startRecordingFps;
- (void)stopRecordingFps:(double)animationStopTimeMs;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AnimationsDebugModule'
     */

    class JSI_EXPORT NativeAnimationsDebugModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeAnimationsDebugModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeAppState {
    struct SpecGetCurrentAppStateSuccessAppState {
      NSString *app_state() const;

      SpecGetCurrentAppStateSuccessAppState(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAppState_SpecGetCurrentAppStateSuccessAppState)
+ (RCTManagedPointer *)JS_NativeAppState_SpecGetCurrentAppStateSuccessAppState:(id)json;
@end

namespace JS {
  namespace NativeAppState {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<NSString *> initialAppState;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeAppStateSpec <RCTBridgeModule, RCTTurboModule>

- (void)getCurrentAppState:(RCTResponseSenderBlock)success
                   failure:(RCTResponseSenderBlock)failure;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;
- (facebook::react::ModuleConstants<JS::NativeAppState::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeAppState::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AppState'
     */

    class JSI_EXPORT NativeAppStateSpecJSI : public ObjCTurboModule {
    public:
      NativeAppStateSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecMultiGetCallbackErrorsElement {
      NSString *message() const;

      SpecMultiGetCallbackErrorsElement(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecMultiGetCallbackErrorsElement)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecMultiGetCallbackErrorsElement:(id)json;
@end

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecMultiSetCallbackErrorsElement {
      NSString *message() const;

      SpecMultiSetCallbackErrorsElement(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecMultiSetCallbackErrorsElement)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecMultiSetCallbackErrorsElement:(id)json;
@end

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecMultiMergeCallbackErrorsElement {
      NSString *message() const;

      SpecMultiMergeCallbackErrorsElement(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecMultiMergeCallbackErrorsElement)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecMultiMergeCallbackErrorsElement:(id)json;
@end

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecMultiRemoveCallbackErrorsElement {
      NSString *message() const;

      SpecMultiRemoveCallbackErrorsElement(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecMultiRemoveCallbackErrorsElement)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecMultiRemoveCallbackErrorsElement:(id)json;
@end

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecClearCallbackError {
      NSString *message() const;

      SpecClearCallbackError(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecClearCallbackError)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecClearCallbackError:(id)json;
@end

namespace JS {
  namespace NativeAsyncStorage {
    struct SpecGetAllKeysCallbackError {
      NSString *message() const;

      SpecGetAllKeysCallbackError(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeAsyncStorage_SpecGetAllKeysCallbackError)
+ (RCTManagedPointer *)JS_NativeAsyncStorage_SpecGetAllKeysCallbackError:(id)json;
@end
@protocol NativeAsyncStorageSpec <RCTBridgeModule, RCTTurboModule>

- (void)multiGet:(NSArray *)keys
        callback:(RCTResponseSenderBlock)callback;
- (void)multiSet:(NSArray *)kvPairs
        callback:(RCTResponseSenderBlock)callback;
- (void)multiMerge:(NSArray *)kvPairs
          callback:(RCTResponseSenderBlock)callback;
- (void)multiRemove:(NSArray *)keys
           callback:(RCTResponseSenderBlock)callback;
- (void)clear:(RCTResponseSenderBlock)callback;
- (void)getAllKeys:(RCTResponseSenderBlock)callback;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'AsyncStorage'
     */

    class JSI_EXPORT NativeAsyncStorageSpecJSI : public ObjCTurboModule {
    public:
      NativeAsyncStorageSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeBlobModule {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<NSString *> BLOB_URI_SCHEME;
          RCTRequired<NSString *> BLOB_URI_HOST;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeBlobModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)addNetworkingHandler;
- (void)addWebSocketHandler:(double)id;
- (void)removeWebSocketHandler:(double)id;
- (void)sendOverSocket:(NSDictionary *)blob
                    id:(double)id;
- (void)createFromParts:(NSArray *)parts
                 blobId:(NSString *)blobId;
- (void)release:(NSString *)blobId;
- (facebook::react::ModuleConstants<JS::NativeBlobModule::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeBlobModule::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'BlobModule'
     */

    class JSI_EXPORT NativeBlobModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeBlobModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeBugReportingSpec <RCTBridgeModule, RCTTurboModule>

- (void)startReportAProblemFlow;
- (void)setExtraData:(NSDictionary *)extraData
          extraFiles:(NSDictionary *)extraFiles;
- (void)setCategoryID:(NSString *)categoryID;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'BugReporting'
     */

    class JSI_EXPORT NativeBugReportingSpecJSI : public ObjCTurboModule {
    public:
      NativeBugReportingSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeClipboardSpec <RCTBridgeModule, RCTTurboModule>

- (void)getString:(RCTPromiseResolveBlock)resolve
           reject:(RCTPromiseRejectBlock)reject;
- (void)setString:(NSString *)content;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'Clipboard'
     */

    class JSI_EXPORT NativeClipboardSpecJSI : public ObjCTurboModule {
    public:
      NativeClipboardSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeDatePickerAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)open:(NSDictionary *)options
     resolve:(RCTPromiseResolveBlock)resolve
      reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DatePickerAndroid'
     */

    class JSI_EXPORT NativeDatePickerAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativeDatePickerAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeDevLoadingViewSpec <RCTBridgeModule, RCTTurboModule>

- (void)showMessage:(NSString *)message
              color:(NSDictionary *)color
    backgroundColor:(NSDictionary *)backgroundColor;
- (void)hide;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DevLoadingView'
     */

    class JSI_EXPORT NativeDevLoadingViewSpecJSI : public ObjCTurboModule {
    public:
      NativeDevLoadingViewSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeDevSettingsSpec <RCTBridgeModule, RCTTurboModule>

- (void)reload;
- (void)setHotLoadingEnabled:(BOOL)isHotLoadingEnabled;
- (void)setIsDebuggingRemotely:(BOOL)isDebuggingRemotelyEnabled;
- (void)setLiveReloadEnabled:(BOOL)isLiveReloadEnabled;
- (void)setProfilingEnabled:(BOOL)isProfilingEnabled;
- (void)toggleElementInspector;
- (void)setIsShakeToShowDevMenuEnabled:(BOOL)enabled;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DevSettings'
     */

    class JSI_EXPORT NativeDevSettingsSpecJSI : public ObjCTurboModule {
    public:
      NativeDevSettingsSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeDeviceEventManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)invokeDefaultBackPressHandler;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DeviceEventManager'
     */

    class JSI_EXPORT NativeDeviceEventManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeDeviceEventManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeDeviceInfo {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<id<NSObject>> Dimensions;
          folly::Optional<bool> isIPhoneX_deprecated;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeDeviceInfoSpec <RCTBridgeModule, RCTTurboModule>

- (facebook::react::ModuleConstants<JS::NativeDeviceInfo::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeDeviceInfo::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DeviceInfo'
     */

    class JSI_EXPORT NativeDeviceInfoSpecJSI : public ObjCTurboModule {
    public:
      NativeDeviceInfoSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeDialogManagerAndroid {
    struct DialogOptions {
      NSString *title() const;
      NSString *message() const;
      NSString *buttonPositive() const;
      NSString *buttonNegative() const;
      NSString *buttonNeutral() const;
      folly::Optional<facebook::react::LazyVector<NSString *>> items() const;
      folly::Optional<bool> cancelable() const;

      DialogOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeDialogManagerAndroid_DialogOptions)
+ (RCTManagedPointer *)JS_NativeDialogManagerAndroid_DialogOptions:(id)json;
@end

namespace JS {
  namespace NativeDialogManagerAndroid {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<NSString *> buttonClicked;
          RCTRequired<NSString *> dismissed;
          RCTRequired<double> buttonPositive;
          RCTRequired<double> buttonNegative;
          RCTRequired<double> buttonNeutral;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeDialogManagerAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)showAlert:(JS::NativeDialogManagerAndroid::DialogOptions &)config
          onError:(RCTResponseSenderBlock)onError
         onAction:(RCTResponseSenderBlock)onAction;
- (facebook::react::ModuleConstants<JS::NativeDialogManagerAndroid::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeDialogManagerAndroid::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'DialogManagerAndroid'
     */

    class JSI_EXPORT NativeDialogManagerAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativeDialogManagerAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeExceptionsManager {
    struct StackFrame {
      folly::Optional<double> column() const;
      NSString *file() const;
      folly::Optional<double> lineNumber() const;
      NSString *methodName() const;
      folly::Optional<bool> collapse() const;

      StackFrame(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeExceptionsManager_StackFrame)
+ (RCTManagedPointer *)JS_NativeExceptionsManager_StackFrame:(id)json;
@end

namespace JS {
  namespace NativeExceptionsManager {
    struct ExceptionData {
      NSString *message() const;
      NSString *originalMessage() const;
      NSString *name() const;
      NSString *componentStack() const;
      facebook::react::LazyVector<JS::NativeExceptionsManager::StackFrame> stack() const;
      double id_() const;
      bool isFatal() const;
      id<NSObject> _Nullable extraData() const;

      ExceptionData(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeExceptionsManager_ExceptionData)
+ (RCTManagedPointer *)JS_NativeExceptionsManager_ExceptionData:(id)json;
@end
@protocol NativeExceptionsManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)reportFatalException:(NSString *)message
                       stack:(NSArray *)stack
                 exceptionId:(double)exceptionId;
- (void)reportSoftException:(NSString *)message
                      stack:(NSArray *)stack
                exceptionId:(double)exceptionId;
- (void)reportException:(JS::NativeExceptionsManager::ExceptionData &)data;
- (void)updateExceptionMessage:(NSString *)message
                         stack:(NSArray *)stack
                   exceptionId:(double)exceptionId;
- (void)dismissRedbox;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ExceptionsManager'
     */

    class JSI_EXPORT NativeExceptionsManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeExceptionsManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeFileReaderModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)readAsDataURL:(NSDictionary *)data
              resolve:(RCTPromiseResolveBlock)resolve
               reject:(RCTPromiseRejectBlock)reject;
- (void)readAsText:(NSDictionary *)data
          encoding:(NSString *)encoding
           resolve:(RCTPromiseResolveBlock)resolve
            reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'FileReaderModule'
     */

    class JSI_EXPORT NativeFileReaderModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeFileReaderModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeFrameRateLogger {
    struct SpecSetGlobalOptionsOptions {
      folly::Optional<bool> debug() const;
      folly::Optional<bool> reportStackTraces() const;

      SpecSetGlobalOptionsOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeFrameRateLogger_SpecSetGlobalOptionsOptions)
+ (RCTManagedPointer *)JS_NativeFrameRateLogger_SpecSetGlobalOptionsOptions:(id)json;
@end
@protocol NativeFrameRateLoggerSpec <RCTBridgeModule, RCTTurboModule>

- (void)setGlobalOptions:(JS::NativeFrameRateLogger::SpecSetGlobalOptionsOptions &)options;
- (void)setContext:(NSString *)context;
- (void)beginScroll;
- (void)endScroll;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'FrameRateLogger'
     */

    class JSI_EXPORT NativeFrameRateLoggerSpecJSI : public ObjCTurboModule {
    public:
      NativeFrameRateLoggerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeHeadlessJsTaskSupportSpec <RCTBridgeModule, RCTTurboModule>

- (void)notifyTaskFinished:(double)taskId;
- (void)notifyTaskRetry:(double)taskId
                resolve:(RCTPromiseResolveBlock)resolve
                 reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'HeadlessJsTaskSupport'
     */

    class JSI_EXPORT NativeHeadlessJsTaskSupportSpecJSI : public ObjCTurboModule {
    public:
      NativeHeadlessJsTaskSupportSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeHeapCaptureSpec <RCTBridgeModule, RCTTurboModule>

- (void)captureHeap:(NSString *)path;
- (void)captureComplete:(NSString *)path
                  error:(NSString * _Nullable)error;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'HeapCapture'
     */

    class JSI_EXPORT NativeHeapCaptureSpecJSI : public ObjCTurboModule {
    public:
      NativeHeapCaptureSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeI18nManager {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<bool> isRTL;
          RCTRequired<bool> doLeftAndRightSwapInRTL;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeI18nManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)allowRTL:(BOOL)allowRTL;
- (void)forceRTL:(BOOL)forceRTL;
- (void)swapLeftAndRightInRTL:(BOOL)flipStyles;
- (facebook::react::ModuleConstants<JS::NativeI18nManager::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeI18nManager::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'I18nManager'
     */

    class JSI_EXPORT NativeI18nManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeI18nManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeImageLoaderSpec <RCTBridgeModule, RCTTurboModule>
@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ImageLoader'
     */

    class JSI_EXPORT NativeImageLoaderSpecJSI : public ObjCTurboModule {
    public:
      NativeImageLoaderSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeImagePickerIOS {
    struct SpecOpenCameraDialogConfig {
      bool unmirrorFrontFacingCamera() const;
      bool videoMode() const;

      SpecOpenCameraDialogConfig(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeImagePickerIOS_SpecOpenCameraDialogConfig)
+ (RCTManagedPointer *)JS_NativeImagePickerIOS_SpecOpenCameraDialogConfig:(id)json;
@end

namespace JS {
  namespace NativeImagePickerIOS {
    struct SpecOpenSelectDialogConfig {
      bool showImages() const;
      bool showVideos() const;

      SpecOpenSelectDialogConfig(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeImagePickerIOS_SpecOpenSelectDialogConfig)
+ (RCTManagedPointer *)JS_NativeImagePickerIOS_SpecOpenSelectDialogConfig:(id)json;
@end
@protocol NativeImagePickerIOSSpec <RCTBridgeModule, RCTTurboModule>

- (void)canRecordVideos:(RCTResponseSenderBlock)callback;
- (void)canUseCamera:(RCTResponseSenderBlock)callback;
- (void)openCameraDialog:(JS::NativeImagePickerIOS::SpecOpenCameraDialogConfig &)config
         successCallback:(RCTResponseSenderBlock)successCallback
          cancelCallback:(RCTResponseSenderBlock)cancelCallback;
- (void)openSelectDialog:(JS::NativeImagePickerIOS::SpecOpenSelectDialogConfig &)config
         successCallback:(RCTResponseSenderBlock)successCallback
          cancelCallback:(RCTResponseSenderBlock)cancelCallback;
- (void)clearAllPendingVideos;
- (void)removePendingVideo:(NSString *)url;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ImagePickerIOS'
     */

    class JSI_EXPORT NativeImagePickerIOSSpecJSI : public ObjCTurboModule {
    public:
      NativeImagePickerIOSSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeJSCSamplingProfilerSpec <RCTBridgeModule, RCTTurboModule>

- (void)operationComplete:(double)token
                   result:(NSString * _Nullable)result
                    error:(NSString * _Nullable)error;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'JSCSamplingProfiler'
     */

    class JSI_EXPORT NativeJSCSamplingProfilerSpecJSI : public ObjCTurboModule {
    public:
      NativeJSCSamplingProfilerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeJSDevSupport {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<double> ERROR_CODE_EXCEPTION;
          RCTRequired<double> ERROR_CODE_VIEW_NOT_FOUND;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeJSDevSupportSpec <RCTBridgeModule, RCTTurboModule>

- (void)onSuccess:(NSDictionary *)data;
- (void)onFailure:(double)errorCode
            error:(NSString *)error;
- (facebook::react::ModuleConstants<JS::NativeJSDevSupport::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeJSDevSupport::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'JSDevSupport'
     */

    class JSI_EXPORT NativeJSDevSupportSpecJSI : public ObjCTurboModule {
    public:
      NativeJSDevSupportSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeKeyboardObserverSpec <RCTBridgeModule, RCTTurboModule>

- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'KeyboardObserver'
     */

    class JSI_EXPORT NativeKeyboardObserverSpecJSI : public ObjCTurboModule {
    public:
      NativeKeyboardObserverSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeLinking {
    struct SpecSendIntentExtrasElement {
      NSString *key() const;
      id<NSObject> value() const;

      SpecSendIntentExtrasElement(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeLinking_SpecSendIntentExtrasElement)
+ (RCTManagedPointer *)JS_NativeLinking_SpecSendIntentExtrasElement:(id)json;
@end
@protocol NativeLinkingSpec <RCTBridgeModule, RCTTurboModule>

- (void)getInitialURL:(RCTPromiseResolveBlock)resolve
               reject:(RCTPromiseRejectBlock)reject;
- (void)canOpenURL:(NSString *)url
           resolve:(RCTPromiseResolveBlock)resolve
            reject:(RCTPromiseRejectBlock)reject;
- (void)openURL:(NSString *)url
        resolve:(RCTPromiseResolveBlock)resolve
         reject:(RCTPromiseRejectBlock)reject;
- (void)openSettings:(RCTPromiseResolveBlock)resolve
              reject:(RCTPromiseRejectBlock)reject;
- (void)sendIntent:(NSString *)action
            extras:(NSArray *_Nullable)extras
           resolve:(RCTPromiseResolveBlock)resolve
            reject:(RCTPromiseRejectBlock)reject;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'Linking'
     */

    class JSI_EXPORT NativeLinkingSpecJSI : public ObjCTurboModule {
    public:
      NativeLinkingSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeModalManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ModalManager'
     */

    class JSI_EXPORT NativeModalManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeModalManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeNetworkingAndroid {
    struct Header {
      NSString *first() const;
      NSString *second() const;

      Header(NSArray *const v) : _v(v) {}
    private:
      NSArray *_v;
    };
  }
}

@interface RCTCxxConvert (NativeNetworkingAndroid_Header)
+ (RCTManagedPointer *)JS_NativeNetworkingAndroid_Header:(id)json;
@end
@protocol NativeNetworkingAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)sendRequest:(NSString *)method
                url:(NSString *)url
          requestId:(double)requestId
            headers:(NSArray *)headers
               data:(NSDictionary *)data
       responseType:(NSDictionary *)responseType
useIncrementalUpdates:(BOOL)useIncrementalUpdates
            timeout:(double)timeout
    withCredentials:(BOOL)withCredentials;
- (void)abortRequest:(double)requestId;
- (void)clearCookies:(RCTResponseSenderBlock)callback;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'NetworkingAndroid'
     */

    class JSI_EXPORT NativeNetworkingAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativeNetworkingAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeNetworkingIOS {
    struct SpecSendRequestQuery {
      NSString *method() const;
      NSString *url() const;
      id<NSObject> data() const;
      id<NSObject> headers() const;
      id<NSObject> responseType() const;
      bool incrementalUpdates() const;
      double timeout() const;
      bool withCredentials() const;

      SpecSendRequestQuery(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeNetworkingIOS_SpecSendRequestQuery)
+ (RCTManagedPointer *)JS_NativeNetworkingIOS_SpecSendRequestQuery:(id)json;
@end
@protocol NativeNetworkingIOSSpec <RCTBridgeModule, RCTTurboModule>

- (void)sendRequest:(JS::NativeNetworkingIOS::SpecSendRequestQuery &)query
           callback:(RCTResponseSenderBlock)callback;
- (void)abortRequest:(double)requestId;
- (void)clearCookies:(RCTResponseSenderBlock)callback;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'NetworkingIOS'
     */

    class JSI_EXPORT NativeNetworkingIOSSpecJSI : public ObjCTurboModule {
    public:
      NativeNetworkingIOSSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativePermissionsAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)checkPermission:(NSString *)permission
                resolve:(RCTPromiseResolveBlock)resolve
                 reject:(RCTPromiseRejectBlock)reject;
- (void)requestPermission:(NSString *)permission
                  resolve:(RCTPromiseResolveBlock)resolve
                   reject:(RCTPromiseRejectBlock)reject;
- (void)shouldShowRequestPermissionRationale:(NSString *)permission
                                     resolve:(RCTPromiseResolveBlock)resolve
                                      reject:(RCTPromiseRejectBlock)reject;
- (void)requestMultiplePermissions:(NSArray *)permissions
                           resolve:(RCTPromiseResolveBlock)resolve
                            reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'PermissionsAndroid'
     */

    class JSI_EXPORT NativePermissionsAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativePermissionsAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativePlatformConstantsAndroid {
    struct ConstantsReactNativeVersion {

      struct Builder {
        struct Input {
          RCTRequired<double> major;
          RCTRequired<double> minor;
          RCTRequired<double> patch;
          RCTRequired<folly::Optional<double>> prerelease;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing ConstantsReactNativeVersion */
        Builder(ConstantsReactNativeVersion i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static ConstantsReactNativeVersion fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      ConstantsReactNativeVersion(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}

namespace JS {
  namespace NativePlatformConstantsAndroid {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<bool> isTesting;
          RCTRequired<JS::NativePlatformConstantsAndroid::ConstantsReactNativeVersion::Builder> reactNativeVersion;
          RCTRequired<double> Version;
          RCTRequired<NSString *> Release;
          RCTRequired<NSString *> Serial;
          RCTRequired<NSString *> Fingerprint;
          RCTRequired<NSString *> Model;
          RCTRequired<NSString *> ServerHost;
          RCTRequired<NSString *> uiMode;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativePlatformConstantsAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (NSString *)getAndroidID;
- (facebook::react::ModuleConstants<JS::NativePlatformConstantsAndroid::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativePlatformConstantsAndroid::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'PlatformConstantsAndroid'
     */

    class JSI_EXPORT NativePlatformConstantsAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativePlatformConstantsAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativePlatformConstantsIOS {
    struct ConstantsReactNativeVersion {

      struct Builder {
        struct Input {
          RCTRequired<double> major;
          RCTRequired<double> minor;
          RCTRequired<double> patch;
          RCTRequired<folly::Optional<double>> prerelease;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing ConstantsReactNativeVersion */
        Builder(ConstantsReactNativeVersion i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static ConstantsReactNativeVersion fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      ConstantsReactNativeVersion(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}

namespace JS {
  namespace NativePlatformConstantsIOS {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<bool> isTesting;
          RCTRequired<JS::NativePlatformConstantsIOS::ConstantsReactNativeVersion::Builder> reactNativeVersion;
          RCTRequired<bool> forceTouchAvailable;
          RCTRequired<NSString *> osVersion;
          RCTRequired<NSString *> systemName;
          RCTRequired<NSString *> interfaceIdiom;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativePlatformConstantsIOSSpec <RCTBridgeModule, RCTTurboModule>

- (facebook::react::ModuleConstants<JS::NativePlatformConstantsIOS::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativePlatformConstantsIOS::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'PlatformConstantsIOS'
     */

    class JSI_EXPORT NativePlatformConstantsIOSSpecJSI : public ObjCTurboModule {
    public:
      NativePlatformConstantsIOSSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativePushNotificationManagerIOS {
    struct SpecRequestPermissionsPermission {
      folly::Optional<bool> alert() const;
      folly::Optional<bool> badge() const;
      folly::Optional<bool> sound() const;

      SpecRequestPermissionsPermission(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativePushNotificationManagerIOS_SpecRequestPermissionsPermission)
+ (RCTManagedPointer *)JS_NativePushNotificationManagerIOS_SpecRequestPermissionsPermission:(id)json;
@end

namespace JS {
  namespace NativePushNotificationManagerIOS {
    struct Permissions {
      bool alert() const;
      bool badge() const;
      bool sound() const;

      Permissions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativePushNotificationManagerIOS_Permissions)
+ (RCTManagedPointer *)JS_NativePushNotificationManagerIOS_Permissions:(id)json;
@end

namespace JS {
  namespace NativePushNotificationManagerIOS {
    struct Notification {
      NSString *alertTitle() const;
      folly::Optional<double> fireDate() const;
      NSString *alertBody() const;
      NSString *alertAction() const;
      id<NSObject> _Nullable userInfo() const;
      NSString *category() const;
      NSString *repeatInterval() const;
      folly::Optional<double> applicationIconBadgeNumber() const;
      folly::Optional<bool> isSilent() const;

      Notification(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativePushNotificationManagerIOS_Notification)
+ (RCTManagedPointer *)JS_NativePushNotificationManagerIOS_Notification:(id)json;
@end
@protocol NativePushNotificationManagerIOSSpec <RCTBridgeModule, RCTTurboModule>

- (void)onFinishRemoteNotification:(NSString *)notificationId
                       fetchResult:(NSString *)fetchResult;
- (void)setApplicationIconBadgeNumber:(double)num;
- (void)getApplicationIconBadgeNumber:(RCTResponseSenderBlock)callback;
- (void)requestPermissions:(JS::NativePushNotificationManagerIOS::SpecRequestPermissionsPermission &)permission
                   resolve:(RCTPromiseResolveBlock)resolve
                    reject:(RCTPromiseRejectBlock)reject;
- (void)abandonPermissions;
- (void)checkPermissions:(RCTResponseSenderBlock)callback;
- (void)presentLocalNotification:(JS::NativePushNotificationManagerIOS::Notification &)notification;
- (void)scheduleLocalNotification:(JS::NativePushNotificationManagerIOS::Notification &)notification;
- (void)cancelAllLocalNotifications;
- (void)cancelLocalNotifications:(NSDictionary *)userInfo;
- (void)getInitialNotification:(RCTPromiseResolveBlock)resolve
                        reject:(RCTPromiseRejectBlock)reject;
- (void)getScheduledLocalNotifications:(RCTResponseSenderBlock)callback;
- (void)removeAllDeliveredNotifications;
- (void)removeDeliveredNotifications:(NSArray *)identifiers;
- (void)getDeliveredNotifications:(RCTResponseSenderBlock)callback;
- (void)addListener:(NSString *)eventType;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'PushNotificationManagerIOS'
     */

    class JSI_EXPORT NativePushNotificationManagerIOSSpecJSI : public ObjCTurboModule {
    public:
      NativePushNotificationManagerIOSSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeRedBoxSpec <RCTBridgeModule, RCTTurboModule>

- (void)setExtraData:(NSDictionary *)extraData
          identifier:(NSString *)identifier;
- (void)dismiss;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'RedBox'
     */

    class JSI_EXPORT NativeRedBoxSpecJSI : public ObjCTurboModule {
    public:
      NativeRedBoxSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeSegmentFetcherSpec <RCTBridgeModule, RCTTurboModule>

- (void)fetchSegment:(double)segmentId
             options:(NSDictionary *)options
            callback:(RCTResponseSenderBlock)callback;
- (void)getSegment:(double)segmentId
           options:(NSDictionary *)options
          callback:(RCTResponseSenderBlock)callback;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'SegmentFetcher'
     */

    class JSI_EXPORT NativeSegmentFetcherSpecJSI : public ObjCTurboModule {
    public:
      NativeSegmentFetcherSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeSettingsManager {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<id<NSObject>> settings;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeSettingsManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)setValues:(NSDictionary *)values;
- (void)deleteValues:(NSArray *)values;
- (facebook::react::ModuleConstants<JS::NativeSettingsManager::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeSettingsManager::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'SettingsManager'
     */

    class JSI_EXPORT NativeSettingsManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeSettingsManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeShareModule {
    struct SpecShareContent {
      NSString *title() const;
      NSString *message() const;

      SpecShareContent(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeShareModule_SpecShareContent)
+ (RCTManagedPointer *)JS_NativeShareModule_SpecShareContent:(id)json;
@end
@protocol NativeShareModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)share:(JS::NativeShareModule::SpecShareContent &)content
  dialogTitle:(NSString *)dialogTitle
      resolve:(RCTPromiseResolveBlock)resolve
       reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ShareModule'
     */

    class JSI_EXPORT NativeShareModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeShareModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeSoundManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)playTouchSound;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'SoundManager'
     */

    class JSI_EXPORT NativeSoundManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeSoundManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeSourceCode {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<NSString *> scriptURL;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeSourceCodeSpec <RCTBridgeModule, RCTTurboModule>

- (facebook::react::ModuleConstants<JS::NativeSourceCode::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeSourceCode::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'SourceCode'
     */

    class JSI_EXPORT NativeSourceCodeSpecJSI : public ObjCTurboModule {
    public:
      NativeSourceCodeSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeStatusBarManager {
    struct SpecGetHeightCallbackResult {
      double height() const;

      SpecGetHeightCallbackResult(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeStatusBarManager_SpecGetHeightCallbackResult)
+ (RCTManagedPointer *)JS_NativeStatusBarManager_SpecGetHeightCallbackResult:(id)json;
@end

namespace JS {
  namespace NativeStatusBarManager {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<double> HEIGHT;
          RCTRequired<double> DEFAULT_BACKGROUND_COLOR;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeStatusBarManagerSpec <RCTBridgeModule, RCTTurboModule>

- (void)setColor:(double)color
        animated:(BOOL)animated;
- (void)setTranslucent:(BOOL)translucent;
- (void)getHeight:(RCTResponseSenderBlock)callback;
- (void)setNetworkActivityIndicatorVisible:(BOOL)visible;
- (void)addListener:(NSString *)eventType;
- (void)removeListeners:(double)count;
- (void)setStyle:(NSString * _Nullable)statusBarStyle
        animated:(NSNumber *)animated;
- (void)setHidden:(BOOL)hidden
    withAnimation:(NSString * _Nullable)withAnimation;
- (facebook::react::ModuleConstants<JS::NativeStatusBarManager::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeStatusBarManager::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'StatusBarManager'
     */

    class JSI_EXPORT NativeStatusBarManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeStatusBarManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeTVNavigationEventEmitterSpec <RCTBridgeModule, RCTTurboModule>

- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'TVNavigationEventEmitter'
     */

    class JSI_EXPORT NativeTVNavigationEventEmitterSpecJSI : public ObjCTurboModule {
    public:
      NativeTVNavigationEventEmitterSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeTimePickerAndroid {
    struct TimePickerOptions {
      folly::Optional<double> hour() const;
      folly::Optional<double> minute() const;
      folly::Optional<bool> is24Hour() const;
      NSString *mode() const;

      TimePickerOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeTimePickerAndroid_TimePickerOptions)
+ (RCTManagedPointer *)JS_NativeTimePickerAndroid_TimePickerOptions:(id)json;
@end
@protocol NativeTimePickerAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)open:(JS::NativeTimePickerAndroid::TimePickerOptions &)options
     resolve:(RCTPromiseResolveBlock)resolve
      reject:(RCTPromiseRejectBlock)reject;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'TimePickerAndroid'
     */

    class JSI_EXPORT NativeTimePickerAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativeTimePickerAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeTimePickerAndroid {
    struct TimePickerResult {
      NSString *action() const;
      double hour() const;
      double minute() const;

      TimePickerResult(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeTimePickerAndroid_TimePickerResult)
+ (RCTManagedPointer *)JS_NativeTimePickerAndroid_TimePickerResult:(id)json;
@end
@protocol NativeTimingSpec <RCTBridgeModule, RCTTurboModule>

- (void)createTimer:(double)callbackID
           duration:(double)duration
   jsSchedulingTime:(double)jsSchedulingTime
            repeats:(BOOL)repeats;
- (void)deleteTimer:(double)timerID;
- (void)setSendIdleEvents:(BOOL)sendIdleEvents;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'Timing'
     */

    class JSI_EXPORT NativeTimingSpecJSI : public ObjCTurboModule {
    public:
      NativeTimingSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeToastAndroid {
    struct Constants {

      struct Builder {
        struct Input {
          RCTRequired<double> SHORT;
          RCTRequired<double> LONG;
          RCTRequired<double> TOP;
          RCTRequired<double> BOTTOM;
          RCTRequired<double> CENTER;
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeToastAndroidSpec <RCTBridgeModule, RCTTurboModule>

- (void)show:(NSString *)message
    duration:(double)duration;
- (void)showWithGravity:(NSString *)message
               duration:(double)duration
                gravity:(double)gravity;
- (void)showWithGravityAndOffset:(NSString *)message
                        duration:(double)duration
                         gravity:(double)gravity
                         xOffset:(double)xOffset
                         yOffset:(double)yOffset;
- (facebook::react::ModuleConstants<JS::NativeToastAndroid::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeToastAndroid::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'ToastAndroid'
     */

    class JSI_EXPORT NativeToastAndroidSpecJSI : public ObjCTurboModule {
    public:
      NativeToastAndroidSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeUIManager {
    struct Constants {

      struct Builder {
        struct Input {
        };

        /** Initialize with a set of values */
        Builder(const Input i);
        /** Initialize with an existing Constants */
        Builder(Constants i);
        /** Builds the object. Generally used only by the infrastructure. */
        NSDictionary *buildUnsafeRawValue() const { return _factory(); };
      private:
        NSDictionary *(^_factory)(void);
      };

      static Constants fromUnsafeRawValue(NSDictionary *const v) { return {v}; }
      NSDictionary *unsafeRawValue() const { return _v; }
    private:
      Constants(NSDictionary *const v) : _v(v) {}
      NSDictionary *_v;
    };
  }
}
@protocol NativeUIManagerSpec <RCTBridgeModule, RCTTurboModule>

- (NSDictionary *)getConstantsForViewManager:(NSString *)viewManagerName;
- (NSArray<NSString *> *)getDefaultEventTypes;
- (void)playTouchSound;
- (NSDictionary *)lazilyLoadView:(NSString *)name;
- (void)createView:(NSNumber *)reactTag
          viewName:(NSString *)viewName
           rootTag:(double)rootTag
             props:(NSDictionary *)props;
- (void)updateView:(double)reactTag
          viewName:(NSString *)viewName
             props:(NSDictionary *)props;
- (void)focus:(NSNumber *)reactTag;
- (void)blur:(NSNumber *)reactTag;
- (void)findSubviewIn:(NSNumber *)reactTag
                point:(NSArray *)point
             callback:(RCTResponseSenderBlock)callback;
- (void)dispatchViewManagerCommand:(NSNumber *)reactTag
                         commandID:(double)commandID
                       commandArgs:(NSArray *_Nullable)commandArgs;
- (void)measure:(NSNumber *)reactTag
       callback:(RCTResponseSenderBlock)callback;
- (void)measureInWindow:(NSNumber *)reactTag
               callback:(RCTResponseSenderBlock)callback;
- (void)viewIsDescendantOf:(NSNumber *)reactTag
          ancestorReactTag:(NSNumber *)ancestorReactTag
                  callback:(RCTResponseSenderBlock)callback;
- (void)measureLayout:(NSNumber *)reactTag
     ancestorReactTag:(NSNumber *)ancestorReactTag
        errorCallback:(RCTResponseSenderBlock)errorCallback
             callback:(RCTResponseSenderBlock)callback;
- (void)measureLayoutRelativeToParent:(NSNumber *)reactTag
                        errorCallback:(RCTResponseSenderBlock)errorCallback
                             callback:(RCTResponseSenderBlock)callback;
- (void)setJSResponder:(NSNumber *)reactTag
  blockNativeResponder:(BOOL)blockNativeResponder;
- (void)clearJSResponder;
- (void)configureNextLayoutAnimation:(NSDictionary *)config
                            callback:(RCTResponseSenderBlock)callback
                       errorCallback:(RCTResponseSenderBlock)errorCallback;
- (void)removeSubviewsFromContainerWithID:(double)containerID;
- (void)replaceExistingNonRootView:(NSNumber *)reactTag
                       newReactTag:(NSNumber *)newReactTag;
- (void)setChildren:(NSNumber *)containerTag
          reactTags:(NSArray *)reactTags;
- (void)manageChildren:(NSNumber *)containerTag
       moveFromIndices:(NSArray *)moveFromIndices
         moveToIndices:(NSArray *)moveToIndices
     addChildReactTags:(NSArray *)addChildReactTags
          addAtIndices:(NSArray *)addAtIndices
       removeAtIndices:(NSArray *)removeAtIndices;
- (void)setLayoutAnimationEnabledExperimental:(BOOL)enabled;
- (void)sendAccessibilityEvent:(NSNumber *)reactTag
                     eventType:(double)eventType;
- (void)showPopupMenu:(NSNumber *)reactTag
                items:(NSArray *)items
                error:(RCTResponseSenderBlock)error
              success:(RCTResponseSenderBlock)success;
- (void)dismissPopupMenu;
- (facebook::react::ModuleConstants<JS::NativeUIManager::Constants::Builder>)constantsToExport;
- (facebook::react::ModuleConstants<JS::NativeUIManager::Constants::Builder>)getConstants;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'UIManager'
     */

    class JSI_EXPORT NativeUIManagerSpecJSI : public ObjCTurboModule {
    public:
      NativeUIManagerSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook
@protocol NativeVibrationSpec <RCTBridgeModule, RCTTurboModule>

- (void)vibrate:(double)pattern;
- (void)vibrateByPattern:(NSArray *)pattern
                  repeat:(double)repeat;
- (void)cancel;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'Vibration'
     */

    class JSI_EXPORT NativeVibrationSpecJSI : public ObjCTurboModule {
    public:
      NativeVibrationSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

namespace JS {
  namespace NativeWebSocketModule {
    struct SpecConnectOptionsHeaders {
      NSString *origin() const;

      SpecConnectOptionsHeaders(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeWebSocketModule_SpecConnectOptionsHeaders)
+ (RCTManagedPointer *)JS_NativeWebSocketModule_SpecConnectOptionsHeaders:(id)json;
@end

namespace JS {
  namespace NativeWebSocketModule {
    struct SpecConnectOptions {
      folly::Optional<JS::NativeWebSocketModule::SpecConnectOptionsHeaders> headers() const;

      SpecConnectOptions(NSDictionary *const v) : _v(v) {}
    private:
      NSDictionary *_v;
    };
  }
}

@interface RCTCxxConvert (NativeWebSocketModule_SpecConnectOptions)
+ (RCTManagedPointer *)JS_NativeWebSocketModule_SpecConnectOptions:(id)json;
@end
@protocol NativeWebSocketModuleSpec <RCTBridgeModule, RCTTurboModule>

- (void)connect:(NSString *)url
      protocols:(NSArray *_Nullable)protocols
        options:(JS::NativeWebSocketModule::SpecConnectOptions &)options
       socketID:(double)socketID;
- (void)send:(NSString *)message
    socketID:(double)socketID;
- (void)sendBinary:(NSString *)base64String
          socketID:(double)socketID;
- (void)ping:(double)socketID;
- (void)close:(double)code
       reason:(NSString *)reason
     socketID:(double)socketID;
- (void)addListener:(NSString *)eventName;
- (void)removeListeners:(double)count;

@end
namespace facebook {
  namespace react {
    /**
     * ObjC++ class for module 'WebSocketModule'
     */

    class JSI_EXPORT NativeWebSocketModuleSpecJSI : public ObjCTurboModule {
    public:
      NativeWebSocketModuleSpecJSI(id<RCTTurboModule> instance, std::shared_ptr<JSCallInvoker> jsInvoker);

    };
  } // namespace react
} // namespace facebook

#import <RCTTypeSafety/RCTConvertHelpers.h>


inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::extraSmall() const
{
  id const p = _v[@"extraSmall"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::small() const
{
  id const p = _v[@"small"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::medium() const
{
  id const p = _v[@"medium"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::large() const
{
  id const p = _v[@"large"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::extraLarge() const
{
  id const p = _v[@"extraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::extraExtraLarge() const
{
  id const p = _v[@"extraExtraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::extraExtraExtraLarge() const
{
  id const p = _v[@"extraExtraExtraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::accessibilityMedium() const
{
  id const p = _v[@"accessibilityMedium"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::accessibilityLarge() const
{
  id const p = _v[@"accessibilityLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::accessibilityExtraLarge() const
{
  id const p = _v[@"accessibilityExtraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::accessibilityExtraExtraLarge() const
{
  id const p = _v[@"accessibilityExtraExtraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeAccessibilityManager::SpecSetAccessibilityContentSizeMultipliersJSMultiipliers::accessibilityExtraExtraExtraLarge() const
{
  id const p = _v[@"accessibilityExtraExtraExtraLarge"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::title() const
{
  id const p = _v[@"title"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline folly::Optional<facebook::react::LazyVector<NSString *>> JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::options() const
{
  id const p = _v[@"options"];
  return RCTBridgingToOptionalVec(p, ^NSString *(id itemValue_0) { return RCTBridgingToString(itemValue_0); });
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::destructiveButtonIndex() const
{
  id const p = _v[@"destructiveButtonIndex"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::cancelButtonIndex() const
{
  id const p = _v[@"cancelButtonIndex"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::anchor() const
{
  id const p = _v[@"anchor"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowActionSheetWithOptionsOptions::tintColor() const
{
  id const p = _v[@"tintColor"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::url() const
{
  id const p = _v[@"url"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::subject() const
{
  id const p = _v[@"subject"];
  return RCTBridgingToString(p);
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::anchor() const
{
  id const p = _v[@"anchor"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::tintColor() const
{
  id const p = _v[@"tintColor"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<facebook::react::LazyVector<NSString *>> JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsOptions::excludedActivityTypes() const
{
  id const p = _v[@"excludedActivityTypes"];
  return RCTBridgingToOptionalVec(p, ^NSString *(id itemValue_0) { return RCTBridgingToString(itemValue_0); });
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsFailureCallbackError::domain() const
{
  id const p = _v[@"domain"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsFailureCallbackError::code() const
{
  id const p = _v[@"code"];
  return RCTBridgingToString(p);
}
inline id<NSObject> _Nullable JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsFailureCallbackError::userInfo() const
{
  id const p = _v[@"userInfo"];
  return p;
}
inline NSString *JS::NativeActionSheetManager::SpecShowShareActionSheetWithOptionsFailureCallbackError::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::title() const
{
  id const p = _v[@"title"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline id<NSObject> _Nullable JS::NativeAlertManager::Args::buttons() const
{
  id const p = _v[@"buttons"];
  return p;
}
inline NSString *JS::NativeAlertManager::Args::type() const
{
  id const p = _v[@"type"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::defaultValue() const
{
  id const p = _v[@"defaultValue"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::cancelButtonKey() const
{
  id const p = _v[@"cancelButtonKey"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::destructiveButtonKey() const
{
  id const p = _v[@"destructiveButtonKey"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAlertManager::Args::keyboardType() const
{
  id const p = _v[@"keyboardType"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAnimatedModule::AnimatedNodeConfig::type() const
{
  id const p = _v[@"type"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAnimatedModule::AnimatingNodeConfig::type() const
{
  id const p = _v[@"type"];
  return RCTBridgingToString(p);
}
inline bool JS::NativeAnimatedModule::EndResult::finished() const
{
  id const p = _v[@"finished"];
  return RCTBridgingToBool(p);
}
inline facebook::react::LazyVector<NSString *> JS::NativeAnimatedModule::EventMapping::nativeEventPath() const
{
  id const p = _v[@"nativeEventPath"];
  return RCTBridgingToVec(p, ^NSString *(id itemValue_0) { return RCTBridgingToString(itemValue_0); });
}
inline folly::Optional<double> JS::NativeAnimatedModule::EventMapping::animatedValueTag() const
{
  id const p = _v[@"animatedValueTag"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativeAppState::SpecGetCurrentAppStateSuccessAppState::app_state() const
{
  id const p = _v[@"app_state"];
  return RCTBridgingToString(p);
}
inline JS::NativeAppState::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto initialAppState = i.initialAppState.get();
  d[@"initialAppState"] = initialAppState;
  return d;
}) {}
inline JS::NativeAppState::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline NSString *JS::NativeAsyncStorage::SpecMultiGetCallbackErrorsElement::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAsyncStorage::SpecMultiSetCallbackErrorsElement::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAsyncStorage::SpecMultiMergeCallbackErrorsElement::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAsyncStorage::SpecMultiRemoveCallbackErrorsElement::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAsyncStorage::SpecClearCallbackError::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeAsyncStorage::SpecGetAllKeysCallbackError::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline JS::NativeBlobModule::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto BLOB_URI_SCHEME = i.BLOB_URI_SCHEME.get();
  d[@"BLOB_URI_SCHEME"] = BLOB_URI_SCHEME;
  auto BLOB_URI_HOST = i.BLOB_URI_HOST.get();
  d[@"BLOB_URI_HOST"] = BLOB_URI_HOST;
  return d;
}) {}
inline JS::NativeBlobModule::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline JS::NativeDeviceInfo::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto Dimensions = i.Dimensions.get();
  d[@"Dimensions"] = Dimensions;
  auto isIPhoneX_deprecated = i.isIPhoneX_deprecated;
  d[@"isIPhoneX_deprecated"] = isIPhoneX_deprecated.hasValue() ? @((BOOL)isIPhoneX_deprecated.value()) : nil;
  return d;
}) {}
inline JS::NativeDeviceInfo::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline NSString *JS::NativeDialogManagerAndroid::DialogOptions::title() const
{
  id const p = _v[@"title"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeDialogManagerAndroid::DialogOptions::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeDialogManagerAndroid::DialogOptions::buttonPositive() const
{
  id const p = _v[@"buttonPositive"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeDialogManagerAndroid::DialogOptions::buttonNegative() const
{
  id const p = _v[@"buttonNegative"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeDialogManagerAndroid::DialogOptions::buttonNeutral() const
{
  id const p = _v[@"buttonNeutral"];
  return RCTBridgingToString(p);
}
inline folly::Optional<facebook::react::LazyVector<NSString *>> JS::NativeDialogManagerAndroid::DialogOptions::items() const
{
  id const p = _v[@"items"];
  return RCTBridgingToOptionalVec(p, ^NSString *(id itemValue_0) { return RCTBridgingToString(itemValue_0); });
}
inline folly::Optional<bool> JS::NativeDialogManagerAndroid::DialogOptions::cancelable() const
{
  id const p = _v[@"cancelable"];
  return RCTBridgingToOptionalBool(p);
}
inline JS::NativeDialogManagerAndroid::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto buttonClicked = i.buttonClicked.get();
  d[@"buttonClicked"] = buttonClicked;
  auto dismissed = i.dismissed.get();
  d[@"dismissed"] = dismissed;
  auto buttonPositive = i.buttonPositive.get();
  d[@"buttonPositive"] = @(buttonPositive);
  auto buttonNegative = i.buttonNegative.get();
  d[@"buttonNegative"] = @(buttonNegative);
  auto buttonNeutral = i.buttonNeutral.get();
  d[@"buttonNeutral"] = @(buttonNeutral);
  return d;
}) {}
inline JS::NativeDialogManagerAndroid::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline folly::Optional<double> JS::NativeExceptionsManager::StackFrame::column() const
{
  id const p = _v[@"column"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativeExceptionsManager::StackFrame::file() const
{
  id const p = _v[@"file"];
  return RCTBridgingToString(p);
}
inline folly::Optional<double> JS::NativeExceptionsManager::StackFrame::lineNumber() const
{
  id const p = _v[@"lineNumber"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativeExceptionsManager::StackFrame::methodName() const
{
  id const p = _v[@"methodName"];
  return RCTBridgingToString(p);
}
inline folly::Optional<bool> JS::NativeExceptionsManager::StackFrame::collapse() const
{
  id const p = _v[@"collapse"];
  return RCTBridgingToOptionalBool(p);
}
inline NSString *JS::NativeExceptionsManager::ExceptionData::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeExceptionsManager::ExceptionData::originalMessage() const
{
  id const p = _v[@"originalMessage"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeExceptionsManager::ExceptionData::name() const
{
  id const p = _v[@"name"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeExceptionsManager::ExceptionData::componentStack() const
{
  id const p = _v[@"componentStack"];
  return RCTBridgingToString(p);
}
inline facebook::react::LazyVector<JS::NativeExceptionsManager::StackFrame> JS::NativeExceptionsManager::ExceptionData::stack() const
{
  id const p = _v[@"stack"];
  return RCTBridgingToVec(p, ^JS::NativeExceptionsManager::StackFrame(id itemValue_0) { return JS::NativeExceptionsManager::StackFrame(itemValue_0); });
}
inline double JS::NativeExceptionsManager::ExceptionData::id_() const
{
  id const p = _v[@"id"];
  return RCTBridgingToDouble(p);
}
inline bool JS::NativeExceptionsManager::ExceptionData::isFatal() const
{
  id const p = _v[@"isFatal"];
  return RCTBridgingToBool(p);
}
inline id<NSObject> _Nullable JS::NativeExceptionsManager::ExceptionData::extraData() const
{
  id const p = _v[@"extraData"];
  return p;
}
inline folly::Optional<bool> JS::NativeFrameRateLogger::SpecSetGlobalOptionsOptions::debug() const
{
  id const p = _v[@"debug"];
  return RCTBridgingToOptionalBool(p);
}
inline folly::Optional<bool> JS::NativeFrameRateLogger::SpecSetGlobalOptionsOptions::reportStackTraces() const
{
  id const p = _v[@"reportStackTraces"];
  return RCTBridgingToOptionalBool(p);
}
inline JS::NativeI18nManager::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto isRTL = i.isRTL.get();
  d[@"isRTL"] = @(isRTL);
  auto doLeftAndRightSwapInRTL = i.doLeftAndRightSwapInRTL.get();
  d[@"doLeftAndRightSwapInRTL"] = @(doLeftAndRightSwapInRTL);
  return d;
}) {}
inline JS::NativeI18nManager::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline bool JS::NativeImagePickerIOS::SpecOpenCameraDialogConfig::unmirrorFrontFacingCamera() const
{
  id const p = _v[@"unmirrorFrontFacingCamera"];
  return RCTBridgingToBool(p);
}
inline bool JS::NativeImagePickerIOS::SpecOpenCameraDialogConfig::videoMode() const
{
  id const p = _v[@"videoMode"];
  return RCTBridgingToBool(p);
}
inline bool JS::NativeImagePickerIOS::SpecOpenSelectDialogConfig::showImages() const
{
  id const p = _v[@"showImages"];
  return RCTBridgingToBool(p);
}
inline bool JS::NativeImagePickerIOS::SpecOpenSelectDialogConfig::showVideos() const
{
  id const p = _v[@"showVideos"];
  return RCTBridgingToBool(p);
}
inline JS::NativeJSDevSupport::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto ERROR_CODE_EXCEPTION = i.ERROR_CODE_EXCEPTION.get();
  d[@"ERROR_CODE_EXCEPTION"] = @(ERROR_CODE_EXCEPTION);
  auto ERROR_CODE_VIEW_NOT_FOUND = i.ERROR_CODE_VIEW_NOT_FOUND.get();
  d[@"ERROR_CODE_VIEW_NOT_FOUND"] = @(ERROR_CODE_VIEW_NOT_FOUND);
  return d;
}) {}
inline JS::NativeJSDevSupport::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline NSString *JS::NativeLinking::SpecSendIntentExtrasElement::key() const
{
  id const p = _v[@"key"];
  return RCTBridgingToString(p);
}
inline id<NSObject> JS::NativeLinking::SpecSendIntentExtrasElement::value() const
{
  id const p = _v[@"value"];
  return p;
}
inline NSString *JS::NativeNetworkingAndroid::Header::first() const
{
  id const p = _v[0];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeNetworkingAndroid::Header::second() const
{
  id const p = _v[1];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeNetworkingIOS::SpecSendRequestQuery::method() const
{
  id const p = _v[@"method"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeNetworkingIOS::SpecSendRequestQuery::url() const
{
  id const p = _v[@"url"];
  return RCTBridgingToString(p);
}
inline id<NSObject> JS::NativeNetworkingIOS::SpecSendRequestQuery::data() const
{
  id const p = _v[@"data"];
  return p;
}
inline id<NSObject> JS::NativeNetworkingIOS::SpecSendRequestQuery::headers() const
{
  id const p = _v[@"headers"];
  return p;
}
inline id<NSObject> JS::NativeNetworkingIOS::SpecSendRequestQuery::responseType() const
{
  id const p = _v[@"responseType"];
  return p;
}
inline bool JS::NativeNetworkingIOS::SpecSendRequestQuery::incrementalUpdates() const
{
  id const p = _v[@"incrementalUpdates"];
  return RCTBridgingToBool(p);
}
inline double JS::NativeNetworkingIOS::SpecSendRequestQuery::timeout() const
{
  id const p = _v[@"timeout"];
  return RCTBridgingToDouble(p);
}
inline bool JS::NativeNetworkingIOS::SpecSendRequestQuery::withCredentials() const
{
  id const p = _v[@"withCredentials"];
  return RCTBridgingToBool(p);
}
inline JS::NativePlatformConstantsAndroid::ConstantsReactNativeVersion::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto major = i.major.get();
  d[@"major"] = @(major);
  auto minor = i.minor.get();
  d[@"minor"] = @(minor);
  auto patch = i.patch.get();
  d[@"patch"] = @(patch);
  auto prerelease = i.prerelease.get();
  d[@"prerelease"] = prerelease.hasValue() ? @((double)prerelease.value()) : nil;
  return d;
}) {}
inline JS::NativePlatformConstantsAndroid::ConstantsReactNativeVersion::Builder::Builder(ConstantsReactNativeVersion i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline JS::NativePlatformConstantsAndroid::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto isTesting = i.isTesting.get();
  d[@"isTesting"] = @(isTesting);
  auto reactNativeVersion = i.reactNativeVersion.get();
  d[@"reactNativeVersion"] = reactNativeVersion.buildUnsafeRawValue();
  auto Version = i.Version.get();
  d[@"Version"] = @(Version);
  auto Release = i.Release.get();
  d[@"Release"] = Release;
  auto Serial = i.Serial.get();
  d[@"Serial"] = Serial;
  auto Fingerprint = i.Fingerprint.get();
  d[@"Fingerprint"] = Fingerprint;
  auto Model = i.Model.get();
  d[@"Model"] = Model;
  auto ServerHost = i.ServerHost.get();
  d[@"ServerHost"] = ServerHost;
  auto uiMode = i.uiMode.get();
  d[@"uiMode"] = uiMode;
  return d;
}) {}
inline JS::NativePlatformConstantsAndroid::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline JS::NativePlatformConstantsIOS::ConstantsReactNativeVersion::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto major = i.major.get();
  d[@"major"] = @(major);
  auto minor = i.minor.get();
  d[@"minor"] = @(minor);
  auto patch = i.patch.get();
  d[@"patch"] = @(patch);
  auto prerelease = i.prerelease.get();
  d[@"prerelease"] = prerelease.hasValue() ? @((double)prerelease.value()) : nil;
  return d;
}) {}
inline JS::NativePlatformConstantsIOS::ConstantsReactNativeVersion::Builder::Builder(ConstantsReactNativeVersion i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline JS::NativePlatformConstantsIOS::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto isTesting = i.isTesting.get();
  d[@"isTesting"] = @(isTesting);
  auto reactNativeVersion = i.reactNativeVersion.get();
  d[@"reactNativeVersion"] = reactNativeVersion.buildUnsafeRawValue();
  auto forceTouchAvailable = i.forceTouchAvailable.get();
  d[@"forceTouchAvailable"] = @(forceTouchAvailable);
  auto osVersion = i.osVersion.get();
  d[@"osVersion"] = osVersion;
  auto systemName = i.systemName.get();
  d[@"systemName"] = systemName;
  auto interfaceIdiom = i.interfaceIdiom.get();
  d[@"interfaceIdiom"] = interfaceIdiom;
  return d;
}) {}
inline JS::NativePlatformConstantsIOS::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline folly::Optional<bool> JS::NativePushNotificationManagerIOS::SpecRequestPermissionsPermission::alert() const
{
  id const p = _v[@"alert"];
  return RCTBridgingToOptionalBool(p);
}
inline folly::Optional<bool> JS::NativePushNotificationManagerIOS::SpecRequestPermissionsPermission::badge() const
{
  id const p = _v[@"badge"];
  return RCTBridgingToOptionalBool(p);
}
inline folly::Optional<bool> JS::NativePushNotificationManagerIOS::SpecRequestPermissionsPermission::sound() const
{
  id const p = _v[@"sound"];
  return RCTBridgingToOptionalBool(p);
}
inline bool JS::NativePushNotificationManagerIOS::Permissions::alert() const
{
  id const p = _v[@"alert"];
  return RCTBridgingToBool(p);
}
inline bool JS::NativePushNotificationManagerIOS::Permissions::badge() const
{
  id const p = _v[@"badge"];
  return RCTBridgingToBool(p);
}
inline bool JS::NativePushNotificationManagerIOS::Permissions::sound() const
{
  id const p = _v[@"sound"];
  return RCTBridgingToBool(p);
}
inline NSString *JS::NativePushNotificationManagerIOS::Notification::alertTitle() const
{
  id const p = _v[@"alertTitle"];
  return RCTBridgingToString(p);
}
inline folly::Optional<double> JS::NativePushNotificationManagerIOS::Notification::fireDate() const
{
  id const p = _v[@"fireDate"];
  return RCTBridgingToOptionalDouble(p);
}
inline NSString *JS::NativePushNotificationManagerIOS::Notification::alertBody() const
{
  id const p = _v[@"alertBody"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativePushNotificationManagerIOS::Notification::alertAction() const
{
  id const p = _v[@"alertAction"];
  return RCTBridgingToString(p);
}
inline id<NSObject> _Nullable JS::NativePushNotificationManagerIOS::Notification::userInfo() const
{
  id const p = _v[@"userInfo"];
  return p;
}
inline NSString *JS::NativePushNotificationManagerIOS::Notification::category() const
{
  id const p = _v[@"category"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativePushNotificationManagerIOS::Notification::repeatInterval() const
{
  id const p = _v[@"repeatInterval"];
  return RCTBridgingToString(p);
}
inline folly::Optional<double> JS::NativePushNotificationManagerIOS::Notification::applicationIconBadgeNumber() const
{
  id const p = _v[@"applicationIconBadgeNumber"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<bool> JS::NativePushNotificationManagerIOS::Notification::isSilent() const
{
  id const p = _v[@"isSilent"];
  return RCTBridgingToOptionalBool(p);
}
inline JS::NativeSettingsManager::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto settings = i.settings.get();
  d[@"settings"] = settings;
  return d;
}) {}
inline JS::NativeSettingsManager::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline NSString *JS::NativeShareModule::SpecShareContent::title() const
{
  id const p = _v[@"title"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeShareModule::SpecShareContent::message() const
{
  id const p = _v[@"message"];
  return RCTBridgingToString(p);
}
inline JS::NativeSourceCode::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto scriptURL = i.scriptURL.get();
  d[@"scriptURL"] = scriptURL;
  return d;
}) {}
inline JS::NativeSourceCode::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline double JS::NativeStatusBarManager::SpecGetHeightCallbackResult::height() const
{
  id const p = _v[@"height"];
  return RCTBridgingToDouble(p);
}
inline JS::NativeStatusBarManager::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto HEIGHT = i.HEIGHT.get();
  d[@"HEIGHT"] = @(HEIGHT);
  auto DEFAULT_BACKGROUND_COLOR = i.DEFAULT_BACKGROUND_COLOR.get();
  d[@"DEFAULT_BACKGROUND_COLOR"] = @(DEFAULT_BACKGROUND_COLOR);
  return d;
}) {}
inline JS::NativeStatusBarManager::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline folly::Optional<double> JS::NativeTimePickerAndroid::TimePickerOptions::hour() const
{
  id const p = _v[@"hour"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<double> JS::NativeTimePickerAndroid::TimePickerOptions::minute() const
{
  id const p = _v[@"minute"];
  return RCTBridgingToOptionalDouble(p);
}
inline folly::Optional<bool> JS::NativeTimePickerAndroid::TimePickerOptions::is24Hour() const
{
  id const p = _v[@"is24Hour"];
  return RCTBridgingToOptionalBool(p);
}
inline NSString *JS::NativeTimePickerAndroid::TimePickerOptions::mode() const
{
  id const p = _v[@"mode"];
  return RCTBridgingToString(p);
}
inline NSString *JS::NativeTimePickerAndroid::TimePickerResult::action() const
{
  id const p = _v[@"action"];
  return RCTBridgingToString(p);
}
inline double JS::NativeTimePickerAndroid::TimePickerResult::hour() const
{
  id const p = _v[@"hour"];
  return RCTBridgingToDouble(p);
}
inline double JS::NativeTimePickerAndroid::TimePickerResult::minute() const
{
  id const p = _v[@"minute"];
  return RCTBridgingToDouble(p);
}
inline JS::NativeToastAndroid::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  auto SHORT = i.SHORT.get();
  d[@"SHORT"] = @(SHORT);
  auto LONG = i.LONG.get();
  d[@"LONG"] = @(LONG);
  auto TOP = i.TOP.get();
  d[@"TOP"] = @(TOP);
  auto BOTTOM = i.BOTTOM.get();
  d[@"BOTTOM"] = @(BOTTOM);
  auto CENTER = i.CENTER.get();
  d[@"CENTER"] = @(CENTER);
  return d;
}) {}
inline JS::NativeToastAndroid::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline JS::NativeUIManager::Constants::Builder::Builder(const Input i) : _factory(^{
  NSMutableDictionary *d = [NSMutableDictionary new];
  return d;
}) {}
inline JS::NativeUIManager::Constants::Builder::Builder(Constants i) : _factory(^{
  return i.unsafeRawValue();
}) {}
inline NSString *JS::NativeWebSocketModule::SpecConnectOptionsHeaders::origin() const
{
  id const p = _v[@"origin"];
  return RCTBridgingToString(p);
}
inline folly::Optional<JS::NativeWebSocketModule::SpecConnectOptionsHeaders> JS::NativeWebSocketModule::SpecConnectOptions::headers() const
{
  id const p = _v[@"headers"];
  return (p == nil ? folly::none : folly::make_optional(JS::NativeWebSocketModule::SpecConnectOptionsHeaders(p)));
}
