/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 * @format
 */

'use strict';

import type {TurboModule} from '../TurboModule/RCTExport';
import * as TurboModuleRegistry from '../TurboModule/TurboModuleRegistry';

export interface Spec extends TurboModule {
  +getConstants: () => {|BLOB_URI_SCHEME: string, BLOB_URI_HOST: ?string|};
  +addNetworkingHandler: () => void;
  +addWebSocketHandler: (id: number) => void;
  +removeWebSocketHandler: (id: number) => void;
  +sendOverSocket: (blob: Object, id: number) => void;
  +createFromParts: (parts: Array<Object>, blobId: string) => void;
  +release: (blobId: string) => void;
}

export default (TurboModuleRegistry.get<Spec>('BlobModule'): ?Spec);
