import _extends from"@babel/runtime/helpers/extends";import _objectSpread from"@babel/runtime/helpers/objectSpread";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";import _classCallCheck from"@babel/runtime/helpers/classCallCheck";import _createClass from"@babel/runtime/helpers/createClass";import _possibleConstructorReturn from"@babel/runtime/helpers/possibleConstructorReturn";import _getPrototypeOf from"@babel/runtime/helpers/getPrototypeOf";import _inherits from"@babel/runtime/helpers/inherits";var _jsxFileName="/Users/satya/Workspace/Callstack/react-native-paper/src/components/TextInput/TextInputOutlined.tsx";import*as React from'react';import{View,TextInput as NativeTextInput,StyleSheet,I18nManager,Platform}from'react-native';import color from'color';import InputLabel from'./Label/InputLabel';import LabelBackground from'./Label/LabelBackground';import{MAXIMIZED_LABEL_FONT_SIZE,MINIMIZED_LABEL_FONT_SIZE,LABEL_WIGGLE_X_OFFSET}from'./constants';import{calculateLabelTopPosition,calculateInputHeight,calculatePadding,adjustPaddingOut,interpolatePlaceholder}from'./helpers';var OUTLINE_MINIMIZED_LABEL_Y_OFFSET=-6;var LABEL_PADDING_TOP=8;var MIN_HEIGHT=64;var MIN_DENSE_HEIGHT=48;var INPUT_PADDING_HORIZONTAL=14;var TextInputOutlined=function(_React$Component){_inherits(TextInputOutlined,_React$Component);function TextInputOutlined(){_classCallCheck(this,TextInputOutlined);return _possibleConstructorReturn(this,_getPrototypeOf(TextInputOutlined).apply(this,arguments));}_createClass(TextInputOutlined,[{key:"render",value:function render(){var _this$props=this.props,disabled=_this$props.disabled,editable=_this$props.editable,label=_this$props.label,error=_this$props.error,selectionColor=_this$props.selectionColor,underlineColor=_this$props.underlineColor,dense=_this$props.dense,style=_this$props.style,theme=_this$props.theme,render=_this$props.render,multiline=_this$props.multiline,parentState=_this$props.parentState,innerRef=_this$props.innerRef,onFocus=_this$props.onFocus,onBlur=_this$props.onBlur,onChangeText=_this$props.onChangeText,onLayoutAnimatedText=_this$props.onLayoutAnimatedText,rest=_objectWithoutProperties(_this$props,["disabled","editable","label","error","selectionColor","underlineColor","dense","style","theme","render","multiline","parentState","innerRef","onFocus","onBlur","onChangeText","onLayoutAnimatedText"]);var colors=theme.colors,fonts=theme.fonts;var font=fonts.regular;var hasActiveOutline=parentState.focused||error;var _ref=StyleSheet.flatten(style)||{},fontSizeStyle=_ref.fontSize,fontWeight=_ref.fontWeight,height=_ref.height,_ref$backgroundColor=_ref.backgroundColor,backgroundColor=_ref$backgroundColor===void 0?colors.background:_ref$backgroundColor,viewStyle=_objectWithoutProperties(_ref,["fontSize","fontWeight","height","backgroundColor"]);var fontSize=fontSizeStyle||MAXIMIZED_LABEL_FONT_SIZE;var inputTextColor,activeColor,outlineColor,placeholderColor,containerStyle;if(disabled){inputTextColor=activeColor=color(colors.text).alpha(0.54).rgb().string();placeholderColor=outlineColor=colors.disabled;}else{inputTextColor=colors.text;activeColor=error?colors.error:colors.primary;placeholderColor=outlineColor=colors.placeholder;}var labelScale=MINIMIZED_LABEL_FONT_SIZE/fontSize;var fontScale=MAXIMIZED_LABEL_FONT_SIZE/fontSize;var labelWidth=parentState.labelLayout.width;var labelHeight=parentState.labelLayout.height;var labelHalfWidth=labelWidth/2;var labelHalfHeight=labelHeight/2;var baseLabelTranslateX=(I18nManager.isRTL?1:-1)*(labelHalfWidth-labelScale*labelWidth/2-(fontSize-MINIMIZED_LABEL_FONT_SIZE)*labelScale);var minInputHeight=(dense?MIN_DENSE_HEIGHT:MIN_HEIGHT)-LABEL_PADDING_TOP;var inputHeight=calculateInputHeight(labelHeight,height,minInputHeight);var topPosition=calculateLabelTopPosition(labelHeight,inputHeight,LABEL_PADDING_TOP);if(height&&typeof height!=='number')console.warn('Currently we support only numbers in height prop');var paddingSettings={height:height?+height:null,labelHalfHeight:labelHalfHeight,offset:LABEL_PADDING_TOP,multiline:multiline?multiline:null,dense:dense?dense:null,topPosition:topPosition,fontSize:fontSize,label:label,scale:fontScale,isAndroid:Platform.OS==='android',styles:StyleSheet.flatten(dense?styles.inputOutlinedDense:styles.inputOutlined)};var pad=calculatePadding(paddingSettings);var paddingOut=adjustPaddingOut(_objectSpread({},paddingSettings,{pad:pad}));var baseLabelTranslateY=-labelHalfHeight-(topPosition+OUTLINE_MINIMIZED_LABEL_Y_OFFSET);var placeholderOpacity=interpolatePlaceholder(parentState.labeled,hasActiveOutline);var labelProps={label:label,onLayoutAnimatedText:onLayoutAnimatedText,placeholderOpacity:placeholderOpacity,error:error,placeholderStyle:styles.placeholder,baseLabelTranslateY:baseLabelTranslateY,baseLabelTranslateX:baseLabelTranslateX,font:font,fontSize:fontSize,fontWeight:fontWeight,labelScale:labelScale,wiggleOffsetX:LABEL_WIGGLE_X_OFFSET,topPosition:topPosition,hasActiveOutline:hasActiveOutline,activeColor:activeColor,placeholderColor:placeholderColor,backgroundColor:backgroundColor};var minHeight=height||(dense?MIN_DENSE_HEIGHT:MIN_HEIGHT);return React.createElement(View,{style:[containerStyle,viewStyle],__source:{fileName:_jsxFileName,lineNumber:185}},React.createElement(View,{__source:{fileName:_jsxFileName,lineNumber:191}},React.createElement(Outline,{theme:theme,hasActiveOutline:hasActiveOutline,activeColor:activeColor,outlineColor:outlineColor,backgroundColor:backgroundColor,__source:{fileName:_jsxFileName,lineNumber:192}}),React.createElement(View,{style:{paddingTop:LABEL_PADDING_TOP,paddingBottom:0,minHeight:minHeight},__source:{fileName:_jsxFileName,lineNumber:199}},React.createElement(InputLabel,{parentState:parentState,labelProps:labelProps,labelBackground:LabelBackground,__source:{fileName:_jsxFileName,lineNumber:206}}),render&&render(_objectSpread({},rest,{ref:innerRef,onChangeText:onChangeText,placeholder:label?parentState.placeholder:this.props.placeholder,placeholderTextColor:placeholderColor,editable:!disabled&&editable,selectionColor:typeof selectionColor==='undefined'?activeColor:selectionColor,onFocus:onFocus,onBlur:onBlur,underlineColorAndroid:'transparent',multiline:multiline,style:[styles.input,!multiline||multiline&&height?{height:inputHeight}:{},paddingOut,_objectSpread({},font,{fontSize:fontSize,fontWeight:fontWeight,color:inputTextColor,textAlignVertical:multiline?'top':'center'})]})))));}}]);return TextInputOutlined;}(React.Component);TextInputOutlined.defaultProps={disabled:false,error:false,multiline:false,editable:true,render:function render(props){return React.createElement(NativeTextInput,_extends({},props,{__source:{fileName:_jsxFileName,lineNumber:44}}));}};export default TextInputOutlined;var Outline=function Outline(_ref2){var theme=_ref2.theme,hasActiveOutline=_ref2.hasActiveOutline,activeColor=_ref2.activeColor,outlineColor=_ref2.outlineColor,backgroundColor=_ref2.backgroundColor;return React.createElement(View,{pointerEvents:"none",style:[styles.outline,{backgroundColor:backgroundColor,borderRadius:theme.roundness,borderWidth:hasActiveOutline?2:1,borderColor:hasActiveOutline?activeColor:outlineColor}],__source:{fileName:_jsxFileName,lineNumber:269}});};var styles=StyleSheet.create({placeholder:{position:'absolute',left:0,paddingHorizontal:INPUT_PADDING_HORIZONTAL},outline:{position:'absolute',left:0,right:0,top:6,bottom:0},input:{flexGrow:1,paddingHorizontal:INPUT_PADDING_HORIZONTAL,margin:0,textAlign:I18nManager.isRTL?'right':'left',zIndex:1},inputOutlined:{paddingTop:8,paddingBottom:8},inputOutlinedDense:{paddingTop:4,paddingBottom:4}});
//# sourceMappingURL=TextInputOutlined.js.map