import _extends from"@babel/runtime/helpers/extends";import _objectSpread from"@babel/runtime/helpers/objectSpread";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";import _classCallCheck from"@babel/runtime/helpers/classCallCheck";import _createClass from"@babel/runtime/helpers/createClass";import _possibleConstructorReturn from"@babel/runtime/helpers/possibleConstructorReturn";import _getPrototypeOf from"@babel/runtime/helpers/getPrototypeOf";import _inherits from"@babel/runtime/helpers/inherits";var _jsxFileName="/Users/satya/Workspace/Callstack/react-native-paper/src/components/TextInput/TextInputFlat.tsx";import*as React from'react';import{View,Animated,TextInput as NativeTextInput,StyleSheet,I18nManager,Platform}from'react-native';import color from'color';import InputLabel from'./Label/InputLabel';import{MAXIMIZED_LABEL_FONT_SIZE,MINIMIZED_LABEL_FONT_SIZE,LABEL_WIGGLE_X_OFFSET,LABEL_PADDING_HORIZONTAL}from'./constants';import{calculateLabelTopPosition,calculateInputHeight,calculatePadding,adjustPaddingFlat,interpolatePlaceholder}from'./helpers';var MINIMIZED_LABEL_Y_OFFSET=-18;var LABEL_PADDING_TOP=30;var LABEL_PADDING_TOP_DENSE=24;var MIN_HEIGHT=64;var MIN_DENSE_HEIGHT_WL=52;var MIN_DENSE_HEIGHT=40;var INPUT_OFFSET=8;var TextInputFlat=function(_React$Component){_inherits(TextInputFlat,_React$Component);function TextInputFlat(){_classCallCheck(this,TextInputFlat);return _possibleConstructorReturn(this,_getPrototypeOf(TextInputFlat).apply(this,arguments));}_createClass(TextInputFlat,[{key:"render",value:function render(){var _this$props=this.props,disabled=_this$props.disabled,editable=_this$props.editable,label=_this$props.label,error=_this$props.error,selectionColor=_this$props.selectionColor,underlineColor=_this$props.underlineColor,dense=_this$props.dense,style=_this$props.style,theme=_this$props.theme,render=_this$props.render,multiline=_this$props.multiline,parentState=_this$props.parentState,innerRef=_this$props.innerRef,onFocus=_this$props.onFocus,onBlur=_this$props.onBlur,onChangeText=_this$props.onChangeText,onLayoutAnimatedText=_this$props.onLayoutAnimatedText,rest=_objectWithoutProperties(_this$props,["disabled","editable","label","error","selectionColor","underlineColor","dense","style","theme","render","multiline","parentState","innerRef","onFocus","onBlur","onChangeText","onLayoutAnimatedText"]);var colors=theme.colors,fonts=theme.fonts;var font=fonts.regular;var hasActiveOutline=parentState.focused||error;var _ref=StyleSheet.flatten(style)||{},fontSizeStyle=_ref.fontSize,fontWeight=_ref.fontWeight,height=_ref.height,paddingHorizontal=_ref.paddingHorizontal,viewStyle=_objectWithoutProperties(_ref,["fontSize","fontWeight","height","paddingHorizontal"]);var fontSize=fontSizeStyle||MAXIMIZED_LABEL_FONT_SIZE;var paddingOffset=paddingHorizontal!==undefined&&typeof paddingHorizontal==='number'?{paddingHorizontal:paddingHorizontal}:StyleSheet.flatten(styles.paddingOffset);var inputTextColor,activeColor,underlineColorCustom,placeholderColor;if(disabled){inputTextColor=activeColor=color(colors.text).alpha(0.54).rgb().string();placeholderColor=colors.disabled;underlineColorCustom='transparent';}else{inputTextColor=colors.text;activeColor=error?colors.error:colors.primary;placeholderColor=colors.placeholder;underlineColorCustom=underlineColor||colors.disabled;}var containerStyle={backgroundColor:theme.dark?color(colors.background).lighten(0.24).rgb().string():color(colors.background).darken(0.06).rgb().string(),borderTopLeftRadius:theme.roundness,borderTopRightRadius:theme.roundness};var labelScale=MINIMIZED_LABEL_FONT_SIZE/fontSize;var fontScale=MAXIMIZED_LABEL_FONT_SIZE/fontSize;var labelWidth=parentState.labelLayout.width;var labelHeight=parentState.labelLayout.height;var labelHalfWidth=labelWidth/2;var labelHalfHeight=labelHeight/2;var baseLabelTranslateX=(I18nManager.isRTL?1:-1)*(labelHalfWidth-labelScale*labelWidth/2)+(1-labelScale)*paddingOffset.paddingHorizontal;var minInputHeight=dense?(label?MIN_DENSE_HEIGHT_WL:MIN_DENSE_HEIGHT)-LABEL_PADDING_TOP_DENSE:MIN_HEIGHT-LABEL_PADDING_TOP;var inputHeight=calculateInputHeight(labelHeight,height,minInputHeight);var topPosition=calculateLabelTopPosition(labelHeight,inputHeight,multiline&&height?0:!height?minInputHeight/2:0);if(height&&typeof height!=='number')console.warn('Currently we support only numbers in height prop');var paddingSettings={height:height?+height:null,labelHalfHeight:labelHalfHeight,offset:INPUT_OFFSET,multiline:multiline?multiline:null,dense:dense?dense:null,topPosition:topPosition,fontSize:fontSize,label:label,scale:fontScale,isAndroid:Platform.OS==='android',styles:StyleSheet.flatten(dense?styles.inputFlatDense:styles.inputFlat)};var pad=calculatePadding(paddingSettings);var paddingFlat=adjustPaddingFlat(_objectSpread({},paddingSettings,{pad:pad}));var baseLabelTranslateY=-labelHalfHeight-(topPosition+MINIMIZED_LABEL_Y_OFFSET);var placeholderOpacity=hasActiveOutline?interpolatePlaceholder(parentState.labeled,hasActiveOutline):parentState.labelLayout.measured?1:0;var labelProps={label:label,onLayoutAnimatedText:onLayoutAnimatedText,placeholderOpacity:placeholderOpacity,error:error,placeholderStyle:styles.placeholder,baseLabelTranslateY:baseLabelTranslateY,baseLabelTranslateX:baseLabelTranslateX,font:font,fontSize:fontSize,fontWeight:fontWeight,labelScale:labelScale,wiggleOffsetX:LABEL_WIGGLE_X_OFFSET,topPosition:topPosition,paddingOffset:paddingOffset,hasActiveOutline:hasActiveOutline,activeColor:activeColor,placeholderColor:placeholderColor};var minHeight=height||(dense?label?MIN_DENSE_HEIGHT_WL:MIN_DENSE_HEIGHT:MIN_HEIGHT);var flatHeight=inputHeight+(!height?dense?LABEL_PADDING_TOP_DENSE:LABEL_PADDING_TOP:0);return React.createElement(View,{style:[containerStyle,viewStyle],__source:{fileName:_jsxFileName,lineNumber:216}},React.createElement(Underline,{parentState:parentState,underlineColorCustom:underlineColorCustom,error:error,colors:colors,activeColor:activeColor,__source:{fileName:_jsxFileName,lineNumber:217}}),React.createElement(View,{style:{paddingTop:0,paddingBottom:0,minHeight:minHeight},__source:{fileName:_jsxFileName,lineNumber:224}},React.createElement(InputLabel,{parentState:parentState,labelProps:labelProps,__source:{fileName:_jsxFileName,lineNumber:231}}),render&&render(_objectSpread({},rest,{ref:innerRef,onChangeText:onChangeText,placeholder:label?parentState.placeholder:this.props.placeholder,placeholderTextColor:placeholderColor,editable:!disabled&&editable,selectionColor:typeof selectionColor==='undefined'?activeColor:selectionColor,onFocus:onFocus,onBlur:onBlur,underlineColorAndroid:'transparent',multiline:multiline,style:[styles.input,paddingOffset,!multiline||multiline&&height?{height:flatHeight}:{},paddingFlat,_objectSpread({},font,{fontSize:fontSize,fontWeight:fontWeight,color:inputTextColor,textAlignVertical:multiline?'top':'center'})]}))));}}]);return TextInputFlat;}(React.Component);TextInputFlat.defaultProps={disabled:false,error:false,multiline:false,editable:true,render:function render(props){return React.createElement(NativeTextInput,_extends({},props,{__source:{fileName:_jsxFileName,lineNumber:47}}));}};export default TextInputFlat;var Underline=function Underline(_ref2){var parentState=_ref2.parentState,error=_ref2.error,colors=_ref2.colors,activeColor=_ref2.activeColor,underlineColorCustom=_ref2.underlineColorCustom;var backgroundColor=parentState.focused?activeColor:underlineColorCustom;if(error)backgroundColor=colors.error;return React.createElement(Animated.View,{style:[styles.underline,{backgroundColor:backgroundColor,transform:[{scaleY:parentState.focused?1:0.5}]}],__source:{fileName:_jsxFileName,lineNumber:300}});};var styles=StyleSheet.create({placeholder:{position:'absolute',left:0},underline:{position:'absolute',left:0,right:0,bottom:0,height:2},input:{flexGrow:1,margin:0,textAlign:I18nManager.isRTL?'right':'left',zIndex:1},inputFlat:{paddingTop:24,paddingBottom:4},inputFlatDense:{paddingTop:22,paddingBottom:2},paddingOffset:{paddingHorizontal:LABEL_PADDING_HORIZONTAL}});
//# sourceMappingURL=TextInputFlat.js.map