import _objectSpread from"@babel/runtime/helpers/objectSpread";import _toConsumableArray from"@babel/runtime/helpers/toConsumableArray";import _classCallCheck from"@babel/runtime/helpers/classCallCheck";import _createClass from"@babel/runtime/helpers/createClass";import _possibleConstructorReturn from"@babel/runtime/helpers/possibleConstructorReturn";import _getPrototypeOf from"@babel/runtime/helpers/getPrototypeOf";import _inherits from"@babel/runtime/helpers/inherits";import _extends from"@babel/runtime/helpers/extends";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";var _jsxFileName="/Users/satya/Workspace/Callstack/react-native-paper/src/components/BottomNavigation.tsx";import*as React from'react';import{View,Animated,TouchableWithoutFeedback,StyleSheet,Platform,Keyboard}from'react-native';import SafeAreaView from'react-native-safe-area-view';import color from'color';import overlay from'../styles/overlay';import Icon from'./Icon';import Surface from'./Surface';import Badge from'./Badge';import TouchableRipple from'./TouchableRipple';import Text from'./Typography/Text';import{black,white}from'../styles/colors';import{withTheme}from'../core/theming';var MIN_RIPPLE_SCALE=0.001;var MIN_TAB_WIDTH=96;var MAX_TAB_WIDTH=168;var BAR_HEIGHT=56;var FAR_FAR_AWAY=9999;var Touchable=TouchableRipple.supported?TouchableRipple:function(_ref){var style=_ref.style,children=_ref.children,borderless=_ref.borderless,centered=_ref.centered,rippleColor=_ref.rippleColor,rest=_objectWithoutProperties(_ref,["style","children","borderless","centered","rippleColor"]);return React.createElement(TouchableWithoutFeedback,_extends({},rest,{__source:{fileName:_jsxFileName,lineNumber:266}}),React.createElement(View,{style:style,__source:{fileName:_jsxFileName,lineNumber:267}},children));};var SceneComponent=function(_React$PureComponent){_inherits(SceneComponent,_React$PureComponent);function SceneComponent(){_classCallCheck(this,SceneComponent);return _possibleConstructorReturn(this,_getPrototypeOf(SceneComponent).apply(this,arguments));}_createClass(SceneComponent,[{key:"render",value:function render(){var _this$props=this.props,component=_this$props.component,rest=_objectWithoutProperties(_this$props,["component"]);return React.createElement(component,rest);}}]);return SceneComponent;}(React.PureComponent);var BottomNavigation=function(_React$Component){_inherits(BottomNavigation,_React$Component);_createClass(BottomNavigation,null,[{key:"SceneMap",value:function SceneMap(scenes){return function(_ref2){var route=_ref2.route,jumpTo=_ref2.jumpTo;return React.createElement(SceneComponent,{key:route.key,component:scenes[route.key?route.key:''],route:route,jumpTo:jumpTo,__source:{fileName:_jsxFileName,lineNumber:351}});};}},{key:"getDerivedStateFromProps",value:function getDerivedStateFromProps(nextProps,prevState){var _nextProps$navigation=nextProps.navigationState,index=_nextProps$navigation.index,routes=_nextProps$navigation.routes;var tabs=routes.map(function(_,i){return prevState.tabs[i]||new Animated.Value(i===index?1:0);});var offsets=routes.map(function(_,i){return prevState.offsets[i]||new Animated.Value(i===index?0:1);});var nextState={tabs:tabs,offsets:offsets};if(index!==prevState.current){_extends(nextState,{current:index,previous:prevState.current,loaded:prevState.loaded.includes(index)?prevState.loaded:[].concat(_toConsumableArray(prevState.loaded),[index])});}return nextState;}}]);function BottomNavigation(props){var _this;_classCallCheck(this,BottomNavigation);_this=_possibleConstructorReturn(this,_getPrototypeOf(BottomNavigation).call(this,props));_this.handleKeyboardShow=function(){return _this.setState({keyboard:true},function(){return Animated.timing(_this.state.visible,{toValue:0,duration:150,useNativeDriver:true}).start();});};_this.handleKeyboardHide=function(){return Animated.timing(_this.state.visible,{toValue:1,duration:100,useNativeDriver:true}).start(function(){_this.setState({keyboard:false});});};_this.animateToCurrentIndex=function(){var shifting=_this.isShifting();var _this$props2=_this.props,sceneAnimationEnabled=_this$props2.sceneAnimationEnabled,navigationState=_this$props2.navigationState;var routes=navigationState.routes,index=navigationState.index;_this.state.ripple.setValue(MIN_RIPPLE_SCALE);Animated.parallel([Animated.timing(_this.state.ripple,{toValue:1,duration:shifting?400:0,useNativeDriver:true})].concat(_toConsumableArray(routes.map(function(_,i){return Animated.timing(_this.state.tabs[i],{toValue:i===index?1:0,duration:shifting&&sceneAnimationEnabled!==false?150:0,useNativeDriver:true});})))).start(function(_ref3){var finished=_ref3.finished;_this.state.tabs.map(function(tab,i){return tab.setValue(i===index?1:0);});_this.state.index.setValue(index);_this.state.ripple.setValue(MIN_RIPPLE_SCALE);if(finished){_this.state.offsets.forEach(function(offset,i){if(i===index){offset.setValue(0);}else{offset.setValue(1);}});}});};_this.handleLayout=function(e){var layout=_this.state.layout;var _e$nativeEvent$layout=e.nativeEvent.layout,height=_e$nativeEvent$layout.height,width=_e$nativeEvent$layout.width;if(height===layout.height&&width===layout.width){return;}_this.setState({layout:{height:height,width:width,measured:true}});};_this.handleTabPress=function(index){var _this$props3=_this.props,navigationState=_this$props3.navigationState,onTabPress=_this$props3.onTabPress,onIndexChange=_this$props3.onIndexChange;if(onTabPress){onTabPress({route:navigationState.routes[index]});}if(index!==navigationState.index){onIndexChange(index);}};_this.jumpTo=function(key){var index=_this.props.navigationState.routes.findIndex(function(route){return route.key===key;});_this.props.onIndexChange(index);};_this.isShifting=function(){return typeof _this.props.shifting==='boolean'?_this.props.shifting:_this.props.navigationState.routes.length>3;};var _index=_this.props.navigationState.index;_this.state={visible:new Animated.Value(1),tabs:[],offsets:[],index:new Animated.Value(_index),ripple:new Animated.Value(MIN_RIPPLE_SCALE),touch:new Animated.Value(MIN_RIPPLE_SCALE),layout:{height:0,width:0,measured:false},current:_index,previous:0,loaded:[_index],keyboard:false};return _this;}_createClass(BottomNavigation,[{key:"componentDidMount",value:function componentDidMount(){this.animateToCurrentIndex();if(Platform.OS==='ios'){Keyboard.addListener('keyboardWillShow',this.handleKeyboardShow);Keyboard.addListener('keyboardWillHide',this.handleKeyboardHide);}else{Keyboard.addListener('keyboardDidShow',this.handleKeyboardShow);Keyboard.addListener('keyboardDidHide',this.handleKeyboardHide);}}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var _this2=this;if(prevProps.navigationState.index===this.props.navigationState.index){return;}this.state.offsets.forEach(function(offset,i){if(i===_this2.props.navigationState.index||i===prevProps.navigationState.index){offset.setValue(0);}});this.animateToCurrentIndex();}},{key:"componentWillUnmount",value:function componentWillUnmount(){if(Platform.OS==='ios'){Keyboard.removeListener('keyboardWillShow',this.handleKeyboardShow);Keyboard.removeListener('keyboardWillHide',this.handleKeyboardHide);}else{Keyboard.removeListener('keyboardDidShow',this.handleKeyboardShow);Keyboard.removeListener('keyboardDidHide',this.handleKeyboardHide);}}},{key:"render",value:function render(){var _this3=this;var _this$props4=this.props,navigationState=_this$props4.navigationState,renderScene=_this$props4.renderScene,renderIcon=_this$props4.renderIcon,renderLabel=_this$props4.renderLabel,_this$props4$getLabel=_this$props4.getLabelText,getLabelText=_this$props4$getLabel===void 0?function(_ref4){var route=_ref4.route;return route.title;}:_this$props4$getLabel,_this$props4$getBadge=_this$props4.getBadge,getBadge=_this$props4$getBadge===void 0?function(_ref5){var route=_ref5.route;return route.badge;}:_this$props4$getBadge,_this$props4$getColor=_this$props4.getColor,getColor=_this$props4$getColor===void 0?function(_ref6){var route=_ref6.route;return route.color;}:_this$props4$getColor,_this$props4$getAcces=_this$props4.getAccessibilityLabel,getAccessibilityLabel=_this$props4$getAcces===void 0?function(_ref7){var route=_ref7.route;return route.accessibilityLabel;}:_this$props4$getAcces,_this$props4$getTestI=_this$props4.getTestID,getTestID=_this$props4$getTestI===void 0?function(_ref8){var route=_ref8.route;return route.testID;}:_this$props4$getTestI,activeColor=_this$props4.activeColor,inactiveColor=_this$props4.inactiveColor,keyboardHidesNavigationBar=_this$props4.keyboardHidesNavigationBar,barStyle=_this$props4.barStyle,labeled=_this$props4.labeled,style=_this$props4.style,theme=_this$props4.theme;var _this$state=this.state,layout=_this$state.layout,loaded=_this$state.loaded,index=_this$state.index,visible=_this$state.visible,ripple=_this$state.ripple,keyboard=_this$state.keyboard,tabs=_this$state.tabs,offsets=_this$state.offsets;var routes=navigationState.routes;var colors=theme.colors,isDarkTheme=theme.dark,mode=theme.mode;var shifting=this.isShifting();var _ref9=StyleSheet.flatten(barStyle)||{},customBackground=_ref9.backgroundColor,_ref9$elevation=_ref9.elevation,elevation=_ref9$elevation===void 0?4:_ref9$elevation;var approxBackgroundColor=customBackground?customBackground:isDarkTheme&&mode==='adaptive'?overlay(elevation,colors.surface):colors.primary;var backgroundColor=shifting?index.interpolate({inputRange:routes.map(function(_,i){return i;}),outputRange:routes.map(function(route){return getColor({route:route})||approxBackgroundColor;})}):approxBackgroundColor;var isDark=!color(approxBackgroundColor).isLight();var textColor=isDark?white:black;var activeTintColor=typeof activeColor!=='undefined'?activeColor:textColor;var inactiveTintColor=typeof inactiveColor!=='undefined'?inactiveColor:color(textColor).alpha(0.5).rgb().string();var touchColor=color(activeColor||activeTintColor).alpha(0.12).rgb().string();var maxTabWidth=routes.length>3?MIN_TAB_WIDTH:MAX_TAB_WIDTH;var maxTabBarWidth=maxTabWidth*routes.length;var tabBarWidth=Math.min(layout.width,maxTabBarWidth);var tabWidth=tabBarWidth/routes.length;var rippleSize=layout.width/4;return React.createElement(View,{style:[styles.container,style],__source:{fileName:_jsxFileName,lineNumber:651}},React.createElement(View,{style:[styles.content,{backgroundColor:colors.background}],__source:{fileName:_jsxFileName,lineNumber:652}},routes.map(function(route,index){if(!loaded.includes(index)){return null;}var opacity=tabs[index];var top=offsets[index].interpolate({inputRange:[0,1],outputRange:[0,FAR_FAR_AWAY]});var focused=navigationState.index===index;return React.createElement(Animated.View,{key:route.key,pointerEvents:focused?'auto':'none',accessibilityElementsHidden:!focused,importantForAccessibility:focused?'auto':'no-hide-descendants',style:[StyleSheet.absoluteFill,{opacity:opacity}],collapsable:false,removeClippedSubviews:Platform.OS==='ios'?navigationState.index!==index:true,__source:{fileName:_jsxFileName,lineNumber:668}},React.createElement(Animated.View,{style:[styles.content,{top:top}],__source:{fileName:_jsxFileName,lineNumber:683}},renderScene({route:route,jumpTo:_this3.jumpTo})));})),React.createElement(Surface,{style:[styles.bar,keyboardHidesNavigationBar?{transform:[{translateY:visible.interpolate({inputRange:[0,1],outputRange:[layout.height,0]})}],position:keyboard?'absolute':null}:null,barStyle],pointerEvents:layout.measured?keyboardHidesNavigationBar&&keyboard?'none':'auto':'none',onLayout:this.handleLayout,__source:{fileName:_jsxFileName,lineNumber:693}},React.createElement(Animated.View,{style:[styles.barContent,{backgroundColor:backgroundColor}],__source:{fileName:_jsxFileName,lineNumber:725}},React.createElement(SafeAreaView,{forceInset:{top:'never',bottom:'always'},style:[styles.items,{maxWidth:maxTabBarWidth}],__source:{fileName:_jsxFileName,lineNumber:726}},shifting?React.createElement(Animated.View,{pointerEvents:"none",style:[styles.ripple,{top:(BAR_HEIGHT-rippleSize)/2,left:tabWidth*(navigationState.index+0.5)-rippleSize/2,height:rippleSize,width:rippleSize,borderRadius:rippleSize/2,backgroundColor:getColor({route:routes[navigationState.index]}),transform:[{scale:ripple.interpolate({inputRange:[0,1],outputRange:[0,8]})}],opacity:ripple.interpolate({inputRange:[0,MIN_RIPPLE_SCALE,0.3,1],outputRange:[0,0,1,1]})}],__source:{fileName:_jsxFileName,lineNumber:731}}):null,routes.map(function(route,index){var focused=navigationState.index===index;var active=tabs[index];var scale=labeled&&shifting?active.interpolate({inputRange:[0,1],outputRange:[0.5,1]}):1;var translateY=labeled?shifting?active.interpolate({inputRange:[0,1],outputRange:[7,0]}):0:7;var activeOpacity=active;var inactiveOpacity=active.interpolate({inputRange:[0,1],outputRange:[1,0]});var badge=getBadge({route:route});return React.createElement(Touchable,{key:route.key,borderless:true,centered:true,rippleColor:touchColor,onPress:function onPress(){return _this3.handleTabPress(index);},testID:getTestID({route:route}),accessibilityLabel:getAccessibilityLabel({route:route}),accessibilityTraits:focused?['button','selected']:'button',accessibilityComponentType:"button",accessibilityRole:"button",accessibilityStates:['selected'],style:styles.item,__source:{fileName:_jsxFileName,lineNumber:800}},React.createElement(View,{pointerEvents:"none",__source:{fileName:_jsxFileName,lineNumber:816}},React.createElement(Animated.View,{style:[styles.iconContainer,{transform:[{translateY:translateY}]}],__source:{fileName:_jsxFileName,lineNumber:817}},React.createElement(Animated.View,{style:[styles.iconWrapper,{opacity:activeOpacity}],__source:{fileName:_jsxFileName,lineNumber:823}},renderIcon?renderIcon({route:route,focused:true,color:activeTintColor}):React.createElement(Icon,{source:route.icon,color:activeTintColor,size:24,__source:{fileName:_jsxFileName,lineNumber:836}})),React.createElement(Animated.View,{style:[styles.iconWrapper,{opacity:inactiveOpacity}],__source:{fileName:_jsxFileName,lineNumber:843}},renderIcon?renderIcon({route:route,focused:false,color:inactiveTintColor}):React.createElement(Icon,{source:route.icon,color:inactiveTintColor,size:24,__source:{fileName:_jsxFileName,lineNumber:856}})),React.createElement(View,{style:[styles.badgeContainer,{right:(badge!=null&&typeof badge!=='boolean'?String(badge).length*-2:0)-2}],__source:{fileName:_jsxFileName,lineNumber:863}},typeof badge==='boolean'?React.createElement(Badge,{visible:badge,size:8,__source:{fileName:_jsxFileName,lineNumber:875}}):React.createElement(Badge,{visible:badge!=null,size:16,__source:{fileName:_jsxFileName,lineNumber:877}},badge))),labeled?React.createElement(Animated.View,{style:[styles.labelContainer,{transform:[{scale:scale}]}],__source:{fileName:_jsxFileName,lineNumber:884}},React.createElement(Animated.View,{style:[styles.labelWrapper,{opacity:activeOpacity}],__source:{fileName:_jsxFileName,lineNumber:890}},renderLabel?renderLabel({route:route,focused:true,color:activeTintColor}):React.createElement(Text,{style:[styles.label,{color:activeTintColor}],__source:{fileName:_jsxFileName,lineNumber:903}},getLabelText({route:route}))),shifting?null:React.createElement(Animated.View,{style:[styles.labelWrapper,{opacity:inactiveOpacity}],__source:{fileName:_jsxFileName,lineNumber:914}},renderLabel?renderLabel({route:route,focused:false,color:inactiveTintColor}):React.createElement(Text,{style:[styles.label,{color:inactiveTintColor}],__source:{fileName:_jsxFileName,lineNumber:927}},getLabelText({route:route})))):React.createElement(View,{style:styles.labelContainer,__source:{fileName:_jsxFileName,lineNumber:940}})));})))));}}]);return BottomNavigation;}(React.Component);BottomNavigation.defaultProps={labeled:true,keyboardHidesNavigationBar:true};export default withTheme(BottomNavigation);var styles=StyleSheet.create({container:{flex:1,overflow:'hidden'},content:{flex:1},bar:{left:0,right:0,bottom:0,elevation:4},barContent:{alignItems:'center',overflow:'hidden'},items:{flexDirection:'row',width:'100%'},item:{flex:1,paddingVertical:6},ripple:{position:'absolute'},iconContainer:{height:24,width:24,marginTop:2,marginHorizontal:12,alignSelf:'center'},iconWrapper:_objectSpread({},StyleSheet.absoluteFillObject,{alignItems:'center'}),labelContainer:{height:16,paddingBottom:2},labelWrapper:_objectSpread({},StyleSheet.absoluteFillObject),label:_objectSpread({fontSize:12,textAlign:'center',backgroundColor:'transparent'},Platform.OS==='web'?{whiteSpace:'nowrap'}:null),badgeContainer:{position:'absolute',left:0,top:-2}});
//# sourceMappingURL=BottomNavigation.js.map