"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const merge2 = require("merge2");
function merge(streams) {
    const mergedStream = merge2(streams);
    streams.forEach((stream) => {
        stream.once('error', (error) => mergedStream.emit('error', error));
    });
    return mergedStream;
}
exports.merge = merge;
