var _pathUtils=require("../pathUtils");it('urlToPathAndParams empty',function(){var _urlToPathAndParams=(0,_pathUtils.urlToPathAndParams)('foo://'),path=_urlToPathAndParams.path,params=_urlToPathAndParams.params;expect(path).toBe('');expect(params).toEqual({});});it('urlToPathAndParams empty params',function(){var _urlToPathAndParams2=(0,_pathUtils.urlToPathAndParams)('foo://foo/bar/b'),path=_urlToPathAndParams2.path,params=_urlToPathAndParams2.params;expect(path).toBe('foo/bar/b');expect(params).toEqual({});});it('urlToPathAndParams trailing slash',function(){var _urlToPathAndParams3=(0,_pathUtils.urlToPathAndParams)('foo://foo/bar/'),path=_urlToPathAndParams3.path,params=_urlToPathAndParams3.params;expect(path).toBe('foo/bar');expect(params).toEqual({});});it('urlToPathAndParams with params',function(){var _urlToPathAndParams4=(0,_pathUtils.urlToPathAndParams)('foo://foo/bar?asdf=1&dude=foo'),path=_urlToPathAndParams4.path,params=_urlToPathAndParams4.params;expect(path).toBe('foo/bar');expect(params).toEqual({asdf:'1',dude:'foo'});});it('urlToPathAndParams with custom delimeter string',function(){var _urlToPathAndParams5=(0,_pathUtils.urlToPathAndParams)('https://example.com/foo/bar?asdf=1','https://example.com/'),path=_urlToPathAndParams5.path,params=_urlToPathAndParams5.params;expect(path).toBe('foo/bar');expect(params).toEqual({asdf:'1'});});it('urlToPathAndParams with custom delimeter RegExp',function(){var _urlToPathAndParams6=(0,_pathUtils.urlToPathAndParams)('https://example.com/foo/bar?asdf=1',new RegExp('https://example.com/')),path=_urlToPathAndParams6.path,params=_urlToPathAndParams6.params;expect(path).toBe('foo/bar');expect(params).toEqual({asdf:'1'});});it('urlToPathAndParams with duplicate prefix in query parameters',function(){var _urlToPathAndParams7=(0,_pathUtils.urlToPathAndParams)('example://whatever?related=example://something','example://'),path=_urlToPathAndParams7.path,params=_urlToPathAndParams7.params;expect(path).toBe('whatever');expect(params).toEqual({related:'example://something'});});it('urlToPathAndParams with array of custom delimiters, should use first match',function(){var _urlToPathAndParams8=(0,_pathUtils.urlToPathAndParams)('https://example.com/foo/bar?asdf=1',['baz','https://example.com/','https://example.com/foo']),path=_urlToPathAndParams8.path,params=_urlToPathAndParams8.params;expect(path).toBe('foo/bar');expect(params).toEqual({asdf:'1'});});it('urlToPathAndParams with array of custom delimiters where none match, should resort to default delimiter',function(){var _urlToPathAndParams9=(0,_pathUtils.urlToPathAndParams)('foo://foo/bar?asdf=1',['baz','bazzlefraz']),path=_urlToPathAndParams9.path,params=_urlToPathAndParams9.params;expect(path).toBe('foo/bar');expect(params).toEqual({asdf:'1'});});
//# sourceMappingURL=pathUtils-test.js.map