"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _AsyncStorage = _interopRequireDefault(require("./AsyncStorage"));

var _defaults = require("./defaults");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright (c) React Native Community.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
class AsyncStorageFactory {
  constructor() {
    throw new Error("[AsyncStorage] AsyncStorageFactory must not be instantiated.\nInstead, use static functions, like 'create' to get AsyncStorage instance.");
  }

  static create(storage, opts = _defaults.factoryOptions) {
    return new _AsyncStorage.default(storage, opts);
  }

}

var _default = AsyncStorageFactory;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC50cyJdLCJuYW1lcyI6WyJBc3luY1N0b3JhZ2VGYWN0b3J5IiwiY29uc3RydWN0b3IiLCJFcnJvciIsImNyZWF0ZSIsInN0b3JhZ2UiLCJvcHRzIiwiZmFjdG9yeU9wdGlvbnMiLCJBc3luY1N0b3JhZ2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFRQTs7QUFDQTs7OztBQVRBOzs7Ozs7O0FBWUEsTUFBTUEsbUJBQU4sQ0FBMEI7QUFDeEJDLEVBQUFBLFdBQVcsR0FBRztBQUNaLFVBQU0sSUFBSUMsS0FBSixDQUNKLDBJQURJLENBQU47QUFHRDs7QUFFRCxTQUFPQyxNQUFQLENBQ0VDLE9BREYsRUFFRUMsSUFBb0IsR0FBR0Msd0JBRnpCLEVBR0U7QUFDQSxXQUFPLElBQUlDLHFCQUFKLENBQXdDSCxPQUF4QyxFQUFpREMsSUFBakQsQ0FBUDtBQUNEOztBQVp1Qjs7ZUFlWEwsbUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCAoYykgUmVhY3QgTmF0aXZlIENvbW11bml0eS5cbiAqXG4gKiBUaGlzIHNvdXJjZSBjb2RlIGlzIGxpY2Vuc2VkIHVuZGVyIHRoZSBNSVQgbGljZW5zZSBmb3VuZCBpbiB0aGVcbiAqIExJQ0VOU0UgZmlsZSBpbiB0aGUgcm9vdCBkaXJlY3Rvcnkgb2YgdGhpcyBzb3VyY2UgdHJlZS5cbiAqXG4gKi9cblxuaW1wb3J0IEFzeW5jU3RvcmFnZSBmcm9tICcuL0FzeW5jU3RvcmFnZSc7XG5pbXBvcnQge2ZhY3RvcnlPcHRpb25zfSBmcm9tICcuL2RlZmF1bHRzJztcbmltcG9ydCB7SVN0b3JhZ2VCYWNrZW5kLCBGYWN0b3J5T3B0aW9ucywgRW1wdHlTdG9yYWdlTW9kZWx9IGZyb20gJy4uL3R5cGVzJztcblxuY2xhc3MgQXN5bmNTdG9yYWdlRmFjdG9yeSB7XG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgIFwiW0FzeW5jU3RvcmFnZV0gQXN5bmNTdG9yYWdlRmFjdG9yeSBtdXN0IG5vdCBiZSBpbnN0YW50aWF0ZWQuXFxuSW5zdGVhZCwgdXNlIHN0YXRpYyBmdW5jdGlvbnMsIGxpa2UgJ2NyZWF0ZScgdG8gZ2V0IEFzeW5jU3RvcmFnZSBpbnN0YW5jZS5cIixcbiAgICApO1xuICB9XG5cbiAgc3RhdGljIGNyZWF0ZTxNID0gRW1wdHlTdG9yYWdlTW9kZWw+KFxuICAgIHN0b3JhZ2U6IElTdG9yYWdlQmFja2VuZCxcbiAgICBvcHRzOiBGYWN0b3J5T3B0aW9ucyA9IGZhY3RvcnlPcHRpb25zLFxuICApIHtcbiAgICByZXR1cm4gbmV3IEFzeW5jU3RvcmFnZTxNLCBJU3RvcmFnZUJhY2tlbmQ8TT4+KHN0b3JhZ2UsIG9wdHMpO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IEFzeW5jU3RvcmFnZUZhY3Rvcnk7XG4iXX0=