"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleErrorHandler = simpleErrorHandler;
exports.simpleLogger = simpleLogger;
exports.noop = noop;
exports.factoryOptions = void 0;

/**
 * Copyright (c) React Native Community.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const factoryOptions = {
  logger: __DEV__,
  errorHandler: __DEV__
};
exports.factoryOptions = factoryOptions;

function simpleErrorHandler(e) {
  let errorMessage = e instanceof Error ? e.message : e;
  console.error(errorMessage);
}

function simpleLogger(logInfo) {
  const log = message => {
    console.log(`[AsyncStorage] ${message}`);
  };

  const {
    action,
    key,
    value
  } = logInfo;

  switch (action) {
    case 'read-single':
      {
        log(`Reading a value for a key: ${key}`);
        break;
      }

    case 'save-single':
      {
        log(`Saving a value: ${value} for a key: ${key}`);
        break;
      }

    case 'delete-single':
      {
        log(`Removing value at a key: ${key}`);
        break;
      }

    case 'read-many':
      {
        log(`Reading values for keys: ${key}`);
        break;
      }

    case 'save-many':
      {
        log(`Saving values ${value} for keys: ${key}`);
        break;
      }

    case 'delete-many':
      {
        log(`Removing multiple values for keys: ${key}`);
        break;
      }

    case 'drop':
      {
        log('Dropping whole database');
        break;
      }

    case 'keys':
      {
        log('Retrieving keys');
        break;
      }

    default:
      {
        log(`Unknown action: ${action}`);
      }
  }
}

function noop() {// noop
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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