# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the LICENSE
# file in the root directory of this source tree.

# flake8: noqa

from __future__ import absolute_import, division, print_function, unicode_literals

import collections
import re


# The blacklist is ordered by decreasing severity.
BLACK_LIST = [
    # Fails due to a bug in Hermes Function.apply(): T28044390.
    "CVEs/CVE-2016-7194.js",
    # These require constructing prohibitively large arrays.
    "CVEs/CVE-2017-2521.js",
    "CVEs/CVE-2017-2464.js",
    "CVEs/CVE-2017-2536.js",
    "CVEs/CVE-2018-0758.js",
    "CVEs/CVE-2013-6632.js",
    # Constructs an enormous regexp leading to stack overflow: T28044592.
    "CVEs/CVE-2017-11890.js",
    # Unicode identifiers.
    "test262/test/language/identifiers/vals-rus-alpha-lower-via-escape-hex4.js",
    "test262/test/language/identifiers/vals-rus-alpha-upper-via-escape-hex4.js",
    "test262/test/language/white-space/mongolian-vowel-separator.js",
    "test262/test/language/literals/regexp/mongolian-vowel-separator.js",
    "test262/test/language/literals/string/mongolian-vowel-separator.js",
    # R-value assignment detected at compile time.
    "mjsunit/serialize-embedded-error.js",
    "mjsunit/regress/regress-crbug-412208.js",
    "mjsunit/regress/regress-436893.js",
    # Tests relying on es6 features.
    "mjsunit/harmony/for-in.js",
    "mjsunit/regress/regress-319120.js",
    "mjsunit/regress/regress-deopt-in-array-literal-spread.js",
    "mjsunit/regress/regress-crbug-621816.js",
    "mjsunit/computed-property-names-deopt.js",
    "test262/test/language/expressions/object/computed-property-evaluation-order.js",
    "test262/test/language/module-code/eval-export-dflt-expr-err-eval.js",
    "test262/test/language/module-code/eval-export-dflt-expr-err-get-value.js",
    # Defines __proto__ multiple times in literal and expects it to throw.
    "object-literal-multiple-proto-fields.js",  # mjsunit
    # Function instance .arguments, .caller, etc. (e.g. foo.arguments).
    "mjsunit/arguments-indirect.js",
    "mjsunit/compiler/escape-analysis-arguments.js",
    "mjsunit/compiler/optimized-closures.js",
    "mjsunit/compiler/regress-funarguments.js",
    "mjsunit/extra-arguments.js",
    "mjsunit/function-arguments-null.js",
    "mjsunit/regress/regress-105.js",
    "mjsunit/regress/regress-347262.js",
    "mjsunit/regress/regress-3985.js",
    "mjsunit/regress/regress-crbug-601617.js",
    "test262/test/language/statements/function/13.2-30-s.js",
    # Expects that Object.prototype.__defineGetter__() doesn't throw on error.
    "mjsunit/regress/regress-1240.js",
    # test262 tests relying on regexp changes in es6
    "test262/test/built-ins/RegExp/15.10.4.1-1.js",
    "test262/test/built-ins/RegExp/S15.10.3.1_A2_T1.js",
    "test262/test/built-ins/RegExp/S15.10.3.1_A2_T2.js",
    "test262/test/built-ins/RegExp/S15.10.4.1_A2_T1.js",
    "test262/test/built-ins/RegExp/S15.10.4.1_A2_T2.js",
    "test262/test/built-ins/RegExp/prototype/15.10.6.js",
    "test262/test/built-ins/RegExp/prototype/exec/S15.10.6.2_A5_T3.js",
    "test262/test/built-ins/RegExp/prototype/global/15.10.7.2-2.js",
    "test262/test/built-ins/RegExp/prototype/global/S15.10.7.2_A9.js",
    "test262/test/built-ins/RegExp/prototype/flags/this-val-regexp-prototype.js",
    "test262/test/built-ins/RegExp/prototype/ignoreCase/15.10.7.3-2.js",
    "test262/test/built-ins/RegExp/prototype/ignoreCase/S15.10.7.3_A9.js",
    "test262/test/built-ins/RegExp/prototype/multiline/15.10.7.4-2.js",
    "test262/test/built-ins/RegExp/prototype/multiline/S15.10.7.4_A9.js",
    "test262/test/built-ins/RegExp/prototype/source/15.10.7.1-2.js",
    "test262/test/built-ins/RegExp/prototype/source/S15.10.7.1_A9.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-success-g-set-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/coerce-global.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/coerce-global.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/last-index-exceeds-str-size.js",
    "test262/test/built-ins/RegExp/prototype/test/S15.10.6.3_A1_T22.js",
    # Uses ES6 classes or arrow functions.
    "mjsunit/harmony/regexp-change-exec.js",
    "mjsunit/regexp-lastIndex.js",
    # Uses ES6 Unicode regular expressions.
    # This is an interesting test that we should enable when Unicode support lands.
    "mjsunit/regexp.js",
    # Attempt to parse Date format not required by the standard.
    "mjsunit/regress/regress-396.js",
    # Uses the V8 debugger.
    "mjsunit/compiler/debug-catch-prediction.js",
    "mjsunit/debug-",
    "mjsunit/deserialize-script-id.js",
    "mjsunit/es6/debug-",
    "mjsunit/es6/mirror-iterators.js",
    "mjsunit/function-source.js",
    # Update of arguments in non-strict mode.
    "mjsunit/regress/regress-arguments-slice.js",
    "mjsunit/regress/regress-392.js",
    "mjsunit/arguments-escape.js",
    "mjsunit/argument-named-arguments.js",
    "mjsunit/regress/regress-2989.js",
    "mjsunit/regress/regress-crbug-157520.js",
    "test262/test/language/arguments-object/10.6-6-4.js",
    "test262/test/language/arguments-object/10.6-10-c-ii-1.js",
    "test262/test/language/arguments-object/S10.1.6_A1_T3.js",
    "test262/test/language/arguments-object/10.6-6-3.js",
    "test262/test/language/arguments-object/10.6-10-c-ii-2.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-4.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-strict-delete-2.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-nonwritable-3.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-nonwritable-4.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-nonwritable-5.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-2.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-delete-3.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-delete-4.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-delete-2.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-strict-delete-3.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-strict-delete-4.js",
    "test262/test/language/arguments-object/mapped/mapped-arguments-nonconfigurable-3.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-293-2.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-294-1.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-293-3.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-292-1.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-295-1.js",
    "test262/test/built-ins/Object/defineProperty/15.2.3.6-4-296-1.js",
    "test262/test/language/expressions/delete/11.4.1-4.a-16.js",
    "test262/test/language/statements/function/S13_A11_T1.js",
    "test262/test/language/statements/function/S13_A15_T4.js",
    "test262/test/language/statements/function/S13_A15_T5.js",
    "test262/test/language/arguments-object/non-strict-arguments-object-is-immutable.js",
    "test262/test/built-ins/ThrowTypeError/extensible.js",
    # arguments.caller, arguments.callee must throw
    # These tests pass in HBC but fail with JSC
    "test262/test/language/arguments-object/10.6-13-b-1-s.js",
    "test262/test/language/arguments-object/arguments-caller.js",
    # Update arguments inside an indirect eval.
    "test262/test/language/statements/variable/12.2.1-21-s.js",
    "test262/test/language/statements/variable/12.2.1-17-s.js",
    # These tests should all fail to compile. jsc-cli behaves correctly,
    # but the hermes compiler does not fail to compile.  So, we don't
    # try running them.
    "test262/test/language/statements/try/12.14.1-1gs.js",
    "test262/test/language/statements/function/13.1-8gs.js",
    "test262/test/language/statements/function/13.1-5gs.js",
    "test262/test/language/statements/return/S12.9_A1_T1.js",
    "test262/test/language/statements/return/S12.9_A1_T4.js",
    "test262/test/language/statements/return/S12.9_A1_T9.js",
    "test262/test/language/statements/return/S12.9_A1_T10.js",
    "test262/test/language/statements/return/S12.9_A1_T8.js",
    "test262/test/language/statements/return/S12.9_A1_T2.js",
    "test262/test/language/statements/return/S12.9_A1_T7.js",
    "test262/test/language/statements/return/S12.9_A1_T5.js",
    "test262/test/language/statements/return/S12.9_A1_T3.js",
    "test262/test/language/statements/return/S12.9_A1_T6.js",
    "test262/test/language/expressions/delete/11.4.1-5-a-5gs.js",
    "test262/test/language/identifiers/val-this-via-escape-hex4.js",
    "test262/test/language/literals/string/S7.8.4_A4.3_T2.js",
    "test262/test/language/literals/string/S7.8.4_A4.3_T1.js",
    "test262/test/language/literals/string/7.8.4-1gs.js",
    "test262/test/language/literals/regexp/early-err-dup-flag.js",
    "test262/test/language/literals/regexp/early-err-bad-flag.js",
    "test262/test/language/literals/regexp/early-err-pattern.js",
    "test262/test/annexB/language/statements/for-in/strict-initializer.js",
    "test262/test/language/statements/try/early-catch-var.js",
    # Unsupported test262 features
    "test262/test/language/statements/do-while/let-array-with-newline.js",
    "test262/test/language/statements/for-await-of/let-array-with-newline.js",
    "test262/test/language/statements/for-in/let-array-with-newline.js",
    "test262/test/language/statements/for-of/let-array-with-newline.js",
    "test262/test/language/statements/for/let-array-with-newline.js",
    "test262/test/language/statements/if/let-array-with-newline.js",
    "test262/test/language/statements/labeled/let-array-with-newline.js",
    "test262/test/language/statements/while/let-array-with-newline.js",
    "test262/test/language/statements/with/let-array-with-newline.js",
    "test262/test/language/statements/for-await-of/let-block-with-newline.js",
    "test262/test/language/statements/for-in/let-block-with-newline.js",
    "test262/test/language/statements/for-of/let-block-with-newline.js",
    "test262/test/language/statements/for/let-block-with-newline.js",
    "test262/test/language/statements/if/let-block-with-newline.js",
    "test262/test/language/statements/labeled/let-block-with-newline.js",
    "test262/test/language/statements/while/let-block-with-newline.js",
    "test262/test/language/statements/with/let-block-with-newline.js",
    "test262/test/language/statements/for-await-of/let-identifier-with-newline.js",
    "test262/test/language/statements/for-in/let-identifier-with-newline.js",
    "test262/test/language/statements/for-of/let-identifier-with-newline.js",
    "test262/test/language/statements/for/let-identifier-with-newline.js",
    "test262/test/language/statements/if/let-identifier-with-newline.js",
    "test262/test/language/statements/labeled/let-identifier-with-newline.js",
    "test262/test/language/statements/while/let-identifier-with-newline.js",
    "test262/test/language/statements/with/let-identifier-with-newline.js",
    "test262/test/built-ins/AsyncFunction/",
    "test262/test/built-ins/Function/prototype/toString/",
    "test262/test/built-ins/Object/getOwnPropertyDescriptors/",
    "test262/test/built-ins/Promise/",
    "test262/test/built-ins/RegExp/prototype/sticky/",
    "test262/test/built-ins/RegExp/prototype/unicode/",
    "test262/test/built-ins/String/raw/",
    "test262/test/language/block-scope/",
    "test262/test/language/computed-property-names/",
    "test262/test/language/destructuring/",
    "test262/test/language/expressions/arrow-function/",
    "test262/test/language/expressions/async-arrow-function/",
    "test262/test/language/expressions/async-function/",
    "test262/test/language/expressions/await/",
    "test262/test/language/expressions/class/",
    "test262/test/language/expressions/assignment/destructuring/",
    "test262/test/language/expressions/new.target/",
    "test262/test/language/expressions/object/method-definition/",
    "test262/test/language/expressions/super/",
    "test262/test/language/literals/numeric/binary.js",
    "test262/test/language/literals/numeric/octal.js",
    "test262/test/language/module-code/",
    "test262/test/language/rest-parameters/",
    "test262/test/language/statements/async-function/",
    "test262/test/language/statements/class/",
    "test262/test/language/statements/for-of/",
    "test262/test/language/statements/labeled/",
    "test262/test/language/statements/let/",
    # Unsupported mjsunit features
    "mjsunit/arguments.js",
    "mjsunit/es6/array-copywithin.js",
    "mjsunit/es6/array-from.js",
    "mjsunit/es6/math-cbrt.js",
    "mjsunit/es6/math-expm1.js",
    "mjsunit/es6/math-log1p.js",
    "mjsunit/es6/numeric-literals.js",
    "mjsunit/es6/object-literals-property-shorthand.js",
    "mjsunit/es6/promise-",
    "mjsunit/es6/string-raw.js",
    "mjsunit/es6/string-startwith.js",
    "mjsunit/es6/tail-call-",
    # These tests test for incorrect behavior of detached ArrayBuffer that v8
    # supports.
    "mjsunit/es6/typedarray-every.js",
    "mjsunit/es6/typedarray-foreach.js",
    "mjsunit/es7/array-includes-receiver.js",
    "mjsunit/es7/exponentiation-operator.js",
    "mjsunit/es8/syntactic-tail-call-simple.js",
    "mjsunit/es8/syntactic-tail-call.js",
    "mjsunit/harmony/atomics.js",
    "mjsunit/regress/regress-wasm-",
    "mjsunit/tools/",
    # Use of V8 intrinsics that Hermes doesn't have.
    "mjsunit/es6/math-log2-log10.js",
    "mjsunit/smi-mul.js",
    "mjsunit/array-construct-transition.js",
    "mjsunit/array-literal-feedback.js",
    "mjsunit/array-literal-transitions.js",
    "mjsunit/array-shift4.js",
    "mjsunit/assert-opt-and-deopt.js",
    "mjsunit/call-intrinsic-type-error.js",
    "mjsunit/compare-known-objects-slow.js",
    "mjsunit/constant-fold-control-instructions.js",
    "mjsunit/count-based-osr.js",
    "mjsunit/deopt-with-fp-regs.js",
    "mjsunit/fast-array-length.js",
    "mjsunit/fast-non-keyed.js",
    "mjsunit/fast-prototype.js",
    "mjsunit/generated-transition-stub.js",
    "mjsunit/getters-on-elements.js",
    "mjsunit/math-min-max.js",
    "mjsunit/migrations.js",
    # Template strings
    "mjsunit/d8-worker-spawn-worker.js",
    "mjsunit/d8-worker-sharedarraybuffer.js",
    "mjsunit/d8-worker.js",
    # Sparse arrays
    "mjsunit/sparse-array-reverse.js",
    # Overly large typed array (uses v8 flag --mock-arraybuffer-allocator)
    "mjsunit/regress/regress-crbug-380671.js",
    # for-of
    "mjsunit/compiler/optimize_max.js",
    "mjsunit/compiler/optimize_min.js",
    "mjsunit/es6/typedarray-from.js",
    "mjsunit/es6/typedarray-of.js",
    "mjsunit/es6/typedarray-reduce.js",
    "mjsunit/es6/typedarray-tostring.js",
    "mjsunit/es6/typedarray-species.js",
    "mjsunit/es6/typedarray-sort.js",
    # Symbol
    "mjsunit/es6/array-concat-revoked-proxy-1.js",
    "mjsunit/es6/array-concat-revoked-proxy-2.js",
    "mjsunit/es6/array-species-neg-zero.js",
    "mjsunit/es6/collections.js",
    "mjsunit/es6/instanceof.js",
    "mjsunit/es6/iterator-prototype.js",
    "mjsunit/es6/object-tostring.js",
    "mjsunit/es6/pattern-brand-check.js",
    "mjsunit/es6/prototype-ordinary-objects.js",
    "mjsunit/es6/regexp-constructor.js",
    "mjsunit/es6/species.js",
    "mjsunit/primitive-keyed-access.js",
    # Array.prototype.includes
    "mjsunit/es7/array-includes.js",
    # Promise
    "mjsunit/es6/microtask-delivery.js",
    # Should early error
    "test262/test/language/statements/for-in/decl-fun.js",
    "test262/test/language/statements/for/decl-fun.js",
    "test262/test/language/statements/if/if-decl-no-else-strict.js",
    "test262/test/language/statements/if/if-fun-no-else-strict.js",
    "test262/test/language/statements/if/if-stmt-else-decl-strict.js",
    "test262/test/language/statements/if/if-stmt-else-fun-strict.js",
    "test262/test/language/statements/while/decl-fun.js",
    # async
    "mjsunit/es6/function-length-configurable.js",
    "mjsunit/es6/generators-debug-liveedit.js",
    "mjsunit/es6/generators-objects.js",
    "mjsunit/es6/generators-parsing.js",
    "mjsunit/es6/generators-poisoned-properties.js",
    "mjsunit/es6/generators-relocation.js",
    "mjsunit/es6/generators-runtime.js",
    "mjsunit/es6/generators-states.js",
    "mjsunit/es6/iteration-semantics.js",
    "mjsunit/harmony/async-debug-caught-exception-cases0.js",
    "mjsunit/harmony/async-debug-caught-exception-cases1.js",
    "mjsunit/harmony/async-debug-caught-exception-cases2.js",
    "mjsunit/harmony/async-debug-caught-exception-cases3.js",
    # let/const (block scope)
    "esprima/test_fixtures/declaration/let/",
    "esprima/test_fixtures/declaration/const/",
    "esprima/test_fixtures/statement/iteration/for-let-let.js",
    "esprima/test_fixtures/statement/iteration/const_forin.js",
    "esprima/test_fixtures/statement/iteration/migrated_0012.js",
    "esprima/test_fixtures/statement/iteration/migrated_0020.js",
    "mjsunit/compiler/osr-block-scope-id.js",
    "mjsunit/es6/debug-blockscopes.js",
    "mjsunit/es6/regexp-tolength.js",
    "mjsunit/es6/regexp-tostring.js",
    "mjsunit/es6/regress/regress-3426.js",
    "test262/test/language/global-code/script-decl-lex-restricted-global.js",
    "test262/test/language/statements/continue/shadowing-loop-variable-in-same-scope-as-continue.js",
    "test262/test/language/global-code/decl-lex-restricted-global.js",
    "test262/test/language/expressions/equals/to-prim-hint.js",
    "test262/test/language/statements/for-in/head-let-bound-names-dup.js",
    "test262/test/language/statements/for-in/head-let-bound-names-fordecl-tdz.js",
    "test262/test/language/statements/for-in/head-let-destructuring.js",
    "test262/test/language/statements/for-in/head-let-fresh-binding-per-iteration.js",
    "test262/test/language/statements/for/head-let-destructuring.js",
    "test262/test/language/statements/switch/syntax/redeclaration/",
    "test262/test/language/global-code/block-decl-strict.js",
    "test262/test/language/function-code/block-decl-strict.js",
    # let/const temporarily disabled
    "test262/test/language/future-reserved-words/let-strict.js",
    "test262/test/language/statements/for-in/head-let-bound-names-in-stmt.js",
    "test262/test/language/statements/for-in/head-lhs-let.js",
    "test262/test/language/statements/for-in/labelled-fn-stmt-let.js",
    "test262/test/language/statements/for-in/head-let-bound-names-let.js",
    "test262/test/language/statements/for-in/identifier-let-allowed-as-lefthandside-expression-not-strict.js",
    "test262/test/language/statements/for/head-let-bound-names-in-stmt.js",
    "test262/test/language/statements/for/head-lhs-let.js",
    "test262/test/language/statements/for/labelled-fn-stmt-let.js",
    "test262/test/harness/assert-throws-early-syntaxerror.js",
    "test262/test/language/global-code/script-decl-lex-var.js",
    # Labels
    "test262/test/language/statements/if/labelled-fn-stmt-second.js",
    "test262/test/language/statements/for-in/labelled-fn-stmt-lhs.js",
    "test262/test/language/statements/for-in/labelled-fn-stmt-var.js",
    "test262/test/language/statements/for/labelled-fn-stmt-expr.js",
    "test262/test/language/statements/for/labelled-fn-stmt-var.js",
    "test262/test/language/statements/if/labelled-fn-stmt-lone.js",
    "test262/test/language/statements/while/labelled-fn-stmt.js",
    # destructuring
    "mjsunit/es6/destructuring-parameters-literalcount-nolazy.js",
    "mjsunit/es6/destructuring-parameters-literalcount.js",
    # computed property names
    "esprima/test_fixtures/expression/primary/object/migrated_0034.js",
    "esprima/test_fixtures/expression/primary/object/migrated_0035.js",
    "esprima/test_fixtures/expression/primary/object/migrated_0036.js",
    "mjsunit/es6/computed-property-names.js",
    "test262/test/harness/verifyProperty-restore-accessor-symbol.js",
    "test262/test/language/expressions/object/accessor-name-computed-err-evaluation.js",
    "test262/test/language/expressions/object/accessor-name-computed-err-to-prop-key.js",
    "test262/test/language/expressions/object/accessor-name-computed-err-unresolvable.js",
    "test262/test/language/expressions/object/accessor-name-computed-yield-id.js",
    "test262/test/language/expressions/object/accessor-name-computed.js",
    "test262/test/language/expressions/object/accessor-name-computed-in.js",
    "test262/test/language/expressions/object/computed-__proto__.js",
    "test262/test/language/expressions/object/fn-name-accessor-get.js",
    "test262/test/language/expressions/object/fn-name-accessor-set.js",
    "test262/test/language/expressions/object/fn-name-arrow.js",
    "test262/test/language/expressions/object/fn-name-cover.js",
    "test262/test/language/expressions/object/fn-name-fn.js",
    "test262/test/built-ins/Array/from/source-object-iterator-1.js",
    "test262/test/built-ins/Array/from/source-object-iterator-2.js",
    # Proxy
    "mjsunit/array-isarray.js",
    "mjsunit/array-join.js",
    "mjsunit/es6/instanceof-proxies.js",
    "mjsunit/es6/classof-proxy.js",
    "test262/test/annexB/built-ins/Object/prototype/__proto__/set-cycle-shadowed.js",
    # Use of "constructor" property
    "test262/test/built-ins/Array/prototype/concat/create-ctor-poisoned.js",
    "test262/test/built-ins/Array/prototype/filter/create-ctor-poisoned.js",
    "test262/test/built-ins/Array/prototype/map/create-ctor-poisoned.js",
    "test262/test/built-ins/Array/prototype/slice/create-ctor-poisoned.js",
    "test262/test/built-ins/Array/prototype/splice/create-ctor-poisoned.js",
    "test262/test/built-ins/Array/prototype/concat/create-ctor-non-object.js",
    "test262/test/built-ins/Array/prototype/filter/create-ctor-non-object.js",
    "test262/test/built-ins/Array/prototype/map/create-ctor-non-object.js",
    "test262/test/built-ins/Array/prototype/slice/create-ctor-non-object.js",
    "test262/test/built-ins/Array/prototype/splice/create-ctor-non-object.js",
    # Enumerable attributes shadowing in the prototype chain.
    # T23621872
    "test262/test/language/statements/for-in/12.6.4-2.js",
    # Multiple evaluation
    # T23622428
    "test262/test/language/expressions/prefix-decrement/S11.4.5_A5_T5.js",
    "test262/test/language/expressions/prefix-decrement/S11.4.5_A6_T3.js",
    "test262/test/language/expressions/prefix-increment/S11.4.4_A6_T3.js",
    "test262/test/language/expressions/prefix-increment/S11.4.4_A5_T5.js",
    "test262/test/language/expressions/postfix-increment/S11.3.1_A6_T3.js",
    "test262/test/language/expressions/postfix-increment/S11.3.1_A5_T5.js",
    "test262/test/language/expressions/postfix-decrement/S11.3.2_A6_T3.js",
    "test262/test/language/expressions/postfix-decrement/S11.3.2_A5_T5.js",
    "test262/test/language/expressions/assignment/S11.13.1_A7_T2.js",
    "test262/test/language/expressions/assignment/S11.13.1_A7_T3.js",
    "test262/test/language/expressions/assignment/S11.13.1_A7_T1.js",
    "test262/test/language/expressions/assignment/S11.13.1_A5_T5.js",
    "test262/test/language/expressions/compound-assignment/",
    # Redefinition
    "mjsunit/es6/regress/regress-2243.js",
    # function name is configurable
    "test262/test/language/expressions/function/name.js",
    # accessors in JSLib
    # Escaped identifiers
    "test262/test/language/identifiers/part-digits-via-escape-hex.js",
    "test262/test/language/identifiers/val-dollar-sign-via-escape-hex.js",
    "test262/test/language/identifiers/val-underscore-via-escape-hex.js",
    "test262/test/language/identifiers/vals-eng-alpha-lower-via-escape-hex.js",
    "test262/test/language/identifiers/vals-eng-alpha-upper-via-escape-hex.js",
    "test262/test/language/identifiers/vals-rus-alpha-lower-via-escape-hex.js",
    "test262/test/language/identifiers/vals-rus-alpha-upper-via-escape-hex.js",
    # Reserved words should fail when escaped
    "test262/test/language/identifiers/val-yield-strict.js",
    "test262/test/language/identifiers/val-catch-via-escape-hex4.js",
    "test262/test/language/identifiers/val-null-via-escape-hex4.js",
    "test262/test/language/identifiers/val-if-via-escape-hex4.js",
    "test262/test/language/identifiers/val-false-via-escape-hex4.js",
    "test262/test/language/identifiers/val-extends-via-escape-hex4.js",
    "test262/test/language/identifiers/val-true-via-escape-hex4.js",
    "test262/test/language/identifiers/val-in-via-escape-hex4.js",
    "test262/test/language/identifiers/val-void-via-escape-hex4.js",
    "test262/test/language/identifiers/val-do-via-escape-hex4.js",
    "test262/test/language/identifiers/val-for-via-escape-hex4.js",
    "test262/test/language/identifiers/val-try-via-escape-hex4.js",
    "test262/test/language/identifiers/val-break-via-escape-hex4.js",
    "test262/test/language/identifiers/val-typeof-via-escape-hex4.js",
    "test262/test/language/identifiers/val-switch-via-escape-hex4.js",
    "test262/test/language/identifiers/val-enum-via-escape-hex4.js",
    "test262/test/language/identifiers/val-export-via-escape-hex4.js",
    "test262/test/language/identifiers/val-var-via-escape-hex4.js",
    "test262/test/language/identifiers/val-debugger-via-escape-hex4.js",
    "test262/test/language/identifiers/val-return-via-escape-hex4.js",
    "test262/test/language/identifiers/val-default-via-escape-hex4.js",
    "test262/test/language/identifiers/val-new-via-escape-hex4.js",
    "test262/test/language/identifiers/val-class-via-escape-hex4.js",
    "test262/test/language/identifiers/val-throw-via-escape-hex4.js",
    "test262/test/language/identifiers/val-function-via-escape-hex4.js",
    "test262/test/language/identifiers/val-instanceof-via-escape-hex4.js",
    "test262/test/language/identifiers/val-super-via-escape-hex4.js",
    "test262/test/language/identifiers/val-import-via-escape-hex4.js",
    "test262/test/language/identifiers/val-delete-via-escape-hex4.js",
    "test262/test/language/identifiers/val-case-via-escape-hex4.js",
    "test262/test/language/identifiers/val-finally-via-escape-hex4.js",
    "test262/test/language/identifiers/val-while-via-escape-hex4.js",
    "test262/test/language/identifiers/val-else-via-escape-hex4.js",
    "test262/test/language/identifiers/val-continue-via-escape-hex4.js",
    "test262/test/language/identifiers/val-super-via-escape-hex.js",
    "test262/test/language/identifiers/val-export-via-escape-hex.js",
    "test262/test/language/identifiers/val-delete-via-escape-hex.js",
    "test262/test/language/identifiers/val-false-via-escape-hex.js",
    "test262/test/language/identifiers/val-function-via-escape-hex.js",
    "test262/test/language/identifiers/val-this-via-escape-hex.js",
    "test262/test/language/identifiers/val-import-via-escape-hex.js",
    "test262/test/language/identifiers/val-new-via-escape-hex.js",
    "test262/test/language/identifiers/val-typeof-via-escape-hex.js",
    "test262/test/language/identifiers/val-null-via-escape-hex.js",
    "test262/test/language/identifiers/val-with-via-escape-hex.js",
    "test262/test/language/identifiers/val-extends-via-escape-hex.js",
    "test262/test/language/identifiers/val-continue-via-escape-hex.js",
    "test262/test/language/identifiers/val-enum-via-escape-hex.js",
    "test262/test/language/identifiers/val-break-via-escape-hex.js",
    "test262/test/language/identifiers/val-case-via-escape-hex.js",
    "test262/test/language/identifiers/val-void-via-escape-hex.js",
    "test262/test/language/identifiers/val-if-via-escape-hex.js",
    "test262/test/language/identifiers/val-do-via-escape-hex.js",
    "test262/test/language/identifiers/val-throw-via-escape-hex.js",
    "test262/test/language/identifiers/val-instanceof-via-escape-hex.js",
    "test262/test/language/identifiers/val-in-via-escape-hex.js",
    "test262/test/language/identifiers/val-while-via-escape-hex.js",
    "test262/test/language/identifiers/val-default-via-escape-hex.js",
    "test262/test/language/identifiers/val-var-via-escape-hex.js",
    "test262/test/language/identifiers/val-try-via-escape-hex.js",
    "test262/test/language/identifiers/val-true-via-escape-hex.js",
    "test262/test/language/identifiers/val-return-via-escape-hex.js",
    "test262/test/language/identifiers/val-class-via-escape-hex.js",
    "test262/test/language/identifiers/val-switch-via-escape-hex.js",
    "test262/test/language/identifiers/val-for-via-escape-hex.js",
    "test262/test/language/identifiers/val-finally-via-escape-hex.js",
    "test262/test/language/identifiers/val-debugger-via-escape-hex.js",
    "test262/test/language/identifiers/val-else-via-escape-hex.js",
    "test262/test/language/identifiers/val-catch-via-escape-hex.js",
    "test262/test/language/reserved-words/ident-reference-false-escaped.js",
    "test262/test/language/reserved-words/label-ident-true-escaped.js",
    "test262/test/language/reserved-words/label-ident-false-escaped.js",
    "test262/test/language/reserved-words/label-ident-null-escaped.js",
    "test262/test/language/reserved-words/ident-reference-true-escaped.js",
    "test262/test/language/reserved-words/ident-reference-null-escaped.js",
    "test262/test/language/future-reserved-words/implements-strict-escaped.js",
    "test262/test/language/future-reserved-words/let-strict-escaped.js",
    "test262/test/language/future-reserved-words/private-strict-escaped.js",
    "test262/test/language/future-reserved-words/static-strict-escaped.js",
    "test262/test/language/future-reserved-words/public-strict-escaped.js",
    "test262/test/language/future-reserved-words/protected-strict-escaped.js",
    "test262/test/language/future-reserved-words/yield-strict-escaped.js",
    "test262/test/language/future-reserved-words/package-strict-escaped.js",
    "test262/test/language/statements/labeled/value-yield-strict-escaped.js",
    "test262/test/language/expressions/new.target/escaped-new.js",
    "test262/test/language/literals/regexp/early-err-flags-unicode-escape.js",
    "test262/test/language/future-reserved-words/interface-strict-escaped.js",
    "test262/test/language/statements/try/catch-parameter-boundnames-restriction-eval-negative-early.js",
    # exp operator
    "test262/test/built-ins/Array/prototype/reverse/length-exceeding-integer-limit-with-proxy.js",
    "test262/test/built-ins/Array/prototype/reverse/length-exceeding-integer-limit-with-object.js",
    "test262/test/built-ins/Array/prototype/splice/clamps-length-to-integer-limit.js",
    "test262/test/built-ins/Array/prototype/splice/length-exceeding-integer-limit-shrink-array.js",
    "test262/test/built-ins/Array/prototype/splice/throws-if-integer-limit-exceeded.js",
    "test262/test/built-ins/Array/prototype/splice/length-and-deleteCount-exceeding-integer-limit.js",
    "test262/test/built-ins/Array/prototype/splice/length-near-integer-limit-grow-array.js",
    "test262/test/built-ins/Array/prototype/slice/length-exceeding-integer-limit.js",
    "test262/test/built-ins/Array/prototype/slice/length-exceeding-integer-limit-proxied-array.js",
    "test262/test/built-ins/Array/prototype/unshift/throws-if-integer-limit-exceeded.js",
    "test262/test/built-ins/Array/prototype/unshift/clamps-to-integer-limit.js",
    "test262/test/built-ins/Array/prototype/unshift/length-near-integer-limit.js",
    "test262/test/built-ins/Array/prototype/pop/clamps-to-integer-limit.js",
    "test262/test/built-ins/Array/prototype/pop/length-near-integer-limit.js",
    # number literals
    "test262/test/built-ins/Number/string-binary-literal.js",
    "test262/test/built-ins/Number/string-octal-literal.js",
    # default arguments
    "esprima/test_fixtures/expression/primary/object/migrated_0038.js",
    "mjsunit/es6/default-parameters-debug.js",
    "test262/test/built-ins/ThrowTypeError/unique-per-realm-non-simple.js",
    "test262/test/language/arguments-object/unmapped/via-params-dflt.js",
    "test262/test/language/arguments-object/unmapped/via-params-dstr.js",
    "test262/test/language/arguments-object/unmapped/via-params-rest.js",
    "test262/test/language/expressions/function/arguments-with-arguments-fn.js",
    "test262/test/language/expressions/function/arguments-with-arguments-lex.js",
    "test262/test/language/expressions/function/scope-name-var-open-non-strict.js",
    "test262/test/language/expressions/function/scope-name-var-open-strict.js",
    "test262/test/language/expressions/function/scope-paramsbody-var-open.js",
    "test262/test/language/statements/function/arguments-with-arguments-fn.js",
    "test262/test/language/statements/function/arguments-with-arguments-lex.js",
    "test262/test/language/statements/function/scope-paramsbody-var-open.js",
    "test262/test/language/statements/try/catch-parameter-boundnames-restriction-arguments-negative-early.js",
    "test262/test/language/statements/try/scope-catch-param-lex-open.js",
    # trailing comma
    re.compile("test262/.*args-trailing-comma-.*.js"),
    "test262/test/language/expressions/function/dflt-params-trailing-comma.js",
    "test262/test/language/statements/function/dflt-params-trailing-comma.js",
    # classes and methods
    "mjsunit/accessors-no-prototype.js",
    "mjsunit/array-functions-prototype-misc.js",
    "mjsunit/es6/class-computed-property-names-super.js",
    "mjsunit/es6/classes-derived-return-type.js",
    "mjsunit/es6/classes-experimental.js",
    "mjsunit/es6/classes-maps.js",
    "mjsunit/es6/classes-proxy.js",
    "mjsunit/es6/classes-subclass-arrays.js",
    "mjsunit/es6/classes-subclass-builtins.js",
    "mjsunit/es6/classes-super.js",
    "mjsunit/es6/computed-property-names-classes.js",
    "mjsunit/es6/computed-property-names-object-literals-methods.js",
    "mjsunit/es6/computed-property-names-super.js",
    "test262/test/built-ins/Array/prototype/concat/Array.prototype.concat_non-array.js",
    "test262/test/built-ins/TypedArray/from/this-is-not-constructor.js",
    "test262/test/built-ins/TypedArray/of/this-is-not-constructor.js",
    "test262/test/built-ins/TypedArray/prototype/fill/fill-values-conversion-once.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-length-access-throws.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-length-to-number-detachbuffer.js",
    "test262/test/built-ins/TypedArrays/from/property-abrupt-completion.js",
    "test262/test/built-ins/TypedArrays/from/set-value-abrupt-completion.js",
    "test262/test/built-ins/TypedArrays/from/this-is-not-constructor.js",
    "test262/test/built-ins/TypedArrays/object-arg-as-generator-iterable-returns.js",
    "test262/test/built-ins/TypedArrays/object-arg-iterating-throws.js",
    "test262/test/built-ins/TypedArrays/object-arg-iterator-throws.js",
    "test262/test/built-ins/TypedArrays/object-arg-length-throws.js",
    "test262/test/built-ins/TypedArrays/object-arg-throws-from-property.js",
    "test262/test/built-ins/TypedArrays/object-arg-throws-setting-property.js",
    "test262/test/built-ins/TypedArrays/of/argument-number-value-throws.js",
    "test262/test/built-ins/TypedArrays/of/this-is-not-constructor.js",
    "test262/test/built-ins/TypedArrays/typedarray-arg-other-ctor-buffer-ctor-access-throws.js",
    "test262/test/language/expressions/assignment/destructuring/keyed-destructuring-property-reference-target-evaluation-order.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-binary.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-exponent.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-hex.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-leading-decimal.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-non-canonical.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-octal.js",
    "test262/test/language/expressions/object/accessor-name-literal-numeric-zero.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-char-escape.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-double-quote.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-empty.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-hex-escape.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-line-continuation.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-single-quote.js",
    "test262/test/language/expressions/object/accessor-name-literal-string-unicode-escape.js",
    "test262/test/language/expressions/object/method.js",
    "test262/test/language/expressions/object/scope-meth-paramsbody-var-close.js",
    "test262/test/language/expressions/object/scope-meth-paramsbody-var-open.js",
    "test262/test/language/expressions/object/scope-setter-paramsbody-var-close.js",
    "test262/test/language/expressions/object/scope-setter-paramsbody-var-open.js",
    "test262/test/language/expressions/typeof/get-value.js",
    "test262/test/language/expressions/object/__proto__-permitted-dup.js",
    "test262/test/language/expressions/object/getter-super-prop.js",
    "test262/test/language/expressions/object/setter-super-prop.js",
    "test262/test/language/global-code/decl-lex-configurable-global.js",
    # T34396912 .prototype property on getter/setter
    "test262/test/built-ins/Function/prototype/Symbol.hasInstance/this-val-poisoned-prototype.js",
    # spread operator
    "mjsunit/es6/regress/regress-4298.js",
    "mjsunit/es6/regress/regress-4417.js",
    "mjsunit/es6/spread-array.js",
    "mjsunit/es6/spread-call-new-class.js",
    "mjsunit/es6/spread-call-new.js",
    "mjsunit/es6/spread-call-super-property.js",
    "mjsunit/es6/spread-call.js",
    "test262/test/language/expressions/array/spread-",
    "test262/test/language/expressions/call/spread-",
    "test262/test/language/expressions/call/trailing-comma.js",
    "test262/test/language/expressions/new/spread-",
    # arrow funs
    "mjsunit/array-indexing-receiver.js",
    "mjsunit/array-sort.js",
    "mjsunit/array-tostring.js",
    "mjsunit/es6/array-concat.js",
    "mjsunit/es6/array-length.js",
    "mjsunit/es6/array-prototype-values.js",
    "mjsunit/es6/array-species-constructor-accessor.js",
    "mjsunit/es6/array-species-constructor-delete.js",
    "mjsunit/es6/array-species-constructor.js",
    "mjsunit/es6/array-species-delete.js",
    "mjsunit/es6/array-species-modified.js",
    "mjsunit/es6/array-species-parent-constructor.js",
    "mjsunit/es6/array-species-proto.js",
    "mjsunit/es6/arraybuffer-species.js",
    "mjsunit/es6/arrow-functions-lexical-arguments.js",
    "mjsunit/es6/arrow-functions.js",
    "mjsunit/es6/arrow-rest-params-lazy-parsing.js",
    "mjsunit/es6/arrow-rest-params.js",
    "mjsunit/es6/object-assign.js",
    "mjsunit/es6/object-literals-method.js",
    "mjsunit/es6/string-replace.js",
    "mjsunit/es6/tail-call.js",
    "mjsunit/modules-exports2.js",
    "test262/test/language/expressions/tagged-template/invalid-escape-sequences.js",
    "test262/test/harness/verifyProperty-restore-accessor.js",
    "test262/test/harness/detachArrayBuffer-host-detachArrayBuffer.js",
    "test262/test/harness/assert-throws-early-incorrect-ctor.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-detachedbuffer.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-byteoffset-to-number-detachbuffer.js",
    # Reflect
    "test262/test/language/expressions/typeof/built-in-ordinary-objects-no-call.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-use-default-proto-if-custom-proto-is-not-object.js",
    "test262/test/built-ins/TypedArrays/typedarray-arg-use-default-proto-if-custom-proto-is-not-object.js",
    "test262/test/built-ins/TypedArrays/object-arg-use-default-proto-if-custom-proto-is-not-object.js",
    "test262/test/built-ins/TypedArrays/length-arg-use-default-proto-if-custom-proto-is-not-object.js",
    "test262/test/built-ins/TypedArrays/no-args-use-default-proto-if-custom-proto-is-not-object.js",
    "test262/test/built-ins/Object/internals/DefineOwnProperty/consistent-value-function-arguments.js",
    "test262/test/built-ins/Object/internals/DefineOwnProperty/consistent-value-function-caller.js",
    "test262/test/built-ins/Object/internals/DefineOwnProperty/consistent-value-regexp-$1.js",
    "test262/test/built-ins/Object/internals/DefineOwnProperty/consistent-writable-regexp-$1.js",
    # Realm
    "mjsunit/regress/regress-crbug-501711.js",
    # leaking arguments
    "test262/test/built-ins/ThrowTypeError/name.js",
    "test262/test/built-ins/ThrowTypeError/unique-per-realm-function-proto.js",
    "test262/test/built-ins/ThrowTypeError/frozen.js",
    "test262/test/built-ins/ThrowTypeError/extensible.js<Paste>",
    # arguments object tracking local names
    "test262/test/language/arguments-object/mapped/nonconfigurable-descriptors-set-value-with-define-property.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-nonwritable-descriptors-set-by-arguments.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-descriptors-with-param-assign.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-descriptors-set-value-by-arguments.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-nonwritable-descriptors-set-by-param.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-nonenumerable-nonwritable-descriptors-set-by-arguments.js",
    "test262/test/language/arguments-object/mapped/nonconfigurable-nonenumerable-nonwritable-descriptors-set-by-param.js",
    # redeclaration
    "test262/test/language/block-scope/syntax/redeclaration/var-declaration-attempt-to-redeclare-with-function-declaration.js",
    "test262/test/language/block-scope/syntax/redeclaration/function-declaration-attempt-to-redeclare-with-function-declaration.js",
    "test262/test/language/block-scope/syntax/redeclaration/function-declaration-attempt-to-redeclare-with-var-declaration.js",
    "test262/test/language/statements/switch/syntax/redeclaration/var-declaration-attempt-to-redeclare-with-function-declaration.js",
    # Template cache in Hermes is per-module, not per-realm.
    "test262/test/language/expressions/tagged-template/cache-differing-expressions-new-function.js",
    "test262/test/language/expressions/tagged-template/cache-identical-source-new-function.js",
    # ToLength changes after ES5.1
    "test262/test/built-ins/TypedArray/prototype/byteLength/detached-buffer.js",
    "test262/test/built-ins/TypedArray/prototype/every/callbackfn-detachbuffer.js",
    "test262/test/built-ins/TypedArray/prototype/length/detached-buffer.js",
    "test262/test/built-ins/Array/prototype/reverse/S15.4.4.8_A3_T3.js",
    "test262/test/built-ins/Array/prototype/push/S15.4.4.7_A2_T2.js",
    "test262/test/built-ins/Array/prototype/push/S15.4.4.7_A4_T3.js",
    "test262/test/built-ins/Array/prototype/push/S15.4.4.7_A4_T1.js",
    # RegExp changes
    "mjsunit/es6/regexp-flags.js",
    "mjsunit/es6/regexp-sticky.js",
    "mjsunit/es6/unicode-regexp-ignore-case-noi18n.js",
    "mjsunit/es6/unicode-regexp-ignore-case.js",
    "mjsunit/es6/unicode-regexp-restricted-syntax.js",
    "mjsunit/es6/unicode-regexp-zero-length.js",
    "test262/test/built-ins/RegExp/prototype/exec/u-",
    "test262/test/built-ins/RegExp/prototype/exec/y-",
    "test262/test/built-ins/RegExp/prototype/test/y-",
    "test262/test/built-ins/RegExp/valid-flags-y.js",
    "test262/test/language/literals/regexp/u-",
    "test262/test/language/literals/regexp/y-",
    "test262/test/built-ins/RegExp/prototype/exec/failure-lastindex-access.js",
    "test262/test/built-ins/RegExp/prototype/flags/coercion-sticky.js",
    "test262/test/built-ins/RegExp/prototype/flags/coercion-unicode.js",
    "test262/test/built-ins/RegExp/prototype/unicode/length.js",
    "test262/test/built-ins/RegExp/unicode_identity_escape.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/y-",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-coerce-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-failure-y-set-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-y-coerce-lastindex-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/get-unicode-error.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-failure-y-set-lastindex-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-success-y-set-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-success-u-return-val-groups.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/u-",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-failure-y-return-val.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-infer-unicode.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.match/builtin-success-y-set-lastindex-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.search/y-fail-return.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.search/u-lastindex-advance.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/u-advance-after-empty.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-set-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-fail-lastindex-no-write.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-fail-return.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-fail-global-return.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-fail-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/y-init-lastindex.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/coerce-unicode.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.replace/get-unicode-error.js",
    # This tests behavior in ES2018.
    "test262/test/built-ins/RegExp/prototype/Symbol.search/lastindex-no-restore.js",
    # species constructors
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-ctor-non-obj.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-ctor-get-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-species-get-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-species-non-ctor.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-species-undef.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor-y.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/species-ctor.js",
    # Unsupported flags.
    "test262/test/built-ins/RegExp/prototype/Symbol.split/u-lastindex-adv-thru-match.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/u-lastindex-adv-thru-failure.js",
    # Implementation specific
    "test262/test/built-ins/RegExp/prototype/Symbol.split/get-flags-err.js",
    "test262/test/built-ins/RegExp/prototype/Symbol.split/coerce-flags-err.js",
    # JSON changes
    # prototype changes
    "test262/test/built-ins/Error/prototype/S15.11.4_A2.js",
    # Array changes
    "test262/test/built-ins/Array/prototype/toLocaleString/primitive_this_value_getter.js",
    "test262/test/built-ins/Array/prototype/toLocaleString/primitive_this_value.js",
    # Function constructor changes
    "mjsunit/function-bind.js",
    "test262/test/built-ins/Function/StrictFunction_restricted-properties.js",
    "test262/test/built-ins/Function/prototype/restricted-property-arguments.js",
    "test262/test/built-ins/Function/prototype/restricted-property-caller.js",
    "test262/test/built-ins/Function/prototype/bind/BoundFunction_restricted-properties.js",
    # Object() changes
    "test262/test/built-ins/Object/prototype/toLocaleString/primitive_this_value.js",
    "test262/test/built-ins/Object/prototype/toLocaleString/primitive_this_value_getter.js",
    # eval changes
    "test262/test/language/global-code/script-decl-var.js",
    "test262/test/language/global-code/script-decl-func-err-non-configurable.js",
    # TypedArray changes
    "test262/test/built-ins/TypedArrays/typedarray-arg-same-ctor-buffer-ctor-access-throws.js",
    "test262/test/built-ins/TypedArrays/internals/Get/key-is-not-integer.js",
    "test262/test/built-ins/TypedArrays/internals/GetOwnProperty/index-prop-desc.js",
    "test262/test/built-ins/TypedArray/prototype/sort/sorted-values-nan.js",
    "test262/test/built-ins/TypedArrays/buffer-arg-defined-negative-length.js",
    "test262/test/built-ins/TypedArrays/typedarray-arg-other-ctor-buffer-ctor-not-object-throws.js",
    "test262/test/built-ins/TypedArrays/typedarray-arg-same-ctor-buffer-ctor-value-not-obj-throws.js",
    # TypedArray ES7 iterators
    "test262/test/built-ins/TypedArrays/object-arg-iterator-not-callable-throws.js",
    "test262/test/built-ins/TypedArrays/from/iter-invoke-error.js",
    "test262/test/built-ins/TypedArrays/from/iter-access-error.js",
    "test262/test/built-ins/TypedArrays/from/iter-next-value-error.js",
    "test262/test/built-ins/TypedArrays/from/iter-next-error.js",
    "test262/test/built-ins/TypedArray/from/iter-invoke-error.js",
    "test262/test/built-ins/TypedArray/from/iter-next-error.js",
    "test262/test/built-ins/TypedArray/from/iter-next-value-error.js",
    "test262/test/built-ins/TypedArray/from/iter-access-error.js",
    # TypedArray detaching buffer
    "test262/test/built-ins/ArrayBuffer/prototype/byteLength/detached-buffer.js",
    "test262/test/built-ins/DataView/detached-buffer.js",
    "test262/test/built-ins/DataView/prototype/byteLength/detached-buffer.js",
    "test262/test/built-ins/DataView/prototype/byteOffset/detached-buffer.js",
    "test262/test/built-ins/TypedArray/prototype/some/callbackfn-detachbuffer.js",
    "test262/test/built-ins/TypedArrays/internals/GetOwnProperty/detached-buffer.js",
    "test262/test/built-ins/TypedArray/prototype/find/predicate-may-detach-buffer.js",
    "test262/test/built-ins/TypedArray/prototype/findIndex/predicate-may-detach-buffer.js",
    # Float32 TypedArray failure
    "test262/test/built-ins/TypedArrays/internals/DefineOwnProperty/conversion-operation-consistent-nan.js",
    # TypedArray accessors
    "test262/test/built-ins/TypedArrays/internals/Get/key-is-out-of-bounds.js",
    "test262/test/built-ins/TypedArrays/internals/Get/detached-buffer.js",
    "test262/test/built-ins/TypedArrays/internals/Get/indexed-value-sab.js",
    "test262/test/built-ins/TypedArrays/internals/Get/key-is-not-minus-zero.js",
    "test262/test/built-ins/TypedArrays/internals/Set/tonumber-value-throws.js",
    "test262/test/built-ins/TypedArrays/internals/Set/detached-buffer.js",
    # SharedArrayBuffer
    "test262/test/built-ins/ArrayBuffer/prototype/byteLength/this-is-sharedarraybuffer.js",
    "test262/test/built-ins/ArrayBuffer/prototype/slice/this-is-sharedarraybuffer.js",
    # function name
    "test262/test/language/expressions/assignment/fn-name-lhs-member.js",
    "test262/test/language/expressions/assignment/fn-name-lhs-cover.js",
    # global object reference
    "test262/test/built-ins/global/global-object.js",
    "test262/test/built-ins/global/property-descriptor.js",
    # Unsupported harness tests
    "test262/test/harness/timer.js",
    "test262/test/harness/assert-throws-early-referenceerror.js",
    # SpeciesConstructor
    "test262/test/built-ins/ArrayBuffer/prototype/slice/species-constructor-is-not-object.js",
    # t19359477
    "mjsunit/regress/regress-3976.js",
    "mjsunit/string-replace-gc.js",
    # Time out. # T20489563
    "mjsunit/regress/regress-crbug-482998.js",
    # Different time out: # T23228706
    "mjsunit/regress/regress-581.js",
    "mjsunit/regress/regress-685.js",
    "mjsunit/regress/regress-crbug-387031.js",
    "mjsunit/regress/regress-crbug-516592.js",
    "mjsunit/regress/regress-splice-large-index.js",
    # String lowercasing bugs. These only happen on Apple platforms using
    # CoreFoundation. See T24545708 for a discussion.
    "test262/test/built-ins/String/prototype/toLocaleLowerCase/special_casing_conditional.js",
    "test262/test/built-ins/String/prototype/toLowerCase/special_casing_conditional.js",
    # Stack overflow catching.
    "mjsunit/regress/regress-1132.js",
    "mjsunit/regress/regress-446389.js",
    # Concurrent recompilation (these call quit() after deciding to skip the test).
    "mjsunit/concurrent-initial-prototype-change.js",
    "mjsunit/compiler/concurrent-proto-change.js",
    "mjsunit/compiler/manual-concurrent-recompile.js",
    "mjsunit/compiler/concurrent-invalidate-transition-map.js",
    "mjsunit/regress/regress-opt-after-debug-deopt.js",
    "mjsunit/regress/regress-embedded-cons-string.js",
    "mjsunit/regress/regress-prepare-break-while-recompile.js",
    # Uncategorized mjsunit failures
    "mjsunit/accessor-map-sharing.js",
    "mjsunit/accessors-on-global-object.js",
    "mjsunit/array-bounds-check-removal.js",
    "mjsunit/array-concat.js",
    "mjsunit/array-indexing.js",
    "mjsunit/array-length.js",
    "mjsunit/array-push5.js",
    "mjsunit/array-reduce.js",
    "mjsunit/array-store-and-grow.js",
    "mjsunit/array-unshift.js",
    "mjsunit/bugs/bug-1344252.js",
    "mjsunit/bugs/bug-222.js",
    "mjsunit/bugs/bug-617.js",
    "mjsunit/bugs/bug-941049.js",
    "mjsunit/bugs/harmony/debug-blockscopes.js",
    "mjsunit/compiler/deopt-inlined-from-call.js",
    "mjsunit/compiler/increment-typefeedback.js",
    "mjsunit/compiler/inlined-array-pop-opt.js",
    "mjsunit/compiler/inlined-call.js",
    "mjsunit/compiler/integral32-add-sub.js",
    "mjsunit/compiler/opt-next-call.js",
    "mjsunit/compiler/optimized-float32array-length.js",
    "mjsunit/compiler/optimized-float64array-length.js",
    "mjsunit/compiler/optimized-instanceof-1.js",
    "mjsunit/compiler/optimized-instanceof-2.js",
    "mjsunit/compiler/optimized-int32array-length.js",
    "mjsunit/compiler/optimized-uint32array-length.js",
    "mjsunit/compiler/regress-416359.js",
    "mjsunit/compiler/regress-5320.js",
    "mjsunit/compiler/regress-compare-negate.js",
    "mjsunit/compiler/regress-stacktrace-methods.js",
    "mjsunit/compiler/string-add-try-catch.js",
    "mjsunit/constant-folding-2.js",
    "mjsunit/date-parse.js",
    "mjsunit/date.js",
    "mjsunit/deopt-minus-zero.js",
    "mjsunit/deserialize-optimize-inner.js",
    "mjsunit/dictionary-properties.js",
    "mjsunit/div-mul-minus-one.js",
    "mjsunit/double-equals.js",
    "mjsunit/element-accessor.js",
    "mjsunit/element-read-only.js",
    "mjsunit/elements-length-no-holey.js",
    "mjsunit/elements-transition-hoisting.js",
    "mjsunit/ensure-growing-store-learns.js",
    "mjsunit/error-accessors.js",
    "mjsunit/error-tostring-omit.js",
    "mjsunit/es6/function-name-configurable.js",
    "mjsunit/es6/indexed-integer-exotics.js",
    "mjsunit/es6/regress/regress-2219.js",
    "mjsunit/es6/regress/regress-2225.js",
    "mjsunit/es6/regress/regress-2322.js",
    "mjsunit/es6/regress/regress-2681.js",
    "mjsunit/es6/regress/regress-2691.js",
    "mjsunit/es6/regress/regress-3280.js",
    "mjsunit/es6/regress/regress-3683.js",
    "mjsunit/es6/regress/regress-3741.js",
    "mjsunit/es6/regress/regress-3902.js",
    "mjsunit/es6/regress/regress-4097.js",
    "mjsunit/es6/regress/regress-411237.js",
    "mjsunit/es6/regress/regress-4466.js",
    "mjsunit/es6/regress/regress-4482.js",
    "mjsunit/es6/regress/regress-455141.js",
    "mjsunit/es6/regress/regress-468661.js",
    "mjsunit/es6/regress/regress-474783.js",
    "mjsunit/es6/regress/regress-4759.js",
    "mjsunit/es6/regress/regress-508074.js",
    "mjsunit/es6/regress/regress-cr372788.js",
    "mjsunit/es6/regress/regress-cr493566.js",
    "mjsunit/es6/regress/regress-crbug-448730.js",
    "mjsunit/es6/regress/regress-inlined-new-target.js",
    "mjsunit/es6/regress/regress-lookup-transition.js",
    "mjsunit/es6/rest-params-lazy-parsing.js",
    "mjsunit/es6/throw-type-error-function-restrictions.js",
    "mjsunit/es6/typedarray.js",
    "mjsunit/es6/unicode-character-ranges.js",
    "mjsunit/es6/unicode-escapes-in-regexps.js",
    "mjsunit/es6/unicode-escapes.js",
    "mjsunit/field-type-tracking.js",
    "mjsunit/fixed-context-shapes-when-recompiling.js",
    "mjsunit/for-in-opt.js",
    "mjsunit/for-in.js",
    "mjsunit/get-prototype-of.js",
    "mjsunit/global-accessors.js",
    "mjsunit/global-infinity-strict.js",
    "mjsunit/global-nan-strict.js",
    "mjsunit/global-undefined-strict.js",
    "mjsunit/harmony/array-concat-array-proto-getter.js",
    "mjsunit/harmony/array-concat-object-proto-dict-getter.js",
    "mjsunit/harmony/async-arrow-lexical-arguments.js",
    "mjsunit/harmony/async-arrow-lexical-new.target.js",
    "mjsunit/harmony/async-arrow-lexical-super.js",
    "mjsunit/harmony/async-arrow-lexical-this.js",
    "mjsunit/harmony/async-await-no-constructor.js",
    "mjsunit/harmony/async-await-resolve-new.js",
    "mjsunit/harmony/async-await-species.js",
    "mjsunit/harmony/async-debug-basic.js",
    "mjsunit/harmony/async-debug-caught-exception-cases.js",
    "mjsunit/harmony/async-debug-caught-exception.js",
    "mjsunit/harmony/async-debug-step-abort-at-break.js",
    "mjsunit/harmony/async-debug-step-continue-at-break.js",
    "mjsunit/harmony/async-debug-step-in-and-out.js",
    "mjsunit/harmony/async-debug-step-in-out-out.js",
    "mjsunit/harmony/async-debug-step-in.js",
    "mjsunit/harmony/async-debug-step-nested.js",
    "mjsunit/harmony/async-debug-step-next-constant.js",
    "mjsunit/harmony/async-debug-step-next.js",
    "mjsunit/harmony/async-debug-step-out.js",
    "mjsunit/harmony/async-function-stacktrace.js",
    "mjsunit/harmony/debug-async-break-on-stack.js",
    "mjsunit/harmony/debug-async-break.js",
    "mjsunit/harmony/debug-async-function-async-task-event.js",
    "mjsunit/harmony/debug-async-liveedit.js",
    "mjsunit/harmony/default-parameter-do-expression.js",
    "mjsunit/harmony/do-expressions-control.js",
    "mjsunit/harmony/function-sent.js",
    "mjsunit/harmony/futex.js",
    "mjsunit/harmony/generators-turbo.js",
    "mjsunit/harmony/generators.js",
    "mjsunit/harmony/harmony-string-pad-end.js",
    "mjsunit/harmony/harmony-string-pad-start.js",
    "mjsunit/harmony/object-entries.js",
    "mjsunit/harmony/object-get-own-property-descriptors.js",
    "mjsunit/harmony/object-values.js",
    "mjsunit/harmony/private-symbols.js",
    "mjsunit/harmony/private.js",
    "mjsunit/harmony/regress/regress-4658.js",
    "mjsunit/harmony/regress/regress-4696.js",
    "mjsunit/harmony/regress/regress-4755.js",
    "mjsunit/harmony/regress/regress-4904.js",
    "mjsunit/harmony/regress/regress-546967.js",
    "mjsunit/harmony/regress/regress-618603.js",
    "mjsunit/harmony/regress/regress-624300.js",
    "mjsunit/harmony/regress/regress-crbug-571149.js",
    "mjsunit/harmony/regress/regress-crbug-578038.js",
    "mjsunit/harmony/regress/regress-crbug-621111.js",
    "mjsunit/harmony/regress/regress-typedarray-out-of-bounds.js",
    "mjsunit/harmony/sharedarraybuffer.js",
    "mjsunit/harmony/simd.js",
    "mjsunit/harmony/sloppy-legacy-duplicate-generators.js",
    "mjsunit/harmony/sloppy-no-duplicate-async.js",
    "mjsunit/harmony/sloppy-no-duplicate-generators.js",
    "mjsunit/harmony/sloppy-restrictive-block-function.js",
    "mjsunit/harmony/to-length.js",
    "mjsunit/harmony/to-name.js",
    "mjsunit/harmony/to-number.js",
    "mjsunit/harmony/to-primitive.js",
    "mjsunit/harmony/to-string.js",
    "mjsunit/harmony/trailing-commas-length.js",
    "mjsunit/has-own-property-evaluation-order.js",
    "mjsunit/ignition/dead-code-source-position.js",
    "mjsunit/ignition/debug-break-mixed-stack.js",
    "mjsunit/ignition/debug-break-on-stack.js",
    "mjsunit/ignition/debug-break.js",
    "mjsunit/ignition/debug-step-mixed-stack.js",
    "mjsunit/ignition/debug-step-prefix-bytecodes.js",
    "mjsunit/ignition/debugger-statement.js",
    "mjsunit/ignition/elided-instruction.js",
    "mjsunit/ignition/ignition-statistics-extension.js",
    "mjsunit/ignition/optimized-debug-frame.js",
    "mjsunit/ignition/optimized-stack-trace.js",
    "mjsunit/ignition/osr-from-generator.js",
    "mjsunit/ignition/stack-trace-source-position.js",
    "mjsunit/indexed-accessors.js",
    "mjsunit/json-replacer-order.js",
    "mjsunit/json-stringify-holder.js",
    "mjsunit/json-stringify-recursive.js",
    "mjsunit/json-stringify-stack.js",
    "mjsunit/json2.js",
    "mjsunit/keyed-load-hole-to-undefined.js",
    "mjsunit/keyed-load-with-string-key.js",
    "mjsunit/keyed-load-with-symbol-key.js",
    "mjsunit/lookup-behind-property.js",
    "mjsunit/math-floor-of-div-minus-zero.js",
    "mjsunit/minmax-simple.js",
    "mjsunit/modules-this.js",
    "mjsunit/never-optimize.js",
    "mjsunit/object-define-properties.js",
    "mjsunit/object-define-property.js",
    "mjsunit/object-freeze.js",
    "mjsunit/object-get-own-property-names.js",
    "mjsunit/object-prevent-extensions.js",
    "mjsunit/object-seal.js",
    "mjsunit/packed-elements.js",
    "mjsunit/polymorph-arrays.js",
    "mjsunit/random-bit-correlations.js",
    "mjsunit/regress-3225.js",
    "mjsunit/regress-sync-optimized-lists.js",
    "mjsunit/regress/d8-readbuffer.js",
    "mjsunit/regress/debug-prepare-step-in.js",
    "mjsunit/regress/regress-102153.js",
    "mjsunit/regress/regress-103259.js",
    "mjsunit/regress/regress-1129.js",
    "mjsunit/regress/regress-1170187.js",
    "mjsunit/regress/regress-119429.js",
    "mjsunit/regress/regress-119609.js",
    "mjsunit/regress/regress-131994.js",
    "mjsunit/regress/regress-1403.js",
    "mjsunit/regress/regress-1523.js",
    "mjsunit/regress/regress-1530.js",
    "mjsunit/regress/regress-1548.js",
    "mjsunit/regress/regress-1586.js",
    "mjsunit/regress/regress-1591.js",
    "mjsunit/regress/regress-1639-2.js",
    "mjsunit/regress/regress-1639.js",
    "mjsunit/regress/regress-1757.js",
    "mjsunit/regress/regress-1849.js",
    "mjsunit/regress/regress-1980.js",
    "mjsunit/regress/regress-2132.js",
    "mjsunit/regress/regress-2318.js",
    "mjsunit/regress/regress-2339.js",
    "mjsunit/regress/regress-2437.js",
    "mjsunit/regress/regress-2451.js",
    "mjsunit/regress/regress-2470.js",
    "mjsunit/regress/regress-252797.js",
    "mjsunit/regress/regress-2564.js",
    "mjsunit/regress/regress-2596.js",
    "mjsunit/regress/regress-2618.js",
    "mjsunit/regress/regress-2686.js",
    "mjsunit/regress/regress-269.js",
    "mjsunit/regress/regress-2825.js",
    "mjsunit/regress/regress-3159.js",
    "mjsunit/regress/regress-3176.js",
    "mjsunit/regress/regress-319722-ArrayBuffer.js",
    "mjsunit/regress/regress-319722-TypedArrays.js",
    "mjsunit/regress/regress-3255.js",
    "mjsunit/regress/regress-325676.js",
    "mjsunit/regress/regress-3281.js",
    "mjsunit/regress/regress-330046.js",
    "mjsunit/regress/regress-334.js",
    "mjsunit/regress/regress-353004.js",
    "mjsunit/regress/regress-356053.js",
    "mjsunit/regress/regress-357103.js",
    "mjsunit/regress/regress-362870.js",
    "mjsunit/regress/regress-3641.js",
    "mjsunit/regress/regress-3650-3.js",
    "mjsunit/regress/regress-365172-2.js",
    "mjsunit/regress/regress-3709.js",
    "mjsunit/regress/regress-3717.js",
    "mjsunit/regress/regress-3718.js",
    "mjsunit/regress/regress-373283.js",
    "mjsunit/regress/regress-385565.js",
    "mjsunit/regress/regress-392114.js",
    "mjsunit/regress/regress-394.js",
    "mjsunit/regress/regress-3960.js",
    "mjsunit/regress/regress-409533.js",
    "mjsunit/regress/regress-4121.js",
    "mjsunit/regress/regress-4173.js",
    "mjsunit/regress/regress-419663.js",
    "mjsunit/regress/regress-4255-4.js",
    "mjsunit/regress/regress-4266.js",
    "mjsunit/regress/regress-4267.js",
    "mjsunit/regress/regress-430201.js",
    "mjsunit/regress/regress-430201b.js",
    "mjsunit/regress/regress-4320.js",
    "mjsunit/regress/regress-4380.js",
    "mjsunit/regress/regress-4521.js",
    "mjsunit/regress/regress-4525.js",
    "mjsunit/regress/regress-4577.js",
    "mjsunit/regress/regress-4640.js",
    "mjsunit/regress/regress-4703.js",
    "mjsunit/regress/regress-479528.js",
    "mjsunit/regress/regress-4908.js",
    "mjsunit/regress/regress-4945.js",
    "mjsunit/regress/regress-4964.js",
    "mjsunit/regress/regress-4967.js",
    "mjsunit/regress/regress-4971.js",
    "mjsunit/regress/regress-5004.js",
    "mjsunit/regress/regress-500831.js",
    "mjsunit/regress/regress-5010.js",
    "mjsunit/regress/regress-5033.js",
    "mjsunit/regress/regress-5036.js",
    "mjsunit/regress/regress-5071.js",
    "mjsunit/regress/regress-5085.js",
    "mjsunit/regress/regress-5106.js",
    "mjsunit/regress/regress-514362.js",
    "mjsunit/regress/regress-5164.js",
    "mjsunit/regress/regress-5174.js",
    "mjsunit/regress/regress-5178.js",
    "mjsunit/regress/regress-5181.js",
    "mjsunit/regress/regress-520029.js",
    "mjsunit/regress/regress-5216.js",
    "mjsunit/regress/regress-5245.js",
    "mjsunit/regress/regress-5252.js",
    "mjsunit/regress/regress-5342.js",
    "mjsunit/regress/regress-539875.js",
    "mjsunit/regress/regress-5404.js",
    "mjsunit/regress/regress-542099.js",
    "mjsunit/regress/regress-544991.js",
    "mjsunit/regress/regress-554865.js",
    "mjsunit/regress/regress-575364.js",
    "mjsunit/regress/regress-578775.js",
    "mjsunit/regress/regress-595319.js",
    "mjsunit/regress/regress-596718.js",
    "mjsunit/regress/regress-599414-array-concat-fast-path.js",
    "mjsunit/regress/regress-599719.js",
    "mjsunit/regress/regress-599825.js",
    "mjsunit/regress/regress-613928.js",
    "mjsunit/regress/regress-617525.js",
    "mjsunit/regress/regress-617526.js",
    "mjsunit/regress/regress-617529.js",
    "mjsunit/regress/regress-618657.js",
    "mjsunit/regress/regress-622663.js",
    "mjsunit/regress/regress-633998.js",
    "mjsunit/regress/regress-639270.js",
    "mjsunit/regress/regress-642409.js",
    "mjsunit/regress/regress-648373-sloppy-arguments-includesValues.js",
    "mjsunit/regress/regress-649078.js",
    "mjsunit/regress/regress-674753.js",
    "mjsunit/regress/regress-857.js",
    "mjsunit/regress/regress-91013.js",
    "mjsunit/regress/regress-91120.js",
    "mjsunit/regress/regress-944.js",
    "mjsunit/regress/regress-94873.js",
    "mjsunit/regress/regress-95113.js",
    "mjsunit/regress/regress-95920.js",
    "mjsunit/regress/regress-995.js",
    "mjsunit/regress/regress-998565.js",
    "mjsunit/regress/regress-cntl-descriptors-enum.js",
    "mjsunit/regress/regress-crbug-107996.js",
    "mjsunit/regress/regress-crbug-119800.js",
    "mjsunit/regress/regress-crbug-122271.js",
    "mjsunit/regress/regress-crbug-160010.js",
    "mjsunit/regress/regress-crbug-222893.js",
    "mjsunit/regress/regress-crbug-233737.js",
    "mjsunit/regress/regress-crbug-245480.js",
    "mjsunit/regress/regress-crbug-309623.js",
    "mjsunit/regress/regress-crbug-323936.js",
    "mjsunit/regress/regress-crbug-349079.js",
    "mjsunit/regress/regress-crbug-351262.js",
    "mjsunit/regress/regress-crbug-387599.js",
    "mjsunit/regress/regress-crbug-393988.js",
    "mjsunit/regress/regress-crbug-401915.js",
    "mjsunit/regress/regress-crbug-405922.js",
    "mjsunit/regress/regress-crbug-409614.js",
    "mjsunit/regress/regress-crbug-410033.js",
    "mjsunit/regress/regress-crbug-412203.js",
    "mjsunit/regress/regress-crbug-422858.js",
    "mjsunit/regress/regress-crbug-424142.js",
    "mjsunit/regress/regress-crbug-430846.js",
    "mjsunit/regress/regress-crbug-432493.js",
    "mjsunit/regress/regress-crbug-435825.js",
    "mjsunit/regress/regress-crbug-451770.js",
    "mjsunit/regress/regress-crbug-465298.js",
    "mjsunit/regress/regress-crbug-465564.js",
    "mjsunit/regress/regress-crbug-467180.js",
    "mjsunit/regress/regress-crbug-469480.js",
    "mjsunit/regress/regress-crbug-471702.js",
    "mjsunit/regress/regress-crbug-474297.js",
    "mjsunit/regress/regress-crbug-480819.js",
    "mjsunit/regress/regress-crbug-484077.js",
    "mjsunit/regress/regress-crbug-485548-1.js",
    "mjsunit/regress/regress-crbug-485548-2.js",
    "mjsunit/regress/regress-crbug-487289.js",
    "mjsunit/regress/regress-crbug-489597.js",
    "mjsunit/regress/regress-crbug-491062.js",
    "mjsunit/regress/regress-crbug-491943.js",
    "mjsunit/regress/regress-crbug-500497.js",
    "mjsunit/regress/regress-crbug-501808.js",
    "mjsunit/regress/regress-crbug-501809.js",
    "mjsunit/regress/regress-crbug-505007-1.js",
    "mjsunit/regress/regress-crbug-505007-2.js",
    "mjsunit/regress/regress-crbug-505370.js",
    "mjsunit/regress/regress-crbug-506443.js",
    "mjsunit/regress/regress-crbug-507070.js",
    "mjsunit/regress/regress-crbug-511880.js",
    "mjsunit/regress/regress-crbug-513471.js",
    "mjsunit/regress/regress-crbug-513472.js",
    "mjsunit/regress/regress-crbug-523308.js",
    "mjsunit/regress/regress-crbug-546968.js",
    "mjsunit/regress/regress-crbug-554831.js",
    "mjsunit/regress/regress-crbug-568477-1.js",
    "mjsunit/regress/regress-crbug-568477-2.js",
    "mjsunit/regress/regress-crbug-568477-3.js",
    "mjsunit/regress/regress-crbug-568477-4.js",
    "mjsunit/regress/regress-crbug-570241.js",
    "mjsunit/regress/regress-crbug-573858.js",
    "mjsunit/regress/regress-crbug-575080.js",
    "mjsunit/regress/regress-crbug-575314.js",
    "mjsunit/regress/regress-crbug-578039-Proxy_construct_prototype_change.js",
    "mjsunit/regress/regress-crbug-580506.js",
    "mjsunit/regress/regress-crbug-582048.js",
    "mjsunit/regress/regress-crbug-582703.js",
    "mjsunit/regress/regress-crbug-587068.js",
    "mjsunit/regress/regress-crbug-592340.js",
    "mjsunit/regress/regress-crbug-592343.js",
    "mjsunit/regress/regress-crbug-594183.js",
    "mjsunit/regress/regress-crbug-594574-concat-leak-1.js",
    "mjsunit/regress/regress-crbug-594574-concat-leak-2.js",
    "mjsunit/regress/regress-crbug-596394.js",
    "mjsunit/regress/regress-crbug-599067.js",
    "mjsunit/regress/regress-crbug-603463.js",
    "mjsunit/regress/regress-crbug-605060.js",
    "mjsunit/regress/regress-crbug-605581.js",
    "mjsunit/regress/regress-crbug-605862.js",
    "mjsunit/regress/regress-crbug-612142.js",
    "mjsunit/regress/regress-crbug-614727.js",
    "mjsunit/regress/regress-crbug-618788.js",
    "mjsunit/regress/regress-crbug-620253.js",
    "mjsunit/regress/regress-crbug-621361.js",
    "mjsunit/regress/regress-crbug-625590.js",
    "mjsunit/regress/regress-crbug-626715.js",
    "mjsunit/regress/regress-crbug-627828.js",
    "mjsunit/regress/regress-crbug-629996.js",
    "mjsunit/regress/regress-crbug-631917.js",
    "mjsunit/regress/regress-crbug-633999.js",
    "mjsunit/regress/regress-crbug-644215.js",
    "mjsunit/regress/regress-crbug-645103.js",
    "mjsunit/regress/regress-create-exception.js",
    "mjsunit/regress/regress-debug-code-recompilation.js",
    "mjsunit/regress/regress-debug-context-load.js",
    "mjsunit/regress/regress-debug-deopt-while-recompile.js",
    "mjsunit/regress/regress-delete-empty-double.js",
    "mjsunit/regress/regress-double-canonicalization.js",
    "mjsunit/regress/regress-ensure-initial-map.js",
    "mjsunit/regress/regress-frame-details-null-receiver.js",
    "mjsunit/regress/regress-function-length-strict.js",
    "mjsunit/regress/regress-inline-class-constructor.js",
    "mjsunit/regress/regress-integer-indexed-element.js",
    "mjsunit/regress/regress-map-invalidation-1.js",
    "mjsunit/regress/regress-map-invalidation-2.js",
    "mjsunit/regress/regress-object-assign-deprecated-2.js",
    "mjsunit/regress/regress-osr-in-case-label.js",
    "mjsunit/regress/regress-param-local-type.js",
    "mjsunit/regress/regress-parseint.js",
    "mjsunit/regress/regress-put-prototype-transition.js",
    "mjsunit/regress/regress-set-flags-stress-compact.js",
    "mjsunit/regress/regress-smi-only-concat.js",
    "mjsunit/regress/regress-store-uncacheable.js",
    "mjsunit/regress/regress-string-from-char-code-tonumber.js",
    "mjsunit/regress/regress-typedarray-length.js",
    "mjsunit/regress/regress-undefined-nan.js",
    "mjsunit/regress/regress-undefined-nan3.js",
    "mjsunit/regress/regress-v8-4972.js",
    "mjsunit/regress/regress-v8-5009.js",
    "mjsunit/regress/string-compare-memcmp.js",
    "mjsunit/samevalue.js",
    "mjsunit/setters-on-elements.js",
    "mjsunit/shift-for-integer-div.js",
    "mjsunit/sin-cos.js",
    "mjsunit/smi-mul-const.js",
    "mjsunit/smi-representation.js",
    "mjsunit/stack-traces-2.js",
    "mjsunit/stack-traces-custom-lazy.js",
    "mjsunit/stack-traces-custom.js",
    "mjsunit/stack-traces-overflow.js",
    "mjsunit/string-case.js",
    "mjsunit/string-external-cached.js",
    "mjsunit/string-externalize.js",
    "mjsunit/string-oom-replace-global-regexp-with-string.js",
    "mjsunit/string-oom-replace-regexp-global-with-function.js",
    "mjsunit/string-replace-with-empty.js",
    "mjsunit/string-slices.js",
    "mjsunit/substr.js",
    "mjsunit/to_number_order.js",
    "mjsunit/track-fields.js",
    "mjsunit/unary-minus-deopt.js",
    "mjsunit/unbox-double-arrays.js",
    "mjsunit/undetectable-compare.js",
    "mjsunit/undetectable.js",
    "mjsunit/var.js",
    "mjsunit/verify-assert-false.js",
    "mjsunit/verify-check-false.js",
    ### Unsupported Esprima tests ###
    ## select ES6 features ##
    # TODO: de-blacklist the ES6 tests after we have parser support
    "esprima/test_fixtures/ES6/",
    # template literal
    "esprima/test_fixtures/statement/return/multiline_template.js",
    # array pattern
    "esprima/test_fixtures/statement/iteration/pattern-in-for-in.js",
    # let and const
    "esprima/test_fixtures/statement/iteration/invalid-strict-for-in-let.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0138.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0139.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0232.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0140.js",
    ## ES6 end ##
    # Hermes parser does not output tokens.
    "esprima/test_fixtures/tokenize/",
    # Hermes does not emit comments
    "esprima/test_fixtures/comment/",
    # Hermes does not support tolerant parse
    "esprima/test_fixtures/tolerant-parse/",
    # Hermes does not support 'with'
    "esprima/test_fixtures/directive-prolog/migrated_0000.js",
    "esprima/test_fixtures/directive-prolog/migrated_0001.js",
    "esprima/test_fixtures/statement/with/",
    # unsupported features
    "esprima/test_fixtures/ES2016/",
    "esprima/test_fixtures/es2017/",
    "esprima/test_fixtures/es2018/",
    "esprima/test_fixtures/JSX/",
    # Hermes doesn't support unicode regexp
    "esprima/test_fixtures/expression/primary/literal/regular-expression/u-flag-valid-range.js",
    "esprima/test_fixtures/expression/primary/literal/regular-expression/u-flag-surrogate-pair.js",
    # not sure why they fail yet
    "esprima/test_fixtures/statement/iteration/migrated_0003.js",
    "esprima/test_fixtures/expression/unary/migrated_0005.js",
    "esprima/test_fixtures/expression/unary/migrated_0004.js",
    "esprima/test_fixtures/expression/assignment/migrated_0002.js",
    # function declaration vs expression
    "esprima/test_fixtures/statement/labelled/function-declaration.js",
    "esprima/test_fixtures/statement/if/migrated_0003.js",
    # non-octal 09.5
    "esprima/test_fixtures/expression/primary/literal/numeric/migrated_0024.js",
    # These should fail but aren't failing.
    "esprima/test_fixtures/statement/if/invalid-function-declaration3.js",
    "esprima/test_fixtures/statement/if/invalid-function-declaration1.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0221.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0234.js",
    "esprima/test_fixtures/invalid-syntax/GH-1106-08.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0188.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0208.js",
    "esprima/test_fixtures/invalid-syntax/GH-1106-09.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0242.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0233.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0247.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0216.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0187.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0222.js",
    "esprima/test_fixtures/expression/primary/keyword/invalid-escaped-true.js",
    "esprima/test_fixtures/declaration/function/invalid-strict-labelled-function-declaration.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0043.source.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0044.source.js",
    "esprima/test_fixtures/invalid-syntax/migrated_0041.source.js",
    "esprima/test_fixtures/expression/primary/literal/regular-expression/migrated_0006.source.js",
    ### Unsupported Esprima tests end ###
]

# This blacklist is specifically for tests that Hermes never intends to support,
# and so should not be counted in totals for targeting 100% coverage.
PERMANENT_BLACK_LIST = [
    # HTML comments.
    "mjsunit/html-comments.js",
    # Uses Function.toString().
    "mjsunit/fun-name.js",
    # non-standard HTML construction string functions (e.f. "foo".bold()).
    "mjsunit/html-string-funcs.js",
    # Tests v8-specific error messages.
    "mjsunit/function-call.js",
    # Tests v8-specific extension of lookbehinds, not part of ES6.
    "mjsunit/harmony/regexp-lookbehind.js",
    # Tests v8-specific extension of named capture groups, not part of ES6.
    "mjsunit/harmony/regexp-named-captures.js",
    # Tests v8-specific extension of Unicode property classes, not part of ES6.
    "mjsunit/es6/unicode-regexp-backrefs.js",
    "mjsunit/es6/unicode-regexp-last-index.js",
    "mjsunit/es6/unicode-regexp-unanchored-advance.js",
    "mjsunit/harmony/regexp-property-binary.js",
    "mjsunit/harmony/regexp-property-blocks.js",
    "mjsunit/harmony/regexp-property-char-class.js",
    "mjsunit/harmony/regexp-property-enumerated.js",
    "mjsunit/harmony/regexp-property-exact-match.js",
    "mjsunit/harmony/regexp-property-general-category.js",
    "mjsunit/harmony/regexp-property-scripts.js",
    "mjsunit/harmony/regexp-property-special.js",
    # Tests RegExp.compile function which is not part of ES 5 or 6,
    # and is not interesting to implement.
    "mjsunit/regexp-compile.js",
    "mjsunit/string-slices-regexp.js",
    "mjsunit/regress/regress/regress-585775.js",
    "mjsunit/regress/regress-585775.js",
    # annexB
    "mjsunit/es6/string-html.js",
    "mjsunit/function-names.js",
    "test262/test/annexB/built-ins/Date/prototype/toGMTString/value.js",
    "test262/test/annexB/built-ins/String/prototype/anchor/",
    "test262/test/annexB/built-ins/String/prototype/big/",
    "test262/test/annexB/built-ins/String/prototype/blink/",
    "test262/test/annexB/built-ins/String/prototype/bold/",
    "test262/test/annexB/built-ins/String/prototype/fixed/",
    "test262/test/annexB/built-ins/String/prototype/fontcolor/",
    "test262/test/annexB/built-ins/String/prototype/fontsize/",
    "test262/test/annexB/built-ins/String/prototype/italics/",
    "test262/test/annexB/built-ins/String/prototype/link/",
    "test262/test/annexB/built-ins/String/prototype/small/",
    "test262/test/annexB/built-ins/String/prototype/strike/",
    "test262/test/annexB/built-ins/String/prototype/sub/",
    "test262/test/annexB/built-ins/String/prototype/sup/",
    "test262/test/annexB/language/function-code/block-decl",
    "test262/test/annexB/language/function-code/if-decl",
    "test262/test/annexB/language/function-code/if-stmt",
    "test262/test/annexB/language/function-code/switch-case",
    "test262/test/annexB/language/function-code/switch-dflt",
    "test262/test/annexB/language/global-code/block-decl",
    "test262/test/annexB/language/global-code/if-decl",
    "test262/test/annexB/language/global-code/if-stmt",
    "test262/test/annexB/language/global-code/switch-case",
    "test262/test/annexB/language/global-code/switch-dflt",
    "test262/test/annexB/built-ins/RegExp/prototype/compile/",
    "test262/test/annexB/built-ins/escape/escape-above-astral.js",
    "test262/test/annexB/language/comments/multi-line-html-close.js",
    "test262/test/annexB/language/comments/single-line-html-close-asi.js",
    "test262/test/annexB/language/comments/single-line-html-close.js",
    "test262/test/annexB/language/comments/single-line-html-open.js",
    "test262/test/annexB/language/expressions/template-literal/legacy-octal-escape-sequence-non-strict.js",
    "test262/test/language/literals/string/legacy-non-octal-escape-sequence-strict.js",
    "test262/test/annexB/language/expressions/object/__proto__-duplicate-computed.js",
    "test262/test/annexB/language/literals/numeric/non-octal-decimal-integer.js",
    "test262/test/annexB/language/literals/regexp/class-escape.js",
    "test262/test/language/function-code/switch-case-decl-strict.js",
    "test262/test/language/function-code/switch-dflt-decl-strict.js",
    "test262/test/language/global-code/switch-case-decl-strict.js",
    "test262/test/language/global-code/switch-dflt-decl-strict.js",
    # Testing whole feature sets that Hermes doesn't support.
    "test262/test/built-ins/Atomics/",
    "test262/test/built-ins/Proxy/",
    "test262/test/built-ins/Reflect/",
    "test262/test/built-ins/SharedArrayBuffer/",
    "test262/test/built-ins/intl402/",
    "test262/test/intl402/Collator/",
    "test262/test/intl402/Date/",
    "test262/test/intl402/DateTimeFormat/",
    "test262/test/intl402/Intl/",
    "test262/test/intl402/Number/",
    "test262/test/intl402/NumberFormat/",
    "test262/test/intl402/PluralRules/",
    "test262/test/intl402/String/",
    "mjsunit/asm/",
    "mjsunit/regress/wasm/",
    "mjsunit/wasm/",
    "mjsunit/es6/proxies-",
    "mjsunit/es6/proxies.js",
    "mjsunit/es6/reflect-",
    "mjsunit/es6/reflect.js",
]

UNSUPPORTED_FEATURES = [
    "Promise.prototype.finally",
    "Symbol.asyncIterator",
    "Symbol.species",
    "Symbol.unscopables",
    "arrow-function",
    "async",
    "async-functions",
    "async-iteration",
    "caller",
    "class",
    "class-fields",
    "computed-property-names",
    "const",
    "default-arg",
    "default-parameters",
    "destructuring-binding",
    "for-of",
    "generator",
    "generators",
    "let",
    "new.target",
    "object-rest",
    "object-spread",
    "optional-catch-binding",
    "regexp-dotall",
    "regexp-lookbehind",
    "regexp-named-groups",
    "regexp-unicode-property-escapes",
    "super",
    "tail-call-optimization",
    "u180e",
]

PERMANENT_UNSUPPORTED_FEATURES = [
    "Proxy",
    "Reflect",
    "Reflect.construct",
    "Reflect.set",
    "Reflect.setPrototypeOf",
    "Atomics",
    "BigInt",
    "IsHTMLDDA",
    "SharedArrayBuffer",
    "cross-realm",
]

assert len(set(BLACK_LIST)) == len(BLACK_LIST), "Blacklist has duplicates: " + str(
    [item for item, count in collections.Counter(BLACK_LIST).items() if count > 1]
)
