/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the LICENSE
 * file in the root directory of this source tree.
 */
#include "TestFunctions.h"

namespace facebook {
namespace hermes {
namespace synthtest {

const char *nativeSetsConstantTrace() {
  return R"###(
{
  "version": 2,
  "globalObjID": 1,
  "env": {
    "mathRandomSeed": 0,
    "callsToDateNow": [],
    "callsToNewDate": [],
    "callsToDateAsFunction": []
  },
  "trace": [
    {
      "type": "SetPropertyRecord",
      "time": 0,
      "objID": 1,
      "propName": "foo",
      "value": "number:0x4000000000000000"
    },
    {
      "type": "BeginExecJSRecord",
      "time": 0
    },
    {
      "type": "EndExecJSRecord",
      "retval": "undefined:",
      "time": 0
    }
  ]
}
)###";
}

const char *nativeSetsConstantSource() {
  return R"###(
'use strict';

(function(global) {
  // Native code should inject the number 2 into the property name foo on
  // the global object.
  if (global.foo !== 2) {
    throw new Error("Expecting 2, got " + global.foo);
  }
})(this);
)###";
}

} // namespace synthtest
} // namespace hermes
} // namespace facebook
