/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.type;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.type.TypesMap;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.type.MapGeneratorRemapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/build/jetifier/processor/type/LibraryMapGenerator;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "(Lcom/android/tools/build/jetifier/core/config/Config;)V", "remapper", "Lcom/android/tools/build/jetifier/processor/type/MapGeneratorRemapper;", "generateMap", "Lcom/android/tools/build/jetifier/core/type/TypesMap;", "scanFile", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "scanLibrary", "library", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "visit", "archive", "archiveFile", "jetifier-processor"})
public final class LibraryMapGenerator
implements ArchiveItemVisitor {
    private final MapGeneratorRemapper remapper;

    public final void scanLibrary(@NotNull Archive library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        library.accept(this);
    }

    @NotNull
    public final TypesMap generateMap() {
        return this.remapper.createTypesMap();
    }

    @Override
    public void visit(@NotNull Archive archive) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Iterable $receiver$iv = archive.getFiles();
        for (Object element$iv : $receiver$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            it.accept(this);
        }
    }

    @Override
    public void visit(@NotNull ArchiveFile archiveFile) {
        Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
        if (archiveFile.isClassFile()) {
            this.scanFile(archiveFile);
        }
    }

    private final void scanFile(ArchiveFile file) {
        ClassReader reader = new ClassReader(file.getData());
        ClassWriter writer = new ClassWriter(0);
        ClassRemapper visitor = this.remapper.createClassRemapper((ClassVisitor)writer);
        reader.accept((ClassVisitor)visitor, 0);
    }

    public LibraryMapGenerator(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.remapper = new MapGeneratorRemapper(config);
    }
}

