/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import android.widget.ZoomButtonsController;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import microsoft.mappoint.TileSystem;
import org.metalev.multitouch.controller.MultiTouchController;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.api.IMapView;
import org.osmdroid.api.IProjection;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileProviderBasic;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.SimpleInvalidationHandler;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.GeometryMath;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.MapController;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayManager;
import org.osmdroid.views.overlay.TilesOverlay;
import org.osmdroid.views.util.constants.MapViewConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapView
extends ViewGroup
implements IMapView,
MapViewConstants,
MultiTouchController.MultiTouchObjectCanvas<Object> {
    private static final Logger logger = LoggerFactory.getLogger(MapView.class);
    private static final double ZOOM_SENSITIVITY = 1.0;
    private static final double ZOOM_LOG_BASE_INV = 1.0 / Math.log(2.0);
    private static Method sMotionEventTransformMethod;
    private int mZoomLevel = 0;
    private final OverlayManager mOverlayManager;
    private Projection mProjection;
    private final TilesOverlay mMapOverlay;
    private final GestureDetector mGestureDetector;
    private final Scroller mScroller;
    protected boolean mIsFlinging;
    protected final AtomicInteger mTargetZoomLevel = new AtomicInteger();
    protected final AtomicBoolean mIsAnimating = new AtomicBoolean(false);
    protected Integer mMinimumZoomLevel;
    protected Integer mMaximumZoomLevel;
    private final MapController mController;
    private final ZoomButtonsController mZoomController;
    private boolean mEnableZoomController = false;
    private final ResourceProxy mResourceProxy;
    private MultiTouchController<Object> mMultiTouchController;
    protected float mMultiTouchScale = 1.0f;
    protected PointF mMultiTouchScalePoint = new PointF();
    protected MapListener mListener;
    private float mapOrientation = 0.0f;
    private final Matrix mRotateMatrix = new Matrix();
    private final float[] mRotatePoints = new float[2];
    private final Rect mInvalidateRect = new Rect();
    protected BoundingBoxE6 mScrollableAreaBoundingBox;
    protected Rect mScrollableAreaLimit;
    private final MapTileProviderBase mTileProvider;
    private final Handler mTileRequestCompleteHandler;
    private final Point mPoint = new Point();

    protected MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase tileProvider, Handler tileRequestCompleteHandler, AttributeSet attrs) {
        super(context, attrs);
        this.mResourceProxy = resourceProxy;
        this.mController = new MapController(this);
        this.mScroller = new Scroller(context);
        TileSystem.setTileSize(tileSizePixels);
        if (tileProvider == null) {
            ITileSource tileSource = this.getTileSourceFromAttributes(attrs);
            tileProvider = this.isInEditMode() ? new MapTileProviderArray(tileSource, null, new MapTileModuleProviderBase[0]) : new MapTileProviderBasic(context, tileSource);
        }
        this.mTileRequestCompleteHandler = tileRequestCompleteHandler == null ? new SimpleInvalidationHandler((View)this) : tileRequestCompleteHandler;
        this.mTileProvider = tileProvider;
        this.mTileProvider.setTileRequestCompleteHandler(this.mTileRequestCompleteHandler);
        this.mMapOverlay = new TilesOverlay(this.mTileProvider, this.mResourceProxy);
        this.mOverlayManager = new OverlayManager(this.mMapOverlay);
        if (this.isInEditMode()) {
            this.mZoomController = null;
        } else {
            this.mZoomController = new ZoomButtonsController((View)this);
            this.mZoomController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new MapViewZoomListener());
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MapViewGestureDetectorListener());
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new MapViewDoubleClickListener());
    }

    public MapView(Context context, AttributeSet attrs) {
        this(context, 256, new DefaultResourceProxyImpl(context), null, null, attrs);
    }

    public MapView(Context context, int tileSizePixels) {
        this(context, tileSizePixels, new DefaultResourceProxyImpl(context));
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy) {
        this(context, tileSizePixels, resourceProxy, null);
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase aTileProvider) {
        this(context, tileSizePixels, resourceProxy, aTileProvider, null);
    }

    public MapView(Context context, int tileSizePixels, ResourceProxy resourceProxy, MapTileProviderBase aTileProvider, Handler tileRequestCompleteHandler) {
        this(context, tileSizePixels, resourceProxy, aTileProvider, tileRequestCompleteHandler, null);
    }

    @Override
    public IMapController getController() {
        return this.mController;
    }

    public List<Overlay> getOverlays() {
        return this.getOverlayManager();
    }

    public OverlayManager getOverlayManager() {
        return this.mOverlayManager;
    }

    public MapTileProviderBase getTileProvider() {
        return this.mTileProvider;
    }

    public Scroller getScroller() {
        return this.mScroller;
    }

    public Handler getTileRequestCompleteHandler() {
        return this.mTileRequestCompleteHandler;
    }

    @Override
    public int getLatitudeSpan() {
        return this.getBoundingBox().getLatitudeSpanE6();
    }

    @Override
    public int getLongitudeSpan() {
        return this.getBoundingBox().getLongitudeSpanE6();
    }

    public BoundingBoxE6 getBoundingBox() {
        return this.getBoundingBox(this.getWidth(), this.getHeight());
    }

    public BoundingBoxE6 getBoundingBox(int pViewWidth, int pViewHeight) {
        int world_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        Rect screenRect = this.getScreenRect(null);
        screenRect.offset(world_2, world_2);
        GeoPoint neGeoPoint = TileSystem.PixelXYToLatLong(screenRect.right, screenRect.top, this.mZoomLevel, null);
        GeoPoint swGeoPoint = TileSystem.PixelXYToLatLong(screenRect.left, screenRect.bottom, this.mZoomLevel, null);
        return new BoundingBoxE6(neGeoPoint.getLatitudeE6(), neGeoPoint.getLongitudeE6(), swGeoPoint.getLatitudeE6(), swGeoPoint.getLongitudeE6());
    }

    public Rect getScreenRect(Rect reuse) {
        Rect out = this.getIntrinsicScreenRect(reuse);
        if (this.getMapOrientation() != 0.0f && this.getMapOrientation() != 180.0f) {
            int centerX = this.getScrollX();
            int centerY = this.getScrollY();
            GeometryMath.getBoundingBoxForRotatatedRectangle(out, centerX, centerY, this.getMapOrientation(), out);
        }
        return out;
    }

    public Rect getIntrinsicScreenRect(Rect reuse) {
        Rect out = reuse == null ? new Rect() : reuse;
        out.set(this.getScrollX() - this.getWidth() / 2, this.getScrollY() - this.getHeight() / 2, this.getScrollX() + this.getWidth() / 2, this.getScrollY() + this.getHeight() / 2);
        return out;
    }

    @Override
    public Projection getProjection() {
        if (this.mProjection == null) {
            this.mProjection = new Projection();
        }
        return this.mProjection;
    }

    void setMapCenter(IGeoPoint aCenter) {
        this.getController().animateTo(aCenter);
    }

    void setMapCenter(int aLatitudeE6, int aLongitudeE6) {
        this.setMapCenter(new GeoPoint(aLatitudeE6, aLongitudeE6));
    }

    public void setTileSource(ITileSource aTileSource) {
        this.mTileProvider.setTileSource(aTileSource);
        TileSystem.setTileSize(aTileSource.getTileSizePixels());
        this.checkZoomButtons();
        this.setZoomLevel(this.mZoomLevel);
        this.postInvalidate();
    }

    int setZoomLevel(int aZoomLevel) {
        int curZoomLevel;
        int maxZoomLevel;
        int minZoomLevel = this.getMinZoomLevel();
        int newZoomLevel = Math.max(minZoomLevel, Math.min(maxZoomLevel = this.getMaxZoomLevel(), aZoomLevel));
        if (newZoomLevel != (curZoomLevel = this.mZoomLevel)) {
            this.mScroller.forceFinished(true);
            this.mIsFlinging = false;
        }
        this.mZoomLevel = newZoomLevel;
        this.checkZoomButtons();
        if (newZoomLevel > curZoomLevel) {
            int worldSize_current_2 = TileSystem.MapSize(curZoomLevel) / 2;
            int worldSize_new_2 = TileSystem.MapSize(newZoomLevel) / 2;
            GeoPoint centerGeoPoint = TileSystem.PixelXYToLatLong(this.getScrollX() + worldSize_current_2, this.getScrollY() + worldSize_current_2, curZoomLevel, null);
            Point centerPoint = TileSystem.LatLongToPixelXY(centerGeoPoint.getLatitude(), centerGeoPoint.getLongitude(), newZoomLevel, null);
            this.scrollTo(centerPoint.x - worldSize_new_2, centerPoint.y - worldSize_new_2);
        } else if (newZoomLevel < curZoomLevel) {
            this.scrollTo(this.getScrollX() >> curZoomLevel - newZoomLevel, this.getScrollY() >> curZoomLevel - newZoomLevel);
        }
        Point snapPoint = new Point();
        this.mProjection = new Projection();
        if (this.getOverlayManager().onSnapToItem(this.getScrollX(), this.getScrollY(), snapPoint, this)) {
            this.scrollTo(snapPoint.x, snapPoint.y);
        }
        this.mTileProvider.rescaleCache(newZoomLevel, curZoomLevel, this.getScreenRect(null));
        if (newZoomLevel != curZoomLevel && this.mListener != null) {
            ZoomEvent event = new ZoomEvent(this, newZoomLevel);
            this.mListener.onZoom(event);
        }
        this.requestLayout();
        return this.mZoomLevel;
    }

    public void zoomToBoundingBox(BoundingBoxE6 boundingBox) {
        BoundingBoxE6 currentBox = this.getBoundingBox();
        double maxZoomLatitudeSpan = this.mZoomLevel == this.getMaxZoomLevel() ? (double)currentBox.getLatitudeSpanE6() : (double)currentBox.getLatitudeSpanE6() / Math.pow(2.0, this.getMaxZoomLevel() - this.mZoomLevel);
        double requiredLatitudeZoom = (double)this.getMaxZoomLevel() - Math.ceil(Math.log((double)boundingBox.getLatitudeSpanE6() / maxZoomLatitudeSpan) / Math.log(2.0));
        double maxZoomLongitudeSpan = this.mZoomLevel == this.getMaxZoomLevel() ? (double)currentBox.getLongitudeSpanE6() : (double)currentBox.getLongitudeSpanE6() / Math.pow(2.0, this.getMaxZoomLevel() - this.mZoomLevel);
        double requiredLongitudeZoom = (double)this.getMaxZoomLevel() - Math.ceil(Math.log((double)boundingBox.getLongitudeSpanE6() / maxZoomLongitudeSpan) / Math.log(2.0));
        this.getController().setZoom((int)(requiredLatitudeZoom < requiredLongitudeZoom ? requiredLatitudeZoom : requiredLongitudeZoom));
        this.getController().setCenter(new GeoPoint(boundingBox.getCenter().getLatitudeE6(), boundingBox.getCenter().getLongitudeE6()));
    }

    @Override
    public int getZoomLevel() {
        return this.getZoomLevel(true);
    }

    public int getZoomLevel(boolean aPending) {
        if (aPending && this.isAnimating()) {
            return this.mTargetZoomLevel.get();
        }
        return this.mZoomLevel;
    }

    public int getMinZoomLevel() {
        return this.mMinimumZoomLevel == null ? this.mMapOverlay.getMinimumZoomLevel() : this.mMinimumZoomLevel.intValue();
    }

    @Override
    public int getMaxZoomLevel() {
        return this.mMaximumZoomLevel == null ? this.mMapOverlay.getMaximumZoomLevel() : this.mMaximumZoomLevel.intValue();
    }

    public void setMinZoomLevel(Integer zoomLevel) {
        this.mMinimumZoomLevel = zoomLevel;
    }

    public void setMaxZoomLevel(Integer zoomLevel) {
        this.mMaximumZoomLevel = zoomLevel;
    }

    public boolean canZoomIn() {
        int maxZoomLevel = this.getMaxZoomLevel();
        return (this.isAnimating() ? this.mTargetZoomLevel.get() : this.mZoomLevel) < maxZoomLevel;
    }

    public boolean canZoomOut() {
        int minZoomLevel = this.getMinZoomLevel();
        return (this.isAnimating() ? this.mTargetZoomLevel.get() : this.mZoomLevel) > minZoomLevel;
    }

    boolean zoomIn() {
        return this.getController().zoomIn();
    }

    boolean zoomInFixing(IGeoPoint point) {
        Point coords = this.getProjection().toMapPixels(point, null);
        return this.getController().zoomInFixing(coords.x, coords.y);
    }

    boolean zoomInFixing(int xPixel, int yPixel) {
        return this.getController().zoomInFixing(xPixel, yPixel);
    }

    boolean zoomOut() {
        return this.getController().zoomOut();
    }

    boolean zoomOutFixing(IGeoPoint point) {
        Point coords = this.getProjection().toMapPixels(point, null);
        return this.zoomOutFixing(coords.x, coords.y);
    }

    boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.getController().zoomOutFixing(xPixel, yPixel);
    }

    @Override
    public IGeoPoint getMapCenter() {
        int world_2 = TileSystem.MapSize(this.mZoomLevel) / 2;
        Rect screenRect = this.getScreenRect(null);
        screenRect.offset(world_2, world_2);
        return TileSystem.PixelXYToLatLong(screenRect.centerX(), screenRect.centerY(), this.mZoomLevel, null);
    }

    public ResourceProxy getResourceProxy() {
        return this.mResourceProxy;
    }

    public void setMapOrientation(float degrees) {
        this.mapOrientation = degrees % 360.0f;
        this.invalidate();
    }

    public float getMapOrientation() {
        return this.mapOrientation;
    }

    public boolean useDataConnection() {
        return this.mMapOverlay.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mMapOverlay.setUseDataConnection(aMode);
    }

    public void setScrollableAreaLimit(BoundingBoxE6 boundingBox) {
        int worldSize_2 = TileSystem.MapSize(22) / 2;
        this.mScrollableAreaBoundingBox = boundingBox;
        if (boundingBox == null) {
            this.mScrollableAreaLimit = null;
            return;
        }
        Point upperLeft = TileSystem.LatLongToPixelXY((double)boundingBox.getLatNorthE6() / 1000000.0, (double)boundingBox.getLonWestE6() / 1000000.0, 22, null);
        upperLeft.offset(-worldSize_2, -worldSize_2);
        Point lowerRight = TileSystem.LatLongToPixelXY((double)boundingBox.getLatSouthE6() / 1000000.0, (double)boundingBox.getLonEastE6() / 1000000.0, 22, null);
        lowerRight.offset(-worldSize_2, -worldSize_2);
        this.mScrollableAreaLimit = new Rect(upperLeft.x, upperLeft.y, lowerRight.x, lowerRight.y);
    }

    public BoundingBoxE6 getScrollableAreaLimit() {
        return this.mScrollableAreaBoundingBox;
    }

    public void invalidateMapCoordinates(Rect dirty) {
        this.invalidateMapCoordinates(dirty.left, dirty.top, dirty.right, dirty.bottom);
    }

    public void invalidateMapCoordinates(int left, int top, int right, int bottom) {
        this.mInvalidateRect.set(left, top, right, bottom);
        int width_2 = this.getWidth() / 2;
        int height_2 = this.getHeight() / 2;
        int centerX = this.getScrollX();
        int centerY = this.getScrollY();
        if (this.getMapOrientation() != 0.0f) {
            GeometryMath.getBoundingBoxForRotatatedRectangle(this.mInvalidateRect, centerX, centerY, this.getMapOrientation() + 180.0f, this.mInvalidateRect);
        }
        this.mInvalidateRect.offset(width_2, height_2);
        super.invalidate(this.mInvalidateRect);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, null, 8, 0, 0);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            this.getProjection().toMapPixels(lp.geoPoint, this.mPoint);
            int x = this.mPoint.x + this.getWidth() / 2;
            int y = this.mPoint.y + this.getHeight() / 2;
            int childRight = x;
            int childBottom = y;
            switch (lp.alignment) {
                case 1: {
                    childRight = x + childWidth;
                    childBottom = y;
                    break;
                }
                case 2: {
                    childRight = x + childWidth / 2;
                    childBottom = y;
                    break;
                }
                case 3: {
                    childRight = x;
                    childBottom = y;
                    break;
                }
                case 4: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 5: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 6: {
                    childRight = x;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 7: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight;
                    break;
                }
                case 8: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight;
                    break;
                }
                case 9: {
                    childRight = x;
                    childBottom = y + childHeight;
                }
            }
            maxWidth = Math.max(maxWidth, childRight += lp.offsetX);
            maxHeight = Math.max(maxHeight, childBottom += lp.offsetY);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(MapView.resolveSize((int)maxWidth, (int)widthMeasureSpec), MapView.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            this.getProjection().toMapPixels(lp.geoPoint, this.mPoint);
            int x = this.mPoint.x + this.getWidth() / 2;
            int y = this.mPoint.y + this.getHeight() / 2;
            int childLeft = x;
            int childTop = y;
            switch (lp.alignment) {
                case 1: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 2: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 3: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 4: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 5: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 6: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 7: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 8: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 9: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight;
                }
            }
            child.layout(childLeft += lp.offsetX, childTop += lp.offsetY, childLeft + childWidth, childTop + childHeight);
        }
    }

    public void onDetach() {
        this.getOverlayManager().onDetach(this);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyDown(keyCode, event, this);
        return result || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyUp(keyCode, event, this);
        return result || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.getOverlayManager().onTrackballEvent(event, this)) {
            return true;
        }
        this.scrollBy((int)(event.getX() * 25.0f), (int)(event.getY() * 25.0f));
        return super.onTrackballEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mZoomController.isVisible() && this.mZoomController.onTouch((View)this, event)) {
            return true;
        }
        MotionEvent rotatedEvent = this.rotateTouchEvent(event);
        try {
            if (super.dispatchTouchEvent(event)) {
                boolean bl = true;
                return bl;
            }
            if (this.getOverlayManager().onTouchEvent(rotatedEvent, this)) {
                boolean bl = true;
                return bl;
            }
            if (this.mMultiTouchController != null && this.mMultiTouchController.onTouchEvent(event)) {
                boolean bl = true;
                return bl;
            }
            if (this.mGestureDetector.onTouchEvent(rotatedEvent)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rotatedEvent != event) {
                rotatedEvent.recycle();
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    private MotionEvent rotateTouchEvent(MotionEvent ev) {
        if (this.getMapOrientation() == 0.0f) {
            return ev;
        }
        this.mRotateMatrix.setRotate(-this.getMapOrientation(), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        MotionEvent rotatedEvent = MotionEvent.obtain((MotionEvent)ev);
        if (Build.VERSION.SDK_INT < 11) {
            this.mRotatePoints[0] = ev.getX();
            this.mRotatePoints[1] = ev.getY();
            this.mRotateMatrix.mapPoints(this.mRotatePoints);
            rotatedEvent.setLocation(this.mRotatePoints[0], this.mRotatePoints[1]);
        } else {
            try {
                if (sMotionEventTransformMethod == null) {
                    sMotionEventTransformMethod = MotionEvent.class.getDeclaredMethod("transform", Matrix.class);
                }
                sMotionEventTransformMethod.invoke((Object)rotatedEvent, this.mRotateMatrix);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return rotatedEvent;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScroller.isFinished()) {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
                this.setZoomLevel(this.mZoomLevel);
                this.mIsFlinging = false;
            } else {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
    }

    public void scrollTo(int x, int y) {
        int worldSize_2 = TileSystem.MapSize(this.getZoomLevel(false)) / 2;
        while (x < -worldSize_2) {
            x += worldSize_2 * 2;
        }
        while (x > worldSize_2) {
            x -= worldSize_2 * 2;
        }
        while (y < -worldSize_2) {
            y += worldSize_2 * 2;
        }
        while (y > worldSize_2) {
            y -= worldSize_2 * 2;
        }
        if (this.mScrollableAreaLimit != null) {
            int zoomDiff = 22 - this.getZoomLevel(false);
            int minX = this.mScrollableAreaLimit.left >> zoomDiff;
            int minY = this.mScrollableAreaLimit.top >> zoomDiff;
            int maxX = this.mScrollableAreaLimit.right >> zoomDiff;
            int maxY = this.mScrollableAreaLimit.bottom >> zoomDiff;
            int scrollableWidth = maxX - minX;
            int scrollableHeight = maxY - minY;
            int width = this.getWidth();
            int height = this.getHeight();
            if (scrollableWidth <= width) {
                if (x - width / 2 > minX) {
                    x = minX + width / 2;
                } else if (x + width / 2 < maxX) {
                    x = maxX - width / 2;
                }
            } else if (x - width / 2 < minX) {
                x = minX + width / 2;
            } else if (x + width / 2 > maxX) {
                x = maxX - width / 2;
            }
            if (scrollableHeight <= height) {
                if (y - height / 2 > minY) {
                    y = minY + height / 2;
                } else if (y + height / 2 < maxY) {
                    y = maxY - height / 2;
                }
            } else if (y - height / 2 < minY) {
                y = minY + height / 2;
            } else if (y + height / 2 > maxY) {
                y = maxY - height / 2;
            }
        }
        super.scrollTo(x, y);
        if (this.mListener != null) {
            ScrollEvent event = new ScrollEvent(this, x, y);
            this.mListener.onScroll(event);
        }
    }

    @Override
    public void setBackgroundColor(int pColor) {
        this.mMapOverlay.setLoadingBackgroundColor(pColor);
        this.invalidate();
    }

    protected void dispatchDraw(Canvas c) {
        long startMs = System.currentTimeMillis();
        this.mProjection = new Projection();
        c.save();
        c.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        c.scale(this.mMultiTouchScale, this.mMultiTouchScale, this.mMultiTouchScalePoint.x, this.mMultiTouchScalePoint.y);
        c.rotate(this.mapOrientation, this.mProjection.getScreenRect().exactCenterX(), this.mProjection.getScreenRect().exactCenterY());
        this.getOverlayManager().onDraw(c, this);
        c.restore();
        super.dispatchDraw(c);
    }

    public boolean isUsingSafeCanvas() {
        return this.getOverlayManager().isUsingSafeCanvas();
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.getOverlayManager().setUseSafeCanvas(useSafeCanvas);
    }

    protected void onDetachedFromWindow() {
        this.mZoomController.setVisible(false);
        this.onDetach();
        super.onDetachedFromWindow();
    }

    public boolean isAnimating() {
        return this.mIsAnimating.get();
    }

    @Override
    public Object getDraggableObjectAtPoint(MultiTouchController.PointInfo pt) {
        if (this.isAnimating()) {
            return null;
        }
        this.mMultiTouchScalePoint.x = pt.getX() + (float)this.getScrollX() - (float)(this.getWidth() / 2);
        this.mMultiTouchScalePoint.y = pt.getY() + (float)this.getScrollY() - (float)(this.getHeight() / 2);
        return this;
    }

    @Override
    public void getPositionAndScale(Object obj, MultiTouchController.PositionAndScale objPosAndScaleOut) {
        objPosAndScaleOut.set(0.0f, 0.0f, true, this.mMultiTouchScale, false, 0.0f, 0.0f, false, 0.0f);
    }

    @Override
    public void selectObject(Object obj, MultiTouchController.PointInfo pt) {
        if (obj == null && this.mMultiTouchScale != 1.0f) {
            float scaleDiffFloat = (float)(Math.log(this.mMultiTouchScale) * ZOOM_LOG_BASE_INV);
            int scaleDiffInt = Math.round(scaleDiffFloat);
            if (scaleDiffInt != 0) {
                Matrix m = new Matrix();
                m.setScale(1.0f / this.mMultiTouchScale, 1.0f / this.mMultiTouchScale, this.mMultiTouchScalePoint.x, this.mMultiTouchScalePoint.y);
                m.postRotate(-this.mapOrientation, (float)this.mProjection.getScreenRect().centerX(), (float)this.mProjection.getScreenRect().centerY());
                float[] pts = new float[]{this.getScrollX(), this.getScrollY()};
                m.mapPoints(pts);
                this.scrollTo((int)pts[0], (int)pts[1]);
            }
            this.setZoomLevel(this.mZoomLevel + scaleDiffInt);
        }
        this.mMultiTouchScale = 1.0f;
    }

    @Override
    public boolean setPositionAndScale(Object obj, MultiTouchController.PositionAndScale aNewObjPosAndScale, MultiTouchController.PointInfo aTouchPoint) {
        float multiTouchScale = aNewObjPosAndScale.getScale();
        if (multiTouchScale > 1.0f && !this.canZoomIn()) {
            multiTouchScale = 1.0f;
        }
        if (multiTouchScale < 1.0f && !this.canZoomOut()) {
            multiTouchScale = 1.0f;
        }
        this.mMultiTouchScale = multiTouchScale;
        this.invalidate();
        return true;
    }

    public void setMapListener(MapListener ml) {
        this.mListener = ml;
    }

    private void checkZoomButtons() {
        this.mZoomController.setZoomInEnabled(this.canZoomIn());
        this.mZoomController.setZoomOutEnabled(this.canZoomOut());
    }

    public void setBuiltInZoomControls(boolean on) {
        this.mEnableZoomController = on;
        this.checkZoomButtons();
    }

    public void setMultiTouchControls(boolean on) {
        this.mMultiTouchController = on ? new MultiTouchController<Object>(this, false) : null;
    }

    private ITileSource getTileSourceFromAttributes(AttributeSet aAttributeSet) {
        String tileSourceAttr;
        ITileSource tileSource = TileSourceFactory.DEFAULT_TILE_SOURCE;
        if (aAttributeSet != null && (tileSourceAttr = aAttributeSet.getAttributeValue(null, "tilesource")) != null) {
            try {
                ITileSource r = TileSourceFactory.getTileSource(tileSourceAttr);
                logger.info("Using tile source specified in layout attributes: " + r);
                tileSource = r;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid tile source specified in layout attributes: " + tileSource);
            }
        }
        if (aAttributeSet != null && tileSource instanceof IStyledTileSource) {
            String style = aAttributeSet.getAttributeValue(null, "style");
            if (style == null) {
                logger.info("Using default style: 1");
            } else {
                logger.info("Using style specified in layout attributes: " + style);
                ((IStyledTileSource)((Object)tileSource)).setStyle(style);
            }
        }
        logger.info("Using tile source: " + tileSource);
        return tileSource;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int TOP_LEFT = 1;
        public static final int TOP_CENTER = 2;
        public static final int TOP_RIGHT = 3;
        public static final int CENTER_LEFT = 4;
        public static final int CENTER = 5;
        public static final int CENTER_RIGHT = 6;
        public static final int BOTTOM_LEFT = 7;
        public static final int BOTTOM_CENTER = 8;
        public static final int BOTTOM_RIGHT = 9;
        public IGeoPoint geoPoint;
        public int alignment;
        public int offsetX;
        public int offsetY;

        public LayoutParams(int width, int height, IGeoPoint geoPoint, int alignment, int offsetX, int offsetY) {
            super(width, height);
            this.geoPoint = geoPoint != null ? geoPoint : new GeoPoint(0, 0);
            this.alignment = alignment;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.geoPoint = new GeoPoint(0, 0);
            this.alignment = 8;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class MapViewZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private MapViewZoomListener() {
        }

        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                MapView.this.getController().zoomIn();
            } else {
                MapView.this.getController().zoomOut();
            }
        }

        public void onVisibilityChanged(boolean visible) {
        }
    }

    private class MapViewDoubleClickListener
    implements GestureDetector.OnDoubleTapListener {
        private MapViewDoubleClickListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (MapView.this.getOverlayManager().onDoubleTap(e, MapView.this)) {
                return true;
            }
            IGeoPoint center = MapView.this.getProjection().fromPixels(e.getX(), e.getY());
            return MapView.this.zoomInFixing(center);
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return MapView.this.getOverlayManager().onDoubleTapEvent(e, MapView.this);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return MapView.this.getOverlayManager().onSingleTapConfirmed(e, MapView.this);
        }
    }

    private class MapViewGestureDetectorListener
    implements GestureDetector.OnGestureListener {
        private MapViewGestureDetectorListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (MapView.this.mIsFlinging) {
                MapView.this.mScroller.abortAnimation();
                MapView.this.mIsFlinging = false;
            }
            if (MapView.this.getOverlayManager().onDown(e, MapView.this)) {
                return true;
            }
            MapView.this.mZoomController.setVisible(MapView.this.mEnableZoomController);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (MapView.this.getOverlayManager().onFling(e1, e2, velocityX, velocityY, MapView.this)) {
                return true;
            }
            int worldSize = TileSystem.MapSize(MapView.this.getZoomLevel(false));
            MapView.this.mIsFlinging = true;
            MapView.this.mScroller.fling(MapView.this.getScrollX(), MapView.this.getScrollY(), (int)(-velocityX), (int)(-velocityY), -worldSize, worldSize, -worldSize, worldSize);
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (MapView.this.mMultiTouchController != null && MapView.this.mMultiTouchController.isPinching()) {
                return;
            }
            MapView.this.getOverlayManager().onLongPress(e, MapView.this);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (MapView.this.getOverlayManager().onScroll(e1, e2, distanceX, distanceY, MapView.this)) {
                return true;
            }
            MapView.this.scrollBy((int)distanceX, (int)distanceY);
            return true;
        }

        public void onShowPress(MotionEvent e) {
            MapView.this.getOverlayManager().onShowPress(e, MapView.this);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return MapView.this.getOverlayManager().onSingleTapUp(e, MapView.this);
        }
    }

    public class Projection
    implements IProjection,
    GeoConstants {
        private final int viewWidth_2;
        private final int viewHeight_2;
        private final int worldSize_2;
        private final int offsetX;
        private final int offsetY;
        private final BoundingBoxE6 mBoundingBoxProjection;
        private final int mZoomLevelProjection;
        private final Rect mScreenRectProjection;
        private final Rect mIntrinsicScreenRectProjection;
        private final float mMapOrientation;

        private Projection() {
            this.viewWidth_2 = MapView.this.getWidth() / 2;
            this.viewHeight_2 = MapView.this.getHeight() / 2;
            this.worldSize_2 = TileSystem.MapSize(MapView.this.mZoomLevel) / 2;
            this.offsetX = -this.worldSize_2;
            this.offsetY = -this.worldSize_2;
            this.mZoomLevelProjection = MapView.this.mZoomLevel;
            this.mBoundingBoxProjection = MapView.this.getBoundingBox();
            this.mScreenRectProjection = MapView.this.getScreenRect(null);
            this.mIntrinsicScreenRectProjection = MapView.this.getIntrinsicScreenRect(null);
            this.mMapOrientation = MapView.this.getMapOrientation();
        }

        public int getZoomLevel() {
            return this.mZoomLevelProjection;
        }

        public BoundingBoxE6 getBoundingBox() {
            return this.mBoundingBoxProjection;
        }

        public Rect getScreenRect() {
            return this.mScreenRectProjection;
        }

        public Rect getIntrinsicScreenRect() {
            return this.mIntrinsicScreenRectProjection;
        }

        public float getMapOrientation() {
            return this.mMapOrientation;
        }

        @Deprecated
        public int getTileSizePixels() {
            return TileSystem.getTileSize();
        }

        @Deprecated
        public Point getCenterMapTileCoords() {
            Rect rect = this.getScreenRect();
            return TileSystem.PixelXYToTileXY(rect.centerX(), rect.centerY(), null);
        }

        @Deprecated
        public Point getUpperLeftCornerOfCenterMapTile() {
            Point centerMapTileCoords = this.getCenterMapTileCoords();
            return TileSystem.TileXYToPixelXY(centerMapTileCoords.x, centerMapTileCoords.y, null);
        }

        public IGeoPoint fromPixels(float x, float y) {
            Rect screenRect = this.getIntrinsicScreenRect();
            return TileSystem.PixelXYToLatLong(screenRect.left + (int)x + this.worldSize_2, screenRect.top + (int)y + this.worldSize_2, this.mZoomLevelProjection, null);
        }

        public Point fromMapPixels(int x, int y, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            out.set(x - this.viewWidth_2, y - this.viewHeight_2);
            out.offset(MapView.this.getScrollX(), MapView.this.getScrollY());
            return out;
        }

        public Point toMapPixels(IGeoPoint in, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            TileSystem.LatLongToPixelXY(in.getLatitude(), in.getLongitude(), this.getZoomLevel(), out);
            out.offset(this.offsetX, this.offsetY);
            if (Math.abs(out.x - MapView.this.getScrollX()) > Math.abs(out.x - TileSystem.MapSize(this.getZoomLevel()) - MapView.this.getScrollX())) {
                out.x -= TileSystem.MapSize(this.getZoomLevel());
            }
            if (Math.abs(out.x - MapView.this.getScrollX()) > Math.abs(out.x + TileSystem.MapSize(this.getZoomLevel()) - MapView.this.getScrollX())) {
                out.x += TileSystem.MapSize(this.getZoomLevel());
            }
            if (Math.abs(out.y - MapView.this.getScrollY()) > Math.abs(out.y - TileSystem.MapSize(this.getZoomLevel()) - MapView.this.getScrollY())) {
                out.y -= TileSystem.MapSize(this.getZoomLevel());
            }
            if (Math.abs(out.y - MapView.this.getScrollY()) > Math.abs(out.y + TileSystem.MapSize(this.getZoomLevel()) - MapView.this.getScrollY())) {
                out.y += TileSystem.MapSize(this.getZoomLevel());
            }
            return out;
        }

        public Point toMapPixelsProjected(int latituteE6, int longitudeE6, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            TileSystem.LatLongToPixelXY((double)latituteE6 * 1.0E-6, (double)longitudeE6 * 1.0E-6, 22, out);
            return out;
        }

        public Point toMapPixelsTranslated(Point in, Point reuse) {
            Point out = reuse != null ? reuse : new Point();
            int zoomDifference = 22 - this.getZoomLevel();
            out.set((in.x >> zoomDifference) + this.offsetX, (in.y >> zoomDifference) + this.offsetY);
            return out;
        }

        public Rect fromPixelsToProjected(Rect in) {
            Rect result = new Rect();
            int zoomDifference = 22 - this.getZoomLevel();
            int x0 = in.left - this.offsetX << zoomDifference;
            int x1 = in.right - this.offsetX << zoomDifference;
            int y0 = in.bottom - this.offsetY << zoomDifference;
            int y1 = in.top - this.offsetY << zoomDifference;
            result.set(Math.min(x0, x1), Math.min(y0, y1), Math.max(x0, x1), Math.max(y0, y1));
            return result;
        }

        @Deprecated
        public Point toPixels(Point tileCoords, Point reuse) {
            return this.toPixels(tileCoords.x, tileCoords.y, reuse);
        }

        @Deprecated
        public Point toPixels(int tileX, int tileY, Point reuse) {
            return TileSystem.TileXYToPixelXY(tileX, tileY, reuse);
        }

        public Rect toPixels(BoundingBoxE6 pBoundingBoxE6) {
            Rect rect = new Rect();
            Point reuse = new Point();
            this.toMapPixels(new GeoPoint(pBoundingBoxE6.getLatNorthE6(), pBoundingBoxE6.getLonWestE6()), reuse);
            rect.left = reuse.x;
            rect.top = reuse.y;
            this.toMapPixels(new GeoPoint(pBoundingBoxE6.getLatSouthE6(), pBoundingBoxE6.getLonEastE6()), reuse);
            rect.right = reuse.x;
            rect.bottom = reuse.y;
            return rect;
        }

        @Override
        public float metersToEquatorPixels(float meters) {
            return meters / (float)TileSystem.GroundResolution(0.0, this.mZoomLevelProjection);
        }

        @Override
        public IGeoPoint getNorthEast() {
            return this.fromPixels(MapView.this.getWidth(), 0);
        }

        @Override
        public IGeoPoint getSouthWest() {
            return this.fromPixels(0, MapView.this.getHeight());
        }

        @Override
        public Point toPixels(IGeoPoint in, Point out) {
            return this.toMapPixels(in, out);
        }

        @Override
        public IGeoPoint fromPixels(int x, int y) {
            return this.fromPixels((float)x, (float)y);
        }
    }
}

