/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Dns;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;

public final class RouteSelector {
    public static final String TLS_V1 = "TLSv1";
    public static final String SSL_V3 = "SSLv3";
    private final Address address;
    private final URI uri;
    private final ProxySelector proxySelector;
    private final ConnectionPool pool;
    private final Dns dns;
    private final RouteDatabase routeDatabase;
    private Proxy lastProxy;
    private InetSocketAddress lastInetSocketAddress;
    private boolean hasNextProxy;
    private Proxy userSpecifiedProxy;
    private Iterator<Proxy> proxySelectorProxies;
    private InetAddress[] socketAddresses;
    private int nextSocketAddressIndex;
    private int socketPort;
    private String nextTlsVersion;
    private final List<Route> postponedRoutes;

    public RouteSelector(Address address, URI uri, ProxySelector proxySelector, ConnectionPool pool, Dns dns, RouteDatabase routeDatabase) {
        this.address = address;
        this.uri = uri;
        this.proxySelector = proxySelector;
        this.pool = pool;
        this.dns = dns;
        this.routeDatabase = routeDatabase;
        this.postponedRoutes = new LinkedList<Route>();
        this.resetNextProxy(uri, address.getProxy());
    }

    public boolean hasNext() {
        return this.hasNextTlsVersion() || this.hasNextInetSocketAddress() || this.hasNextProxy() || this.hasNextPostponed();
    }

    public Connection next(String method) throws IOException {
        String tlsVersion;
        Route route;
        Connection pooled;
        while ((pooled = this.pool.get(this.address)) != null) {
            if (method.equals("GET") || Internal.instance.isReadable(pooled)) {
                return pooled;
            }
            pooled.getSocket().close();
        }
        if (!this.hasNextTlsVersion()) {
            if (!this.hasNextInetSocketAddress()) {
                if (!this.hasNextProxy()) {
                    if (!this.hasNextPostponed()) {
                        throw new NoSuchElementException();
                    }
                    return new Connection(this.pool, this.nextPostponed());
                }
                this.lastProxy = this.nextProxy();
                this.resetNextInetSocketAddress(this.lastProxy);
            }
            this.lastInetSocketAddress = this.nextInetSocketAddress();
            this.resetNextTlsVersion();
        }
        if (this.routeDatabase.shouldPostpone(route = new Route(this.address, this.lastProxy, this.lastInetSocketAddress, tlsVersion = this.nextTlsVersion()))) {
            this.postponedRoutes.add(route);
            return this.next(method);
        }
        return new Connection(this.pool, route);
    }

    public void connectFailed(Connection connection, IOException failure) {
        if (Internal.instance.recycleCount(connection) > 0) {
            return;
        }
        Route failedRoute = connection.getRoute();
        if (failedRoute.getProxy().type() != Proxy.Type.DIRECT && this.proxySelector != null) {
            this.proxySelector.connectFailed(this.uri, failedRoute.getProxy().address(), failure);
        }
        this.routeDatabase.failed(failedRoute);
        if (!(failure instanceof SSLHandshakeException) && !(failure instanceof SSLProtocolException)) {
            while (this.hasNextTlsVersion()) {
                Route toSuppress = new Route(this.address, this.lastProxy, this.lastInetSocketAddress, this.nextTlsVersion());
                this.routeDatabase.failed(toSuppress);
            }
        }
    }

    private void resetNextProxy(URI uri, Proxy proxy) {
        this.hasNextProxy = true;
        if (proxy != null) {
            this.userSpecifiedProxy = proxy;
        } else {
            List<Proxy> proxyList = this.proxySelector.select(uri);
            if (proxyList != null) {
                this.proxySelectorProxies = proxyList.iterator();
            }
        }
    }

    private boolean hasNextProxy() {
        return this.hasNextProxy;
    }

    private Proxy nextProxy() {
        if (this.userSpecifiedProxy != null) {
            this.hasNextProxy = false;
            return this.userSpecifiedProxy;
        }
        if (this.proxySelectorProxies != null) {
            while (this.proxySelectorProxies.hasNext()) {
                Proxy candidate = this.proxySelectorProxies.next();
                if (candidate.type() == Proxy.Type.DIRECT) continue;
                return candidate;
            }
        }
        this.hasNextProxy = false;
        return Proxy.NO_PROXY;
    }

    private void resetNextInetSocketAddress(Proxy proxy) throws UnknownHostException {
        String socketHost;
        this.socketAddresses = null;
        if (proxy.type() == Proxy.Type.DIRECT) {
            socketHost = this.uri.getHost();
            this.socketPort = Util.getEffectivePort(this.uri);
        } else {
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass());
            }
            InetSocketAddress proxySocketAddress = (InetSocketAddress)proxyAddress;
            socketHost = proxySocketAddress.getHostName();
            this.socketPort = proxySocketAddress.getPort();
        }
        this.socketAddresses = this.dns.getAllByName(socketHost);
        this.nextSocketAddressIndex = 0;
    }

    private boolean hasNextInetSocketAddress() {
        return this.socketAddresses != null;
    }

    private InetSocketAddress nextInetSocketAddress() throws UnknownHostException {
        InetSocketAddress result = new InetSocketAddress(this.socketAddresses[this.nextSocketAddressIndex++], this.socketPort);
        if (this.nextSocketAddressIndex == this.socketAddresses.length) {
            this.socketAddresses = null;
            this.nextSocketAddressIndex = 0;
        }
        return result;
    }

    private void resetNextTlsVersion() {
        this.nextTlsVersion = this.address.getSslSocketFactory() != null ? TLS_V1 : SSL_V3;
    }

    private boolean hasNextTlsVersion() {
        return this.nextTlsVersion != null;
    }

    private String nextTlsVersion() {
        if (this.nextTlsVersion == null) {
            throw new IllegalStateException("No next TLS version");
        }
        if (this.nextTlsVersion.equals(TLS_V1)) {
            this.nextTlsVersion = SSL_V3;
            return TLS_V1;
        }
        if (this.nextTlsVersion.equals(SSL_V3)) {
            this.nextTlsVersion = null;
            return SSL_V3;
        }
        throw new AssertionError();
    }

    private boolean hasNextPostponed() {
        return !this.postponedRoutes.isEmpty();
    }

    private Route nextPostponed() {
        return this.postponedRoutes.remove(0);
    }
}

