/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.NetworkInfo;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.MarkableInputStream;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkBitmapHunter
extends BitmapHunter {
    static final int DEFAULT_RETRY_COUNT = 2;
    private static final int MARKER = 65536;
    private final Downloader downloader;
    int retryCount;

    public NetworkBitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        super(picasso, dispatcher, cache, stats, action);
        this.downloader = downloader;
        this.retryCount = 2;
        if (!Utils.hasPermission(picasso.context, "android.permission.INTERNET")) {
            Picasso.HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    throw new IllegalStateException("INTERNET permission is required.");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bitmap decode(Request data) throws IOException {
        boolean loadFromLocalCacheOnly = this.retryCount == 0;
        Downloader.Response response = this.downloader.load(data.uri, loadFromLocalCacheOnly);
        if (response == null) {
            return null;
        }
        this.loadedFrom = response.cached ? Picasso.LoadedFrom.DISK : Picasso.LoadedFrom.NETWORK;
        Bitmap result = response.getBitmap();
        if (result != null) {
            return result;
        }
        InputStream is = response.getInputStream();
        if (is == null) {
            return null;
        }
        if (response.getContentLength() == 0L) {
            Utils.closeQuietly(is);
            throw new IOException("Received response with 0 content-length header.");
        }
        if (this.loadedFrom == Picasso.LoadedFrom.NETWORK && response.getContentLength() > 0L) {
            this.stats.dispatchDownloadFinished(response.getContentLength());
        }
        try {
            Bitmap bitmap = this.decodeStream(is, data);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    @Override
    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        boolean hasRetries;
        boolean bl = hasRetries = this.retryCount > 0;
        if (!hasRetries) {
            return false;
        }
        --this.retryCount;
        return info == null || info.isConnected();
    }

    @Override
    boolean supportsReplay() {
        return true;
    }

    private Bitmap decodeStream(InputStream stream, Request data) throws IOException {
        Bitmap bitmap;
        MarkableInputStream markStream = new MarkableInputStream(stream);
        stream = markStream;
        long mark = markStream.savePosition(65536);
        BitmapFactory.Options options = NetworkBitmapHunter.createBitmapOptions(data);
        boolean calculateSize = NetworkBitmapHunter.requiresInSampleSize(options);
        boolean isWebPFile = Utils.isWebPFile(stream);
        markStream.reset(mark);
        if (isWebPFile) {
            byte[] bytes = Utils.toByteArray(stream);
            if (calculateSize) {
                BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
                NetworkBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
            }
            return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        if (calculateSize) {
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            NetworkBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
            markStream.reset(mark);
        }
        if ((bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options)) == null) {
            throw new IOException("Failed to decode stream.");
        }
        return bitmap;
    }
}

