/*
 * OpalXmlDumpTest.kt
 *
 * Copyright 2019 Michael Farrell <micolous+git@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package au.id.micolous.metrodroid.test

import au.id.micolous.metrodroid.card.desfire.DesfireCard
import au.id.micolous.metrodroid.serializers.XmlCardFormat
import au.id.micolous.metrodroid.transit.TransitCurrency
import au.id.micolous.metrodroid.transit.opal.OpalData
import au.id.micolous.metrodroid.transit.opal.OpalTransitData
import kotlin.test.Test
import kotlin.test.assertEquals

class OpalXmlDumpTest: CardReaderWithAssetDumpsTest(XmlCardFormat()) {
    @Test
    fun testLitter() {
        /*
         * This is some unregistered transit litter, discarded likely because it was in negative
         * balance.
         *
         * Card number = 3085 2200 7856 2242
         * Balance = -1.82 AUD
         *
         * This card dump contains some additional modifications to test the robustness of the XML
         * parser against types of dumps generated by older versions of Metrodroid and Farebot.
         *
         * See the comment in the file for details.
         */
        setLocale("en-US")
        val c = loadAndParseCard<DesfireCard, OpalTransitData>("opal/opal-transit-litter.xml")
        assertEquals("3085 2200 7856 2242", c.serialNumber)
        assertEquals(TransitCurrency.AUD(-182), c.balance)
        assertEquals(21, c.lastTransactionNumber)
        assertEquals(OpalData.MODE_RAIL, c.lastTransactionMode)
        assertEquals(2, c.weeklyTrips)
    }
}