/*
 * LuhnTest.kt
 *
 * Copyright 2016-2018 Michael Farrell <micolous+git@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package au.id.micolous.metrodroid.test

import au.id.micolous.metrodroid.util.NumberUtils
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertFalse
import kotlin.test.assertTrue

/**
 * Testing the Luhn checksum calculator
 */
class LuhnTest {
    @Test
    fun testValidation() {
        assertTrue(NumberUtils.validateLuhn("14455833625"))
        assertTrue(NumberUtils.validateLuhn("2132023611"))
        assertTrue(NumberUtils.validateLuhn("22278878354"))
        assertTrue(NumberUtils.validateLuhn("16955109885"))
        assertTrue(NumberUtils.validateLuhn("20705769295"))
        assertTrue(NumberUtils.validateLuhn("5141418763"))
        assertTrue(NumberUtils.validateLuhn("13076501629"))
        assertTrue(NumberUtils.validateLuhn("26625862995"))
        assertTrue(NumberUtils.validateLuhn("13622972688"))
        assertTrue(NumberUtils.validateLuhn("11981944561"))
        assertTrue(NumberUtils.validateLuhn("7868205860"))
        assertTrue(NumberUtils.validateLuhn("12769832796"))
        assertTrue(NumberUtils.validateLuhn("13738153843"))
        assertTrue(NumberUtils.validateLuhn("33032358864"))
        assertTrue(NumberUtils.validateLuhn("17675980209"))
        assertTrue(NumberUtils.validateLuhn("17992698740"))
        assertTrue(NumberUtils.validateLuhn("23711490617"))
        assertTrue(NumberUtils.validateLuhn("25099325414"))
        assertTrue(NumberUtils.validateLuhn("32328053437"))
        assertTrue(NumberUtils.validateLuhn("5468460836"))
        assertTrue(NumberUtils.validateLuhn("7326462152"))
        assertTrue(NumberUtils.validateLuhn("20546726827"))
        assertTrue(NumberUtils.validateLuhn("900318908"))
        assertTrue(NumberUtils.validateLuhn("28759945042"))
        assertTrue(NumberUtils.validateLuhn("26024096005"))
        assertTrue(NumberUtils.validateLuhn("32803807406"))
        assertTrue(NumberUtils.validateLuhn("41950380174"))
        assertTrue(NumberUtils.validateLuhn("7144685935"))
        assertTrue(NumberUtils.validateLuhn("200247740"))
        assertTrue(NumberUtils.validateLuhn("3580259228"))
        assertTrue(NumberUtils.validateLuhn("35103155830"))
        assertTrue(NumberUtils.validateLuhn("38832859524"))
        assertTrue(NumberUtils.validateLuhn("15520499730"))
        assertTrue(NumberUtils.validateLuhn("42895092221"))
        assertTrue(NumberUtils.validateLuhn("42445712377"))
        assertTrue(NumberUtils.validateLuhn("23589471772"))
        assertTrue(NumberUtils.validateLuhn("24185368255"))
        assertTrue(NumberUtils.validateLuhn("27584849593"))
        assertTrue(NumberUtils.validateLuhn("14286020574"))
        assertTrue(NumberUtils.validateLuhn("10209508851"))
        assertTrue(NumberUtils.validateLuhn("12103634601"))
        assertTrue(NumberUtils.validateLuhn("9882041909"))
        assertTrue(NumberUtils.validateLuhn("21735085231"))
        assertTrue(NumberUtils.validateLuhn("26734471720"))
        assertTrue(NumberUtils.validateLuhn("660001215"))
        assertTrue(NumberUtils.validateLuhn("34667618408"))
        assertTrue(NumberUtils.validateLuhn("23145570083"))
        assertTrue(NumberUtils.validateLuhn("9885843319"))
        assertTrue(NumberUtils.validateLuhn("7579437711"))
        assertTrue(NumberUtils.validateLuhn("32784123336"))
        assertTrue(NumberUtils.validateLuhn("7847703084"))
        assertTrue(NumberUtils.validateLuhn("21127514533"))
        assertTrue(NumberUtils.validateLuhn("632990271"))
        assertTrue(NumberUtils.validateLuhn("33021014510"))
        assertTrue(NumberUtils.validateLuhn("11666056244"))
        assertTrue(NumberUtils.validateLuhn("35440463616"))
        assertTrue(NumberUtils.validateLuhn("15409942420"))
        assertTrue(NumberUtils.validateLuhn("39828628881"))
        assertTrue(NumberUtils.validateLuhn("16118274394"))
        assertTrue(NumberUtils.validateLuhn("12211164111"))
        assertTrue(NumberUtils.validateLuhn("9604520834"))
        assertTrue(NumberUtils.validateLuhn("22614593253"))
        assertTrue(NumberUtils.validateLuhn("25859215862"))
        assertTrue(NumberUtils.validateLuhn("23067679268"))
        assertTrue(NumberUtils.validateLuhn("28214834377"))
        assertTrue(NumberUtils.validateLuhn("28781966271"))
        assertTrue(NumberUtils.validateLuhn("3811009145"))
        assertTrue(NumberUtils.validateLuhn("25973242313"))
        assertTrue(NumberUtils.validateLuhn("14198135569"))
        assertTrue(NumberUtils.validateLuhn("26997711937"))
        assertTrue(NumberUtils.validateLuhn("24467620969"))
        assertTrue(NumberUtils.validateLuhn("6556551593"))
        assertTrue(NumberUtils.validateLuhn("1557591078"))
        assertTrue(NumberUtils.validateLuhn("27628820907"))
        assertTrue(NumberUtils.validateLuhn("5311479991"))
        assertTrue(NumberUtils.validateLuhn("12002033574"))
        assertTrue(NumberUtils.validateLuhn("32934191498"))
        assertTrue(NumberUtils.validateLuhn("20720982733"))
        assertTrue(NumberUtils.validateLuhn("38009252107"))
        assertTrue(NumberUtils.validateLuhn("33292581635"))
        assertTrue(NumberUtils.validateLuhn("7681531666"))
        assertTrue(NumberUtils.validateLuhn("26341189681"))
        assertTrue(NumberUtils.validateLuhn("22497297667"))
        assertTrue(NumberUtils.validateLuhn("26097655984"))
        assertTrue(NumberUtils.validateLuhn("15925093864"))
        assertTrue(NumberUtils.validateLuhn("3645297643"))
        assertTrue(NumberUtils.validateLuhn("37672018977"))
        assertTrue(NumberUtils.validateLuhn("27585874590"))
        assertTrue(NumberUtils.validateLuhn("5346444127"))
        assertTrue(NumberUtils.validateLuhn("26083423199"))
        assertTrue(NumberUtils.validateLuhn("19272674524"))
        assertTrue(NumberUtils.validateLuhn("7431451645"))
        assertTrue(NumberUtils.validateLuhn("9742753537"))
        assertTrue(NumberUtils.validateLuhn("10462043414"))
        assertTrue(NumberUtils.validateLuhn("8992851777"))
        assertTrue(NumberUtils.validateLuhn("5384023908"))
        assertTrue(NumberUtils.validateLuhn("7618265594"))
        assertTrue(NumberUtils.validateLuhn("34876414250"))
        assertTrue(NumberUtils.validateLuhn("29661424837"))
        assertTrue(NumberUtils.validateLuhn("4531175455"))
    }

    @Test
    fun testInvalidation() {
        assertFalse(NumberUtils.validateLuhn("4139648926"))
        assertFalse(NumberUtils.validateLuhn("1694387920"))
        assertFalse(NumberUtils.validateLuhn("258151280"))
        assertFalse(NumberUtils.validateLuhn("314237730"))
        assertFalse(NumberUtils.validateLuhn("423646643"))
        assertFalse(NumberUtils.validateLuhn("4189231277"))
        assertFalse(NumberUtils.validateLuhn("3941601643"))
        assertFalse(NumberUtils.validateLuhn("3049254051"))
        assertFalse(NumberUtils.validateLuhn("2324038570"))
        assertFalse(NumberUtils.validateLuhn("2318610013"))
        assertFalse(NumberUtils.validateLuhn("3424436428"))
        assertFalse(NumberUtils.validateLuhn("2547597866"))
        assertFalse(NumberUtils.validateLuhn("93214216"))
        assertFalse(NumberUtils.validateLuhn("1118934985"))
        assertFalse(NumberUtils.validateLuhn("2533600774"))
        assertFalse(NumberUtils.validateLuhn("2773955884"))
        assertFalse(NumberUtils.validateLuhn("2586548382"))
        assertFalse(NumberUtils.validateLuhn("319313528"))
        assertFalse(NumberUtils.validateLuhn("3788114908"))
        assertFalse(NumberUtils.validateLuhn("3865367972"))
        assertFalse(NumberUtils.validateLuhn("2379273829"))
        assertFalse(NumberUtils.validateLuhn("1889557132"))
        assertFalse(NumberUtils.validateLuhn("3740082978"))
        assertFalse(NumberUtils.validateLuhn("477182936"))
        assertFalse(NumberUtils.validateLuhn("4079410192"))
        assertFalse(NumberUtils.validateLuhn("242136626"))
        assertFalse(NumberUtils.validateLuhn("3654739564"))
        assertFalse(NumberUtils.validateLuhn("2681152772"))
        assertFalse(NumberUtils.validateLuhn("3543499891"))
        assertFalse(NumberUtils.validateLuhn("2701898946"))
        assertFalse(NumberUtils.validateLuhn("3064898346"))
        assertFalse(NumberUtils.validateLuhn("2086310111"))
        assertFalse(NumberUtils.validateLuhn("315035024"))
        assertFalse(NumberUtils.validateLuhn("403593642"))
        assertFalse(NumberUtils.validateLuhn("1066883963"))
        assertFalse(NumberUtils.validateLuhn("2726445073"))
        assertFalse(NumberUtils.validateLuhn("3937438646"))
        assertFalse(NumberUtils.validateLuhn("2534677247"))
        assertFalse(NumberUtils.validateLuhn("3387630627"))
        assertFalse(NumberUtils.validateLuhn("2006818881"))
        assertFalse(NumberUtils.validateLuhn("4032867810"))
        assertFalse(NumberUtils.validateLuhn("1095257309"))
        assertFalse(NumberUtils.validateLuhn("2841923898"))
        assertFalse(NumberUtils.validateLuhn("1331063085"))
        assertFalse(NumberUtils.validateLuhn("116236061"))
        assertFalse(NumberUtils.validateLuhn("1967204659"))
        assertFalse(NumberUtils.validateLuhn("416070218"))
        assertFalse(NumberUtils.validateLuhn("1057178451"))
        assertFalse(NumberUtils.validateLuhn("3319596230"))
        assertFalse(NumberUtils.validateLuhn("2673774471"))
        assertFalse(NumberUtils.validateLuhn("3963343113"))
        assertFalse(NumberUtils.validateLuhn("936531716"))
        assertFalse(NumberUtils.validateLuhn("382724971"))
        assertFalse(NumberUtils.validateLuhn("904105927"))
        assertFalse(NumberUtils.validateLuhn("1871391278"))
        assertFalse(NumberUtils.validateLuhn("3130081581"))
        assertFalse(NumberUtils.validateLuhn("4059361904"))
        assertFalse(NumberUtils.validateLuhn("3714616229"))
        assertFalse(NumberUtils.validateLuhn("4015708833"))
        assertFalse(NumberUtils.validateLuhn("3519864641"))
        assertFalse(NumberUtils.validateLuhn("2706248333"))
        assertFalse(NumberUtils.validateLuhn("388265254"))
        assertFalse(NumberUtils.validateLuhn("175583925"))
        assertFalse(NumberUtils.validateLuhn("3272693851"))
        assertFalse(NumberUtils.validateLuhn("3296821468"))
        assertFalse(NumberUtils.validateLuhn("4057853413"))
        assertFalse(NumberUtils.validateLuhn("1710156309"))
        assertFalse(NumberUtils.validateLuhn("3823186111"))
        assertFalse(NumberUtils.validateLuhn("3466869908"))
        assertFalse(NumberUtils.validateLuhn("2321599513"))
        assertFalse(NumberUtils.validateLuhn("3057128038"))
        assertFalse(NumberUtils.validateLuhn("953972225"))
        assertFalse(NumberUtils.validateLuhn("395188"))
        assertFalse(NumberUtils.validateLuhn("2078905303"))
        assertFalse(NumberUtils.validateLuhn("1276633190"))
        assertFalse(NumberUtils.validateLuhn("2507894399"))
        assertFalse(NumberUtils.validateLuhn("277038187"))
        assertFalse(NumberUtils.validateLuhn("412128760"))
        assertFalse(NumberUtils.validateLuhn("2943125634"))
        assertFalse(NumberUtils.validateLuhn("776811136"))
        assertFalse(NumberUtils.validateLuhn("3399817169"))
        assertFalse(NumberUtils.validateLuhn("2611010924"))
        assertFalse(NumberUtils.validateLuhn("661442521"))
        assertFalse(NumberUtils.validateLuhn("1215280457"))
        assertFalse(NumberUtils.validateLuhn("2815909804"))
        assertFalse(NumberUtils.validateLuhn("1238511920"))
        assertFalse(NumberUtils.validateLuhn("1308763876"))
    }

    @Test
    fun testCalculation() {
        assertEquals(4, NumberUtils.calculateLuhn("3524280191"))
        assertEquals(7, NumberUtils.calculateLuhn("2162879206"))
        assertEquals(9, NumberUtils.calculateLuhn("468820099"))
        assertEquals(5, NumberUtils.calculateLuhn("1841157647"))
        assertEquals(4, NumberUtils.calculateLuhn("1545923558"))
        assertEquals(8, NumberUtils.calculateLuhn("3505726769"))
        assertEquals(4, NumberUtils.calculateLuhn("1270456073"))
        assertEquals(2, NumberUtils.calculateLuhn("1350238745"))
        assertEquals(5, NumberUtils.calculateLuhn("297648390"))
        assertEquals(6, NumberUtils.calculateLuhn("1843301911"))
        assertEquals(3, NumberUtils.calculateLuhn("855896294"))
        assertEquals(4, NumberUtils.calculateLuhn("1339351812"))
        assertEquals(5, NumberUtils.calculateLuhn("2931244069"))
        assertEquals(0, NumberUtils.calculateLuhn("4293179176"))
        assertEquals(2, NumberUtils.calculateLuhn("1039761808"))
        assertEquals(9, NumberUtils.calculateLuhn("582144696"))
        assertEquals(0, NumberUtils.calculateLuhn("191657718"))
        assertEquals(8, NumberUtils.calculateLuhn("2577191480"))
        assertEquals(1, NumberUtils.calculateLuhn("4272424725"))
        assertEquals(7, NumberUtils.calculateLuhn("1347722771"))
        assertEquals(6, NumberUtils.calculateLuhn("4291357200"))
        assertEquals(5, NumberUtils.calculateLuhn("2367098207"))
        assertEquals(6, NumberUtils.calculateLuhn("3267329712"))
        assertEquals(7, NumberUtils.calculateLuhn("210530659"))
        assertEquals(9, NumberUtils.calculateLuhn("2778144206"))
        assertEquals(9, NumberUtils.calculateLuhn("2702657753"))
        assertEquals(1, NumberUtils.calculateLuhn("1467634285"))
        assertEquals(3, NumberUtils.calculateLuhn("10756416"))
        assertEquals(1, NumberUtils.calculateLuhn("2018745132"))
        assertEquals(8, NumberUtils.calculateLuhn("258813855"))
        assertEquals(0, NumberUtils.calculateLuhn("2045829124"))
        assertEquals(1, NumberUtils.calculateLuhn("2462276418"))
        assertEquals(1, NumberUtils.calculateLuhn("2898416195"))
        assertEquals(8, NumberUtils.calculateLuhn("1406469808"))
        assertEquals(5, NumberUtils.calculateLuhn("485914030"))
        assertEquals(0, NumberUtils.calculateLuhn("3349988592"))
        assertEquals(3, NumberUtils.calculateLuhn("890535187"))
        assertEquals(4, NumberUtils.calculateLuhn("464388418"))
        assertEquals(3, NumberUtils.calculateLuhn("4110810463"))
        assertEquals(5, NumberUtils.calculateLuhn("4089731496"))
        assertEquals(9, NumberUtils.calculateLuhn("1323902639"))
        assertEquals(3, NumberUtils.calculateLuhn("2710573885"))
        assertEquals(6, NumberUtils.calculateLuhn("1902004343"))
        assertEquals(8, NumberUtils.calculateLuhn("4037723041"))
        assertEquals(4, NumberUtils.calculateLuhn("836953707"))
        assertEquals(9, NumberUtils.calculateLuhn("2586413396"))
        assertEquals(9, NumberUtils.calculateLuhn("3157553598"))
        assertEquals(0, NumberUtils.calculateLuhn("4036721495"))
        assertEquals(6, NumberUtils.calculateLuhn("829504720"))
        assertEquals(2, NumberUtils.calculateLuhn("1825557101"))
        assertEquals(9, NumberUtils.calculateLuhn("3195187675"))
        assertEquals(2, NumberUtils.calculateLuhn("1853435002"))
        assertEquals(6, NumberUtils.calculateLuhn("1201030091"))
        assertEquals(7, NumberUtils.calculateLuhn("1549083952"))
        assertEquals(1, NumberUtils.calculateLuhn("3600954721"))
        assertEquals(2, NumberUtils.calculateLuhn("2228034841"))
        assertEquals(8, NumberUtils.calculateLuhn("1846380485"))
        assertEquals(6, NumberUtils.calculateLuhn("3299485817"))
        assertEquals(7, NumberUtils.calculateLuhn("4266356531"))
        assertEquals(4, NumberUtils.calculateLuhn("80494393"))
        assertEquals(1, NumberUtils.calculateLuhn("3338502087"))
        assertEquals(4, NumberUtils.calculateLuhn("1210755169"))
        assertEquals(8, NumberUtils.calculateLuhn("4126449397"))
        assertEquals(0, NumberUtils.calculateLuhn("1362375873"))
        assertEquals(0, NumberUtils.calculateLuhn("3113577816"))
        assertEquals(5, NumberUtils.calculateLuhn("1188635514"))
        assertEquals(1, NumberUtils.calculateLuhn("2946063998"))
        assertEquals(0, NumberUtils.calculateLuhn("1719371154"))
        assertEquals(3, NumberUtils.calculateLuhn("1895514650"))
        assertEquals(4, NumberUtils.calculateLuhn("2080829998"))
        assertEquals(3, NumberUtils.calculateLuhn("3609894519"))
        assertEquals(2, NumberUtils.calculateLuhn("3511856319"))
        assertEquals(5, NumberUtils.calculateLuhn("1952932537"))
        assertEquals(4, NumberUtils.calculateLuhn("1910620955"))
        assertEquals(1, NumberUtils.calculateLuhn("935913671"))
        assertEquals(9, NumberUtils.calculateLuhn("725760186"))
        assertEquals(4, NumberUtils.calculateLuhn("233933984"))
        assertEquals(7, NumberUtils.calculateLuhn("1968137531"))
        assertEquals(7, NumberUtils.calculateLuhn("3437612629"))
        assertEquals(4, NumberUtils.calculateLuhn("3516015717"))
        assertEquals(0, NumberUtils.calculateLuhn("1945185765"))
        assertEquals(7, NumberUtils.calculateLuhn("207931382"))
        assertEquals(3, NumberUtils.calculateLuhn("2373789959"))
        assertEquals(1, NumberUtils.calculateLuhn("3847636398"))
        assertEquals(1, NumberUtils.calculateLuhn("1062556296"))
        assertEquals(1, NumberUtils.calculateLuhn("4085951795"))
        assertEquals(5, NumberUtils.calculateLuhn("2630252765"))
        assertEquals(0, NumberUtils.calculateLuhn("3970196936"))
        assertEquals(4, NumberUtils.calculateLuhn("21259608"))
        assertEquals(7, NumberUtils.calculateLuhn("2238013911"))
        assertEquals(3, NumberUtils.calculateLuhn("1319502209"))
        assertEquals(9, NumberUtils.calculateLuhn("895861044"))
        assertEquals(9, NumberUtils.calculateLuhn("1585306656"))
        assertEquals(9, NumberUtils.calculateLuhn("3367246111"))
        assertEquals(8, NumberUtils.calculateLuhn("903071289"))
        assertEquals(3, NumberUtils.calculateLuhn("2430231960"))
        assertEquals(9, NumberUtils.calculateLuhn("345922272"))
        assertEquals(8, NumberUtils.calculateLuhn("1233909707"))
        assertEquals(5, NumberUtils.calculateLuhn("2553083072"))
        assertEquals(8, NumberUtils.calculateLuhn("3053346265"))
    }
}
