package au.id.micolous.metrodroid.util

object ISO4217 {
    data class CurrencyInfo(val symbol: String, val decimalDigits: Int)
    fun getInfoByCode(code: Int) = codeMap[code]
    private val codeMap = mapOf(
            784 to CurrencyInfo("AED", 2),
            971 to CurrencyInfo("AFN", 2),
            8 to CurrencyInfo("ALL", 2),
            51 to CurrencyInfo("AMD", 2),
            532 to CurrencyInfo("ANG", 2),
            973 to CurrencyInfo("AOA", 2),
            32 to CurrencyInfo("ARS", 2),
            36 to CurrencyInfo("AUD", 2),
            533 to CurrencyInfo("AWG", 2),
            944 to CurrencyInfo("AZN", 2),
            977 to CurrencyInfo("BAM", 2),
            52 to CurrencyInfo("BBD", 2),
            50 to CurrencyInfo("BDT", 2),
            975 to CurrencyInfo("BGN", 2),
            48 to CurrencyInfo("BHD", 3),
            108 to CurrencyInfo("BIF", 0),
            60 to CurrencyInfo("BMD", 2),
            96 to CurrencyInfo("BND", 2),
            68 to CurrencyInfo("BOB", 2),
            984 to CurrencyInfo("BOV", 2),
            986 to CurrencyInfo("BRL", 2),
            44 to CurrencyInfo("BSD", 2),
            64 to CurrencyInfo("BTN", 2),
            72 to CurrencyInfo("BWP", 2),
            933 to CurrencyInfo("BYN", 2),
            974 to CurrencyInfo("BYR", 0),
            84 to CurrencyInfo("BZD", 2),
            124 to CurrencyInfo("CAD", 2),
            976 to CurrencyInfo("CDF", 2),
            947 to CurrencyInfo("CHE", 2),
            756 to CurrencyInfo("CHF", 2),
            948 to CurrencyInfo("CHW", 2),
            990 to CurrencyInfo("CLF", 0),
            152 to CurrencyInfo("CLP", 0),
            156 to CurrencyInfo("CNY", 2),
            170 to CurrencyInfo("COP", 2),
            970 to CurrencyInfo("COU", 2),
            188 to CurrencyInfo("CRC", 2),
            931 to CurrencyInfo("CUC", 2),
            192 to CurrencyInfo("CUP", 2),
            132 to CurrencyInfo("CVE", 2),
            203 to CurrencyInfo("CZK", 2),
            262 to CurrencyInfo("DJF", 0),
            208 to CurrencyInfo("DKK", 2),
            214 to CurrencyInfo("DOP", 2),
            12 to CurrencyInfo("DZD", 2),
            818 to CurrencyInfo("EGP", 2),
            232 to CurrencyInfo("ERN", 2),
            230 to CurrencyInfo("ETB", 2),
            978 to CurrencyInfo("EUR", 2),
            242 to CurrencyInfo("FJD", 2),
            238 to CurrencyInfo("FKP", 2),
            826 to CurrencyInfo("GBP", 2),
            981 to CurrencyInfo("GEL", 2),
            936 to CurrencyInfo("GHS", 2),
            292 to CurrencyInfo("GIP", 2),
            270 to CurrencyInfo("GMD", 2),
            324 to CurrencyInfo("GNF", 0),
            320 to CurrencyInfo("GTQ", 2),
            328 to CurrencyInfo("GYD", 2),
            344 to CurrencyInfo("HKD", 2),
            340 to CurrencyInfo("HNL", 2),
            191 to CurrencyInfo("HRK", 2),
            332 to CurrencyInfo("HTG", 2),
            348 to CurrencyInfo("HUF", 2),
            360 to CurrencyInfo("IDR", 2),
            376 to CurrencyInfo("ILS", 2),
            356 to CurrencyInfo("INR", 2),
            368 to CurrencyInfo("IQD", 3),
            364 to CurrencyInfo("IRR", 2),
            352 to CurrencyInfo("ISK", 0),
            388 to CurrencyInfo("JMD", 2),
            400 to CurrencyInfo("JOD", 3),
            392 to CurrencyInfo("JPY", 0),
            404 to CurrencyInfo("KES", 2),
            417 to CurrencyInfo("KGS", 2),
            116 to CurrencyInfo("KHR", 2),
            174 to CurrencyInfo("KMF", 0),
            408 to CurrencyInfo("KPW", 2),
            410 to CurrencyInfo("KRW", 0),
            414 to CurrencyInfo("KWD", 3),
            136 to CurrencyInfo("KYD", 2),
            398 to CurrencyInfo("KZT", 2),
            418 to CurrencyInfo("LAK", 2),
            422 to CurrencyInfo("LBP", 2),
            144 to CurrencyInfo("LKR", 2),
            430 to CurrencyInfo("LRD", 2),
            426 to CurrencyInfo("LSL", 2),
            440 to CurrencyInfo("LTL", 2),
            434 to CurrencyInfo("LYD", 3),
            504 to CurrencyInfo("MAD", 2),
            498 to CurrencyInfo("MDL", 2),
            969 to CurrencyInfo("MGA", 2),
            807 to CurrencyInfo("MKD", 2),
            104 to CurrencyInfo("MMK", 2),
            496 to CurrencyInfo("MNT", 2),
            446 to CurrencyInfo("MOP", 2),
            478 to CurrencyInfo("MRO", 2),
            929 to CurrencyInfo("MRU", 2),
            480 to CurrencyInfo("MUR", 2),
            462 to CurrencyInfo("MVR", 2),
            454 to CurrencyInfo("MWK", 2),
            484 to CurrencyInfo("MXN", 2),
            979 to CurrencyInfo("MXV", 2),
            458 to CurrencyInfo("MYR", 2),
            943 to CurrencyInfo("MZN", 2),
            516 to CurrencyInfo("NAD", 2),
            566 to CurrencyInfo("NGN", 2),
            558 to CurrencyInfo("NIO", 2),
            578 to CurrencyInfo("NOK", 2),
            524 to CurrencyInfo("NPR", 2),
            554 to CurrencyInfo("NZD", 2),
            512 to CurrencyInfo("OMR", 3),
            590 to CurrencyInfo("PAB", 2),
            604 to CurrencyInfo("PEN", 2),
            598 to CurrencyInfo("PGK", 2),
            608 to CurrencyInfo("PHP", 2),
            586 to CurrencyInfo("PKR", 2),
            985 to CurrencyInfo("PLN", 2),
            600 to CurrencyInfo("PYG", 0),
            634 to CurrencyInfo("QAR", 2),
            946 to CurrencyInfo("RON", 2),
            941 to CurrencyInfo("RSD", 2),
            643 to CurrencyInfo("RUB", 2),
            810 to CurrencyInfo("RUR", 2),
            646 to CurrencyInfo("RWF", 0),
            682 to CurrencyInfo("SAR", 2),
            90 to CurrencyInfo("SBD", 2),
            690 to CurrencyInfo("SCR", 2),
            938 to CurrencyInfo("SDG", 2),
            752 to CurrencyInfo("SEK", 2),
            702 to CurrencyInfo("SGD", 2),
            654 to CurrencyInfo("SHP", 2),
            694 to CurrencyInfo("SLL", 2),
            706 to CurrencyInfo("SOS", 2),
            968 to CurrencyInfo("SRD", 2),
            728 to CurrencyInfo("SSP", 2),
            678 to CurrencyInfo("STD", 2),
            930 to CurrencyInfo("STN", 2),
            222 to CurrencyInfo("SVC", 2),
            760 to CurrencyInfo("SYP", 2),
            748 to CurrencyInfo("SZL", 2),
            764 to CurrencyInfo("THB", 2),
            972 to CurrencyInfo("TJS", 2),
            934 to CurrencyInfo("TMT", 2),
            788 to CurrencyInfo("TND", 3),
            776 to CurrencyInfo("TOP", 2),
            949 to CurrencyInfo("TRY", 2),
            780 to CurrencyInfo("TTD", 2),
            901 to CurrencyInfo("TWD", 2),
            834 to CurrencyInfo("TZS", 2),
            980 to CurrencyInfo("UAH", 2),
            800 to CurrencyInfo("UGX", 0),
            840 to CurrencyInfo("USD", 2),
            997 to CurrencyInfo("USN", 2),
            998 to CurrencyInfo("USS", 2),
            940 to CurrencyInfo("UYI", 0),
            858 to CurrencyInfo("UYU", 2),
            860 to CurrencyInfo("UZS", 2),
            937 to CurrencyInfo("VEF", 2),
            928 to CurrencyInfo("VES", 2),
            704 to CurrencyInfo("VND", 0),
            548 to CurrencyInfo("VUV", 0),
            882 to CurrencyInfo("WST", 2),
            950 to CurrencyInfo("XAF", 0),
            961 to CurrencyInfo("XAG", -1),
            959 to CurrencyInfo("XAU", -1),
            955 to CurrencyInfo("XBA", -1),
            956 to CurrencyInfo("XBB", -1),
            957 to CurrencyInfo("XBC", -1),
            958 to CurrencyInfo("XBD", -1),
            951 to CurrencyInfo("XCD", 2),
            960 to CurrencyInfo("XDR", -1),
            952 to CurrencyInfo("XOF", 0),
            964 to CurrencyInfo("XPD", -1),
            953 to CurrencyInfo("XPF", 0),
            962 to CurrencyInfo("XPT", -1),
            994 to CurrencyInfo("XSU", -1),
            963 to CurrencyInfo("XTS", -1),
            965 to CurrencyInfo("XUA", -1),
            999 to CurrencyInfo("XXX", -1),
            886 to CurrencyInfo("YER", 2),
            710 to CurrencyInfo("ZAR", 2),
            967 to CurrencyInfo("ZMW", 2),
            932 to CurrencyInfo("ZWL", 2)
    )
}