package au.id.micolous.metrodroid.util

object ISO3166 {
    private val numericToAlpha2Map = mapOf(
        20 to "AD",
        784 to "AE",
        4 to "AF",
        28 to "AG",
        660 to "AI",
        8 to "AL",
        51 to "AM",
        530 to "AN",
        24 to "AO",
        10 to "AQ",
        32 to "AR",
        16 to "AS",
        40 to "AT",
        36 to "AU",
        533 to "AW",
        248 to "AX",
        31 to "AZ",
        70 to "BA",
        52 to "BB",
        50 to "BD",
        56 to "BE",
        854 to "BF",
        100 to "BG",
        48 to "BH",
        108 to "BI",
        204 to "BJ",
        652 to "BL",
        60 to "BM",
        96 to "BN",
        68 to "BO",
        535 to "BQ",
        76 to "BR",
        44 to "BS",
        64 to "BT",
        104 to "BU",
        74 to "BV",
        72 to "BW",
        112 to "BY",
        84 to "BZ",
        124 to "CA",
        166 to "CC",
        180 to "CD",
        140 to "CF",
        178 to "CG",
        756 to "CH",
        384 to "CI",
        184 to "CK",
        152 to "CL",
        120 to "CM",
        156 to "CN",
        170 to "CO",
        188 to "CR",
        891 to "CS",
        192 to "CU",
        132 to "CV",
        531 to "CW",
        162 to "CX",
        196 to "CY",
        203 to "CZ",
        276 to "DE",
        262 to "DJ",
        208 to "DK",
        212 to "DM",
        214 to "DO",
        12 to "DZ",
        218 to "EC",
        233 to "EE",
        818 to "EG",
        732 to "EH",
        232 to "ER",
        724 to "ES",
        231 to "ET",
        246 to "FI",
        242 to "FJ",
        238 to "FK",
        583 to "FM",
        234 to "FO",
        250 to "FR",
        249 to "FX",
        266 to "GA",
        826 to "GB",
        308 to "GD",
        268 to "GE",
        254 to "GF",
        831 to "GG",
        288 to "GH",
        292 to "GI",
        304 to "GL",
        270 to "GM",
        324 to "GN",
        312 to "GP",
        226 to "GQ",
        300 to "GR",
        239 to "GS",
        320 to "GT",
        316 to "GU",
        624 to "GW",
        328 to "GY",
        344 to "HK",
        334 to "HM",
        340 to "HN",
        191 to "HR",
        332 to "HT",
        348 to "HU",
        360 to "ID",
        372 to "IE",
        376 to "IL",
        833 to "IM",
        356 to "IN",
        86 to "IO",
        368 to "IQ",
        364 to "IR",
        352 to "IS",
        380 to "IT",
        832 to "JE",
        388 to "JM",
        400 to "JO",
        392 to "JP",
        404 to "KE",
        417 to "KG",
        116 to "KH",
        296 to "KI",
        174 to "KM",
        659 to "KN",
        408 to "KP",
        410 to "KR",
        414 to "KW",
        136 to "KY",
        398 to "KZ",
        418 to "LA",
        422 to "LB",
        662 to "LC",
        438 to "LI",
        144 to "LK",
        430 to "LR",
        426 to "LS",
        440 to "LT",
        442 to "LU",
        428 to "LV",
        434 to "LY",
        504 to "MA",
        492 to "MC",
        498 to "MD",
        499 to "ME",
        663 to "MF",
        450 to "MG",
        584 to "MH",
        807 to "MK",
        466 to "ML",
        104 to "MM",
        496 to "MN",
        446 to "MO",
        580 to "MP",
        474 to "MQ",
        478 to "MR",
        500 to "MS",
        470 to "MT",
        480 to "MU",
        462 to "MV",
        454 to "MW",
        484 to "MX",
        458 to "MY",
        508 to "MZ",
        516 to "NA",
        540 to "NC",
        562 to "NE",
        574 to "NF",
        566 to "NG",
        558 to "NI",
        528 to "NL",
        578 to "NO",
        524 to "NP",
        520 to "NR",
        536 to "NT",
        570 to "NU",
        554 to "NZ",
        512 to "OM",
        591 to "PA",
        604 to "PE",
        258 to "PF",
        598 to "PG",
        608 to "PH",
        586 to "PK",
        616 to "PL",
        666 to "PM",
        612 to "PN",
        630 to "PR",
        275 to "PS",
        620 to "PT",
        585 to "PW",
        600 to "PY",
        634 to "QA",
        638 to "RE",
        642 to "RO",
        688 to "RS",
        643 to "RU",
        646 to "RW",
        682 to "SA",
        90 to "SB",
        690 to "SC",
        729 to "SD",
        752 to "SE",
        246 to "SF",
        702 to "SG",
        654 to "SH",
        705 to "SI",
        744 to "SJ",
        703 to "SK",
        694 to "SL",
        674 to "SM",
        686 to "SN",
        706 to "SO",
        740 to "SR",
        728 to "SS",
        678 to "ST",
        810 to "SU",
        222 to "SV",
        534 to "SX",
        760 to "SY",
        748 to "SZ",
        796 to "TC",
        148 to "TD",
        260 to "TF",
        768 to "TG",
        764 to "TH",
        762 to "TJ",
        772 to "TK",
        626 to "TL",
        795 to "TM",
        788 to "TN",
        776 to "TO",
        626 to "TP",
        792 to "TR",
        780 to "TT",
        798 to "TV",
        158 to "TW",
        834 to "TZ",
        804 to "UA",
        800 to "UG",
        826 to "UK",
        581 to "UM",
        840 to "US",
        858 to "UY",
        860 to "UZ",
        336 to "VA",
        670 to "VC",
        862 to "VE",
        92 to "VG",
        850 to "VI",
        704 to "VN",
        548 to "VU",
        876 to "WF",
        882 to "WS",
        887 to "YE",
        175 to "YT",
        890 to "YU",
        710 to "ZA",
        894 to "ZM",
        180 to "ZR",
        716 to "ZW"
    )

    fun mapNumericToAlpha2(numeric: Int): String? = numericToAlpha2Map[numeric]
}
