package app.fedilab.openmaps.drawer;
/* Copyright 2020 Thomas Schneider
 *
 * This file is a part of OpenMultiMaps
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * OpenMultiMaps is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with OpenMultiMaps; if not,
 * see <http://www.gnu.org/licenses>. */
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

import app.fedilab.openmaps.R;
import app.fedilab.openmaps.entity.Contributor;


public class ContributorsDrawer extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final List<Contributor> contributors;

    public ContributorsDrawer(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from(context);
        return new ViewHolder(layoutInflater.inflate(R.layout.drawer_contributors, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        final Contributor contributor = contributors.get(position);
        final ViewHolder holder = (ViewHolder) viewHolder;

        holder.main_title.setText(contributor.getMain_title());
        holder.project.setText(contributor.getProject());
        holder.map_url.setText(contributor.getMap_url());
        holder.source_code.setText(contributor.getSource_code());
        holder.maintainer.setText(contributor.getMaintainer());
        holder.donations.setText(contributor.getDonations());
        if( contributor.isHasTitle()) {
            holder.main_title.setVisibility(View.VISIBLE);
        }else{
            holder.main_title.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return contributors.size();
    }

    static class ViewHolder extends RecyclerView.ViewHolder {

        TextView main_title, project, map_url, source_code, maintainer, donations;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            main_title = itemView.findViewById(R.id.main_title);
            project = itemView.findViewById(R.id.project);
            map_url = itemView.findViewById(R.id.map_url);
            source_code = itemView.findViewById(R.id.source_code);
            maintainer = itemView.findViewById(R.id.maintainer);
            donations = itemView.findViewById(R.id.donations);
        }
    }
}
