/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.jupiter.api.Test;

public class TabelWrapLayoutParametersTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newText = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        layout.command_CREATE(newText, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("TableWrapLayout.enableGrab", false);
            ControlInfo newText = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
            layout.command_CREATE(newText, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newTable = BTestUtils.createControl("org.eclipse.swt.widgets.Table");
        layout.command_CREATE(newTable, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Table table = new Table(this, SWT.BORDER | SWT.FULL_SELECTION);", "      table.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB, 1, 1));", "      table.setHeaderVisible(true);", "      table.setLinesVisible(true);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newLabel = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        layout.command_CREATE(newLabel, 0, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP, 1, 1));", "      label.setText('New Label');", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("TableWrapLayout.enableRightAlignment", false);
            ControlInfo newLabel = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
            layout.command_CREATE(newLabel, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('New Label');", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_CREATE_TextAfterLabel() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newText = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        layout.command_CREATE(newText, 1, false, 0, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP, 1, 1));", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));", "    }", "  }", "}");
    }
}

