/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class CopyActionTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noSelection() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t}\n\t// filler filler filler\n}");
        IAction copyAction = this.getCopyAction();
        this.canvas.select(new Object[0]);
        CopyActionTest.assertFalse((boolean)copyAction.isEnabled());
    }

    @Test
    public void test_thisSelection() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t}\n\t// filler filler filler\n}");
        IAction copyAction = this.getCopyAction();
        this.canvas.select(panel);
        CopyActionTest.assertFalse((boolean)copyAction.isEnabled());
    }

    @Test
    public void test_copySingle() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton btn = new JButton();\n\t\t\tadd(btn);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(button);
        IAction copyAction = this.getCopyAction();
        CopyActionTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        CopyActionTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        EditPart targetEditPart = this.m_contentEditPart;
        this.canvas.moveTo((Object)targetEditPart, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton btn = new JButton();\n\t\t\tadd(btn);\n\t\t}\n\t\t{\n\t\t\tJButton btn = new JButton();\n\t\t\tadd(btn);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_copyParentAndItsChild() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.select(inner, button);
        IAction copyAction = this.getCopyAction();
        CopyActionTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        CopyActionTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        EditPart targetEditPart = this.m_contentEditPart;
        this.canvas.moveTo((Object)targetEditPart, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }
}

