/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.EnumCustomPropertyEditor;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class EnumCustomPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_configure_withClass() throws Exception {
        EnumCustomPropertyEditor editor = new EnumCustomPropertyEditor();
        editor.configure(MyEnum.class);
        EnumCustomPropertyEditorTest.assertSame(MyEnum.class, (Object)ReflectionUtils.getFieldObject((Object)editor, (String)"m_class"));
        Enum[] enumValues = (MyEnum[])ReflectionUtils.invokeMethod2((Object)editor, (String)"getElements", Property.class, null);
        Object[] enumStrings = GenericsUtils.getEnumStrings((Enum[])enumValues);
        EnumCustomPropertyEditorTest.assertArrayEquals((Object[])enumStrings, (Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void test_configure_withElements() throws Exception {
        EnumCustomPropertyEditor editor = new EnumCustomPropertyEditor();
        editor.configure((Enum[])new MyEnum[]{MyEnum.A, MyEnum.C});
        EnumCustomPropertyEditorTest.assertSame(MyEnum.class, (Object)ReflectionUtils.getFieldObject((Object)editor, (String)"m_class"));
        Enum[] enumValues = (MyEnum[])ReflectionUtils.invokeMethod2((Object)editor, (String)"getElements", Property.class, null);
        Object[] enumStrings = GenericsUtils.getEnumStrings((Enum[])enumValues);
        EnumCustomPropertyEditorTest.assertArrayEquals((Object[])enumStrings, (Object[])new String[]{"A", "C"});
    }

    private static enum MyEnum {
        A,
        B,
        C;

    }
}

