/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;

public final class PlaceholderUtils {
    private static String KEY_EXCEPTIONS = PlaceholderUtils.class.getName() + ".exceptions";
    private static String KEY_PLACEHOLDER = PlaceholderUtils.class.getName() + ".placeholder";

    private PlaceholderUtils() {
    }

    public static boolean isPlaceholder(JavaInfo javaInfo) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        return PlaceholderUtils.isPlaceholder(node);
    }

    public static List<Throwable> getExceptions(JavaInfo javaInfo) {
        ASTNode node = javaInfo.getCreationSupport().getNode();
        return PlaceholderUtils.getExceptions(node);
    }

    public static List<Throwable> getExceptions(ASTNode node) {
        List<Throwable> exceptions = PlaceholderUtils.getExceptions0(node);
        return exceptions != null ? exceptions : Collections.emptyList();
    }

    public static void clear(ASTNode node) {
        node.setProperty(KEY_EXCEPTIONS, null);
        node.setProperty(KEY_PLACEHOLDER, null);
    }

    public static void addException(ASTNode node, Throwable e) {
        List<Throwable> exceptions = PlaceholderUtils.getExceptions0(node);
        if (exceptions == null) {
            exceptions = new ArrayList<Throwable>();
            node.setProperty(KEY_EXCEPTIONS, exceptions);
        }
        exceptions.add(e);
    }

    private static List<Throwable> getExceptions0(ASTNode node) {
        return (List)node.getProperty(KEY_EXCEPTIONS);
    }

    public static boolean isPlaceholder(ASTNode node) {
        return node != null && node.getProperty(KEY_PLACEHOLDER) == Boolean.TRUE;
    }

    public static void markPlaceholder(ASTNode node) {
        node.setProperty(KEY_PLACEHOLDER, (Object)Boolean.TRUE);
    }
}

