/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.eval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class ExecutionFlowUtils2 {
    private static final String STAMP_AST = "ExecutionFlowUtils2.cache_stampAST";
    private static final String STAMP_FLOW = "ExecutionFlowUtils2.cache_stampFlow";
    private static final String KEY_VALUE = "ExecutionFlowUtils2.ExpressionValue";
    private static final String KEY_VALUE_PREV = "ExecutionFlowUtils2.ExpressionValue.prev";
    private static final String KEY_VALUE_PERMANENT = "ExecutionFlowUtils2.ExpressionValue.permanent";
    private static final String KEY_VALUE_ASSIGNMENT = "ExecutionFlowUtils2.ExpressionValue.assigmnent";

    private ExecutionFlowUtils2() {
    }

    public static void setValue0(Expression expression, ExpressionValue value) {
        expression.setProperty(KEY_VALUE, (Object)value);
    }

    public static ExpressionValue getValue0(Expression expression) {
        ExpressionValue value = (ExpressionValue)expression.getProperty(KEY_VALUE);
        if (value == null) {
            value = (ExpressionValue)expression.getProperty(KEY_VALUE_PERMANENT);
        }
        return value;
    }

    public static void setPermanentValue0(Expression expression, ExpressionValue value) {
        expression.setProperty(KEY_VALUE_PERMANENT, (Object)value);
    }

    public static List<Assignment> getAssignmentValue0(Expression expression) {
        List assignments = (List)expression.getProperty(KEY_VALUE_ASSIGNMENT);
        if (assignments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(assignments);
    }

    public static ExpressionValue getPermanentValue0(Expression expression) {
        return (ExpressionValue)expression.getProperty(KEY_VALUE_PERMANENT);
    }

    public static ExpressionValue ensurePermanentValue(Expression expression) {
        ExpressionValue value = (ExpressionValue)expression.getProperty(KEY_VALUE);
        if (value == null) {
            value = new ExpressionValue(expression);
        }
        expression.setProperty(KEY_VALUE_PERMANENT, (Object)value);
        return value;
    }

    public static void clearPermanentValue(Expression expression) {
        ExpressionValue value = (ExpressionValue)expression.getProperty(KEY_VALUE_PERMANENT);
        if (value != null) {
            value.setModel(null);
            expression.setProperty(KEY_VALUE_PERMANENT, null);
        }
    }

    public static ExpressionValue getValue(ExecutionFlowDescription flowDescription, Expression expression) {
        ExecutionFlowUtils2.ensureValues(flowDescription);
        ExpressionValue value = (ExpressionValue)expression.getProperty(KEY_VALUE);
        if (value == null) {
            value = (ExpressionValue)expression.getProperty(KEY_VALUE_PERMANENT);
        }
        return value;
    }

    public static ExpressionValue getValuePrev(ExecutionFlowDescription flowDescription, Expression expression) {
        ExecutionFlowUtils2.ensureValues(flowDescription);
        return (ExpressionValue)expression.getProperty(KEY_VALUE_PREV);
    }

    public static void ensureValues(ExecutionFlowDescription flowDescription) {
        CompilationUnit rootNode = flowDescription.getCompilationUnit();
        long stampAST = rootNode.getAST().modificationCount();
        long stampFlow = flowDescription.modificationCount();
        Long cache_stampAST = (Long)rootNode.getProperty(STAMP_AST);
        Long cache_stampFlow = (Long)rootNode.getProperty(STAMP_FLOW);
        if (cache_stampAST == null || cache_stampAST != stampAST || cache_stampFlow == null || cache_stampFlow != stampFlow) {
            rootNode.setProperty(STAMP_AST, (Object)stampAST);
            rootNode.setProperty(STAMP_FLOW, (Object)stampFlow);
            ExecutionFlowUtils2.trackValues(flowDescription, (ASTNode)rootNode);
        }
    }

    private static void trackValues(ExecutionFlowDescription flowDescription, ASTNode root) {
        ValuesVisitor visitor = new ValuesVisitor();
        ExecutionFlowUtils.visit(new ExecutionFlowUtils.VisitingContext(true), flowDescription, visitor);
        visitor.whenLeave_type_visitRestMethods();
    }

    private static class Frame {
        private final ASTNode m_node;
        private final Frame m_parent;
        private final Map<String, ExpressionValue> m_variables = new HashMap<String, ExpressionValue>();

        public Frame(ASTNode node, Frame parent) {
            this.m_node = node;
            this.m_parent = parent;
        }

        public ASTNode getNode() {
            return this.m_node;
        }

        public Frame getParent() {
            return this.m_parent;
        }

        public void define(String name, ExpressionValue value) {
            this.m_variables.put(name, value);
        }

        public void setValue(String name, ExpressionValue value) {
            if (this.m_variables.containsKey(name)) {
                this.m_variables.put(name, value);
            } else if (this.m_parent != null) {
                this.m_parent.setValue(name, value);
            }
        }

        public ExpressionValue getValue(String name) {
            ExpressionValue value = this.m_variables.get(name);
            if (value != null) {
                return value;
            }
            if (this.m_parent != null) {
                return this.m_parent.getValue(name);
            }
            return null;
        }
    }

    private static class ValuesVisitor
    extends ExecutionFlowUtils.ExecutionFlowFrameVisitor {
        private Frame m_frame;
        private Frame m_typeFrame;
        private boolean m_ignoreAssignments;
        private final Set<MethodDeclaration> m_visitedMethods = new HashSet<MethodDeclaration>();

        private ValuesVisitor() {
        }

        @Override
        public boolean enterFrame(ASTNode node) {
            this.m_frame = new Frame(node, this.m_frame);
            this.defineMethodParameters(node);
            if (node instanceof TypeDeclaration) {
                this.m_typeFrame = this.m_frame;
            }
            return true;
        }

        @Override
        public void leaveFrame(ASTNode node) {
            this.m_frame = this.m_frame.getParent();
            this.whenLeave_method_rememberVisited(node);
        }

        void whenLeave_type_visitRestMethods() {
            if (this.m_typeFrame != null) {
                this.m_frame = this.m_typeFrame;
                this.m_ignoreAssignments = true;
                TypeDeclaration typeDeclaration = (TypeDeclaration)this.m_typeFrame.getNode();
                MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
                int n = methodDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodDeclaration method = methodDeclarationArray[n2];
                    if (!this.m_visitedMethods.contains(method)) {
                        method.accept((ASTVisitor)this);
                    }
                    ++n2;
                }
            }
        }

        private void whenLeave_method_rememberVisited(ASTNode node) {
            if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                this.m_visitedMethods.add(method);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void defineMethodParameters(ASTNode node) {
            void declaration;
            if (!(node instanceof MethodDeclaration)) {
                return;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            List<SingleVariableDeclaration> parameters = DomGenerics.parameters((MethodDeclaration)declaration);
            String key = "ExecutionFlowUtils.frameInvocation";
            ASTNode invocation = (ASTNode)declaration.getProperty(key);
            if (invocation == null) {
                int i = 0;
                while (i < parameters.size()) {
                    SingleVariableDeclaration parameter = parameters.get(i);
                    this.define((VariableDeclaration)parameter, null);
                    ++i;
                }
                return;
            }
            List<Expression> arguments = DomGenerics.arguments(invocation);
            int i = 0;
            while (i < parameters.size()) {
                SingleVariableDeclaration parameter = parameters.get(i);
                if (arguments.size() > i) {
                    Expression argument = arguments.get(i);
                    this.define((VariableDeclaration)parameter, argument);
                }
                ++i;
            }
        }

        public void endVisit(SimpleName node) {
            String identifier = node.getIdentifier();
            ExpressionValue value = this.m_frame.getValue(identifier);
            if (value != null) {
                node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
        }

        public void endVisit(FieldAccess node) {
            SimpleName variable;
            String identifier;
            ExpressionValue value;
            if (node.getExpression() instanceof ThisExpression && (value = this.m_typeFrame.getValue(identifier = (variable = node.getName()).getIdentifier())) != null) {
                node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
        }

        public void endVisit(ParenthesizedExpression node) {
            Expression expression = node.getExpression();
            ExpressionValue value = this.createValue(expression);
            if (value != null) {
                node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
        }

        public void endVisit(CastExpression node) {
            Expression expression = node.getExpression();
            ExpressionValue value = this.createValue(expression);
            if (value != null) {
                node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
        }

        public void endVisit(MethodInvocation node) {
            MethodDeclaration method = AstNodeUtils.getLocalMethodDeclaration(node);
            if (method != null) {
                ReturnStatement returnStatement;
                Expression expression;
                List<Statement> statements;
                Statement lastStatement;
                LazyVariableSupport.LazyVariableInformation information = LazyVariableSupportUtils.getInformation(method);
                if (information != null) {
                    Expression expression2 = information.getCreation();
                    ExpressionValue value = this.createValue(expression2);
                    if (value != null) {
                        node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
                    }
                    return;
                }
                boolean isLocalStaticFactory = AstNodeUtils.isStatic((BodyDeclaration)method);
                if (!isLocalStaticFactory && (lastStatement = (Statement)GenericsUtils.getLastOrNull(statements = DomGenerics.statements(method))) instanceof ReturnStatement && (expression = (returnStatement = (ReturnStatement)lastStatement).getExpression()) != null) {
                    ExpressionValue value = this.createValue(expression);
                    node.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
                }
            }
        }

        public void endVisit(VariableDeclarationFragment node) {
            this.define((VariableDeclaration)node, node.getInitializer());
        }

        public void endVisit(PostfixExpression node) {
            Expression operand = node.getOperand();
            if (operand instanceof SimpleName) {
                SimpleName variable = (SimpleName)operand;
                String identifier = variable.getIdentifier();
                variable.setProperty(ExecutionFlowUtils2.KEY_VALUE_PREV, (Object)this.m_frame.getValue(identifier));
                ExpressionValue value = this.createValue((Expression)node);
                this.m_frame.setValue(identifier, value);
                variable.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
        }

        public void endVisit(Assignment node) {
            ArrayAccess leftFieldAccess;
            Expression array;
            ExpressionValue value;
            FieldAccess leftFieldAccess2;
            if (this.m_ignoreAssignments) {
                return;
            }
            Expression leftSide = node.getLeftHandSide();
            Expression rightSide = node.getRightHandSide();
            if (leftSide instanceof SimpleName) {
                SimpleName variable = (SimpleName)leftSide;
                String identifier = variable.getIdentifier();
                ExpressionValue value2 = this.createValue(rightSide);
                this.m_frame.setValue(identifier, value2);
                variable.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value2);
            }
            if (leftSide instanceof FieldAccess && (leftFieldAccess2 = (FieldAccess)leftSide).getExpression() instanceof ThisExpression) {
                SimpleName variable = leftFieldAccess2.getName();
                ExpressionValue value3 = this.createValue(rightSide);
                String identifier = variable.getIdentifier();
                this.m_typeFrame.setValue(identifier, value3);
                leftFieldAccess2.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value3);
            }
            if (leftSide instanceof ArrayAccess && (value = ExecutionFlowUtils2.getValue0(array = (leftFieldAccess = (ArrayAccess)leftSide).getArray())) != null) {
                Expression initializer = value.getExpression();
                ArrayList<Assignment> assignments = new ArrayList<Assignment>(ExecutionFlowUtils2.getAssignmentValue0(initializer));
                assignments.add(node);
                initializer.setProperty(ExecutionFlowUtils2.KEY_VALUE_ASSIGNMENT, assignments);
            }
        }

        private void define(VariableDeclaration node, Expression initializer) {
            ExpressionValue value = initializer != null ? this.createValue(initializer) : this.createValue((Expression)node.getName());
            SimpleName variable = node.getName();
            variable.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            String identifier = variable.getIdentifier();
            this.m_frame.define(identifier, value);
        }

        private ExpressionValue createValue(Expression expression) {
            ExpressionValue value = (ExpressionValue)expression.getProperty(ExecutionFlowUtils2.KEY_VALUE);
            if (value == null) {
                value = (ExpressionValue)expression.getProperty(ExecutionFlowUtils2.KEY_VALUE_PERMANENT);
            }
            if (value == null) {
                value = new ExpressionValue(expression);
                expression.setProperty(ExecutionFlowUtils2.KEY_VALUE, (Object)value);
            }
            return value;
        }
    }
}

