/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.group;

import java.awt.FlowLayout;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class GroupLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_set_another_layout_on_GroupLayout_lazyCodeGen() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.GroupLayout.Alignment;\npublic class Test extends JPanel {\n\tprivate JButton button;\n\tpublic Test() {\n\t\tGroupLayout groupLayout = new GroupLayout(this);\n\t\tgroupLayout.setHorizontalGroup(\n\t\t\tgroupLayout.createParallelGroup(Alignment.LEADING)\n\t\t\t\t.addGroup(groupLayout.createSequentialGroup()\n\t\t\t\t\t.addContainerGap()\n\t\t\t\t\t.addComponent(getButton())\n\t\t\t\t\t.addContainerGap(353, Short.MAX_VALUE))\n\t\t);\n\t\tgroupLayout.setVerticalGroup(\n\t\t\tgroupLayout.createParallelGroup(Alignment.LEADING)\n\t\t\t\t.addGroup(groupLayout.createSequentialGroup()\n\t\t\t\t\t.addContainerGap()\n\t\t\t\t\t.addComponent(getButton())\n\t\t\t\t.addContainerGap(259, Short.MAX_VALUE))\n\t\t);\n\t\tsetLayout(groupLayout);\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton(\"New button\");\n\t\t}\n\t\treturn button;\n\t}\n}");
        panel.refresh();
        JavaInfo newLayout = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, FlowLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout((LayoutInfo)newLayout);
        this.assertEditor("import javax.swing.GroupLayout.Alignment;\npublic class Test extends JPanel {\n\tprivate JButton button;\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\tadd(getButton());\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton(\"New button\");\n\t\t}\n\t\treturn button;\n\t}\n}");
    }

    @Test
    public void test_set_another_layout_on_GroupLayout_localVarCodeGen() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.GroupLayout.Alignment;\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tJButton button = new JButton(\"New button\");\n\t\tGroupLayout groupLayout = new GroupLayout(this);\n\t\tgroupLayout.setHorizontalGroup(\n\t\t\tgroupLayout.createParallelGroup(Alignment.LEADING)\n\t\t\t\t.addGroup(groupLayout.createSequentialGroup()\n\t\t\t\t\t.addContainerGap()\n\t\t\t\t\t.addComponent(button)\n\t\t\t\t\t.addContainerGap(353, Short.MAX_VALUE))\n\t\t);\n\t\tgroupLayout.setVerticalGroup(\n\t\t\tgroupLayout.createParallelGroup(Alignment.LEADING)\n\t\t\t\t.addGroup(groupLayout.createSequentialGroup()\n\t\t\t\t\t.addContainerGap()\n\t\t\t\t\t.addComponent(button)\n\t\t\t\t.addContainerGap(259, Short.MAX_VALUE))\n\t\t);\n\t\tsetLayout(groupLayout);\n\t}\n}");
        panel.refresh();
        JavaInfo newLayout = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, FlowLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout((LayoutInfo)newLayout);
        this.assertEditor("import javax.swing.GroupLayout.Alignment;\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\tJButton button = new JButton(\"New button\");\n\t\tadd(button);\n\t}\n}");
    }
}

