/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.jupiter.api.Test;

public class TableWrapDataTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getSmallAlignmentImage() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        try {
            TableWrapDataInfo layoutData = layout.getTableWrapData(button);
            TableWrapDataTest.check_getSmallAlignmentImage(layoutData, true, new int[]{2, 4, 8, 128}, new ImageDescriptor[]{CoreImages.ALIGNMENT_H_SMALL_LEFT, CoreImages.ALIGNMENT_H_SMALL_CENTER, CoreImages.ALIGNMENT_H_SMALL_RIGHT, CoreImages.ALIGNMENT_H_SMALL_FILL});
            TableWrapDataTest.check_getSmallAlignmentImage(layoutData, false, new int[]{16, 32, 64, 128}, new ImageDescriptor[]{CoreImages.ALIGNMENT_V_SMALL_TOP, CoreImages.ALIGNMENT_V_SMALL_CENTER, CoreImages.ALIGNMENT_V_SMALL_BOTTOM, CoreImages.ALIGNMENT_V_SMALL_FILL});
        }
        finally {
            shell.refresh_dispose();
        }
    }

    private static void check_getSmallAlignmentImage(TableWrapDataInfo layoutData, boolean horizontal, int[] alignments, ImageDescriptor[] icons) throws Exception {
        int i = 0;
        while (i < alignments.length) {
            int alignment = alignments[i];
            if (horizontal) {
                layoutData.setHorizontalAlignment(alignment);
            } else {
                layoutData.setVerticalAlignment(alignment);
            }
            TableWrapDataTest.assertSame((Object)icons[i], (Object)layoutData.getSmallAlignmentImageDescriptor(horizontal));
            ++i;
        }
    }

    @Test
    public void test_horizontalAlignment_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        tableWrapData.setHorizontalAlignment(4);
        TableWrapDataTest.assertEquals((int)4, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.CENTER, TableWrapData.TOP));", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(8);
        TableWrapDataTest.assertEquals((int)8, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP));", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(128);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL, TableWrapData.TOP));", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(2);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalAlignment_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.align = TableWrapData.LEFT;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        tableWrapData.setHorizontalAlignment(4);
        TableWrapDataTest.assertEquals((int)4, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.align = TableWrapData.CENTER;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(8);
        TableWrapDataTest.assertEquals((int)8, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.align = TableWrapData.RIGHT;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(128);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.align = TableWrapData.FILL;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setHorizontalAlignment(2);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalGrab() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        tableWrapData.setHorizontalGrab(true);
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setHorizontalGrab(false);
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalFillGrab_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        tableWrapData.setHorizontalGrab(true);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP));", "    }", "  }", "}");
        tableWrapData.setHorizontalGrab(false);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL, TableWrapData.TOP));", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalFillGrab_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        final TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                tableWrapData.setHorizontalAlignment(128);
            }
        });
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP));", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                tableWrapData.setHorizontalAlignment(2);
            }
        });
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalFillGrab_3() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getHorizontalGrab());
        tableWrapData.setHorizontalGrab(true);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getHorizontalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_horizontalSpan_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)1, (int)tableWrapData.getHorizontalSpan());
        tableWrapData.setHorizontalSpan(2);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getHorizontalSpan());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 2));", "    }", "  }", "}");
        tableWrapData.getPropertyByTitle("colspan").setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)1, (int)tableWrapData.getHorizontalSpan());
    }

    @Test
    public void test_verticalAlignment_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalAlignment(32);
        TableWrapDataTest.assertEquals((int)32, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.MIDDLE));", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(64);
        TableWrapDataTest.assertEquals((int)64, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM));", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(128);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL));", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(16);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_verticalAlignment_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.valign = TableWrapData.TOP;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalAlignment(32);
        TableWrapDataTest.assertEquals((int)32, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.valign = TableWrapData.MIDDLE;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(64);
        TableWrapDataTest.assertEquals((int)64, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.valign = TableWrapData.BOTTOM;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(128);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.valign = TableWrapData.FILL;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setVerticalAlignment(16);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_verticalAlignment_3() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalAlignment(32);
        TableWrapDataTest.assertEquals((int)32, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.MIDDLE);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_verticalGrab() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalGrab(true);
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        tableWrapData.setVerticalGrab(false);
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_verticalFillGrab_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL));", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalGrab(true);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL_GRAB));", "    }", "  }", "}");
        tableWrapData.setVerticalGrab(false);
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL));", "    }", "  }", "}");
    }

    @Test
    public void test_verticalFillGrab_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        final TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                tableWrapData.setVerticalAlignment(128);
            }
        });
        TableWrapDataTest.assertEquals((int)128, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL_GRAB));", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                tableWrapData.setVerticalAlignment(16);
            }
        });
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_verticalFillGrab_3() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertFalse((boolean)tableWrapData.getVerticalGrab());
        tableWrapData.setVerticalGrab(true);
        TableWrapDataTest.assertEquals((int)16, (int)tableWrapData.getVerticalAlignment());
        TableWrapDataTest.assertTrue((boolean)tableWrapData.getVerticalGrab());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_verticalSpan_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1));", "    }", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)1, (int)tableWrapData.getVerticalSpan());
        tableWrapData.setVerticalSpan(2);
        TableWrapDataTest.assertEquals((int)2, (int)tableWrapData.getVerticalSpan());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1));", "    }", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        tableWrapData.getPropertyByTitle("rowspan").setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        tableWrapData = layout.getTableWrapData(button);
        TableWrapDataTest.assertEquals((int)1, (int)tableWrapData.getVerticalSpan());
    }

    @Test
    public void test_contextMenu_horizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo layoutData = (TableWrapDataInfo)button.getChildrenJava().get(0);
        TableWrapDataTest.assertNotNull((Object)layoutData);
        MenuManager manager = TableWrapDataTest.getDesignerMenuManager();
        shell.getBroadcastObject().addContextMenu(null, (ObjectInfo)button, (IMenuManager)manager);
        IMenuManager manager2 = TableWrapDataTest.findChildMenuManager((IContributionManager)manager, "Horizontal alignment");
        TableWrapDataTest.assertNotNull((Object)manager2);
        TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space"));
        TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Left"));
        TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Center"));
        TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Right"));
        TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Fill"));
        TableWrapDataTest.assertTrue((boolean)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Left").isChecked());
        TableWrapDataTest.assertFalse((boolean)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Right").isChecked());
        IAction action = TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Right");
        action.setChecked(true);
        action.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP, 1, 1));", "    }", "  }", "}");
        action = TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space");
        action.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_vertical() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        TableWrapDataInfo layoutData = (TableWrapDataInfo)button.getChildrenJava().get(0);
        TableWrapDataTest.assertNotNull((Object)layoutData);
        shell.refresh();
        try {
            MenuManager manager = TableWrapDataTest.getDesignerMenuManager();
            shell.getBroadcastObject().addContextMenu(null, (ObjectInfo)button, (IMenuManager)manager);
            IMenuManager manager2 = TableWrapDataTest.findChildMenuManager((IContributionManager)manager, "Vertical alignment");
            TableWrapDataTest.assertNotNull((Object)manager2);
            TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space"));
            TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Top"));
            TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Middle"));
            TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Bottom"));
            TableWrapDataTest.assertNotNull((Object)TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Fill"));
            IAction action = TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Bottom");
            action.setChecked(true);
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM, 1, 1));", "    }", "  }", "}");
            action = TableWrapDataTest.findChildAction((IContributionManager)manager2, "&Grab excess space");
            action.run();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_deleteIfDefault_constructor0() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData());", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor1_yes() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor1_no() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT));", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor2_yes() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor2_no() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM));", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor4_yes() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteIfDefault_constructor4_no() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1));", "    }", "  }", "}");
        shell.refresh();
        ExecutionUtils.refresh((ObjectInfo)shell);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1));", "    }", "  }", "}");
    }

    @Test
    public void test_hasParentLayout_notCompatible() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new TableWrapData());", "  }", "}");
        TableWrapDataTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new TableWrapData())/}");
        shell.refresh();
        TableWrapDataTest.assertNoErrors((JavaInfo)shell);
    }
}

