/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.context;

import java.util.List;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.SetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.SetBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateSetStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.CheckedElementsObservableInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.jupiter.api.Test;

public class BindSetTest
extends AbstractBindingTest {
    @Test
    public void test_bindSet() throws Exception {
        BindSetTest.setFileContentSrc("test/TestBean.java", BindSetTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTreeViewer m_viewer;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableSet observeWidget = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeWidget, observeSet, null, null);", "    return bindingContext;", "  }", "}"});
        BindSetTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindSetTest.assertNotNull((Object)bindings);
        BindSetTest.assertEquals((int)1, (int)bindings.size());
        BindSetTest.assertInstanceOf(SetBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        BindSetTest.assertNotNull((Object)binding.getTarget());
        BindSetTest.assertNotNull((Object)binding.getTargetProperty());
        BindSetTest.assertNotNull((Object)binding.getTargetObservable());
        BindSetTest.assertSame((Object)binding.getTarget(), (Object)binding.getTargetObservable().getBindableObject());
        BindSetTest.assertSame((Object)binding.getTargetProperty(), (Object)binding.getTargetObservable().getBindableProperty());
        BindSetTest.assertInstanceOf(CheckedElementsObservableInfo.class, (Object)binding.getTargetObservable());
        BindSetTest.assertEquals((Object)"observeWidget", (Object)binding.getTargetObservable().getVariableIdentifier());
        BindSetTest.assertNotNull((Object)binding.getModel());
        BindSetTest.assertNotNull((Object)binding.getModelProperty());
        BindSetTest.assertNotNull((Object)binding.getModelObservable());
        BindSetTest.assertSame((Object)binding.getModel(), (Object)binding.getModelObservable().getBindableObject());
        BindSetTest.assertSame((Object)binding.getModelProperty(), (Object)binding.getModelObservable().getBindableProperty());
        BindSetTest.assertInstanceOf(SetBeanObservableInfo.class, (Object)binding.getModelObservable());
        BindSetTest.assertEquals((Object)"observeSet", (Object)binding.getModelObservable().getVariableIdentifier());
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    @Test
    public void test_strategy_constructors_1() throws Exception {
        this.strategy_constructors("    bindingContext.bindSet(observeWidget, observeSet, new UpdateSetStrategy(), new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER));", UpdateSetStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_constructors_2() throws Exception {
        this.strategy_constructors("    bindingContext.bindSet(observeWidget, observeSet, new UpdateSetStrategy(), new UpdateSetStrategy(UpdateSetStrategy.POLICY_ON_REQUEST));", UpdateSetStrategyInfo.Value.POLICY_ON_REQUEST, "POLICY_ON_REQUEST|POLICY_ON_REQUEST");
    }

    @Test
    public void test_strategy_constructors_3() throws Exception {
        this.strategy_constructors("    bindingContext.bindSet(observeWidget, observeSet, new UpdateSetStrategy(), new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE));", UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
    }

    private void strategy_constructors(String line, Object value, String presentation) throws Exception {
        BindSetTest.setFileContentSrc("test/TestBean.java", BindSetTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTreeViewer m_viewer;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableSet observeWidget = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", line, "    return bindingContext;", "  }", "}"});
        BindSetTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindSetTest.assertNotNull((Object)bindings);
        BindSetTest.assertEquals((int)1, (int)bindings.size());
        BindSetTest.assertInstanceOf(SetBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.IntConstructor, value, presentation);
    }

    @Test
    public void test_strategy_variable() throws Exception {
        BindSetTest.setFileContentSrc("test/TestBean.java", BindSetTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTreeViewer m_viewer;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableSet observeWidget = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateSetStrategy strategy0 = new UpdateSetStrategy();", "    UpdateSetStrategy strategy1 = new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER);", "    bindingContext.bindSet(observeWidget, observeSet, strategy0, strategy1);", "    return bindingContext;", "  }", "}"});
        BindSetTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindSetTest.assertNotNull((Object)bindings);
        BindSetTest.assertEquals((int)1, (int)bindings.size());
        BindSetTest.assertInstanceOf(SetBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), "strategy0", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy1", UpdateStrategyInfo.StrategyType.IntConstructor, UpdateSetStrategyInfo.Value.POLICY_NEVER, "POLICY_NEVER|POLICY_NEVER");
    }

    @Test
    public void test_strategy_extendet() throws Exception {
        this.createModelCompilationUnit("test", "TestStrategy.java", DatabindingTestUtils.getTestSource("public class TestStrategy extends UpdateSetStrategy {", "  public TestStrategy() {", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        BindSetTest.setFileContentSrc("test/TestBean.java", BindSetTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTreeViewer m_viewer;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableSet observeWidget = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeWidget, observeSet, null, new test.TestStrategy());", "    return bindingContext;", "  }", "}"});
        BindSetTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindSetTest.assertNotNull((Object)bindings);
        BindSetTest.assertEquals((int)1, (int)bindings.size());
        BindSetTest.assertInstanceOf(SetBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), null, UpdateStrategyInfo.StrategyType.ExtendetClass, "test.TestStrategy", "test.TestStrategy|test.TestStrategy");
    }

    @Test
    public void test_strategy_converter_1() throws Exception {
        this.strategy_converter("    strategy.setConverter(new TestConverter());", "    //", "null|test.TestConverter|TestConverter");
    }

    @Test
    public void test_strategy_converter_2() throws Exception {
        this.strategy_converter("    TestConverter converter = new TestConverter();", "    strategy.setConverter(converter);", "converter|test.TestConverter|TestConverter");
    }

    private void strategy_converter(String line0, String line1, String testString) throws Exception {
        this.createModelCompilationUnit("test", "TestConverter.java", DatabindingTestUtils.getTestSource("public class TestConverter extends Converter {", "  public TestConverter() {", "    super(null, null);", "  }", "  public Object convert(Object fromObject) {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        BindSetTest.setFileContentSrc("test/TestBean.java", BindSetTest.getSourceDQ("package test;", "public class TestBean {", "  public java.util.Set getNames() {", "    return null;", "  }", "}"));
        BindSetTest.waitForAutoBuild();
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTreeViewer m_viewer;", "  private TestBean m_bean;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet = BeanProperties.set(\"names\").observe(Realm.getDefault(), m_bean);", "    IObservableSet observeWidget = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", "    UpdateSetStrategy strategy = new UpdateSetStrategy();", line0, line1, "    bindingContext.bindSet(observeWidget, observeSet, null, strategy);", "    return bindingContext;", "  }", "}"});
        BindSetTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindSetTest.assertNotNull((Object)bindings);
        BindSetTest.assertEquals((int)1, (int)bindings.size());
        BindSetTest.assertInstanceOf(SetBindingInfo.class, bindings.get(0));
        BindingInfo binding = (BindingInfo)bindings.get(0);
        this.assertStrategy(binding.getTargetStrategy(), null, UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE");
        this.assertStrategy(binding.getModelStrategy(), "strategy", UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, "POLICY_UPDATE|POLICY_UPDATE", testString);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation) throws Exception {
        this.assertStrategy(objectStrategy, variable, type, value, presentation, null);
    }

    private void assertStrategy(Object objectStrategy, String variable, Object type, Object value, String presentation, String converter) throws Exception {
        BindSetTest.assertNotNull((Object)objectStrategy);
        BindSetTest.assertInstanceOf(UpdateSetStrategyInfo.class, (Object)objectStrategy);
        UpdateSetStrategyInfo strategy = (UpdateSetStrategyInfo)objectStrategy;
        if (variable == null) {
            BindSetTest.assertNull((Object)strategy.getVariableIdentifier());
        } else {
            BindSetTest.assertEquals((Object)variable, (Object)strategy.getVariableIdentifier());
        }
        BindSetTest.assertEquals((Object)type, (Object)strategy.getStrategyType());
        BindSetTest.assertEquals((Object)value, (Object)strategy.getStrategyValue());
        BindSetTest.assertEquals((Object)presentation, (Object)(strategy.getStringValue() + "|" + strategy.getPresentationText()));
        if (converter == null) {
            BindSetTest.assertNull((Object)strategy.getConverter());
        } else {
            BindSetTest.assertEquals((Object)converter, (Object)(strategy.getConverter().getVariableIdentifier() + "|" + strategy.getConverter().getClassName() + "|" + strategy.getConverter().getPresentationText()));
        }
    }
}

