/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.reflect;

import java.beans.BeanDescriptor;
import java.beans.Customizer;
import java.beans.SimpleBeanInfo;
import javax.swing.JPanel;
import org.eclipse.wb.internal.core.utils.reflect.IntrospectionHelper;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class IntrospectionHelperTest
extends DesignerTestCase {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getBeanDescriptor_BeanA() throws Exception {
        IntrospectionHelper helper = new IntrospectionHelper(BeanA.class);
        BeanDescriptor beanDescriptor = helper.getBeanDescriptor();
        IntrospectionHelperTest.assertSame(BeanCustomizer.class, beanDescriptor.getCustomizerClass());
        IntrospectionHelperTest.assertSame((Object)Boolean.TRUE, (Object)beanDescriptor.getValue("attr_1"));
    }

    @Test
    public void test_getBeanDescriptor_BeanB() throws Exception {
        IntrospectionHelper helper = new IntrospectionHelper(BeanB.class);
        BeanDescriptor beanDescriptor = helper.getBeanDescriptor();
        IntrospectionHelperTest.assertSame(BeanCustomizer.class, beanDescriptor.getCustomizerClass());
        IntrospectionHelperTest.assertSame((Object)Boolean.TRUE, (Object)beanDescriptor.getValue("attr_1"));
    }

    @Test
    public void test_getBeanDescriptor_BeanC() throws Exception {
        IntrospectionHelper helper = new IntrospectionHelper(BeanC.class);
        BeanDescriptor beanDescriptor = helper.getBeanDescriptor();
        IntrospectionHelperTest.assertSame(BeanCustomizer.class, beanDescriptor.getCustomizerClass());
        IntrospectionHelperTest.assertSame((Object)Boolean.FALSE, (Object)beanDescriptor.getValue("attr_1"));
        IntrospectionHelperTest.assertSame((Object)5, (Object)beanDescriptor.getValue("attr_2"));
    }

    public static class BeanA {
    }

    public static class BeanABeanInfo
    extends SimpleBeanInfo {
        private static final Class<?> beanClass = BeanA.class;
        private static final Class<?> customizerClass = BeanCustomizer.class;

        @Override
        public BeanDescriptor getBeanDescriptor() {
            BeanDescriptor result = new BeanDescriptor(beanClass, customizerClass);
            result.setValue("attr_1", Boolean.TRUE);
            return result;
        }
    }

    public static class BeanB
    extends BeanA {
    }

    public static class BeanC
    extends BeanA {
    }

    public static class BeanCBeanInfo
    extends SimpleBeanInfo {
        private static final Class<?> beanClass = BeanC.class;

        @Override
        public BeanDescriptor getBeanDescriptor() {
            BeanDescriptor result = new BeanDescriptor(beanClass, null);
            result.setValue("attr_1", Boolean.FALSE);
            result.setValue("attr_2", 5);
            return result;
        }
    }

    public static class BeanCustomizer
    extends JPanel
    implements Customizer {
        private static final long serialVersionUID = 0L;

        @Override
        public void setObject(Object bean) {
        }
    }
}

