/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotStyledText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.ExposePropertySupport;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class ExposePropertySupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_validOrInvalidProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IAction action = ExposePropertySupportTest.getExposeAction((JavaInfo)panel, "Class");
        ExposePropertySupportTest.assertNull((Object)action);
        action = ExposePropertySupportTest.getExposeAction((JavaInfo)panel, "enabled");
        ExposePropertySupportTest.assertNotNull((Object)action);
    }

    @Test
    public void test_validate() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  private int getFoo() {return 0;}", "  private void setBar(boolean bar) {}", "}");
        IAction action = ExposePropertySupportTest.getExposeAction((JavaInfo)panel, "enabled");
        String message = ExposePropertySupportTest.call_validate(action, "bad-name");
        ExposePropertySupportTest.assertTrue((boolean)message.contains("identifier"));
        message = ExposePropertySupportTest.call_validate(action, "foo");
        ExposePropertySupportTest.assertTrue((boolean)message.contains("getFoo()"));
        message = ExposePropertySupportTest.call_validate(action, "bar");
        ExposePropertySupportTest.assertTrue((boolean)message.contains("setBar(boolean)"));
        ExposePropertySupportTest.assertNull((Object)ExposePropertySupportTest.call_validate(action, "someUniqueProperty"));
    }

    private static String call_validate(IAction action, String exposedName) throws Exception {
        return (String)ReflectionUtils.invokeMethod((Object)action, (String)"validate(java.lang.String)", (Object[])new Object[]{exposedName});
    }

    @Test
    public void test_getPreviewSource_primitive() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertEquals((Object)ExposePropertySupportTest.getSourceDQ("...", "  public float getButtonAlignmentX() {", "    return button.getAlignmentX();", "  }", "  public void setButtonAlignmentX(float alignmentX) {", "    button.setAlignmentX(alignmentX);", "  }", "..."), (Object)ExposePropertySupportTest.call_getPreview((JavaInfo)button, "alignmentX", "buttonAlignmentX", true));
    }

    @Test
    public void test_getPreviewSource_parameter() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private int alignmentX;", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertEquals((Object)ExposePropertySupportTest.getSourceDQ("...", "  public float getButtonAlignmentX() {", "    return button.getAlignmentX();", "  }", "  public void setButtonAlignmentX(float alignmentX_1) {", "    button.setAlignmentX(alignmentX_1);", "  }", "..."), (Object)ExposePropertySupportTest.call_getPreview((JavaInfo)button, "alignmentX", "buttonAlignmentX", true));
    }

    @Test
    public void test_getPreviewSource_qualified() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertEquals((Object)ExposePropertySupportTest.getSourceDQ("...", "  public String getButtonName() {", "    return button.getName();", "  }", "  public void setButtonName(String name) {", "    button.setName(name);", "  }", "..."), (Object)ExposePropertySupportTest.call_getPreview((JavaInfo)button, "name", "buttonName", true));
    }

    @Test
    public void test_getPreviewSource_qualifiedArray() throws Exception {
        ExposePropertySupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public String[] getItems() {", "    return null;", "  }", "  public void setItems(String[] items) {", "  }", "}"));
        ExposePropertySupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertEquals((Object)ExposePropertySupportTest.getSourceDQ("...", "  public String[] getButtonItems() {", "    return button.getItems();", "  }", "  public void setButtonItems(String[] items) {", "    button.setItems(items);", "  }", "..."), (Object)ExposePropertySupportTest.call_getPreview((JavaInfo)button, "items", "buttonItems", true));
    }

    @Test
    public void test_getPreviewSource_protected() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertEquals((Object)ExposePropertySupportTest.getSourceDQ("...", "  protected String getButtonName() {", "    return button.getName();", "  }", "  protected void setButtonName(String name) {", "    button.setName(name);", "  }", "..."), (Object)ExposePropertySupportTest.call_getPreview((JavaInfo)button, "name", "buttonName", false));
    }

    private static String call_getPreview(JavaInfo component, String propertyName, String exposedName, boolean isPublic) throws Exception {
        String initialSource = component.getEditor().getSource();
        IAction action = ExposePropertySupportTest.getExposeAction(component, propertyName);
        ExposePropertySupportTest.assertNotNull((Object)action);
        ExposePropertySupportTest.assertTrue((boolean)action.isEnabled());
        ExposePropertySupportTest.assertNull((Object)ExposePropertySupportTest.call_validate(action, exposedName));
        String previewSource = (String)ReflectionUtils.invokeMethod2((Object)action, (String)"getPreviewSource", Boolean.TYPE, (Object)isPublic);
        ExposePropertySupportTest.assertEquals((Object)initialSource, (Object)component.getEditor().getSource());
        return previewSource;
    }

    @Test
    public void test_expose_String() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.call_expose((JavaInfo)button, "name", "buttonName", true);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "  public String getButtonName() {", "    return button.getName();", "  }", "  public void setButtonName(String name) {", "    button.setName(name);", "  }", "}");
    }

    @Test
    public void test_expose_StringArray() throws Exception {
        ExposePropertySupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public String[] getItems() {", "    return null;", "  }", "  public void setItems(String[] items) {", "  }", "}"));
        ExposePropertySupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.call_expose((JavaInfo)button, "items", "buttonItems", true);
        this.assertEditor("public class Test extends JPanel {", "  private MyButton button;", "  public Test() {", "    button = new MyButton();", "    add(button);", "  }", "  public String[] getButtonItems() {", "    return button.getItems();", "  }", "  public void setButtonItems(String[] items) {", "    button.setItems(items);", "  }", "}");
    }

    private static void call_expose(JavaInfo component, String propertyName, String exposedName, boolean isPublic) throws Exception {
        IAction action = ExposePropertySupportTest.getExposeAction(component, propertyName);
        ExposePropertySupportTest.assertNull((Object)ExposePropertySupportTest.call_validate(action, exposedName));
        ReflectionUtils.invokeMethod2((Object)action, (String)"expose", Boolean.TYPE, (Object)isPublic);
    }

    @Test
    public void test_animateDialog() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposePropertySupportTest.getJavaInfoByName("button");
        ExposePropertySupportTest.assertNotNull((Object)button);
        final IAction action = ExposePropertySupportTest.getExposeAction((JavaInfo)button, "text");
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Expose property").bot();
                SWTBotText textWidget = shell.textWithLabel("Property name:");
                SWTBotStyledText previewWidget = bot.styledTextWithLabel("Preview:");
                SWTBotButton okButton = shell.button("OK");
                ExposePropertySupportTest.assertEquals((Object)"buttonText", (Object)textWidget.getText());
                Assertions.assertThat((String)previewWidget.getText()).contains(new CharSequence[]{"getButtonText()"});
                ExposePropertySupportTest.assertTrue((boolean)okButton.isEnabled());
                textWidget.setText("wrong name");
                ExposePropertySupportTest.assertEquals((Object)previewWidget.getText(), (Object)"No preview");
                ExposePropertySupportTest.assertFalse((boolean)okButton.isEnabled());
                textWidget.setText("myText");
                Assertions.assertThat((String)previewWidget.getText()).contains(new CharSequence[]{"getMyText()"});
                ExposePropertySupportTest.assertTrue((boolean)okButton.isEnabled());
                okButton.click();
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "  public String getMyText() {", "    return button.getText();", "  }", "  public void setMyText(String text) {", "    button.setText(text);", "  }", "}");
    }

    private static IAction getExposeAction(Property property) throws Exception {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.edit"));
        ExposePropertySupport.INSTANCE.contributeMenu((IMenuManager)manager, property);
        return ExposePropertySupportTest.findChildAction((IContributionManager)manager, "Expose property...");
    }

    private static IAction getExposeAction(JavaInfo javaInfo, String propertyName) throws Exception {
        Property property = javaInfo.getPropertyByTitle(propertyName);
        return ExposePropertySupportTest.getExposeAction(property);
    }
}

