/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.List;
import org.eclipse.gef.Tool;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.tools.PasteTool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class MenuBarPopupTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_popupCreate() throws Exception {
        CompositeInfo shellInfo = this.openComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)this.loadCreationTool("org.eclipse.swt.widgets.Menu");
        this.canvas.assertNoFeedbacks();
        this.canvas.moveTo((Object)shellInfo, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(shellInfo));
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "    }", "  }", "}");
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.canvas.assertPrimarySelected(popupInfo);
        this.canvas.assertChildrenCount(popupPart, 1);
    }

    @Test
    public void test_popupCreate_alreadyExists() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setMenu(new Menu(this));", "  }", "}");
        String source = this.m_lastEditor.getSource();
        this.loadCreationTool("org.eclipse.swt.widgets.Menu");
        this.canvas.moveTo((Object)shellInfo, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(shellInfo));
        this.canvas.assertCommandNull();
        this.canvas.click();
        MenuBarPopupTest.assertEditor(source, this.m_lastEditor);
    }

    @Test
    public void test_popupMove_otherControl() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        ControlInfo buttonInfo_1 = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo_2 = (ControlInfo)shellInfo.getChildrenControls().get(1);
        MenuInfo popupInfo = (MenuInfo)buttonInfo_1.getChildren(MenuInfo.class).get(0);
        this.canvas.beginDrag(popupInfo).dragTo(buttonInfo_2);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(buttonInfo_2));
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "      {", "        Menu menu = new Menu(button_2);", "        button_2.setMenu(menu);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_popupMove_sameControl() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "  }", "}");
        String source = this.m_lastEditor.getSource();
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        this.canvas.beginDrag(popupInfo).dragTo((Object)shellInfo, 100, 100);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(shellInfo));
        this.canvas.assertCommandNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        MenuBarPopupTest.assertEditor(source, this.m_lastEditor);
    }

    @Ignore
    @Test
    public void test_popupPaste() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "        {", "          MenuItem item = new MenuItem(menu, SWT.NONE);", "          item.setText('My item');", "        }", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        ControlInfo buttonInfo_1 = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo_2 = (ControlInfo)shellInfo.getChildrenControls().get(1);
        MenuInfo popupInfo = (MenuInfo)buttonInfo_1.getChildren(MenuInfo.class).get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)popupInfo);
        PasteTool pasteTool = new PasteTool(List.of(memento));
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)pasteTool);
        this.canvas.moveTo((Object)buttonInfo_2, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(buttonInfo_2));
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "        {", "          MenuItem item = new MenuItem(menu, SWT.NONE);", "          item.setText('My item');", "        }", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "      {", "        Menu menu = new Menu(button_2);", "        button_2.setMenu(menu);", "        {", "          MenuItem menuItem = new MenuItem(menu, SWT.NONE);", "          menuItem.setText('My item');", "        }", "      }", "    }", "  }", "}");
        MenuInfo newPopup = (MenuInfo)buttonInfo_2.getChildren(MenuInfo.class).get(0);
        this.canvas.assertPrimarySelected(newPopup);
    }

    @Test
    public void test_barCreate() throws Exception {
        CompositeInfo shellInfo = this.openComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        MenuInfo barInfo = (MenuInfo)this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.canvas.assertNoFeedbacks();
        this.canvas.moveTo((Object)shellInfo, 0, 0);
        this.canvas.assertFeedbacks(t -> t.getSize().width > 200);
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(barInfo);
    }

    @Test
    public void test_barCreate_alreadyExists() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    setMenuBar(new Menu(this, SWT.BAR));", "  }", "}");
        String source = this.m_lastEditor.getSource();
        this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.canvas.moveTo((Object)shellInfo, 0, 0);
        this.canvas.assertNoFeedbacks();
        this.canvas.assertCommandNull();
        this.canvas.click();
        MenuBarPopupTest.assertEditor(source, this.m_lastEditor);
    }
}

