/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbstractAbsoluteLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.SelectionActionsSupport;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class AbsoluteLayoutSelectionActionsTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_selectionActions() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton('New Button1');", "      button.setBounds(70, 27, 83, 22);", "      add(button);", "    }", "    {", "      JButton button = new JButton('New Button');", "      button.setBounds(41, 129, 134, 84);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(286, 135, 134, 120);", "      add(subPanel);", "      {", "        JLabel label = new JLabel('New Label');", "        label.setBounds(41, 53, 51, 13);", "        subPanel.add(label);", "      }", "    }", "  }", "}");
        this.setupSelectionActions(panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerInfo subPanel = (ContainerInfo)panel.getChildrenComponents().get(2);
        ComponentInfo label = (ComponentInfo)subPanel.getChildrenComponents().get(0);
        panel.refresh();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(button);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertEquals((long)17L, (long)actions.size());
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window"));
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(subPanel);
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        selectedObjects.add((Object)new TestObjectInfo());
        actions.clear();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)actions.isEmpty());
    }

    @Test
    public void test_rootComponentInSelection() throws Exception {
        String[] lines = new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton();", "      button.setBounds(10, 10, 150, 30);", "      add(button);", "    }", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        this.setupSelectionActions(panel);
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(button);
        selectedObjects.add(panel);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_align_left_edges_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(20, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(20, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(10, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align left edges", false);
    }

    @Test
    public void test_align_left_edges_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(30, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(25, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align left edges", false);
    }

    @Test
    public void test_align_right_edges_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(70, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(20, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(-40, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align right edges", false);
    }

    @Test
    public void test_align_right_edges_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(80, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(25, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(-45, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align right edges", false);
    }

    @Test
    public void test_align_horizontal_centers_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(45, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(20, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(-15, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, "Align horizontal centers", false);
    }

    @Test
    public void test_align_horizontal_centers_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(55, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(25, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(-20, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align horizontal centers", false);
    }

    private void check_align_horizontal(String[] expectedSource, String action, boolean toUp) throws Exception {
        this.check_align(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(20, 50, 150, 30);", "      add(button);", "    }", "  }", "}"}, expectedSource, action, toUp);
    }

    private void check_align_horizontal2(String[] expectedSource, String action, boolean toUp) throws Exception {
        this.check_align2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 20);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(5, 40, 300, 100);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(25, 55, 150, 30);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, expectedSource, action, toUp);
    }

    @Test
    public void test_align_top_edges_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 100, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 10, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align top edges", false);
    }

    @Test
    public void test_align_top_edges_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 100, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 95, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 5, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align top edges", false);
    }

    @Test
    public void test_align_bottom_edges_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 140, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, -30, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align bottom edges", false);
    }

    @Test
    public void test_align_bottom_edges_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 140, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 95, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, -35, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align bottom edges", false);
    }

    @Test
    public void test_align_vertical_centers_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 120, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, -10, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Align vertical centers", false);
    }

    @Test
    public void test_align_vertical_centers_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 120, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 95, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, -15, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, "Align vertical centers", false);
    }

    private void check_align_vertical(String[] newSource, String action, boolean toUp) throws Exception {
        this.check_align(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, newSource, action, toUp);
    }

    private void check_align_vertical2(String[] newSource, String action, boolean toUp) throws Exception {
        this.check_align2(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JPanel subPanel = new JPanel();", "      subPanel.setLayout(null);", "      subPanel.setBounds(65, 5, 300, 300);", "      add(subPanel);", "      {", "        JButton button = new JButton(\"111\");", "        button.setBounds(5, 95, 100, 80);", "        subPanel.add(button);", "      }", "    }", "  }", "}"}, newSource, action, toUp);
    }

    @Test
    public void test_align_replicate_width() throws Exception {
        this.check_align(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 100, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Replicate width", true);
    }

    @Test
    public void test_align_replicate_height() throws Exception {
        this.check_align(new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 40);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, new String[]{"class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton(\"000\");", "      button.setBounds(10, 10, 50, 80);", "      add(button);", "    }", "    {", "      JButton button = new JButton(\"111\");", "      button.setBounds(70, 100, 100, 80);", "      add(button);", "    }", "  }", "}"}, "Replicate height", true);
    }

    @Test
    public void test_align_space_equally_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(600, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(30, 90, 100, 70);", "      add(button);", "    }", "    {", "      JButton button = new JButton('111');", "      button.setBounds(40, 200, 50, 30);", "      add(button);", "    }", "  }", "}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(600, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(150, 100, 100, 70);", "      add(button);", "    }", "    {", "      JButton button = new JButton('111');", "      button.setBounds(400, 270, 50, 30);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_align_space_equally_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(400, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(10, 10, 50, 50);", "      add(button);", "    }", "    {", "      JButton button = new JButton('111');", "      button.setBounds(90, 90, 60, 60);", "      add(button);", "    }", "    {", "      JButton button = new JButton('222');", "      button.setBounds(220, 220, 70, 70);", "      add(button);", "    }", "  }", "}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(2));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        try {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)true);
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        }
        finally {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)false);
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(400, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(10, 10, 50, 50);", "      add(button);", "    }", "    {", "      JButton button = new JButton('111');", "      button.setBounds(110, 110, 60, 60);", "      add(button);", "    }", "    {", "      JButton button = new JButton('222');", "      button.setBounds(220, 220, 70, 70);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_align_center_in_window() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(600, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(10, 10, 60, 40);", "      add(button);", "    }", "  }", "}");
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").run();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    setLayout(null);", "    setSize(600, 400);", "    {", "      JButton button = new JButton('000');", "      button.setBounds(270, 180, 60, 40);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_JTabbedPane_onWayToRoot() throws Exception {
        ContainerInfo root = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JPanel panel = new JPanel();", "      tabbed.addTab('Tab', panel);", "      panel.setLayout(null);", "      {", "        JButton button_1 = new JButton();", "        panel.add(button_1);", "        button_1.setBounds(10, 10, 100, 50);", "      }", "      {", "        JButton button_2 = new JButton();", "        panel.add(button_2);", "        button_2.setBounds(20, 100, 100, 50);", "      }", "    }", "  }", "}");
        root.refresh();
        ArrayList selectedObjects = new ArrayList();
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_1"));
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_2"));
        ContainerInfo panel = (ContainerInfo)AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("panel");
        this.setupSelectionActions(panel);
        ArrayList actions = new ArrayList();
        root.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").run();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JPanel panel = new JPanel();", "      tabbed.addTab('Tab', panel);", "      panel.setLayout(null);", "      {", "        JButton button_1 = new JButton();", "        panel.add(button_1);", "        button_1.setBounds(10, 10, 100, 50);", "      }", "      {", "        JButton button_2 = new JButton();", "        panel.add(button_2);", "        button_2.setBounds(10, 100, 100, 50);", "      }", "    }", "  }", "}");
    }

    private void check_align(String[] initialSource, String[] expectedSource, String action, boolean toUp) throws Exception {
        ContainerInfo panel = this.parseContainer(initialSource);
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        if (toUp) {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        } else {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(1));
        }
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void check_align2(String[] initialSource, String[] expectedSource, String action, boolean toUp) throws Exception {
        ContainerInfo panel = this.parseContainer(initialSource);
        this.setupSelectionActions(panel);
        panel.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        ContainerInfo subPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        this.setupSelectionActions(subPanel);
        if (toUp) {
            selectedObjects.add((ObjectInfo)subPanel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
        } else {
            selectedObjects.add((ObjectInfo)panel.getChildrenComponents().get(0));
            selectedObjects.add((ObjectInfo)subPanel.getChildrenComponents().get(0));
        }
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void setupSelectionActions(final ContainerInfo panel) {
        panel.addBroadcastListener((Object)new ObjectEventListener(){

            public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
                new SelectionActionsSupport((AbstractAbsoluteLayoutInfo)((AbsoluteLayoutInfo)panel.getLayout())).addAlignmentActions(objects, actions);
            }
        });
    }
}

