/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout;

import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class GridLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(450, 300);", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridLayoutTest.assertTrue((button.getBounds().width > 400 ? 1 : 0) != 0);
    }

    @Test
    public void test_twoNested() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(GridData.FILL_BOTH));", "      composite.setLayout(new GridLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new GridData(GridData.FILL_BOTH));", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)GridLayoutTest.getJavaInfoByName("button");
        Rectangle buttonBounds = button.getBounds();
        GridLayoutTest.assertTrue((buttonBounds.width > 400 ? 1 : 0) != 0);
        GridLayoutTest.assertTrue((buttonBounds.height > 200 ? 1 : 0) != 0);
        CompositeInfo composite = (CompositeInfo)GridLayoutTest.getJavaInfoByName("composite");
        GridLayoutInfo gridLayout = (GridLayoutInfo)composite.getLayout();
        IGridInfo gridInfo = gridLayout.getGridInfo();
        Interval columnInterval = gridInfo.getColumnIntervals()[0];
        GridLayoutTest.assertEquals((long)buttonBounds.x, (long)columnInterval.begin());
        GridLayoutTest.assertEquals((long)buttonBounds.width, (long)columnInterval.length());
        Interval rowInterval = gridInfo.getRowIntervals()[0];
        GridLayoutTest.assertEquals((long)buttonBounds.y, (long)rowInterval.begin());
        GridLayoutTest.assertEquals((long)buttonBounds.height, (long)rowInterval.length());
    }

    @Test
    public void test_defaultValues() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutTest.assertEquals((long)16384L, (long)gridData.getHorizontalAlignment());
        GridLayoutTest.assertEquals((long)0x1000000L, (long)gridData.getVerticalAlignment());
        GridLayoutTest.assertEquals((Object)false, (Object)gridData.getHorizontalGrab());
        GridLayoutTest.assertEquals((Object)false, (Object)gridData.getVerticalGrab());
        GridLayoutTest.assertEquals((Object)16384, (Object)gridData.getPropertyByTitle("horizontalAlignment").getValue());
        GridLayoutTest.assertEquals((Object)0x1000000, (Object)gridData.getPropertyByTitle("verticalAlignment").getValue());
    }

    @Test
    public void test_getLayoutData_override() throws Exception {
        GridLayoutTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private final GridData m_gridData = new GridData();", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "  public Object getLayoutData() {", "    return m_gridData;", "  }", "}"));
        GridLayoutTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(1, false));", "    new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        GridLayoutTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_Switching_fromTableWrapLayout() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout tableWrapLayout = new TableWrapLayout();", "      tableWrapLayout.numColumns = 3;", "      setLayout(tableWrapLayout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        label.setLayoutData(tableWrapData);", "      }", "      label.setText('New Label');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new TableWrapData(TableWrapData.FILL, TableWrapData.TOP, 1, 2));", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('New Button');", "    }", "  }", "}");
        composite.refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)BTestUtils.createLayout("org.eclipse.swt.layout.GridLayout");
        composite.setLayout((LayoutInfo)gridLayout);
        this.assertEditor("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(3, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, true, false, 1, 1));", "      label.setText('New Label');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 2, 1));", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, true, 1, 1));", "      button.setText('New Button');", "    }", "  }", "}");
    }
}

