/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.databinding.Activator;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.DataBindingsCodeUtils;
import org.eclipse.wb.internal.rcp.databinding.model.ObservableCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.ObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.CollectionPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.direct.DirectPropertyObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.DetailValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.SetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.ValueBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableListBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.WritableSetBeanObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableDetailListCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableDetailSetCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableDetailValueCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableListCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableSetCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.BeanObservableValueCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.WritableListCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.beans.observables.standard.WritableSetCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.DataBindingContextInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ListBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.SetBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.ValueBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.ConverterInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateListStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateSetStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.UpdateValueStrategyInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.strategies.ValidatorInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.CheckedElementsObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.ItemsSwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.MultiSelectionObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.SingleSelectionObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.SwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.TextSwtObservableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.properties.WidgetPropertiesCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.properties.WidgetPropertyTextCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.CheckedElementsObservableCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.MultiSelectionObservableCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.SingleSelectionObservableCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.SwtObservableCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.SwtObservableItemsCodeSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.observables.standard.SwtObservableTextCodeSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.junit.Test;

public class CodeGenerationTest
extends AbstractBindingTest {
    @Test
    public void test_ConverterInfo() throws Exception {
        ConverterInfo converter = new ConverterInfo("org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter");
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)converter);
        CodeGenerationTest.assertEquals((Object)"new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter()", (Object)converter.getSourceCode(lines, generationSupport));
        CodeGenerationTest.assertTrue((boolean)lines.isEmpty());
        converter.setVariableIdentifier("m_converter");
        CodeGenerationTest.assertEquals((Object)"m_converter", (Object)converter.getSourceCode(lines, generationSupport));
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.conversion.IConverter m_converter = new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter();");
    }

    @Test
    public void test_ValidatorInfo() throws Exception {
        ValidatorInfo validator = new ValidatorInfo("org.eclipse.core.internal.databinding.validation.StringToDateValidator");
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)validator);
        CodeGenerationTest.assertEquals((Object)"new org.eclipse.core.internal.databinding.validation.StringToDateValidator()", (Object)validator.getSourceCode(lines, generationSupport));
        CodeGenerationTest.assertTrue((boolean)lines.isEmpty());
        validator.setVariableIdentifier("validator");
        CodeGenerationTest.assertEquals((Object)"validator", (Object)validator.getSourceCode(lines, generationSupport));
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToDateValidator();");
    }

    @Test
    public void test_UpdateListStrategyInfo_Null() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, null, null), "null", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateListStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateListStrategy strategy = new org.eclipse.core.databinding.UpdateListStrategy();");
    }

    @Test
    public void test_UpdateListStrategyInfo_DefaultConstructor() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, null, null), "new org.eclipse.core.databinding.UpdateListStrategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateListStrategy strategy = new org.eclipse.core.databinding.UpdateListStrategy();");
    }

    @Test
    public void test_UpdateListStrategyInfo_IntConstructor() throws Exception {
        UpdateListStrategyInfo listStrategyInfo = CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateListStrategyInfo.Value.POLICY_UPDATE, null, null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)listStrategyInfo, "new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_UPDATE)", new String[0]);
        listStrategyInfo.setStringValue("POLICY_ON_REQUEST");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)listStrategyInfo, "new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_ON_REQUEST)", new String[0]);
        listStrategyInfo.setStringValue("POLICY_NEVER");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)listStrategyInfo, "new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_NEVER)", new String[0]);
        listStrategyInfo.setStringValue("POLICY_UPDATE");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)listStrategyInfo, "null", new String[0]);
        listStrategyInfo.setStringValue("com.company.project.Strategy");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)listStrategyInfo, "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateListStrategyInfo.Value.POLICY_ON_REQUEST, null, null), "new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_ON_REQUEST)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateListStrategyInfo.Value.POLICY_NEVER, null, null), "new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_NEVER)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateListStrategyInfo.Value.POLICY_NEVER, null, "m_strategy"), "m_strategy", "org.eclipse.core.databinding.UpdateListStrategy m_strategy = new org.eclipse.core.databinding.UpdateListStrategy(org.eclipse.core.databinding.UpdateListStrategy.POLICY_NEVER);");
    }

    @Test
    public void test_UpdateListStrategyInfo_ExtendetClass() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, null), "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, "_strategy"), "_strategy", "org.eclipse.core.databinding.UpdateListStrategy _strategy = new com.company.project.Strategy();");
    }

    @Test
    public void test_UpdateListStrategyInfo_Converter() throws Exception {
        UpdateListStrategyInfo strategy = CodeGenerationTest.createListStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", new ConverterInfo("org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter"), "_strategy");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "_strategy", "org.eclipse.core.databinding.UpdateListStrategy _strategy = new com.company.project.Strategy();", "_strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());");
        strategy.setVariableIdentifier(null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateListStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());");
        strategy.setConverter(new ConverterInfo("org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter"));
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateListStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter());");
    }

    @Test
    public void test_UpdateSetStrategyInfo_Null() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, null, null), "null", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateSetStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateSetStrategy strategy = new org.eclipse.core.databinding.UpdateSetStrategy();");
    }

    @Test
    public void test_UpdateSetStrategyInfo_DefaultConstructor() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, null, null), "new org.eclipse.core.databinding.UpdateSetStrategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateSetStrategy strategy = new org.eclipse.core.databinding.UpdateSetStrategy();");
    }

    @Test
    public void test_UpdateSetStrategyInfo_IntConstructor() throws Exception {
        UpdateSetStrategyInfo setStrategyInfo = CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateSetStrategyInfo.Value.POLICY_UPDATE, null, null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)setStrategyInfo, "new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_UPDATE)", new String[0]);
        setStrategyInfo.setStringValue("POLICY_ON_REQUEST");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)setStrategyInfo, "new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_ON_REQUEST)", new String[0]);
        setStrategyInfo.setStringValue("POLICY_NEVER");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)setStrategyInfo, "new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_NEVER)", new String[0]);
        setStrategyInfo.setStringValue("POLICY_UPDATE");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)setStrategyInfo, "null", new String[0]);
        setStrategyInfo.setStringValue("com.company.project.Strategy");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)setStrategyInfo, "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateSetStrategyInfo.Value.POLICY_ON_REQUEST, null, null), "new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_ON_REQUEST)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateSetStrategyInfo.Value.POLICY_NEVER, null, null), "new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_NEVER)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateSetStrategyInfo.Value.POLICY_NEVER, null, "m_strategy"), "m_strategy", "org.eclipse.core.databinding.UpdateSetStrategy m_strategy = new org.eclipse.core.databinding.UpdateSetStrategy(org.eclipse.core.databinding.UpdateSetStrategy.POLICY_NEVER);");
    }

    @Test
    public void test_UpdateSetStrategyInfo_ExtendetClass() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, null), "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, "_strategy"), "_strategy", "org.eclipse.core.databinding.UpdateSetStrategy _strategy = new com.company.project.Strategy();");
    }

    @Test
    public void test_UpdateSetStrategyInfo_Converter() throws Exception {
        UpdateSetStrategyInfo strategy = CodeGenerationTest.createSetStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", new ConverterInfo("org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter"), "_strategy");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "_strategy", "org.eclipse.core.databinding.UpdateSetStrategy _strategy = new com.company.project.Strategy();", "_strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());");
        strategy.setVariableIdentifier(null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateSetStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());");
        strategy.setConverter(new ConverterInfo("org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter"));
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateSetStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter());");
    }

    @Test
    public void test_UpdateValueStrategyInfo_Null() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, null, null), "null", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.Null, UpdateValueStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateValueStrategy strategy = new org.eclipse.core.databinding.UpdateValueStrategy();");
    }

    @Test
    public void test_UpdateValueStrategyInfo_DefaultConstructor() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, null, null), "new org.eclipse.core.databinding.UpdateValueStrategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.DefaultConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, null, "strategy"), "strategy", "org.eclipse.core.databinding.UpdateValueStrategy strategy = new org.eclipse.core.databinding.UpdateValueStrategy();");
    }

    @Test
    public void test_UpdateValueStrategyInfo_IntConstructor() throws Exception {
        UpdateValueStrategyInfo valueStrategyInfo = CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_UPDATE, null, null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_UPDATE)", new String[0]);
        valueStrategyInfo.setStringValue("POLICY_ON_REQUEST");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_ON_REQUEST)", new String[0]);
        valueStrategyInfo.setStringValue("POLICY_NEVER");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_NEVER)", new String[0]);
        valueStrategyInfo.setStringValue("POLICY_CONVERT");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_CONVERT)", new String[0]);
        valueStrategyInfo.setStringValue("POLICY_UPDATE");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "null", new String[0]);
        valueStrategyInfo.setStringValue("com.company.project.Strategy");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)valueStrategyInfo, "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_ON_REQUEST, null, null), "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_ON_REQUEST)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_NEVER, null, null), "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_NEVER)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_CONVERT, null, null), "new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_CONVERT)", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.IntConstructor, UpdateValueStrategyInfo.Value.POLICY_NEVER, null, "m_strategy"), "m_strategy", "org.eclipse.core.databinding.UpdateValueStrategy m_strategy = new org.eclipse.core.databinding.UpdateValueStrategy(org.eclipse.core.databinding.UpdateValueStrategy.POLICY_NEVER);");
    }

    @Test
    public void test_UpdateValueStrategyInfo_ExtendetClass() throws Exception {
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, null), "new com.company.project.Strategy()", new String[0]);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", null, "_strategy"), "_strategy", "org.eclipse.core.databinding.UpdateValueStrategy _strategy = new com.company.project.Strategy();");
    }

    @Test
    public void test_UpdateValueStrategyInfo_Converter_Validators() throws Exception {
        UpdateValueStrategyInfo strategy = CodeGenerationTest.createValueStrategy(UpdateStrategyInfo.StrategyType.ExtendetClass, "com.company.project.Strategy", new ConverterInfo("org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter"), "_strategy");
        strategy.setValidator("setAfterConvertValidator", new ValidatorInfo("org.eclipse.core.internal.databinding.validation.StringToIntegerValidator"));
        ValidatorInfo validator = new ValidatorInfo("org.eclipse.core.internal.databinding.validation.StringToIntegerValidator");
        validator.setVariableIdentifier("validator");
        strategy.setValidator("setAfterGetValidator", validator);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "_strategy", "org.eclipse.core.databinding.UpdateValueStrategy _strategy = new com.company.project.Strategy();", "_strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());", "_strategy.setAfterConvertValidator(new org.eclipse.core.internal.databinding.validation.StringToIntegerValidator());", "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToIntegerValidator();", "_strategy.setAfterGetValidator(validator);");
        validator.setClassName("org.eclipse.core.internal.databinding.validation.StringToByteValidator");
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "_strategy", "org.eclipse.core.databinding.UpdateValueStrategy _strategy = new com.company.project.Strategy();", "_strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());", "_strategy.setAfterConvertValidator(new org.eclipse.core.internal.databinding.validation.StringToIntegerValidator());", "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToByteValidator();", "_strategy.setAfterGetValidator(validator);");
        strategy.setVariableIdentifier(null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateValueStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter());", "strategy.setAfterConvertValidator(new org.eclipse.core.internal.databinding.validation.StringToIntegerValidator());", "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToByteValidator();", "strategy.setAfterGetValidator(validator);");
        strategy.setConverter(new ConverterInfo("org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter"));
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateValueStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter());", "strategy.setAfterConvertValidator(new org.eclipse.core.internal.databinding.validation.StringToIntegerValidator());", "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToByteValidator();", "strategy.setAfterGetValidator(validator);");
        strategy.setValidator("setAfterConvertValidator", null);
        CodeGenerationTest.assertStrategy((UpdateStrategyInfo)strategy, "strategy", "org.eclipse.core.databinding.UpdateValueStrategy strategy = new com.company.project.Strategy();", "strategy.setConverter(new org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter());", "org.eclipse.core.databinding.validation.IValidator validator = new org.eclipse.core.internal.databinding.validation.StringToByteValidator();", "strategy.setAfterGetValidator(validator);");
    }

    @Test
    public void test_BeanObservebleInfo() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private String m_bean;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableInfo bindableObject = (BeanBindableInfo)observes.get(0);
        BeanPropertyBindableInfo bindableProperty = (BeanPropertyBindableInfo)bindableObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new ListBeanObservableInfo(bindableObject, bindableProperty), (ObservableCodeSupport)new BeanObservableListCodeSupport(), "observeList", "org.eclipse.core.databinding.observable.list.IObservableList observeList = org.eclipse.core.databinding.beans.typed.PojoProperties.list(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.list.IObservableList beanBytesObserveList = org.eclipse.core.databinding.beans.typed.PojoProperties.list(\"bytes\").observe(m_bean);");
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new SetBeanObservableInfo(bindableObject, bindableProperty), (ObservableCodeSupport)new BeanObservableSetCodeSupport(), "observeSet", "org.eclipse.core.databinding.observable.set.IObservableSet observeSet = org.eclipse.core.databinding.beans.typed.PojoProperties.set(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.set.IObservableSet beanBytesObserveSet = org.eclipse.core.databinding.beans.typed.PojoProperties.set(\"bytes\").observe(m_bean);");
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new ValueBeanObservableInfo(bindableObject, bindableProperty), (ObservableCodeSupport)new BeanObservableValueCodeSupport(), "observeValue", "org.eclipse.core.databinding.observable.value.IObservableValue observeValue = org.eclipse.core.databinding.beans.typed.PojoProperties.value(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.value.IObservableValue beanBytesObserveValue = org.eclipse.core.databinding.beans.typed.PojoProperties.value(\"bytes\").observe(m_bean);");
    }

    @Test
    public void test_CollectionObservableInfo() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private java.util.List m_bean0;", "  private java.util.Set m_bean1;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableInfo bindableObjectList = (BeanBindableInfo)observes.get(0);
        CollectionPropertyBindableInfo bindablePropertyList = (CollectionPropertyBindableInfo)bindableObjectList.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new WritableListBeanObservableInfo(bindableObjectList, bindablePropertyList, String.class), (ObservableCodeSupport)new WritableListCodeSupport(), "writableList", "org.eclipse.core.databinding.observable.list.WritableList writableList = new org.eclipse.core.databinding.observable.list.WritableList(m_bean0, java.lang.String.class);", "org.eclipse.core.databinding.observable.list.WritableList writableList = new org.eclipse.core.databinding.observable.list.WritableList(m_bean0, java.lang.String.class);");
        WritableListBeanObservableInfo listObservable = new WritableListBeanObservableInfo(bindableObjectList, bindablePropertyList, null);
        listObservable.setElementType(String.class);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)listObservable, (ObservableCodeSupport)new WritableListCodeSupport(), "writableList", "org.eclipse.core.databinding.observable.list.WritableList writableList = new org.eclipse.core.databinding.observable.list.WritableList(m_bean0, java.lang.String.class);", "org.eclipse.core.databinding.observable.list.WritableList writableList = new org.eclipse.core.databinding.observable.list.WritableList(m_bean0, java.lang.String.class);");
        BeanBindableInfo bindableObjectSet = (BeanBindableInfo)observes.get(1);
        CollectionPropertyBindableInfo bindablePropertySet = (CollectionPropertyBindableInfo)bindableObjectSet.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        WritableSetBeanObservableInfo setObservable = new WritableSetBeanObservableInfo(bindableObjectSet, bindablePropertySet, null);
        setObservable.setElementType(String.class);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)setObservable, (ObservableCodeSupport)new WritableSetCodeSupport(), "writableSet", "org.eclipse.core.databinding.observable.set.WritableSet writableSet = new org.eclipse.core.databinding.observable.set.WritableSet(m_bean1, java.lang.String.class);", "org.eclipse.core.databinding.observable.set.WritableSet writableSet = new org.eclipse.core.databinding.observable.set.WritableSet(m_bean1, java.lang.String.class);");
    }

    @Test
    public void test_BeanObservableInfo_observeDetail() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private String m_bean;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableInfo bindableObject = (BeanBindableInfo)observes.get(0);
        BeanPropertyBindableInfo bindableProperty = (BeanPropertyBindableInfo)bindableObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(1);
        ValueBeanObservableInfo masterObservable = new ValueBeanObservableInfo(bindableObject, bindableProperty);
        masterObservable.setCodeSupport((ObservableCodeSupport)new BeanObservableValueCodeSupport());
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)masterObservable);
        DetailValueBeanObservableInfo observableDetailValue = new DetailValueBeanObservableInfo((ObservableInfo)masterObservable, null, "\"abc\"", Integer.TYPE);
        observableDetailValue.setCodeSupport((ObservableCodeSupport)new BeanObservableDetailValueCodeSupport());
        observableDetailValue.setVariableIdentifier("detail");
        observableDetailValue.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue beanBytesObserveValue = org.eclipse.core.databinding.beans.typed.PojoProperties.value(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.value.IObservableValue detail = org.eclipse.core.databinding.beans.typed.BeanProperties.value(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
        lines.clear();
        observableDetailValue.setVariableIdentifier(null);
        observableDetailValue.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue beanAbcObserveDetailValue = org.eclipse.core.databinding.beans.typed.BeanProperties.value(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
        lines.clear();
        observableDetailValue.setDetailPropertyReference(Component.class, "\"property\"");
        observableDetailValue.setDetailPropertyType(String.class);
        observableDetailValue.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue beanAbcObserveDetailValue = org.eclipse.core.databinding.beans.typed.BeanProperties.value(java.awt.Component.class, \"property\", java.lang.String.class).observeDetail(beanBytesObserveValue);");
        DetailListBeanObservableInfo observableDetailList = new DetailListBeanObservableInfo((ObservableInfo)masterObservable, null, "\"abc\"", Integer.TYPE);
        observableDetailList.setCodeSupport((ObservableCodeSupport)new BeanObservableDetailListCodeSupport());
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)masterObservable);
        lines.clear();
        observableDetailList.setVariableIdentifier("detail");
        observableDetailList.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue beanBytesObserveValue = org.eclipse.core.databinding.beans.typed.PojoProperties.value(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.list.IObservableList detail = org.eclipse.core.databinding.beans.typed.BeanProperties.list(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
        lines.clear();
        observableDetailList.setVariableIdentifier(null);
        observableDetailList.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.list.IObservableList beanAbcObserveDetailList = org.eclipse.core.databinding.beans.typed.BeanProperties.list(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
        DetailSetBeanObservableInfo observableDetailSet = new DetailSetBeanObservableInfo((ObservableInfo)masterObservable, null, "\"abc\"", Integer.TYPE);
        observableDetailSet.setCodeSupport((ObservableCodeSupport)new BeanObservableDetailSetCodeSupport());
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)masterObservable);
        lines.clear();
        observableDetailSet.setVariableIdentifier("detail");
        observableDetailSet.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue beanBytesObserveValue = org.eclipse.core.databinding.beans.typed.PojoProperties.value(\"bytes\").observe(m_bean);", "org.eclipse.core.databinding.observable.set.IObservableSet detail = org.eclipse.core.databinding.beans.typed.BeanProperties.set(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
        lines.clear();
        observableDetailSet.setVariableIdentifier(null);
        observableDetailSet.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.set.IObservableSet beanAbcObserveDetailSet = org.eclipse.core.databinding.beans.typed.BeanProperties.set(\"abc\", int.class).observeDetail(beanBytesObserveValue);");
    }

    @Test
    public void test_DirectPropertyObservableInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  private DataBindingContext m_context;", "  private String m_bean;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableInfo bindableObject = (BeanBindableInfo)observes.get(0);
        DirectPropertyBindableInfo bindableProperty = (DirectPropertyBindableInfo)bindableObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(3);
        DirectPropertyObservableInfo observable = new DirectPropertyObservableInfo((BindableInfo)bindableObject, (BindableInfo)bindableProperty);
        CodeGenerationTest.assertEquals((Object)"m_context.getValidationStatusProviders()", (Object)observable.getVariableIdentifier());
        try {
            observable.setVariableIdentifier("variable");
            CodeGenerationTest.fail();
        }
        catch (Throwable e) {
            CodeGenerationTest.assertInstanceOf(UnsupportedOperationException.class, (Object)e);
        }
        ArrayList lines = new ArrayList();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)observable);
        observable.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertTrue((boolean)lines.isEmpty());
        CodeGenerationTest.assertEquals((Object)"m_context.getValidationStatusProviders()", (Object)observable.getVariableIdentifier());
    }

    @Test
    public void test_DirectObservableInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  private WritableValue m_value;", "  private String m_bean;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableInfo bindableObject = (BeanBindableInfo)observes.get(0);
        DirectPropertyBindableInfo bindableProperty = (DirectPropertyBindableInfo)bindableObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        DirectObservableInfo observable = new DirectObservableInfo((BindableInfo)bindableObject, (BindableInfo)bindableProperty);
        CodeGenerationTest.assertEquals((Object)"m_value", (Object)observable.getVariableIdentifier());
        try {
            observable.setVariableIdentifier("variable");
            CodeGenerationTest.fail();
        }
        catch (Throwable e) {
            CodeGenerationTest.assertInstanceOf(UnsupportedOperationException.class, (Object)e);
        }
        ArrayList lines = new ArrayList();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)observable);
        observable.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertTrue((boolean)lines.isEmpty());
        CodeGenerationTest.assertEquals((Object)"m_value", (Object)observable.getVariableIdentifier());
    }

    @Test
    public void test_SWTObservableInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Spinner m_spinner;", "  private Text m_text;", "  private Combo m_combo;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_spinner = new Spinner(m_shell, SWT.NONE);", "    m_text = new Text(m_shell, SWT.NONE);", "    m_combo = new Combo(m_shell, SWT.NONE);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableInfo shellBindable = (WidgetBindableInfo)observes.get(0);
        List shellProperties = shellBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetPropertyBindableInfo shellEnabled = (WidgetPropertyBindableInfo)shellProperties.get(2);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellEnabled, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell));");
        WidgetPropertyBindableInfo shellVisible = (WidgetPropertyBindableInfo)shellProperties.get(10);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellVisible, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell));");
        WidgetPropertyBindableInfo shellTooltip = (WidgetPropertyBindableInfo)shellProperties.get(9);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellTooltip, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeTooltipText(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveTooltipTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeTooltipText(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveTooltipTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeTooltipText(m_shell));");
        WidgetPropertyBindableInfo shellText = (WidgetPropertyBindableInfo)shellProperties.get(8);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellText, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_shell));");
        WidgetPropertyBindableInfo shellForeground = (WidgetPropertyBindableInfo)shellProperties.get(5);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellForeground, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeForeground(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveForegroundObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeForeground(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveForegroundObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeForeground(m_shell));");
        WidgetPropertyBindableInfo shellBackground = (WidgetPropertyBindableInfo)shellProperties.get(0);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellBackground, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeBackground(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveBackgroundObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeBackground(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveBackgroundObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeBackground(m_shell));");
        WidgetPropertyBindableInfo shellFont = (WidgetPropertyBindableInfo)shellProperties.get(4);
        CodeGenerationTest.assertSWTObservableInfo(shellBindable, shellFont, (ObservableCodeSupport)new SwtObservableCodeSupport(), "shellObserve", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeFont(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveFontObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeFont(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveFontObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeFont(m_shell));");
        List shellChildren = shellBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        WidgetBindableInfo spinnerBindable = (WidgetBindableInfo)shellChildren.get(0);
        WidgetPropertyBindableInfo spinnerMax = (WidgetPropertyBindableInfo)spinnerBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(7);
        CodeGenerationTest.assertSWTObservableInfo(spinnerBindable, spinnerMax, (ObservableCodeSupport)new SwtObservableCodeSupport(), "spinnerObserve", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeMax(m_spinner);", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserveMaxObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeMax(m_spinner);", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserveMaxObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeMax(m_spinner));");
        WidgetPropertyBindableInfo spinnerMin = (WidgetPropertyBindableInfo)spinnerBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        CodeGenerationTest.assertSWTObservableInfo(spinnerBindable, spinnerMin, (ObservableCodeSupport)new SwtObservableCodeSupport(), "spinnerObserve", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeMin(m_spinner);", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserveMinObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeMin(m_spinner);", "org.eclipse.core.databinding.observable.value.IObservableValue spinnerObserveMinObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeMin(m_spinner));");
        WidgetBindableInfo textBindable = (WidgetBindableInfo)shellChildren.get(1);
        WidgetPropertyBindableInfo textEditable = (WidgetPropertyBindableInfo)textBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        CodeGenerationTest.assertSWTObservableInfo(textBindable, textEditable, (ObservableCodeSupport)new SwtObservableCodeSupport(), "editableObserve", "org.eclipse.core.databinding.observable.value.IObservableValue editableObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeEditable(m_text);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveEditableObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEditable(m_text);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveEditableObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeEditable(m_text));");
        WidgetPropertyBindableInfo textText = (WidgetPropertyBindableInfo)textBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        CodeGenerationTest.assertSWTObservableInfo((SwtObservableInfo)new TextSwtObservableInfo(textBindable, textText, 24), (ObservableCodeSupport)new SwtObservableTextCodeSupport(), "textObserve", "org.eclipse.core.databinding.observable.value.IObservableValue textObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.Modify);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.Modify);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.Modify));");
        CodeGenerationTest.assertSWTObservableInfo((SwtObservableInfo)new TextSwtObservableInfo(textBindable, textText, 16), (ObservableCodeSupport)new SwtObservableTextCodeSupport(), "textObserve", "org.eclipse.core.databinding.observable.value.IObservableValue textObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.FocusOut);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.FocusOut);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.FocusOut));");
        CodeGenerationTest.assertSWTObservableInfo((SwtObservableInfo)new TextSwtObservableInfo(textBindable, textText, 0), (ObservableCodeSupport)new SwtObservableTextCodeSupport(), "textObserve", "org.eclipse.core.databinding.observable.value.IObservableValue textObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.NONE);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.NONE);", "org.eclipse.core.databinding.observable.value.IObservableValue textObserveTextObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeText(m_text, org.eclipse.swt.SWT.NONE));");
        WidgetBindableInfo comboBindable = (WidgetBindableInfo)shellChildren.get(2);
        WidgetPropertyBindableInfo comboItems = (WidgetPropertyBindableInfo)comboBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(6);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new ItemsSwtObservableInfo(comboBindable, comboItems), (ObservableCodeSupport)new SwtObservableItemsCodeSupport(), "itemsObserve", "org.eclipse.core.databinding.observable.list.IObservableList itemsObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeItems(m_combo);", "org.eclipse.core.databinding.observable.list.IObservableList comboObserveItemsObserveListWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeItems(m_combo);");
        WidgetPropertyBindableInfo comboSelection = (WidgetPropertyBindableInfo)comboBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        CodeGenerationTest.assertSWTObservableInfo(comboBindable, comboSelection, (ObservableCodeSupport)new SwtObservableCodeSupport(), "selectionObserve", "org.eclipse.core.databinding.observable.value.IObservableValue selectionObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeSelection(m_combo);", "org.eclipse.core.databinding.observable.value.IObservableValue comboObserveSelectionObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeSelection(m_combo);", "org.eclipse.core.databinding.observable.value.IObservableValue comboObserveSelectionObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeSelection(m_combo));");
        WidgetPropertyBindableInfo comboSelectionIndex = (WidgetPropertyBindableInfo)comboBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(9);
        CodeGenerationTest.assertSWTObservableInfo(comboBindable, comboSelectionIndex, (ObservableCodeSupport)new SwtObservableCodeSupport(), "selectionObserve", "org.eclipse.core.databinding.observable.value.IObservableValue selectionObserve = org.eclipse.jface.databinding.swt.SWTObservables.observeSingleSelectionIndex(m_combo);", "org.eclipse.core.databinding.observable.value.IObservableValue comboObserveSingleSelectionIndexObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeSingleSelectionIndex(m_combo);", "org.eclipse.core.databinding.observable.value.IObservableValue comboObserveSingleSelectionIndexObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeDelayedValue(100, org.eclipse.jface.databinding.swt.SWTObservables.observeSingleSelectionIndex(m_combo));");
    }

    @Test
    public void test_ViewerObservableInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private CheckboxTableViewer m_viewer;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_viewer = new CheckboxTableViewer(m_shell, SWT.NONE);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableInfo viewerBindable = (WidgetBindableInfo)((IObserveInfo)((IObserveInfo)observes.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetPropertyBindableInfo singleSelection = (WidgetPropertyBindableInfo)viewerBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new SingleSelectionObservableInfo((BindableInfo)viewerBindable, (BindableInfo)singleSelection), (ObservableCodeSupport)new SingleSelectionObservableCodeSupport(), "viewerObservable", "org.eclipse.core.databinding.observable.value.IObservableValue viewerObservable = org.eclipse.jface.databinding.viewers.ViewersObservables.observeSingleSelection(m_viewer);", "org.eclipse.core.databinding.observable.value.IObservableValue viewerObserveSingleSelection = org.eclipse.jface.databinding.viewers.ViewersObservables.observeSingleSelection(m_viewer);");
        WidgetPropertyBindableInfo multiSelection = (WidgetPropertyBindableInfo)viewerBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)new MultiSelectionObservableInfo((BindableInfo)viewerBindable, multiSelection), (ObservableCodeSupport)new MultiSelectionObservableCodeSupport(), "viewerObservable", "org.eclipse.core.databinding.observable.list.IObservableList viewerObservable = org.eclipse.jface.databinding.viewers.ViewersObservables.observeMultiSelection(m_viewer);", "org.eclipse.core.databinding.observable.list.IObservableList viewerObserveMultiSelection = org.eclipse.jface.databinding.viewers.ViewersObservables.observeMultiSelection(m_viewer);");
        CheckedElementsObservableInfo checkedObservable = new CheckedElementsObservableInfo((BindableInfo)viewerBindable);
        checkedObservable.setElementType(String.class);
        CodeGenerationTest.assertObservableInfo((ObservableInfo)checkedObservable, (ObservableCodeSupport)new CheckedElementsObservableCodeSupport(), "viewerObservable", "org.eclipse.core.databinding.observable.set.IObservableSet viewerObservable = org.eclipse.jface.databinding.viewers.ViewersObservables.observeCheckedElements(m_viewer, java.lang.String.class);", "org.eclipse.core.databinding.observable.set.IObservableSet viewerObserveCheckedElements = org.eclipse.jface.databinding.viewers.ViewersObservables.observeCheckedElements(m_viewer, java.lang.String.class);");
    }

    @Test
    public void test_DataBindingContextInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableInfo shellBindable = (WidgetBindableInfo)observes.get(0);
        List shellProperties = shellBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetPropertyBindableInfo shellEnabled = (WidgetPropertyBindableInfo)shellProperties.get(2);
        WidgetPropertyBindableInfo shellVisible = (WidgetPropertyBindableInfo)shellProperties.get(10);
        DataBindingContextInfo contextInfo = new DataBindingContextInfo();
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)contextInfo);
        contextInfo.addSourceCode(this.m_lastEditor, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.DataBindingContext bindingContext = new org.eclipse.core.databinding.DataBindingContext();", "//", "return bindingContext;");
        lines.clear();
        contextInfo.setVariableIdentifier("context");
        contextInfo.addInitializeContext(true);
        contextInfo.addSourceCode(this.m_lastEditor, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.DataBindingContext context = new org.eclipse.core.databinding.DataBindingContext();", "initializeContext(context);", "//", "return context;");
        SwtObservableInfo target = new SwtObservableInfo(shellBindable, shellEnabled);
        target.setCodeSupport((ObservableCodeSupport)new SwtObservableCodeSupport());
        SwtObservableInfo model = new SwtObservableInfo(shellBindable, shellVisible);
        model.setCodeSupport((ObservableCodeSupport)new SwtObservableCodeSupport());
        contextInfo.getBindings().add(new ValueBindingInfo((ObservableInfo)target, (ObservableInfo)model));
        lines.clear();
        contextInfo.setVariableIdentifier(null);
        contextInfo.addInitializeContext(false);
        contextInfo.addSourceCode(this.m_lastEditor, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.DataBindingContext bindingContext = new org.eclipse.core.databinding.DataBindingContext();", "//", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "bindingContext.bindValue(shellObserveEnabledObserveWidget, shellObserveVisibleObserveWidget, null, null);", "//", "return bindingContext;");
        lines.clear();
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)contextInfo);
        Activator.getStore().setValue("INITDB_TRY_CATCH", true);
        try {
            contextInfo.addSourceCode(this.m_lastEditor, lines, generationSupport);
            CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.DataBindingContext bindingContext = new org.eclipse.core.databinding.DataBindingContext();", "//", "try {", "\torg.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "\torg.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "\tbindingContext.bindValue(shellObserveEnabledObserveWidget, shellObserveVisibleObserveWidget, null, null);", "} catch(Throwable e) {}", "//", "return bindingContext;");
        }
        finally {
            Activator.getStore().setValue("INITDB_TRY_CATCH", false);
        }
    }

    @Test
    public void test_BindingInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Combo m_combo0;", "  private Combo m_combo1;", "  private CheckboxTableViewer m_viewer0;", "  private CheckboxTableViewer m_viewer1;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_combo0 = new Combo(m_shell, SWT.BORDER);", "    m_combo1 = new Combo(m_shell, SWT.BORDER);", "    m_viewer0 = new CheckboxTableViewer(m_shell, SWT.NONE);", "    m_viewer1 = new CheckboxTableViewer(m_shell, SWT.NONE);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableInfo shellBindable = (WidgetBindableInfo)observes.get(0);
        List shellProperties = shellBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetPropertyBindableInfo shellEnabled = (WidgetPropertyBindableInfo)shellProperties.get(2);
        WidgetPropertyBindableInfo shellVisible = (WidgetPropertyBindableInfo)shellProperties.get(10);
        SwtObservableInfo target0 = new SwtObservableInfo(shellBindable, shellEnabled);
        target0.setCodeSupport((ObservableCodeSupport)new SwtObservableCodeSupport());
        SwtObservableInfo model0 = new SwtObservableInfo(shellBindable, shellVisible);
        model0.setCodeSupport((ObservableCodeSupport)new SwtObservableCodeSupport());
        ValueBindingInfo binding0 = new ValueBindingInfo((ObservableInfo)target0, (ObservableInfo)model0);
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)binding0);
        DataBindingContextInfo context = new DataBindingContextInfo();
        context.setVariableIdentifier("context");
        binding0.addSourceCode(context, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "context.bindValue(shellObserveEnabledObserveWidget, shellObserveVisibleObserveWidget, null, null);");
        binding0.setVariableIdentifier("binding");
        lines.clear();
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)binding0);
        binding0.addSourceCode(context, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveVisibleObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeVisible(m_shell);", "binding = context.bindValue(shellObserveEnabledObserveWidget, shellObserveVisibleObserveWidget, null, null);");
        ValueBindingInfo binding1 = new ValueBindingInfo((ObservableInfo)target0, (ObservableInfo)target0);
        lines.clear();
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)binding1);
        binding1.addSourceCode(context, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.value.IObservableValue shellObserveEnabledObserveWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeEnabled(m_shell);", "context.bindValue(shellObserveEnabledObserveWidget, shellObserveEnabledObserveWidget, null, null);");
        List shellChildren = shellBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        WidgetBindableInfo combo0Bindable = (WidgetBindableInfo)shellChildren.get(0);
        WidgetPropertyBindableInfo combo0Items = (WidgetPropertyBindableInfo)combo0Bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(6);
        WidgetBindableInfo combo1Bindable = (WidgetBindableInfo)shellChildren.get(1);
        WidgetPropertyBindableInfo combo1Items = (WidgetPropertyBindableInfo)combo1Bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(6);
        ItemsSwtObservableInfo target1 = new ItemsSwtObservableInfo(combo0Bindable, combo0Items);
        target1.setCodeSupport((ObservableCodeSupport)new SwtObservableItemsCodeSupport());
        ItemsSwtObservableInfo model1 = new ItemsSwtObservableInfo(combo1Bindable, combo1Items);
        model1.setCodeSupport((ObservableCodeSupport)new SwtObservableItemsCodeSupport());
        ListBindingInfo binding2 = new ListBindingInfo((ObservableInfo)target1, (ObservableInfo)model1);
        lines.clear();
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)binding2);
        binding2.addSourceCode(context, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.list.IObservableList combo0ObserveItemsObserveListWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeItems(m_combo0);", "org.eclipse.core.databinding.observable.list.IObservableList combo1ObserveItemsObserveListWidget = org.eclipse.jface.databinding.swt.SWTObservables.observeItems(m_combo1);", "context.bindList(combo0ObserveItemsObserveListWidget, combo1ObserveItemsObserveListWidget, null, null);");
        WidgetBindableInfo viewerBindable0 = (WidgetBindableInfo)((IObserveInfo)shellChildren.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetBindableInfo viewerBindable1 = (WidgetBindableInfo)((IObserveInfo)shellChildren.get(3)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        CheckedElementsObservableInfo checkedObservable0 = new CheckedElementsObservableInfo((BindableInfo)viewerBindable0, String.class);
        checkedObservable0.setCodeSupport((ObservableCodeSupport)new CheckedElementsObservableCodeSupport());
        CheckedElementsObservableInfo checkedObservable1 = new CheckedElementsObservableInfo((BindableInfo)viewerBindable1, String.class);
        checkedObservable1.setCodeSupport((ObservableCodeSupport)new CheckedElementsObservableCodeSupport());
        SetBindingInfo binding3 = new SetBindingInfo((ObservableInfo)checkedObservable0, (ObservableInfo)checkedObservable1);
        lines.clear();
        generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)binding3);
        binding3.addSourceCode(context, lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, "org.eclipse.core.databinding.observable.set.IObservableSet viewer0ObserveCheckedElements = org.eclipse.jface.databinding.viewers.ViewersObservables.observeCheckedElements(m_viewer0, java.lang.String.class);", "org.eclipse.core.databinding.observable.set.IObservableSet viewer1ObserveCheckedElements = org.eclipse.jface.databinding.viewers.ViewersObservables.observeCheckedElements(m_viewer1, java.lang.String.class);", "context.bindSet(viewer0ObserveCheckedElements, viewer1ObserveCheckedElements, null, null);");
    }

    @Test
    public void test_BindingInfo_setVariableIdentifier() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeWidget0 = WidgetProperties.visible().observe(m_shell);", "    IObservableValue observeWidget1 = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget0, observeWidget1, null, null);", "    return bindingContext;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        CodeGenerationTest.assertEquals((long)1L, (long)provider.getBindings().size());
        CodeGenerationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding = (BindingInfo)provider.getBindings().get(0);
        CodeGenerationTest.assertNull((Object)binding.getVariableIdentifier());
        binding.setVariableIdentifier(shell.getRootJava(), "m_binding", true);
        CodeGenerationTest.assertEquals((Object)"m_binding", (Object)binding.getVariableIdentifier());
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private Binding m_binding;", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeWidget0 = WidgetProperties.visible().observe(m_shell);", "    IObservableValue observeWidget1 = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget0, observeWidget1, null, null);", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        binding.setVariableIdentifier(shell.getRootJava(), "_binding", true);
        CodeGenerationTest.assertEquals((Object)"_binding", (Object)binding.getVariableIdentifier());
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private Binding _binding;", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeWidget0 = WidgetProperties.visible().observe(m_shell);", "    IObservableValue observeWidget1 = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget0, observeWidget1, null, null);", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        binding.setVariableIdentifier(shell.getRootJava(), null, false);
        CodeGenerationTest.assertNull((Object)binding.getVariableIdentifier());
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeWidget0 = WidgetProperties.visible().observe(m_shell);", "    IObservableValue observeWidget1 = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget0, observeWidget1, null, null);", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_DataBindingsCodeUtils_ensureDBLibraries() throws Exception {
        TestProject project = new TestProject("OtherProject");
        try {
            BTestUtils.configure(project);
            IJavaProject javaProject = project.getJavaProject();
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
            DataBindingsCodeUtils.ensureDBLibraries((IJavaProject)javaProject);
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
            DataBindingsCodeUtils.ensureDBLibraries((IJavaProject)javaProject);
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
        }
        finally {
            project.dispose();
            CodeGenerationTest.waitForAutoBuild();
        }
    }

    @Test
    public void test_DataBindingsCodeUtils_ensureDBLibraries_ForPlugin() throws Exception {
        TestProject project = new TestProject("OtherProject");
        try {
            BTestUtils.configure(project);
            PdeProjectConversionUtils.convertToPDE(project.getProject(), null);
            CodeGenerationTest.waitForAutoBuild();
            IJavaProject javaProject = project.getJavaProject();
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
            DataBindingsCodeUtils.ensureDBLibraries((IJavaProject)javaProject);
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
            DataBindingsCodeUtils.ensureDBLibraries((IJavaProject)javaProject);
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.observable.IObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.core.databinding.beans.IBeanObservable"));
            CodeGenerationTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.jface.databinding.swt.ISWTObservable"));
        }
        finally {
            project.dispose();
            CodeGenerationTest.waitForAutoBuild();
        }
    }

    @Test
    public void test_DataBindingsCodeUtils_ensureEnclosingRealmOfMain_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DataBindingsCodeUtils.ensureEnclosingRealmOfMain((AstEditor)this.m_lastEditor);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"), this.m_lastEditor);
        DataBindingsCodeUtils.ensureEnclosingRealmOfMain((AstEditor)this.m_lastEditor);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_DataBindingsCodeUtils_ensureEnclosingRealmOfMain_2() throws Exception {
        CompositeInfo composite = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)composite);
        DataBindingsCodeUtils.ensureEnclosingRealmOfMain((AstEditor)this.m_lastEditor);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_DataBindingsCodeUtils_getLastInfoDeclaration_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration createContentsMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"createContents()");
        CodeGenerationTest.assertNotNull((Object)createContentsMethod);
        CodeGenerationTest.assertSame((Object)createContentsMethod, (Object)DataBindingsCodeUtils.getLastInfoDeclaration(null, (JavaInfo)shell));
    }

    @Test
    public void test_DataBindingsCodeUtils_getLastInfoDeclaration_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration openMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"open()");
        CodeGenerationTest.assertNotNull((Object)openMethod);
        CodeGenerationTest.assertSame((Object)openMethod, (Object)DataBindingsCodeUtils.getLastInfoDeclaration(null, (JavaInfo)shell));
    }

    @Test
    public void test_DataBindingsCodeUtils_getLastInfoDeclaration_3() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  public static void main(String[] args) {", "    Display display = new Display();", "    Shell shell = new Shell();", "    shell.open();", "    shell.layout();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration mainMethod = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"main(java.lang.String[])");
        CodeGenerationTest.assertNotNull((Object)mainMethod);
        CodeGenerationTest.assertSame((Object)mainMethod, (Object)DataBindingsCodeUtils.getLastInfoDeclaration(null, (JavaInfo)shell));
    }

    @Test
    public void test_ensureInvokeInitDataBindings_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  public static void main(String[] args) {", "    Display display = new Display();", "    Shell shell = new Shell();", "    shell.open();", "    shell.layout();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected static DataBindingContext initDataBindings() {", "    return null;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  public static void main(String[] args) {", "    Display display = new Display();", "    Shell shell = new Shell();", "    initDataBindings();", "    shell.open();", "    shell.layout();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected static DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureInvokeInitDataBindings_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureInvokeInitDataBindings_3() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
        type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureInvokeInitDataBindings_4() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected boolean createContents() {", "    m_shell = new Shell();", "    return true;", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        MethodDeclaration lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected boolean createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "    return true;", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
        type = JavaInfoUtils.getTypeDeclaration((JavaInfo)shell);
        lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)shell);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)shell, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected boolean createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "    return true;", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_ensureInvokeInitDataBindings_5() throws Exception {
        CompositeInfo composite = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)composite);
        TypeDeclaration type = JavaInfoUtils.getTypeDeclaration((JavaInfo)composite);
        MethodDeclaration lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)composite);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)composite, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test extends Composite {", "  private DataBindingContext m_bindingContext;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
        type = JavaInfoUtils.getTypeDeclaration((JavaInfo)composite);
        lastInfoDeclaration = DataBindingsCodeUtils.getLastInfoDeclaration((MethodDeclaration)AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"initDataBindings()"), (JavaInfo)composite);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings((JavaInfo)composite, (AstEditor)this.m_lastEditor, (TypeDeclaration)type, (MethodDeclaration)lastInfoDeclaration);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test extends Composite {", "  private DataBindingContext m_bindingContext;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    return null;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_JavaInfoDeleteManager() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Spinner m_spinner;", "  private Text m_text;", "  private Combo m_combo;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_spinner = new Spinner(m_shell, SWT.NONE);", "    m_text = new Text(m_shell, SWT.NONE);", "    m_combo = new Combo(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue widget0 = WidgetProperties.enabled().observe(m_text);", "    IObservableValue widget1 = WidgetProperties.enabled().observe(m_combo);", "    bindingContext.bindValue(widget0, widget1, null, null);", "    //", "    return bindingContext;", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        ((ControlInfo)shell.getChildrenControls().get(0)).delete();
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Text m_text;", "  private Combo m_combo;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_combo = new Combo(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue widget0 = WidgetProperties.enabled().observe(m_text);", "    IObservableValue widget1 = WidgetProperties.enabled().observe(m_combo);", "    bindingContext.bindValue(widget0, widget1, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        ((ControlInfo)shell.getChildrenControls().get(0)).delete();
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  protected Shell m_shell;", "  private Combo m_combo;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_combo = new Combo(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_totalCodeGeneration_1() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableInfo shellObserve = (WidgetBindableInfo)provider.getObserves(ObserveType.WIDGETS).get(0);
        WidgetPropertyBindableInfo shellTextProperty = (WidgetPropertyBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        WidgetBindableInfo textObserve = (WidgetBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetPropertyBindableInfo textTextProperty = (WidgetPropertyBindableInfo)textObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        SwtObservableInfo target = new SwtObservableInfo(shellObserve, shellTextProperty);
        target.setCodeSupport((ObservableCodeSupport)new WidgetPropertiesCodeSupport("observeText"));
        TextSwtObservableInfo model = new TextSwtObservableInfo(textObserve, textTextProperty);
        model.setCodeSupport((ObservableCodeSupport)new WidgetPropertyTextCodeSupport(new int[]{24}));
        ValueBindingInfo binding = new ValueBindingInfo((ObservableInfo)target, (ObservableInfo)model);
        provider.addBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue observeTextShellObserveWidget = WidgetProperties.text().observe(m_shell);", "    IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(observeTextShellObserveWidget, observeTextTextObserveWidget, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        target.setVariableIdentifier("target");
        model.setVariableIdentifier("model");
        provider.editBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue target = WidgetProperties.text().observe(m_shell);", "    IObservableValue model = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(target, model, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        provider.deleteBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_totalCodeGeneration_2() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableInfo shellObserve = (WidgetBindableInfo)provider.getObserves(ObserveType.WIDGETS).get(0);
        WidgetPropertyBindableInfo shellTextProperty = (WidgetPropertyBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        WidgetBindableInfo textObserve = (WidgetBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetPropertyBindableInfo textTextProperty = (WidgetPropertyBindableInfo)textObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        SwtObservableInfo target = new SwtObservableInfo(shellObserve, shellTextProperty);
        target.setCodeSupport((ObservableCodeSupport)new WidgetPropertiesCodeSupport("observeText"));
        TextSwtObservableInfo model = new TextSwtObservableInfo(textObserve, textTextProperty);
        model.setCodeSupport((ObservableCodeSupport)new WidgetPropertyTextCodeSupport(new int[]{24}));
        ValueBindingInfo binding = new ValueBindingInfo((ObservableInfo)target, (ObservableInfo)model);
        provider.addBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue observeTextShellObserveWidget = WidgetProperties.text().observe(m_shell);", "    IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(observeTextShellObserveWidget, observeTextTextObserveWidget, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        target.setVariableIdentifier("target");
        model.setVariableIdentifier("model");
        provider.editBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue target = WidgetProperties.text().observe(m_shell);", "    IObservableValue model = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(target, model, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        provider.deleteAllBindings();
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private DataBindingContext m_bindingContext;", "  protected Shell m_shell;", "  private Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Test test = new Test();", "        test.open();", "      }", "    });", "  }", "  public void open() {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_bindingContext = initDataBindings();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_totalCodeGeneration_3() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test {", "  private static Shell m_shell;", "  private static Text m_text;", "  public static void main(String[] args) {", "    Display display = new Display();", "    m_shell = new Shell();", "    m_shell.setLayout(new FillLayout());", "    m_text = new Text(m_shell, SWT.NONE);", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableInfo shellObserve = (WidgetBindableInfo)provider.getObserves(ObserveType.WIDGETS).get(0);
        WidgetPropertyBindableInfo shellTextProperty = (WidgetPropertyBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(8);
        WidgetBindableInfo textObserve = (WidgetBindableInfo)shellObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetPropertyBindableInfo textTextProperty = (WidgetPropertyBindableInfo)textObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        SwtObservableInfo target = new SwtObservableInfo(shellObserve, shellTextProperty);
        target.setCodeSupport((ObservableCodeSupport)new WidgetPropertiesCodeSupport("observeText"));
        TextSwtObservableInfo model = new TextSwtObservableInfo(textObserve, textTextProperty);
        model.setCodeSupport((ObservableCodeSupport)new WidgetPropertyTextCodeSupport(new int[]{24}));
        ValueBindingInfo binding = new ValueBindingInfo((ObservableInfo)target, (ObservableInfo)model);
        provider.addBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private static Shell m_shell;", "  private static Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Display display = new Display();", "        m_shell = new Shell();", "        m_shell.setLayout(new FillLayout());", "        m_text = new Text(m_shell, SWT.NONE);", "        initDataBindings();", "        m_shell.open();", "        m_shell.layout();", "        while (!m_shell.isDisposed()) {", "          if (!display.readAndDispatch()) {", "            display.sleep();", "          }", "        }", "      }", "    });", "  }", "  protected static DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue observeTextShellObserveWidget = WidgetProperties.text().observe(m_shell);", "    IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(observeTextShellObserveWidget, observeTextTextObserveWidget, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        target.setVariableIdentifier("target");
        model.setVariableIdentifier("model");
        provider.editBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test {", "  private static Shell m_shell;", "  private static Text m_text;", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Realm.runWithDefault(DisplayRealm.getRealm(display), new Runnable() {", "      public void run() {", "        Display display = new Display();", "        m_shell = new Shell();", "        m_shell.setLayout(new FillLayout());", "        m_text = new Text(m_shell, SWT.NONE);", "        initDataBindings();", "        m_shell.open();", "        m_shell.layout();", "        while (!m_shell.isDisposed()) {", "          if (!display.readAndDispatch()) {", "            display.sleep();", "          }", "        }", "      }", "    });", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue target = WidgetProperties.text().observe(m_shell);", "    IObservableValue model = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(target, model, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_totalCodeGeneration_4() throws Exception {
        CompositeInfo composite = DatabindingTestUtils.parseTestSource(this, new String[]{"public class Test extends Composite {", "  private Text m_text;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    m_text = new Text(this, SWT.NONE);", "  }", "}"});
        CodeGenerationTest.assertNotNull((Object)composite);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableInfo compositeObserve = (WidgetBindableInfo)provider.getObserves(ObserveType.WIDGETS).get(0);
        WidgetPropertyBindableInfo compositeEnabledProperty = (WidgetPropertyBindableInfo)compositeObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(2);
        WidgetBindableInfo textObserve = (WidgetBindableInfo)compositeObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetPropertyBindableInfo textTextProperty = (WidgetPropertyBindableInfo)textObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(10);
        SwtObservableInfo target = new SwtObservableInfo(compositeObserve, compositeEnabledProperty);
        target.setCodeSupport((ObservableCodeSupport)new WidgetPropertiesCodeSupport("observeText"));
        TextSwtObservableInfo model = new TextSwtObservableInfo(textObserve, textTextProperty);
        model.setCodeSupport((ObservableCodeSupport)new WidgetPropertyTextCodeSupport(new int[]{24}));
        ValueBindingInfo binding = new ValueBindingInfo((ObservableInfo)target, (ObservableInfo)model);
        provider.addBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test extends Composite {", "  private DataBindingContext m_bindingContext;", "  private Text m_text;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    m_text = new Text(this, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue observeEnabledThisObserveWidget = WidgetProperties.enabled().observe(this);", "    IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(observeEnabledThisObserveWidget, observeTextTextObserveWidget, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
        target.setVariableIdentifier("target");
        model.setVariableIdentifier("model");
        provider.editBinding((IBindingInfo)binding);
        CodeGenerationTest.assertEditor(DatabindingTestUtils.getTestSource("public class Test extends Composite {", "  private DataBindingContext m_bindingContext;", "  private Text m_text;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    m_text = new Text(this, SWT.NONE);", "    m_bindingContext = initDataBindings();", "  }", "  protected DataBindingContext initDataBindings() {", "    DataBindingContext bindingContext = new DataBindingContext();", "    //", "    IObservableValue target = WidgetProperties.enabled().observe(this);", "    IObservableValue model = WidgetProperties.text(SWT.Modify).observe(m_text);", "    bindingContext.bindValue(target, model, null, null);", "    //", "    return bindingContext;", "  }", "}"), this.m_lastEditor);
    }

    private static void assertSWTObservableInfo(WidgetBindableInfo widget, WidgetPropertyBindableInfo property, ObservableCodeSupport codeSupport, String variable, String line1, String line2, String line3) throws Exception {
        CodeGenerationTest.assertSWTObservableInfo(new SwtObservableInfo(widget, property), codeSupport, variable, line1, line2, line3);
    }

    private static void assertSWTObservableInfo(SwtObservableInfo observable, ObservableCodeSupport codeSupport, String variable, String line1, String line2, String line3) throws Exception {
        CodeGenerationTest.assertObservableInfo((ObservableInfo)observable, codeSupport, variable, line1, line2);
        observable.setDelayValue(100);
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)observable);
        observable.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, line3);
    }

    private static void assertObservableInfo(ObservableInfo observable, ObservableCodeSupport codeSupport, String variable, String line1, String line2) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)observable);
        observable.setCodeSupport(codeSupport);
        observable.setVariableIdentifier(variable);
        observable.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, line1);
        lines.clear();
        observable.setVariableIdentifier(null);
        observable.addSourceCode(lines, generationSupport);
        CodeGenerationTest.assertEqualsLines(lines, line2);
    }

    private static void assertStrategy(UpdateStrategyInfo strategy, String expectedSourceCode, String ... expectedLines) throws Exception {
        ArrayList lines = new ArrayList();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(false, (AstObjectInfo)strategy);
        CodeGenerationTest.assertEquals((Object)expectedSourceCode, (Object)strategy.getSourceCode(lines, generationSupport));
        CodeGenerationTest.assertEquals((long)expectedLines.length, (long)lines.size());
        int i = 0;
        while (i < expectedLines.length) {
            CodeGenerationTest.assertEquals((String)("line:" + i), (Object)expectedLines[i], lines.get(i));
            ++i;
        }
    }

    private static UpdateValueStrategyInfo createValueStrategy(UpdateStrategyInfo.StrategyType strategyType, Object strategyValue, ConverterInfo converter, String variable) {
        UpdateValueStrategyInfo strategy = new UpdateValueStrategyInfo(strategyType, strategyValue, converter);
        strategy.setVariableIdentifier(variable);
        return strategy;
    }

    private static UpdateListStrategyInfo createListStrategy(UpdateStrategyInfo.StrategyType strategyType, Object strategyValue, ConverterInfo converter, String variable) {
        UpdateListStrategyInfo strategy = new UpdateListStrategyInfo(strategyType, strategyValue, converter);
        strategy.setVariableIdentifier(variable);
        return strategy;
    }

    private static UpdateSetStrategyInfo createSetStrategy(UpdateStrategyInfo.StrategyType strategyType, Object strategyValue, ConverterInfo converter, String variable) {
        UpdateSetStrategyInfo strategy = new UpdateSetStrategyInfo(strategyType, strategyValue, converter);
        strategy.setVariableIdentifier(variable);
        return strategy;
    }

    private static void assertEqualsLines(List<String> actual, String ... expected) throws Exception {
        CodeGenerationTest.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            CodeGenerationTest.assertEquals((Object)expected[i], (Object)actual.get(i));
            ++i;
        }
    }
}

