/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTabItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class NlsDialogTest
extends AbstractDialogTest {
    @Test
    public void test_noSources() throws Exception {
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SWTBotTabItem properties = shell.tabItem("Properties");
                NlsDialogTest.assertTrue((boolean)properties.isActive());
                NlsDialogTest.assertItems(shell, "Properties");
            }
        });
    }

    @Test
    public void test_possibleSources() throws Exception {
        NlsDialogTest.setFileContentSrc("test/messages.properties", NlsDialogTest.getSourceDQ("#Direct ResourceBundle", "frame.title=My JFrame"));
        NlsDialogTest.setFileContentSrc("test/messages2.properties", NlsDialogTest.getSourceDQ("#Direct ResourceBundle", "frame.name=My name"));
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                NlsDialogTest.assertItems(shell, "test.messages", "test.messages2", "Properties");
                SWTBotTabItem messagesTab = shell.tabItem("test.messages");
                NlsDialogTest.assertFalse((boolean)messagesTab.isActive());
                SWTBotTabItem messages2Tab = shell.tabItem("test.messages2");
                NlsDialogTest.assertFalse((boolean)messages2Tab.isActive());
                SWTBotTabItem properties = shell.tabItem("Properties");
                NlsDialogTest.assertTrue((boolean)properties.isActive());
                messagesTab.activate();
                SWTBotTable table = shell.tableWithLabel("Strings:");
                NlsDialogTest.assertColumns(table, "Key", "(default)");
                NlsDialogTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                messages2Tab.activate();
                table = shell.tableWithLabel("Strings:");
                NlsDialogTest.assertColumns(table, "Key", "(default)");
                NlsDialogTest.assertItems(table, new String[][]{{"frame.name", "My name"}});
            }
        });
    }

    @Test
    public void test_existingSources() throws Exception {
        NlsDialogTest.setFileContentSrc("test/messages.properties", NlsDialogTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        NlsDialogTest.setFileContentSrc("test/messages_it.properties", NlsDialogTest.getSourceDQ("frame.title=My JFrame IT"));
        NlsDialogTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                NlsDialogTest.assertItems(shell, "test.messages", "Properties");
                SWTBotTabItem messagesTab = shell.tabItem("test.messages");
                NlsDialogTest.assertTrue((boolean)messagesTab.isActive());
                SWTBotTable table = shell.tableWithLabel("Strings:");
                NlsDialogTest.assertColumns(table, "Key", "(default)", "it");
                NlsDialogTest.assertItems(table, {"frame.name", "My name", ""}, {"frame.title", "My JFrame", "My JFrame IT"});
            }
        });
    }
}

